/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.CompressedTextureType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.InternalWorkspaceConectionInfo;
import com.supermap.data.processing.SceneCacheBuilderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.realspace.Scene;
import java.io.File;
import java.util.Vector;

public class SceneCacheBuilder
extends InternalHandleDisposable {
    private long _$6;
    private String _$5;
    private String _$4;
    private Scene _$3;
    private WorkspaceConnectionInfo _$2;
    transient Vector m_steppedListeners;
    private static String _$1;

    public SceneCacheBuilder() {
        long l = SceneCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$6 = SceneCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public SceneCacheBuilder(Scene scene, String string) {
        long l = 0L;
        if (scene != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)scene)) == 0L) {
            String string2 = InternalResource.loadString("scene", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("outputFolder", InternalResource.CacheBuilderSCI3DOutputFolderNotExists, "processing_resources");
            throw new IllegalStateException(string3);
        }
        long l2 = SceneCacheBuilderNative.jni_New1(l, string);
        this.setHandle(l2, true);
        this._$6 = SceneCacheBuilderNative.jni_NewSelfEventHandle(this);
        this._$3 = scene;
        this._$4 = string;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)scene);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this._$3 == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this._$4 == null || this._$4.trim().length() == 0) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        return SceneCacheBuilderNative.jni_Build(this.getHandle(), this._$6, this._$5);
    }

    @Deprecated
    public static boolean buildOfflinePackage(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("buildOfflinePackage(String strWorkspacePath,String strSceneName)", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string4 = InternalResource.loadString("buildOfflinePackage(String strWorkspacePath,String strSceneName)", "Global_ArgumentNull", "processing_resources");
            throw new UnsupportedOperationException(string4);
        }
        return SceneCacheBuilderNative.jni_BuildOfflinePackage(string, string2);
    }

    public Scene getScene() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScene()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setScene(Scene scene) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (scene == null) {
            SceneCacheBuilderNative.jni_SetScene(this.getHandle(), 0L);
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)scene);
            SceneCacheBuilderNative.jni_SetScene(this.getHandle(), l);
        }
        this._$3 = scene;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)scene);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneCacheBuilderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType(StorageType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = storageType.value();
        SceneCacheBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    public int getUpdateSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUpdateSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetUpdateSize(this.getHandle());
    }

    public void setUpdateSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUpdateSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetUpdateSize(this.getHandle(), n);
    }

    public CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return (CacheImageSize)CacheImageSize.parse(CacheImageSize.class, (int)SceneCacheBuilderNative.jni_GetImageSize(this.getHandle()));
    }

    public void setImageSize(CacheImageSize cacheImageSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetImageSize(this.getHandle(), cacheImageSize.value());
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("outputFolder", InternalResource.CacheBuilderSCI3DOutputFolderNotExists, "processing_resources");
            throw new IllegalStateException(string3);
        }
        SceneCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), string);
        this._$4 = string;
    }

    public WorkspaceConnectionInfo getOutputWorkspaceConnectionInfo() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspaceConnectionInfo", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null && (l = SceneCacheBuilderNative.jni_GetWorkspaceConnectionInfo(this.getHandle())) != 0L) {
            this._$2 = InternalWorkspaceConectionInfo.createInstance(l);
        }
        return this._$2;
    }

    public void setOutputWorkspaceConnectionInfo(WorkspaceConnectionInfo workspaceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspaceConnectionInfo(WorkspaceConnectionInfo value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            if (this._$2 != null) {
                InternalWorkspaceConectionInfo.clearHandle(this._$2);
                this._$2 = null;
            }
            SceneCacheBuilderNative.jni_SetWorkspaceConnectionInfo(this.getHandle(), 0L);
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)workspaceConnectionInfo);
            SceneCacheBuilderNative.jni_SetWorkspaceConnectionInfo(this.getHandle(), l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspaceConnectionInfo);
    }

    public String getOutputSceneName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputSceneName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputSceneName(this.getHandle());
    }

    public void setOutputSceneName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputSceneName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("setOutputSceneName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string3);
        }
        SceneCacheBuilderNative.jni_SetOutputSceneName(this.getHandle(), string);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        SceneCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        SceneCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SceneCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this._$1();
            if (this._$2 != null) {
                InternalWorkspaceConectionInfo.clearHandle(this._$2);
            }
        }
    }

    private void _$1() {
        if (this._$6 != 0L) {
            SceneCacheBuilderNative.jni_DeleteSelfEventHandle(this._$6);
            this._$6 = 0L;
        }
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        this._$5 = string;
    }

    public void setOutputLayerNames(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputLayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetOutputLayerNames(this.getHandle(), stringArray);
    }

    public void setOutputTerrainLayerNames(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputTerrainlayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_setOutpuTerrainLayerNames(this.getHandle(), stringArray);
    }

    public String[] getOutputLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputLayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetOutputLayerNames(this.getHandle());
    }

    public String[] getOutputTerrainLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputTerrainlayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetTerrainOutputLayerNames(this.getHandle());
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    public boolean isBoundsCeiled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBoundsCeiled()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_IsBoudsCeiled(this.getHandle());
    }

    public void setBoundsCeiled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBoundsCeiled()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetBoudsCeiled(this.getHandle(), bl);
    }

    public CompressedTextureType getCompressedTextureType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneCacheBuilderNative.jni_GetCompressedTextureType(this.getHandle());
        return (CompressedTextureType)InternalEnum.parseUGCValue(CompressedTextureType.class, n);
    }

    public void setCompressedTextureType(CompressedTextureType compressedTextureType) {
        if (compressedTextureType == null) {
            String string = InternalResource.loadString("CompressedTextureType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetCompressedTextureType(this.getHandle(), compressedTextureType.value());
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(SceneCacheBuilder sceneCacheBuilder, int n, long l, String string, String string2, long l2) {
        if (sceneCacheBuilder != null) {
            _$1 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)sceneCacheBuilder, n, l, string, string2, _$1, bl);
            sceneCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    public String[] getPreCacheLayerNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreCacheLayerNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return SceneCacheBuilderNative.jni_GetPreCacheLayerNames(this.getHandle());
    }

    public void setPreCacheLayerNames(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPreCacheLayerNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        SceneCacheBuilderNative.jni_SetPreCacheLayerNames(this.getHandle(), stringArray);
    }
}

