/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.BuildResultInfo;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.CacheStrategy;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalProcessingToolkit;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.MapCacheBuilderNative;
import com.supermap.data.processing.MapCacheVersion;
import com.supermap.data.processing.MapTileType;
import com.supermap.data.processing.MapTilingMode;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import com.supermap.mapping.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Map _$5 = null;
    private Dataset _$4 = null;
    private GeoRegion _$3 = null;
    private long _$2;
    transient Vector m_steppedListeners;
    private static String _$1;

    public MapCacheBuilder() {
        long l = MapCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$1(null, null, null);
    }

    public MapCacheBuilder(Map map, String string, double[] dArray) {
        long l = MapCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$1(map, string, dArray);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (map == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)map) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)map);
        }
        MapCacheBuilderNative.jni_SetMap(this.getHandle(), l);
        this._$5 = map;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    private Dataset _$11() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    private void _$1(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        long l2 = 0L;
        if (dataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L) {
            if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE && dataset.getType() != DatasetType.GRIDCOLLECTION && dataset.getType() != DatasetType.IMAGECOLLECTION) {
                String string = InternalResource.loadString("dataset", "DatasetTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset.getDatasource().getWorkspace());
        }
        MapCacheBuilderNative.jni_SetDataset(this.getHandle(), l, l2);
        this._$4 = dataset;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)dataset);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null) {
            long l = MapCacheBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this._$3 = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$3, false);
            }
        } else {
            long l = MapCacheBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                InternalGeoRegion.clearHandle(this._$3);
                InternalGeoRegion.refreshHandle(this._$3, l);
            } else {
                InternalGeoRegion.clearHandle(this._$3);
                this._$3 = null;
            }
        }
        return this._$3;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion2 = null;
        if (geoRegion != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
                String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            geoRegion2 = new GeoRegion(geoRegion);
            MapCacheBuilderNative.jni_SetClipRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion));
        } else {
            MapCacheBuilderNative.jni_SetClipRegion(this.getHandle(), 0L);
        }
        this._$3 = geoRegion2;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive(geoRegion2);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCacheBuilderNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheBuilderNative.jni_GetCacheName(this.getHandle());
        if ((string == null || string.length() == 0) && this._$5 != null) {
            string = this._$5.getName();
        }
        return string;
    }

    public void setCacheName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        MapCacheBuilderNative.jni_SetCacheName(this.getHandle(), string);
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        MapCacheBuilderNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> hashMap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (hashMap == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = hashMap.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = hashMap.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        MapCacheBuilderNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetOutputScales(this.getHandle());
    }

    public void setOutputScales(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!MapCacheBuilderNative.jni_SetOutputScales(this.getHandle(), dArray)) {
            String string = InternalResource.loadString("setOutputScales()", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    @Deprecated
    private CacheImageSize _$10() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageSize(this.getHandle());
        CacheImageSize cacheImageSize = null;
        switch (n) {
            case 0: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 1: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 2: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 3: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 4: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 5: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    @Deprecated
    private void _$1(CacheImageSize cacheImageSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageSize);
        MapCacheBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public int getImageCompress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageCompress(this.getHandle());
        return n;
    }

    public void setImageCompress(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (n > 100 || n < 0) {
            String string = InternalResource.loadString("setImageCompress()", "MapCacheBuidlerImageCompressIncorrect", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetImageCompress(this.getHandle(), n);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
        return string;
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string.trim().length() == 0) {
            String string3 = InternalResource.loadString("setOutputFolder()", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string3);
        }
        MapCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsTransparent(this.getHandle());
    }

    public void setTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetTransparentc(this.getHandle(), bl);
    }

    public boolean isFillMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsFillMargin(this.getHandle());
    }

    public void setFillMargin(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetFillMargin(this.getHandle(), bl);
    }

    @Deprecated
    private CacheImageType _$9() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageType(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    @Deprecated
    private void _$1(CacheImageType cacheImageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageType);
        MapCacheBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetStorageType(this.getHandle());
        StorageType storageType = null;
        storageType = (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
        return storageType;
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(storageType);
        MapCacheBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    @Deprecated
    private CacheStrategy _$8() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheStrategy()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetStrategy(this.getHandle());
        CacheStrategy cacheStrategy = null;
        cacheStrategy = (CacheStrategy)InternalEnum.parseUGCValue(CacheStrategy.class, n);
        return cacheStrategy;
    }

    @Deprecated
    private void _$1(CacheStrategy cacheStrategy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheStrategy()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheStrategy);
        MapCacheBuilderNative.jni_SetStrategy(this.getHandle(), n);
    }

    public Rectangle2D getIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetIndexBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setIndexBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCacheBuilderNative.jni_SetIndexBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        MapCacheBuilderNative.jni_SetPassword(this.getHandle(), string);
    }

    public boolean build() {
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$5 != null && this._$5.isContainLayerChart() && InternalProcessingToolkit.getChartLicenseState() != 0) {
            return false;
        }
        String string3 = this.getCacheName();
        if (string3.contains("\\") || string3.contains("/") || string3.contains(":") || string3.contains("*") || string3.contains("?") || string3.contains("\"") || string3.contains("<") || string3.contains(">") || string3.contains("|")) {
            String string4 = InternalResource.loadString("CacheNameInvalid", "CacheBuilderCacheNameInvalid", "processing_resources");
            throw new IllegalArgumentException(string4);
        }
        MapCacheVersion mapCacheVersion = this.getVersion();
        if (this._$5 != null && mapCacheVersion != MapCacheVersion.VERSION_10 && mapCacheVersion != MapCacheVersion.VERSION_50 && ((string = this._$5.getName()).contains("\\") || string.contains("/") || string.contains(":") || string.contains("*") || string.contains("?") || string.contains("\"") || string.contains("<") || string.contains(">") || string.contains("|"))) {
            String string5 = InternalResource.loadString("CacheNameInvalid", "CacheBuilderCacheNameInvalid", "processing_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$4 != null && this._$5 == null && this.getVersion().value() < MapCacheVersion.VERSION_50.value()) {
            string = InternalResource.loadString("CacheParameterInvalid", "DatasetNotSupportVersion", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = MapCacheBuilderNative.jni_Build(this.getHandle(), this._$2);
        return this._$3(n);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_BuildWithoutConfig(this.getHandle(), this._$2);
        return this._$3(n);
    }

    public boolean toConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getMap() == null) {
            String string3 = InternalResource.loadString("toConfigFile()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            String string4 = InternalResource.loadString("toConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string4);
        }
        if (string.length() == 0) {
            String string5 = InternalResource.loadString("toConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string5);
        }
        String string6 = ".sci";
        if (!string.endsWith(string6)) {
            string = string + string6;
        }
        boolean bl = MapCacheBuilderNative.jni_ToConfigFile(this.getHandle(), string);
        return bl;
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string.length() == 0) {
            String string4 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = MapCacheBuilderNative.jni_FromConfigFile(this.getHandle(), string);
        return bl;
    }

    public String computeImageFileName(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        String string = MapCacheBuilderNative.jni_ComputeImageFileName(this.getHandle(), dArray, d);
        return string;
    }

    public String[] computeImageFileName(Rectangle2D rectangle2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCacheBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        String string = MapCacheBuilderNative.jni_ComputeImageFileName(this.getHandle(), dArray, d);
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheBuilderNative.jni_ComputeOutputScales(this.getHandle());
        return bl;
    }

    public double[] getDefultOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefultOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetDefulatOutputScales(this.getHandle());
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(MapCacheBuilder mapCacheBuilder, int n, long l, String string, String string2, long l2) {
        if (mapCacheBuilder != null) {
            _$1 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)mapCacheBuilder, n, l, string, string2, _$1, bl);
            mapCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this._$7();
        }
    }

    private void _$7() {
        if (this._$2 != 0L) {
            MapCacheBuilderNative.jni_DeleteSelfEventHandle(this._$2);
            this._$2 = 0L;
        }
    }

    private void _$1(Map map, String string, double[] dArray) {
        if (map != null) {
            this.setMap(map);
        }
        if (string != null) {
            this.setOutputFolder(string);
        }
        if (dArray != null) {
            this.setOutputScales(dArray);
        }
        this._$2 = MapCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public Rectangle2D getImageBounds(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getImageBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("getImageBounds()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string.length() == 0) {
            String string4 = InternalResource.loadString("getImageBounds()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        double[] dArray = new double[4];
        MapCacheBuilderNative.jni_GetImageBounds(this.getHandle(), string, dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public String getHashCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHashCode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetHashCode(this.getHandle());
    }

    public byte[] getImageData(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("getImageData()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        return MapCacheBuilderNative.jni_GetImageData(this.getHandle(), string, string2);
    }

    @Deprecated
    private boolean _$6() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCacheUsingNewScheme()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetCacheUsingNewScheme(this.getHandle());
    }

    @Deprecated
    private void _$4(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCacheUsingNewScheme()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetCacheUsingNewScheme(this.getHandle(), bl);
    }

    public void setHashCodeEnabled(boolean bl) {
        MapCacheBuilderNative.jni_SetHashCodeEnabled(this.getHandle(), bl);
    }

    public boolean isHashCodeEnabled() {
        return MapCacheBuilderNative.jni_IsHashCodeEnabled(this.getHandle());
    }

    public MapCacheVersion getVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetVersion(this.getHandle());
        MapCacheVersion mapCacheVersion = null;
        mapCacheVersion = (MapCacheVersion)InternalEnum.parseUGCValue(MapCacheVersion.class, n);
        return mapCacheVersion;
    }

    public void setVersion(MapCacheVersion mapCacheVersion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(mapCacheVersion);
        MapCacheBuilderNative.jni_SetVersion(this.getHandle(), n);
    }

    public boolean originalToCompact(String string, String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("originalToCompact()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string4);
        }
        return MapCacheBuilderNative.jni_OriginalToCompact(this.getHandle(), string, string2, string3);
    }

    public static HashMap<Double, String> globalLevelToScale(int[] nArray, PrjCoordSys prjCoordSys, TileSize tileSize) {
        if (nArray == null) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(tileSize);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= 20) continue;
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        double[] dArray = MapCacheBuilderNative.jni_GlobalLevelToScale(nArray, l, n);
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                Double d2 = new Double(d);
                Integer n2 = new Integer(nArray[i]);
                String string = n2.toString();
                hashMap.put(d2, string);
            }
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)prjCoordSys);
        return hashMap;
    }

    @Deprecated
    public static HashMap<Double, String> globalLevelToScale(int[] nArray, PrjCoordSys prjCoordSys, CacheImageSize cacheImageSize) {
        TileSize tileSize = TileSize.SIZE64;
        switch (cacheImageSize.value()) {
            case 64: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 128: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 256: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 512: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 1024: 
            case 2048: {
                tileSize = TileSize.SIZE1024;
                break;
            }
        }
        return MapCacheBuilder.globalLevelToScale(nArray, prjCoordSys, tileSize);
    }

    public HashMap<Double, String> globalLevelToScale(int[] nArray) {
        if (nArray == null) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= 20) continue;
            String string = InternalResource.loadString("globalLevelToScale()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheImageSize cacheImageSize = this._$10();
        int n = InternalEnum.getUGCValue(cacheImageSize);
        PrjCoordSys prjCoordSys = this._$5.getPrjCoordSys();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        double[] dArray = MapCacheBuilderNative.jni_GlobalLevelToScale(nArray, l, n);
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                Double d2 = new Double(d);
                Integer n2 = new Integer(nArray[i]);
                String string = n2.toString();
                hashMap.put(d2, string);
            }
        }
        return hashMap;
    }

    @Deprecated
    private MapTileType _$5() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetTileType(this.getHandle());
        MapTileType mapTileType = null;
        mapTileType = (MapTileType)InternalEnum.parseUGCValue(MapTileType.class, n);
        return mapTileType;
    }

    @Deprecated
    private void _$1(MapTileType mapTileType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMapTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getVersion() == MapCacheVersion.VERSION_10) {
            String string = InternalResource.loadString("setMapTileType()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = InternalEnum.getUGCValue(mapTileType);
        MapCacheBuilderNative.jni_SetTileType(this.getHandle(), n);
    }

    private boolean _$3(int n) {
        boolean bl = false;
        if (n == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    @Deprecated
    private boolean _$4() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 != null && this._$5.isContainLayerChart() && InternalProcessingToolkit.getChartLicenseState() != 0) {
            return false;
        }
        boolean bl = MapCacheBuilderNative.jni_AppendBuild(this.getHandle(), this._$2);
        return bl;
    }

    public double getDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetDPI(this.getHandle());
    }

    public void setDPI(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("build()", "ArgumentShouldNotBeNegative", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetDPI(this.getHandle(), d);
    }

    public boolean isAppending() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsAppending(this.getHandle());
    }

    public void setIsAppending(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsAppending(this.getHandle(), bl);
    }

    public void setTilingMode(MapTilingMode mapTilingMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingMode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getVersion() == MapCacheVersion.VERSION_10) {
            String string = InternalResource.loadString("setTilingMode()", "Global_ArgumentTypeInvalid", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        int n = InternalEnum.getUGCValue(mapTilingMode);
        MapCacheBuilderNative.jni_SetTileType(this.getHandle(), n);
    }

    public MapTilingMode getTilingMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingMode()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetTileType(this.getHandle());
        MapTilingMode mapTilingMode = null;
        mapTilingMode = (MapTilingMode)InternalEnum.parseUGCValue(MapTilingMode.class, n);
        return mapTilingMode;
    }

    public TileSize getTileSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageSize(this.getHandle());
        TileSize tileSize = null;
        switch (n) {
            case 0: {
                tileSize = TileSize.SIZE64;
                break;
            }
            case 1: {
                tileSize = TileSize.SIZE128;
                break;
            }
            case 2: {
                tileSize = TileSize.SIZE256;
                break;
            }
            case 3: {
                tileSize = TileSize.SIZE512;
                break;
            }
            case 4: {
                tileSize = TileSize.SIZE1024;
                break;
            }
            default: {
                tileSize = TileSize.SIZE256;
            }
        }
        return tileSize;
    }

    public void setTileSize(TileSize tileSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileSize);
        MapCacheBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public TileFormat getTileFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheBuilderNative.jni_GetImageType(this.getHandle());
        TileFormat tileFormat = null;
        tileFormat = (TileFormat)InternalEnum.parseUGCValue(TileFormat.class, n);
        return tileFormat;
    }

    public void setTileFormat(TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTileFormat()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(tileFormat);
        MapCacheBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    void setBigImageSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setChunkSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetBigImageSize(this.getHandle(), n);
    }

    public BuildResultInfo getBuildResult() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheBuildLog()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = MapCacheBuilderNative.jni_GetBuildResult(this.getHandle());
        if (l != 0L) {
            return new BuildResultInfo(l, false);
        }
        return null;
    }

    public boolean isDeleteLogFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDeleteLogFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsDeleteLogFile(this.getHandle());
    }

    public void setIsDeleteLogFile(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsDeleteLogFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsDeleteLogFile(this.getHandle(), bl);
    }

    public boolean isBlockOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordGroupInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordBlockInfo(this.getHandle());
    }

    @Deprecated
    private void _$3(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordGroupInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordBlockInfo(this.getHandle(), bl);
    }

    public void setBlockOverRecord(boolean bl) {
        this._$3(bl);
    }

    public boolean isScaleOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordScaleInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordScaleInfo(this.getHandle());
    }

    @Deprecated
    private void _$2(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordScaleInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordScaleInfo(this.getHandle(), bl);
    }

    public void setScaleOverRecord(boolean bl) {
        this._$2(bl);
    }

    public boolean isTaskOverRecord() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRecordTotalInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsRecordTotalInfo(this.getHandle());
    }

    @Deprecated
    private void _$1(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsRecordTotalInfo()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetIsRecordTotalInfo(this.getHandle(), bl);
    }

    public void setTaskOverRecord(boolean bl) {
        this._$1(bl);
    }

    void resumable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resumable()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetErrorLog(this.getHandle(), bl);
    }

    private int _$3() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetRevisionNumber(this.getHandle());
    }

    private void _$2(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetRevisionNumber(this.getHandle(), n);
    }

    private int _$2() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomMaxVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetMaxRevisionNumber(this.getHandle());
    }

    private void _$1(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetBuildThreadCount(this.getHandle(), n);
    }

    private int _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomMaxVersion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_GetBuildThreadCount(this.getHandle());
    }
}

