/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.util.FastByteArrayOutputStream;

public class ContentCachingResponseWrapper
extends HttpServletResponseWrapper {
    private final FastByteArrayOutputStream content = new FastByteArrayOutputStream(1024);
    private final ServletOutputStream outputStream = new ResponseServletOutputStream();
    private PrintWriter writer;
    private int statusCode = 200;

    public ContentCachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusCode = sc;
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.statusCode = sc;
    }

    public void sendError(int sc) throws IOException {
        this.copyBodyToResponse();
        super.sendError(sc);
        this.statusCode = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.copyBodyToResponse();
        super.sendError(sc, msg);
        this.statusCode = sc;
    }

    public void sendRedirect(String location) throws IOException {
        this.copyBodyToResponse();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
        }
        return this.writer;
    }

    public void setContentLength(int len) {
        this.content.resize(len);
    }

    public void setContentLengthLong(long len) {
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Content-Length exceeds ShallowEtagHeaderFilter's maximum (2147483647): " + len);
        }
        this.content.resize((int)len);
    }

    public void setBufferSize(int size) {
        this.content.resize(size);
    }

    public void resetBuffer() {
        this.content.reset();
    }

    public void reset() {
        super.reset();
        this.content.reset();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public void copyBodyToResponse() throws IOException {
        if (this.content.size() > 0) {
            HttpServletResponse rawResponse = (HttpServletResponse)this.getResponse();
            if (!rawResponse.isCommitted()) {
                rawResponse.setContentLength(this.content.size());
            }
            this.content.writeTo((OutputStream)rawResponse.getOutputStream());
            this.content.reset();
        }
    }

    public int getContentSize() {
        return this.content.size();
    }

    public InputStream getContentInputStream() {
        return this.content.getInputStream();
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
            super(new OutputStreamWriter((OutputStream)ContentCachingResponseWrapper.this.content, characterEncoding));
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
        }
    }

    private class ResponseServletOutputStream
    extends ServletOutputStream {
        private ResponseServletOutputStream() {
        }

        public void write(int b) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ContentCachingResponseWrapper.this.content.write(b, off, len);
        }
    }
}

