/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class FilenameFlowUrlHandler
extends DefaultFlowUrlHandler {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public String getFlowId(HttpServletRequest request) {
        return WebUtils.extractFilenameFromUrlPath((String)this.urlPathHelper.getLookupPathForRequest(request));
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            url.append(request.getContextPath());
            url.append(request.getServletPath());
            url.append(pathInfo.substring(0, pathInfo.lastIndexOf("/") + 1));
            url.append(flowId);
            int dotIndex = pathInfo.lastIndexOf(46);
            if (dotIndex != -1) {
                url.append(pathInfo.substring(dotIndex));
            }
        } else {
            String servletPath = request.getServletPath();
            if (StringUtils.hasText((String)servletPath)) {
                url.append(request.getContextPath());
                int slashIndex = servletPath.lastIndexOf("/");
                if (slashIndex != -1) {
                    url.append(servletPath.substring(0, slashIndex));
                }
                url.append('/');
                url.append(flowId);
                int dotIndex = servletPath.lastIndexOf(46);
                if (dotIndex != -1) {
                    url.append(servletPath.substring(dotIndex));
                }
            } else {
                url.append('/');
                url.append(flowId);
            }
        }
        if (input != null && !input.isEmpty()) {
            url.append('?');
            this.appendQueryParameters(url, input.asMap(), this.getEncodingScheme(request));
        }
        return url.toString();
    }
}

