/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.data.TextAlignment;
import com.supermap.data.TextStyle;
import com.supermap.mapping.GraduatedMode;
import com.supermap.mapping.GraphAxesTextDisplayMode;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.Layer;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGraphItem;
import com.supermap.mapping.ThemeGraphNative;
import com.supermap.mapping.ThemeGraphTextFormat;
import com.supermap.mapping.ThemeGraphType;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGraph
extends Theme {
    private ArrayList _$6 = null;
    private GeoStyle _$5 = null;
    private TextStyle _$4 = null;
    private TextStyle _$3 = null;
    private GraphAxesTextDisplayMode _$2 = null;
    private Layer _$1;

    public ThemeGraph() {
        long l = ThemeGraphNative.jni_New();
        this.setHandle(l, true);
        this._$6 = new ArrayList();
        this._$2 = GraphAxesTextDisplayMode.YAXES;
    }

    public ThemeGraph(ThemeGraph themeGraph) {
        if (themeGraph == null) {
            String string = InternalResource.loadString("themeGraph", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraph.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGraph", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGraphNative.jni_Clone(themeGraph.getHandle());
        this.setHandle(l, true);
        this._$6 = new ArrayList();
        int n = themeGraph.getGraphItemsList().size();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l2, this);
            this._$6.add(themeGraphItem);
        }
    }

    ThemeGraph(long l, Layer layer, boolean bl) {
        this.setHandle(l, bl);
        this._$6 = new ArrayList();
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l2, this);
            this._$6.add(themeGraphItem);
        }
        this._$1 = layer;
    }

    public ThemeGraphItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGraphItem)((Object)this._$6.get(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int n, ThemeGraphItem themeGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItem(int index, ThemeGraphItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(themeGraphItem);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem2);
            ThemeGraphNative.jni_SetItem(this.getHandle(), n, l);
            long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
            ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l2, this);
            this._$6.set(n, themeGraphItem3);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem2));
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetCount(this.getHandle());
    }

    public boolean isGraphSizeFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsGraphSizeFixed(this.getHandle());
    }

    public void setGraphSizeFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsGraphSizeFixed(this.getHandle(), bl);
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeGraphNative.jni_SetOffsetX(this.getHandle(), string);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeGraphNative.jni_SetOffsetY(this.getHandle(), string);
    }

    public ThemeGraphType getGraphType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraphType(this.getHandle());
        return (ThemeGraphType)InternalEnum.parseUGCValue(ThemeGraphType.class, n);
    }

    public void setGraphType(ThemeGraphType themeGraphType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGraphType == null) {
            String string = InternalResource.loadString("themeGraphType", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = InternalEnum.getUGCValue(themeGraphType);
        ThemeGraphNative.jni_SetGraphType(this.getHandle(), n);
        this._$1();
        this.m_lock.unlock();
    }

    public double getBarWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetBarWidth(this.getHandle());
    }

    public void setBarWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarWidthShoudBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetBarWidth(this.getHandle(), d);
        this.m_lock.unlock();
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetStartAngle(this.getHandle(), d);
        this.m_lock.unlock();
    }

    public double getRoseAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetRoseAngle(this.getHandle());
    }

    public void setRoseAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_RoseAngleShoudNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetRoseAngle(this.getHandle(), d);
        this.m_lock.unlock();
    }

    public boolean isFlowEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsFlowEnabled(this.getHandle());
    }

    public void setFlowEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetIsFlowEnabled(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public GeoStyle getLeaderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = ThemeGraphNative.jni_GetLeaderLineStyle(this.getHandle())) != 0L) {
            this._$5 = InternalGeoStyle.createInstance(l);
        }
        return this._$5;
    }

    public void setLeaderLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeaderLineStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
        ThemeGraphNative.jni_SetLeaderLineStyle(this.getHandle(), l2);
        this.m_lock.unlock();
    }

    public boolean isLeaderLineDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsLeaderLineDisplayed(this.getHandle());
    }

    public void setLeaderLineDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsLeaderLineDisplayed(this.getHandle(), bl);
    }

    public boolean isNegativeDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsNegativeDisplayed(this.getHandle());
    }

    public void setNegativeDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetIsNegativeDisplayed(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public Color getAxesColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetAxesColor(this.getHandle());
        return new Color(n);
    }

    public void setAxesColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetAxesColor(this.getHandle(), color.getRGB());
    }

    public boolean isAxesDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsAxesDisplayed(this.getHandle());
    }

    public void setAxesDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsAxesDisplayed(this.getHandle(), bl);
    }

    public TextStyle getAxesTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = ThemeGraphNative.jni_GetAxesTextStyle(this.getHandle())) != 0L) {
            this._$4 = InternalTextStyle.createInstance(l);
            this._$4.setSizeFixed(true);
            this._$4.setAlignment(TextAlignment.BOTTOMRIGHT);
        }
        return this._$4;
    }

    public void setAxesTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        textStyle2.setAlignment(TextAlignment.BOTTOMRIGHT);
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle2);
        ThemeGraphNative.jni_SetAxesTextStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public boolean isAxesTextDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_IsShowYAxesText(this.getHandle()) || ThemeGraphNative.jni_IsShowXAxesText(this.getHandle());
    }

    public void setAxesTextDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl2 = bl;
        boolean bl3 = bl;
        if (bl && this.getAxesTextDisplayMode().equals((Object)GraphAxesTextDisplayMode.YAXES)) {
            bl2 = false;
            bl3 = true;
        }
        ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), bl3);
        ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), bl2);
    }

    public boolean isAxesGridDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsAxesGridDisplayed(this.getHandle());
    }

    public void setAxesGridDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsAxesGridDisplayed(this.getHandle(), bl);
    }

    public TextStyle getGraphTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = ThemeGraphNative.jni_GetGraphTextStyle(this.getHandle())) != 0L) {
            this._$3 = InternalTextStyle.createInstance(l);
        }
        return this._$3;
    }

    public void setGraphTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        ThemeGraphNative.jni_SetGraphTextStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public ThemeGraphTextFormat getGraphTextFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraphTextFormat(this.getHandle());
        return (ThemeGraphTextFormat)InternalEnum.parseUGCValue(ThemeGraphTextFormat.class, n);
    }

    public void setGraphTextFormat(ThemeGraphTextFormat themeGraphTextFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGraphTextFormat == null) {
            String string = InternalResource.loadString("themeGraphTextFormat", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(themeGraphTextFormat);
        ThemeGraphNative.jni_SetGraphTextFormat(this.getHandle(), n);
    }

    public boolean isGraphTextDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsGraphTextDisplayed(this.getHandle());
    }

    public void setGraphTextDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsGraphTextDisplayed(this.getHandle(), bl);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_isOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_setOffsetFixed(this.getHandle(), bl);
    }

    public double getMinGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMinGraphSize(this.getHandle());
    }

    public void setMinGraphSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfMinGraphSizeShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraphNative.jni_SetMinGraphSize(this.getHandle(), d);
    }

    public double getMaxGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMaxGraphSize(this.getHandle());
    }

    public void setMaxGraphSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfMaxGraphSizeShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraphNative.jni_SetMaxGraphSize(this.getHandle(), d);
    }

    public GraduatedMode getGraduatedMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraduatedMode(this.getHandle());
        return (GraduatedMode)InternalEnum.parseUGCValue(GraduatedMode.class, n);
    }

    public void setGraduatedMode(GraduatedMode graduatedMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (graduatedMode == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = InternalEnum.getUGCValue(graduatedMode);
        ThemeGraphNative.jni_SetGraduateMode(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public boolean isOverlapAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOverlapAvoided(this.getHandle());
    }

    public void setOverlapAvoided(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetOverlapAvoided(this.getHandle(), bl);
    }

    public int[] getMemoryKeys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryKeys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMemoryKeys(this.getHandle());
    }

    public void setMemoryKeys(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMemoryKeys(int[] keys)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetMemoryKeys(this.getHandle(), nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ThemeGraphItem themeGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGraphItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(themeGraphItem);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem2);
            n = ThemeGraphNative.jni_Add(this.getHandle(), l);
            if (n != -1) {
                long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
                ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l2, this);
                this._$6.add(themeGraphItem3);
                this._$2();
                this._$1();
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem2));
        }
        finally {
            this.m_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int n, ThemeGraphItem themeGraphItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n > n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraphItem.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(themeGraphItem);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem2);
            bl = false;
            if (n == n2) {
                int n3 = ThemeGraphNative.jni_Add(this.getHandle(), l);
                if (n3 == n2) {
                    bl = true;
                    long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
                    ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l2, this);
                    this._$6.add(themeGraphItem3);
                    this._$2();
                    this._$1();
                }
            } else {
                int n4 = ThemeGraphNative.jni_Insert(this.getHandle(), n, l);
                if (n4 == n) {
                    bl = true;
                    long l3 = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
                    ThemeGraphItem themeGraphItem4 = new ThemeGraphItem(l3, this);
                    this._$6.add(n, themeGraphItem4);
                    this._$2();
                    this._$1();
                }
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem2));
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exchangeItem(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string = InternalResource.loadString("index1", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= n3) {
            String string = InternalResource.loadString("index2", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeGraphNative.jni_ExchangeItem(this.getHandle(), n, n2);
            if (bl) {
                ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this._$6.get(n));
                ThemeGraphItem themeGraphItem2 = (ThemeGraphItem)((Object)this._$6.get(n2));
                long l = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
                ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l, this);
                this._$6.set(n, themeGraphItem3);
                long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), n2);
                ThemeGraphItem themeGraphItem4 = new ThemeGraphItem(l2, this);
                this._$6.set(n2, themeGraphItem4);
                themeGraphItem.clearHandle();
                themeGraphItem2.clearHandle();
                this._$1();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = ThemeGraphNative.jni_IndexOf(this.getHandle(), string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeGraphNative.jni_RemoveAt(this.getHandle(), n);
            if (bl) {
                ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this._$6.get(n));
                themeGraphItem.clearHandle();
                this._$6.remove(n);
                this._$2();
                this._$1();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        try {
            this.m_lock.lock();
            ThemeGraphNative.jni_Clear(this.getHandle());
            if (this._$6 != null) {
                this._$4();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        this._$1();
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AxesColor = {");
        stringBuffer.append(this.getAxesColor().toString());
        stringBuffer.append("},AxesTextStyle = ");
        stringBuffer.append(this.getAxesTextStyle().toString());
        stringBuffer.append(",BarWidth = ");
        stringBuffer.append(this.getBarWidth());
        stringBuffer.append(",Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",GraduatedMode = ");
        stringBuffer.append((Object)this.getGraduatedMode());
        stringBuffer.append(",GraphTextFormat = ");
        stringBuffer.append(this.getGraphTextFormat().name());
        stringBuffer.append(",GraphType = ");
        stringBuffer.append((Object)this.getGraphType());
        stringBuffer.append(",IsAxesDisplayed = ");
        stringBuffer.append(this.isAxesDisplayed());
        stringBuffer.append(",IsAxesGridDisplayed = ");
        stringBuffer.append(this.isAxesGridDisplayed());
        stringBuffer.append(",IsAxesTextDisplayed = ");
        stringBuffer.append(this.isAxesTextDisplayed());
        stringBuffer.append(",IsFlowEnabled = ");
        stringBuffer.append(this.isFlowEnabled());
        stringBuffer.append(",IsGraphSIzeFixed = ");
        stringBuffer.append(this.isGraphSizeFixed());
        stringBuffer.append(",IsGraphTextDisplayed = ");
        stringBuffer.append(this.isGraphTextDisplayed());
        stringBuffer.append(",IsLeaderLineDisplayed = ");
        stringBuffer.append(this.isLeaderLineDisplayed());
        stringBuffer.append(",IsNegativeDisplayed = ");
        stringBuffer.append(this.isNegativeDisplayed());
        stringBuffer.append(",MaxGraphSize = ");
        stringBuffer.append(this.getMaxGraphSize());
        stringBuffer.append(",MinGraphSize = ");
        stringBuffer.append(this.getMinGraphSize());
        stringBuffer.append(",OffsetX = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append(",RoseAngle = ");
        stringBuffer.append(this.getRoseAngle());
        stringBuffer.append(",StartAngle = ");
        stringBuffer.append(this.getStartAngle());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void setAxesTextDisplayMode(GraphAxesTextDisplayMode graphAxesTextDisplayMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphAxesTextDisplayMode(GraphAxesTextDisplayMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this._$2 = graphAxesTextDisplayMode;
        switch (this._$2.value()) {
            case 0: {
                ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), false);
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), false);
                break;
            }
            case 2: {
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), true);
                break;
            }
            case 3: {
                ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), true);
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), true);
                break;
            }
        }
    }

    public GraphAxesTextDisplayMode getAxesTextDisplayMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphAxesTextDisplayMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isAxesDisplayed()) {
            if (ThemeGraphNative.jni_IsShowYAxesText(this.getHandle())) {
                this._$2 = GraphAxesTextDisplayMode.YAXES;
                if (ThemeGraphNative.jni_IsShowXAxesText(this.getHandle())) {
                    this._$2 = GraphAxesTextDisplayMode.ALL;
                }
            }
        } else {
            this._$2 = GraphAxesTextDisplayMode.NONE;
        }
        return this._$2;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGraphNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Deprecated
    public boolean IsAllDirectionsOverlapedAvoided() {
        return this.isAllDirectionsOverlappedAvoided();
    }

    public boolean isAllDirectionsOverlappedAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_IsAllDirectionOverlap(this.getHandle());
    }

    @Deprecated
    public void setAllDirectionsOverlapedAvoided(boolean bl) {
        this.setAllDirectionsOverlappedAvoided(bl);
    }

    public void setAllDirectionsOverlappedAvoided(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetAllDirectionOverlaped(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                if (this._$5 != null) {
                    InternalGeoStyle.clearHandle(this._$5);
                    this._$5 = null;
                }
                if (this._$4 != null) {
                    InternalTextStyle.clearHandle(this._$4);
                }
                if (this._$3 != null) {
                    InternalTextStyle.clearHandle(this._$3);
                }
                this._$3();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    protected void clearHandle() {
        if (this._$6 != null) {
            this._$4();
            this._$6 = null;
        }
        if (this._$5 != null) {
            InternalGeoStyle.clearHandle(this._$5);
            this._$5 = null;
        }
        if (this._$4 != null) {
            InternalTextStyle.clearHandle(this._$4);
        }
        if (this._$3 != null) {
            InternalTextStyle.clearHandle(this._$3);
        }
        this.setHandle(0L);
    }

    ArrayList getGraphItemsList() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphItemsList()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    private void _$4() {
        int n = this._$6.size();
        for (int i = 0; i < n; ++i) {
            ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this._$6.get(i));
            themeGraphItem.clearHandle();
        }
        this._$6.clear();
    }

    private void _$3() {
        if (this._$6 != null) {
            this._$4();
        }
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l, this);
            this._$6.add(themeGraphItem);
        }
    }

    private void _$2() {
        int n = this.getCount();
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        ThemeGraphNative.jni_GetItemAndStyleHandles(this.getHandle(), lArray, lArray2);
        for (int i = 0; i < n; ++i) {
            ThemeGraphItem themeGraphItem = this.getItem(i);
            themeGraphItem.refreshItemAndStyle(lArray[i], lArray2[i]);
        }
    }

    private void _$1() {
        long l;
        if (this._$1 != null && this._$1.getDataset() != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1.getDataset())) != 0L) {
            ThemeGraphNative.jni_CalculateExtremum(this.getHandle(), l);
        }
    }
}

