/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.data.DatasetType;
import com.supermap.data.Enum;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.Workspace;
import com.supermap.layout.BufferImageNative;
import com.supermap.layout.InternalEnum;
import com.supermap.layout.InternalHandleDisposable;
import com.supermap.layout.InternalResource;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

class InternalBufferImage
extends InternalHandleDisposable {
    private Image _$4 = null;
    private int _$3;
    private int _$2;
    private int[] _$1;

    public InternalBufferImage(int n, int n2) {
        this._$3 = n;
        this._$2 = n2;
        this._$1 = new int[n * n2];
        long l = BufferImageNative.jni_New(n, n2);
        this.setHandle(l, true);
    }

    public void resize(int n, int n2) {
        if (n > 0 && n2 > 0 && (this._$3 != n || this._$2 != n2)) {
            BufferImageNative.jni_Resize(this.getHandle(), n, n2);
            this._$3 = n;
            this._$2 = n2;
            this._$1 = new int[n * n2];
        }
    }

    public void dispose() {
        long l = this.getHandle();
        if (l != 0L) {
            BufferImageNative.jni_Delete(l);
            this.setHandle(0L);
        }
    }

    public int getWidth() {
        return this._$3;
    }

    public int getHeight() {
        return this._$2;
    }

    public Image getMemoryImage() {
        BufferImageNative.jni_GetImage(this.getHandle(), this._$1);
        MemoryImageSource memoryImageSource = new MemoryImageSource(this._$3, this._$2, this._$1, 0, this._$3);
        this._$4 = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        return this._$4;
    }

    private void _$1(Graphics graphics, int n, int n2) {
        Image image = this.getMemoryImage();
        graphics.drawImage(image, n, n2, null);
    }

    static int getSymbolItemIndex(int n, DatasetType datasetType, Workspace workspace) {
        if (datasetType == null) {
            String string = InternalResource.loadString("datasetType", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = InternalEnum.getUGCValue((Enum)datasetType);
        return BufferImageNative.jni_GetSymbolItemIndex(l, n2, n);
    }

    static double getMarkerSymbolDefaultSize(Workspace workspace, int n) {
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return BufferImageNative.jni_GetSymbolDefaultSize(l, n);
    }

    static boolean drawRegion(Graphics graphics, Point2Ds point2Ds, GeoStyle geoStyle, Workspace workspace) {
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            Object object;
            int n;
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            Rectangle2D rectangle2D = geoRegion.getBounds();
            int n2 = rectangle2D.getWidth() > rectangle2D.getHeight() ? (int)rectangle2D.getWidth() : (int)rectangle2D.getHeight();
            if (InternalBufferImage.getSymbolItemIndex(geoStyle.getFillSymbolID(), DatasetType.REGION, workspace) < 0) {
                int n3 = point2Ds.getCount();
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                for (int i = 0; i < point2Ds.getCount(); ++i) {
                    nArray[i] = (int)point2Ds.getItem(i).getX();
                    nArray2[i] = (int)point2Ds.getItem(i).getY();
                }
                graphics.setColor(geoStyle.getFillForeColor());
                graphics.fillPolygon(nArray, nArray2, n3);
                InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
                return true;
            }
            InternalBufferImage internalBufferImage = new InternalBufferImage(n2 + 1, n2 + 1);
            for (n = 0; n < point2Ds.getCount(); ++n) {
                object = point2Ds.getItem(n);
                object.setX(object.getX() - rectangle2D.getLeft());
                object.setY(object.getY() - rectangle2D.getBottom());
                point2Ds.setItem(n, object);
            }
            geoRegion.dispose();
            InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
            geoRegion = null;
            n = point2Ds.getCount();
            object = new double[n];
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                object[i] = (Point2D)point2Ds.getItem(i).getX();
                dArray[i] = point2Ds.getItem(i).getY();
            }
            if (BufferImageNative.jni_DrawFillSymbol(internalBufferImage.getHandle(), l2, l, (double[])object, dArray)) {
                internalBufferImage._$1(graphics, (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom());
                internalBufferImage.dispose();
                internalBufferImage = null;
                InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
            return false;
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        return false;
    }

    static boolean drawLine(Graphics graphics, Point2Ds point2Ds, GeoStyle geoStyle, Workspace workspace) {
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            Object object;
            int n;
            int n2;
            GeoLine geoLine = new GeoLine(point2Ds);
            Rectangle2D rectangle2D = geoLine.getBounds();
            int n3 = 0;
            int n4 = 0;
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                n2 = (int)rectangle2D.getWidth();
                n4 = (int)rectangle2D.getWidth() / 2;
            } else {
                n2 = (int)rectangle2D.getHeight();
                n3 = (int)rectangle2D.getHeight() / 2;
            }
            if (InternalBufferImage.getSymbolItemIndex(geoStyle.getLineSymbolID(), DatasetType.LINE, workspace) < 0) {
                int n5 = point2Ds.getCount();
                int[] nArray = new int[n5];
                int[] nArray2 = new int[n5];
                for (int i = 0; i < point2Ds.getCount(); ++i) {
                    nArray[i] = (int)point2Ds.getItem(i).getX();
                    nArray2[i] = (int)point2Ds.getItem(i).getY();
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n6 = (int)geoStyle.getLineWidth();
                if (n6 > 3) {
                    n6 = 3;
                }
                graphics2D.setStroke(new BasicStroke(n6));
                graphics2D.setColor(geoStyle.getLineColor());
                graphics2D.drawPolyline(nArray, nArray2, n5);
                return true;
            }
            InternalBufferImage internalBufferImage = new InternalBufferImage(n2 + 1, n2 + 1);
            for (n = 0; n < point2Ds.getCount(); ++n) {
                object = point2Ds.getItem(n);
                object.setX(object.getX() - rectangle2D.getLeft() + (double)n3);
                object.setY(object.getY() - rectangle2D.getBottom() + (double)n4);
                point2Ds.setItem(n, object);
            }
            geoLine.dispose();
            geoLine = null;
            n = point2Ds.getCount();
            object = new double[n];
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                object[i] = (Point2D)point2Ds.getItem(i).getX();
                dArray[i] = point2Ds.getItem(i).getY();
            }
            if (BufferImageNative.jni_DrawLineSymbol(internalBufferImage.getHandle(), l2, l, (double[])object, dArray)) {
                internalBufferImage._$1(graphics, (int)rectangle2D.getLeft() - n3, (int)rectangle2D.getBottom() - n4);
                internalBufferImage.dispose();
                internalBufferImage = null;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    static boolean drawPoint(Graphics graphics, int n, int n2, GeoStyle geoStyle, Workspace workspace) {
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)workspace);
        if (l2 == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            int n3;
            Size2D size2D = geoStyle.getMarkerSize();
            if (size2D.getHeight() < 0.0 || size2D.getWidth() < 0.0) {
                return false;
            }
            double d = size2D.getWidth();
            if (size2D.getWidth() <= 1.0E-7) {
                d = InternalBufferImage.getMarkerSymbolDefaultSize(workspace, geoStyle.getMarkerSymbolID());
            }
            if ((n3 = (int)(d * 82.0 / 25.4)) == 0) {
                n3 = 1;
            }
            if (InternalBufferImage.getSymbolItemIndex(geoStyle.getMarkerSymbolID(), DatasetType.POINT, workspace) < 0) {
                graphics.setColor(geoStyle.getLineColor());
                graphics.fillArc(n, n2, n3, n3, 0, 360);
                return true;
            }
            InternalBufferImage internalBufferImage = new InternalBufferImage(n3, n3);
            if (BufferImageNative.jni_DrawMarkerSymbol(internalBufferImage.getHandle(), l2, l, n, n2)) {
                internalBufferImage._$1(graphics, n, n2);
                internalBufferImage.dispose();
                internalBufferImage = null;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }
}

