/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.topology;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TopologyDatasetRelationItem;
import com.supermap.data.TopologyRule;
import com.supermap.data.topology.InternalDatasetVector;
import com.supermap.data.topology.InternalDatasets;
import com.supermap.data.topology.InternalHandle;
import com.supermap.data.topology.InternalResource;
import com.supermap.data.topology.InternalToolkitTolopogy;
import com.supermap.data.topology.TopologyPreprocessOptions;
import com.supermap.data.topology.TopologyValidatorNative;
import java.util.Vector;

public class TopologyValidator {
    private static transient Vector _$1;

    private TopologyValidator() {
    }

    public static boolean preprocess(DatasetTopology datasetTopology) {
        if (datasetTopology == null) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetTopology);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        return TopologyValidatorNative.jni_preprocess(l);
    }

    public static boolean preprocess(TopologyDatasetRelationItem[] topologyDatasetRelationItemArray, double d) {
        int n;
        if (topologyDatasetRelationItemArray == null) {
            String string = InternalResource.loadString("items", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = topologyDatasetRelationItemArray.length;
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)topologyDatasetRelationItemArray[n].getDataset());
            if (lArray[n] == 0L) {
                bl = false;
                break;
            }
            if (topologyDatasetRelationItemArray[n].getDataset().getType() != DatasetType.POINT && topologyDatasetRelationItemArray[n].getDataset().getType() != DatasetType.LINE && topologyDatasetRelationItemArray[n].getDataset().getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            nArray[n] = topologyDatasetRelationItemArray[n].getPrecisionOrder();
        }
        if (!bl) {
            String string = InternalResource.loadString("items", "TopologyValidator_TopologyDatasetRelationItemInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess1(lArray, nArray, d) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess(DatasetVector[] datasetVectorArray, int[] nArray, double d) {
        if (datasetVectorArray == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectorArray.length != nArray.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        TopologyDatasetRelationItem[] topologyDatasetRelationItemArray = new TopologyDatasetRelationItem[datasetVectorArray.length];
        for (int i = 0; i < topologyDatasetRelationItemArray.length; ++i) {
            if (datasetVectorArray[i].getType() != DatasetType.POINT && datasetVectorArray[i].getType() != DatasetType.LINE && datasetVectorArray[i].getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string);
            }
            topologyDatasetRelationItemArray[i] = new TopologyDatasetRelationItem(datasetVectorArray[i], nArray[i]);
        }
        return TopologyValidator.preprocess(topologyDatasetRelationItemArray, d);
    }

    public static boolean preprocess(DatasetVector[] datasetVectorArray, int[] nArray, TopologyPreprocessOptions topologyPreprocessOptions, double d) {
        int n;
        if (datasetVectorArray == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectorArray.length != nArray.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (topologyPreprocessOptions == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = datasetVectorArray.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (datasetVectorArray[n].getType() != DatasetType.POINT && datasetVectorArray[n].getType() != DatasetType.LINE && datasetVectorArray[n].getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess2(lArray, nArray, topologyPreprocessOptions.areArcsInserted(), topologyPreprocessOptions.areVertexArcInserted(), topologyPreprocessOptions.areVertexesSnapped(), topologyPreprocessOptions.arePolygonsChecked(), d) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess(Recordset[] recordsetArray, int[] nArray, TopologyPreprocessOptions topologyPreprocessOptions, double d) {
        int n;
        if (recordsetArray == null) {
            String string = InternalResource.loadString("recordsets", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordsetArray.length != nArray.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (topologyPreprocessOptions == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = recordsetArray.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (recordsetArray[n].getDataset().getType() != DatasetType.POINT && recordsetArray[n].getDataset().getType() != DatasetType.LINE && recordsetArray[n].getDataset().getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordsetArray[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("recordsets", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess3(lArray, nArray, topologyPreprocessOptions.areArcsInserted(), topologyPreprocessOptions.areVertexArcInserted(), topologyPreprocessOptions.areVertexesSnapped(), topologyPreprocessOptions.arePolygonsChecked(), d) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean validate(DatasetTopology datasetTopology, GeoRegion geoRegion) {
        if (datasetTopology == null) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetTopology);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetTopology", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (geoRegion != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion)) == 0L) {
            String string = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = TopologyValidatorNative.jni_validate(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return bl;
    }

    public static DatasetVector validate(DatasetVector datasetVector, DatasetVector datasetVector2, TopologyRule topologyRule, double d, GeoRegion geoRegion, Datasource datasource, String string) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string3 = InternalResource.loadString("sourceDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string4 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            if (l2 == 0L) {
                String string5 = InternalResource.loadString("validatingDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
                throw new IllegalArgumentException(string5);
            }
            if (datasetVector2.getType() != DatasetType.POINT && datasetVector2.getType() != DatasetType.LINE && datasetVector2.getType() != DatasetType.REGION) {
                String string6 = InternalResource.loadString("validatingDataset", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (topologyRule == null) {
            String string7 = InternalResource.loadString("rule", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string7);
        }
        long l3 = 0L;
        if (geoRegion != null && (l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion)) == 0L) {
            String string8 = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasource == null) {
            String string9 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string9);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l4 == 0L) {
            String string10 = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string10);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string11 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string11);
        }
        long l5 = TopologyValidatorNative.jni_validate1(l, l2, topologyRule.value(), d, l3, l4, string);
        DatasetVector datasetVector3 = null;
        if (l5 != 0L) {
            datasetVector3 = InternalDatasetVector.createInstance(l5, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector3);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return datasetVector3;
    }

    public static DatasetVector validate(Recordset recordset, Recordset recordset2, TopologyRule topologyRule, double d, GeoRegion geoRegion, Datasource datasource, String string) {
        if (recordset == null) {
            String string2 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string3 = InternalResource.loadString("sourceRecordset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string3);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string4 = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = 0L;
        if (recordset2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset2);
            if (l2 == 0L) {
                String string5 = InternalResource.loadString("validatingRecordset", "Handle_ObjectHasBeenDisposed", "topology_resources");
                throw new IllegalArgumentException(string5);
            }
            if (recordset2.getDataset().getType() != DatasetType.POINT && recordset2.getDataset().getType() != DatasetType.LINE && recordset2.getDataset().getType() != DatasetType.REGION) {
                String string6 = InternalResource.loadString("validatingRecordset", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (topologyRule == null) {
            String string7 = InternalResource.loadString("rule", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string7);
        }
        long l3 = 0L;
        if (geoRegion != null && (l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion)) == 0L) {
            String string8 = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasource == null) {
            String string9 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string9);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l4 == 0L) {
            String string10 = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string10);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string11 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string11);
        }
        long l5 = TopologyValidatorNative.jni_validate2(l, l2, topologyRule.value(), d, l3, l4, string);
        DatasetVector datasetVector = null;
        if (l5 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l5, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return datasetVector;
    }

    public static boolean fixTopoError(DatasetVector datasetVector, DatasetVector datasetVector2, DatasetVector datasetVector3) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (datasetVector2 != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2)) == 0L) {
            String string = InternalResource.loadString("validatingDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3 == null) {
            String string = InternalResource.loadString("topoErrorDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector3);
        if (l3 == 0L) {
            String string = InternalResource.loadString("topoErrorDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector3.getRecordCount() <= 0) {
            return false;
        }
        return TopologyValidatorNative.jni_fixErrorAuto(l, l2, l3);
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "TopologyValidator";
        boolean bl = InternalToolkitTolopogy.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        TopologyValidator.fireStepped(steppedEvent);
        InternalToolkitTolopogy.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }
}

