/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.Serializable;
import java.security.Principal;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChallengeResponse {
    private volatile boolean authenticated;
    private volatile String credentials;
    private volatile String identifier;
    private volatile Series<Parameter> parameters;
    private volatile ChallengeScheme scheme;
    private volatile char[] secret;

    public ChallengeResponse(ChallengeScheme scheme, String credentials) {
        this.scheme = scheme;
        this.credentials = credentials;
        this.identifier = null;
        this.secret = null;
        this.parameters = null;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret) {
        this.scheme = scheme;
        this.credentials = null;
        this.identifier = identifier;
        this.secret = secret;
        this.parameters = null;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, Series<Parameter> parameters) {
        this.scheme = scheme;
        this.credentials = null;
        this.identifier = identifier;
        this.secret = null;
        this.parameters = parameters;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this.scheme = scheme;
        this.credentials = null;
        this.identifier = identifier;
        this.secret = secret != null ? secret.toCharArray() : null;
        this.parameters = null;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof ChallengeResponse) {
            ChallengeResponse that = (ChallengeResponse)obj;
            if (this.getCredentials() != null) {
                result = this.getCredentials().equals(that.getCredentials());
            } else {
                boolean bl2 = result = that.getCredentials() == null;
            }
            if (result) {
                if (this.getIdentifier() != null) {
                    result = this.getIdentifier().equals(that.getIdentifier());
                } else {
                    boolean bl3 = result = that.getIdentifier() == null;
                }
                if (result) {
                    if (this.getScheme() != null) {
                        result = this.getScheme().equals(that.getScheme());
                    } else {
                        boolean bl4 = result = that.getScheme() == null;
                    }
                    if (result) {
                        if (this.getSecret() == null || that.getSecret() == null) {
                            result = this.getSecret() == that.getSecret();
                        } else if (this.getSecret().length == that.getSecret().length) {
                            boolean equals = true;
                            for (int i = 0; i < this.getSecret().length && equals; ++i) {
                                equals = this.getSecret()[i] == that.getSecret()[i];
                            }
                            result = equals;
                        }
                    }
                }
            }
        }
        return result;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Form();
        }
        return this.parameters;
    }

    public Principal getPrincipal() {
        return new PrincipalImpl();
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public char[] getSecret() {
        return this.secret;
    }

    public int hashCode() {
        return Engine.hashCode(this.getScheme(), this.getIdentifier(), this.getSecret() == null ? null : new String(this.getSecret()), this.getCredentials());
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setCredentialComponents(Series<Parameter> credentialComponents) {
        this.parameters = credentialComponents;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setScheme(ChallengeScheme scheme) {
        this.scheme = scheme;
    }

    public void setSecret(char[] secret) {
        this.secret = secret;
    }

    public void setSecret(String secret) {
        this.secret = secret == null ? null : secret.toCharArray();
    }

    private final class PrincipalImpl
    implements Principal,
    Serializable {
        private static final long serialVersionUID = -1842197948591956691L;

        private PrincipalImpl() {
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (!(another instanceof Principal)) {
                return false;
            }
            Principal otherPrinc = (Principal)another;
            return this.getName().equals(otherPrinc.getName());
        }

        public String getName() {
            return ChallengeResponse.this.getIdentifier();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

