/**
 * 流程实例管理
 * 
 * @author 袁晓冬
 */
$.namespace("wf.task");
/** 一览控件 */
wf.task.$grid = null;
/** 公用代码【是否】 */
wf.task.sfCodeArray = null;
/** 流程公用弹出窗口 */
wf.task.$popWin = null;
/** 查询面板-业务名称 */
wf.task.q$bizsname = null;
/** 查询面板-流程步骤 */
wf.task.q$stepname = null;
/** 查询面板-处理人 */
wf.task.q$assigneename = null;
/** 查询面板-发送人 */
wf.task.q$sendername = null;
/** 初始化组件引用 */
wf.task.initComp = function() {
    wf.task.$grid = $('#grid');
    wf.task.$popWin = $('#popWin');
    wf.task.q$bizsname = $('#qbizsname');
    wf.task.q$stepsname = $('#qstepsname');
    wf.task.q$assigneesname = $('#qassigneesname');
    wf.task.q$sendersname = $('#qsendersname');
}
/** 页面初始化 */
wf.task.init = function() {
    wf.task.initComp();
    // 初始化一览列表
    wf.task.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/wf/task/list",
    });
}
/**
 * 转办
 */
wf.task.transfer = function() {
    var rows = wf.task.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.prompt('提示信息', '请输入办理人：', function(uname) {
            if (uname) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].taskId);
                });
                $.post($.ctx + "/wf/task/transfer", {
                    ids : ids.join(","),
                    uname : uname
                }, function(data, status) {
                    if (data.success) {
                        wf.task.$grid.datagrid('reload');
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");

            }
        });
    }
    else {
        $.messager.alert("提示", "请选择要转办的任务！");
    }

}
/**
 * 更新流程状态
 */
wf.task.jump = function() {
    var row = wf.task.getOneRow();
    if (!row) return;
    $.post($.ctx + "/wf/task/queryActivityIds", {
        taskId : row.taskId
    }, function(data, status) {
        if (data.success) {
            $.messager.prompt('提示信息', '请输入跳转到的步骤：<br>' + data.attrs.steps, function(activityId) {
                if (activityId) {
                    $.post($.ctx + "/wf/task/jump", {
                        taskId :row.taskId,
                        activityId : activityId
                    }, function(data, status) {
                        if (data.success) {
                            wf.task.$grid.datagrid('reload');
                        }
                        else {
                            $.messager.showError(data.message);
                        }
                    }, "json");

                }
            });
        }
        else {
            $.messager.showError(data.message);
        }
    }, "json");

}
/**
 * 选择一条记录
 */
wf.task.getOneRow = function() {
    var rows = wf.task.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            return rows[0];
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
            return null;
        }
    }
    else {
        $.messager.alert("提示", "请选择记录！");
        return null;
    }
}
/**
 * 结束流程
 */
wf.task.endProcess = function() {
    var row = wf.task.getOneRow();
    if (!row) return;
    $.post($.ctx + "/wf/task/endProcess", {
        taskId :row.taskId
    }, function(data, status) {
        if (data.success) {
            wf.task.$grid.datagrid('reload');
        }
        else {
            $.messager.showError(data.message);
        }
    }, "json");
}
/** 刷新一览列表 */
wf.task.refreshGrid = function() {
    
    
    // 刷新一览列表
    wf.task.$grid.datagrid({
    	pageSize : 20,
        url : $.ctx + "/wf/task/list",
        
    });
}
