/**
 * 流程实例管理
 * 
 * @author 袁晓冬
 */
$.namespace("wf.instance");
/** 一览控件 */
wf.instance.$grid = null;
/** 公用代码【是否】 */
wf.instance.sfCodeArray = null;
/** 流程公用弹出窗口 */
wf.instance.$popWin = null;
/** 查询面板-当前节点 */
wf.instance.q$activityname = null;
/** 查询面板-是否挂起 */
wf.instance.q$suspended= null;
/** 初始化组件引用 */
wf.instance.initComp = function() {
    wf.instance.$grid = $('#grid');
    wf.instance.$popWin = $('#popWin');
    wf.instance.q$activityname = $('#qactivityname');
    wf.instance.q$suspended = $('#qsuspended');
}
/** 页面初始化 */
wf.instance.init = function() {
    wf.instance.initComp();
    wf.instance.initCombox();
    // 初始化一览列表
    wf.instance.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/wf/instance/list",
    });
}
/**
 * XML链接格式化
 */
wf.instance.xmlFormatter = function(value, rowData, rowIndex) {
    return "<a target='_blank' href='" + $.ctx + "/wf/process/readResource?processDefinitionId="
            + rowData.processDefinitionId + "&resourceType=xml'>查看</a>";
}
/**
 * 流程图链接格式化
 */
wf.instance.imageFormatter = function(value, rowData, rowIndex) {
    return "<a target='_blank' href='" + $.ctx + "/wf/process/readResource?processDefinitionId="
            + rowData.processDefinitionId + "&resourceType=image'>查看</a>";
}
/**
 * 删除流程
 */
wf.instance.deleteProcess = function() {
    var rows = wf.instance.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].deploymentId);
                });
                $.post($.ctx + "/wf/process/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        wf.instance.$grid.datagrid('reload');
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的流程！");
    }

}
/**
 * 更新流程状态
 */
wf.instance.updateState = function() {
    var row = wf.instance.getOneRow();
    if (!row) return;
    var msg = "确定要";
    if (row.suspended) {
        msg += "激活";
    }
    else {
        msg += "挂起";
    }
    msg += "流程【" + row.processInstanceId + "】吗？"
    $.messager.confirm("确认", msg, function(msg) {
        if (msg) {
            $.post($.ctx + "/wf/instance/updateState", {
                processInstanceId : row.id,
                state : row.suspended ? "active" : "suspend"
            }, function(data, status) {
                if (data.success) {
                    wf.instance.$grid.datagrid('reload');
                }
                else {
                    $.messager.showError(data.message);
                }
            }, "json");
        }
    });
}
/**
 * 选择一条记录
 */
wf.instance.getOneRow = function() {
    var rows = wf.instance.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            return rows[0];
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
            return null;
        }
    }
    else {
        $.messager.alert("提示", "请选择记录！");
        return null;
    }
}
/**
 * 部署流程
 */
wf.instance.deploy = function() {
    $.messager.alert("提示", "敬请期待！");
}
wf.instance.viewFlow=function(obj){
    var row = wf.instance.getOneRow();
    if (!row) return;
    obj.pid = row.id;
    graphTrace(obj);
}
/**
 * 初始化下拉框
 */
wf.instance.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(wf.instance.sfCodeArray);
    
    wf.instance.q$suspended.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false
    });
};
/** 刷新一览列表 */
wf.instance.refreshGrid = function() {
    
    
    // 刷新一览列表
    wf.instance.$grid.datagrid({
    	pageSize : 20,
        url : $.ctx + "/wf/instance/list",
        
    });
}
