/**
 * 菜单维护js
 * 
 * @author 袁晓冬
 */
$.namespace("user.main");
/** 一览控件 */
user.main.$grid = null;
/** 通用弹窗 */
user.main.$popWin = null;
/** 公用代码【是否】 */
user.main.sfCodeArray = null;
/** 查询面板-用户名 */
user.main.q$username = null;
/** 查询面板-是否有效 */
user.main.q$valid = null;
user.main.orgid = null;
/** 组织树 */
user.main.$orgTree = null;
/** 初始化组件引用 */
user.main.initComp = function() {
    user.main.$grid = $('#grid');
    user.main.q$valid = $('#qvalid');
    user.main.q$username = $('#qusername');
    user.main.$popWin = $('#popWin');
    user.main.$orgTree = $('#orgTree');
}

/**
 * 判断是否为空
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str){
    if(str!=null&&str!=""&&str.length!=0){
        return false;
    }else{
        return true;
    }
}

/** 页面初始化 */
user.main.init = function() {
    user.main.initComp();
    user.main.initCombox();
    // 初始化字典树
    user.main.$orgTree.tree({
        url : $.ctx + "/workflow/showUserTree"+"?"+Math.random(),
        method : 'post',
        queryParams : {
            root : "false"
        },
        onLoadSuccess:function(node,data){  
            var n = $("#orgTree").tree("getRoots");  
            if(isEmpty(user.main.orgid)){
                $("#orgTree li:eq(0)").find("div:eq(0)").click();
            }else {
                $.each(n,function(a,b){
                    if(b.id == user.main.orgid ){
                       $("#orgTree").tree("select",b.target);  
                   }
               })
            }
         },
        onClick : function(node) {
            if(isEmpty(node.parent)){
                user.main.refreshUser(node);
            }else{
                user.main.refreshGrid(node);
            }
        }
    });
    user.main.initpage()
}

/** 页面初始化 */
user.main.initpage = function() {
    $("#pagetools").hide();
    // 把form传入，构造翻页控件
    pageinfo($("#rform"));// 见common.js
}

/**
 * 初始化下拉框
 */
user.main.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(user.main.sfCodeArray);
    dataArr.push({
        'code' : '',
        'text' : '全部'
    });
    user.main.q$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false
    });
};
/** 根据树图所选择的节点刷新一览列表 */
user.main.refreshGrid = function(node) {
    if (!node) {
        node = user.main.$orgTree.tree('getSelected');
    }
    if (!node) {
        return;
    }
    window.location = $.ctx + "/userManage/main?orgid="+node.id;
    
}

user.main.refreshUser = function(node) {
    if (!node) {
        node = user.main.$orgTree.tree('getSelected');
    }
    if (!node) {
        return;
    }
    window.location=$.ctx + '/userManage/edit?orgid=' +user.main.orgid +"&id="+node.id;
}
/**
 * 记录新增处理
 */
user.main.doAdd = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择用户所属组织！');
        return;
    }
    window.location=$.ctx + '/userManage/add?orgid=' + selectedNode.id;

}
/**
 * 记录编辑处理
 */
user.main.doEdit = function() {
    var rows = user.main.getSelectedRecords();
    if (rows.length > 0) {
        if (rows.length == 1) {
            window.location=$.ctx + '/userManage/edit?orgid=' +user.main.orgid +"&id="+rows[0];
        } else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    } else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }
}
/** 删除处理 */
user.main.doDel = function() {
    var rows = user.main.getSelectedRecords();
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/user/delete", {
                    ids : rows.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        user.main.$popWin.dialog('close');
                        user.main.refreshGrid();
                    } else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    } else {
        $.messager.alert("提示", "请选择记录！");
    }
}
/**
 * 用户角色维护
 */
user.main.roleManager = function() {
    var rows = user.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            user.main.$popWin.dialog({
                href : $.ctx + "/user/roleManager",
                title : "角色关联",
                width : 450,
                queryParams : {
                    id : rows[0].id
                },
                onClose : user.main.refreshGrid
            }).dialog('open');
        } else {
            $.messager.alert("提示", "只能选择一个用户！");
        }
    } else {
        $.messager.alert("提示", "请选择要要维护的用户！");
    }
}
//刷新树图
user.main.treeReload = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if(!selectedNode){
    	user.main.$orgTree.tree('reload');	    	
    }else{
    	user.main.$orgTree.tree('reload', selectedNode.target);	
    }
}

/**
 * 全选/全不选
 */
user.main.all = function() {
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

/**
 * 获取选中的数据 返回选中数据的id数组
 */
user.main.getSelectedRecords = function() {
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function() {
        if ($(this).prop("checked")) {
            ids.push($(this).val());
        }
    });
    return ids;
}

user.main.back =function(){
    window.location = $.ctx + "/orgManage/main";
}

user.main.setPermission=function(id){
    window.location= $.ctx + "/userManage/auth/" + id;
}

//设置权限
user.main.setOrgQx = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织设置权限！');
        return;
    }   
    window.location= $.ctx + "/orgManage/auth/" + selectedNode.id;
}

/**
 * 创建组织处理
 */
user.main.doOrgAddRoot = function() {
    user.main.addOrg();
}

/**
 * 新增菜单
 */
user.main.addOrg = function(pid) {
    if (!pid) pid = ""
        window.location=$.ctx + '/orgManage/add?pid=' + pid;
}
/**
 * 创建下级组织处理
 */
user.main.doOrgAdd = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择上级组织！');
        return;
    }
    if (selectedNode.leaf != 'true') {
        user.main.addOrg(selectedNode.id);
    }
}
/**
 * 记录编辑处理
 */
user.main.doOrgEdit = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织！');
        return;
    }
    window.location.href=$.ctx + '/orgManage/edit?id=' + selectedNode.id;
           
}
/** 删除处理 */
user.main.doOrgDel = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织！');
        return;
    }
    var ch = user.main.$orgTree.tree('getChildren', selectedNode.target);
    if(ch.length > 0){
        $.messager.alert('提示', '请删除组织下的人员后再删除！');
        return;
    }
   $.messager.confirm("确认", "确定要删除吗？", function(msg) {
        if (msg) {
            $.post($.ctx + "/org/delete", {
                ids : selectedNode.id
            }, function(data, status) {
                if (data.success) {
                    location.href=$.ctx + '/userManage/main?t='+new Date() ;
                }
                else {
                    $.messager.showError(data.message);
                }
            }, "json");
        }
    });
  
}

user.main.resetPwd=function(id){
    $.messager.confirm("确认", "确定要重置密码吗？", function(msg) {
        if (msg) {
            $.post($.ctx + "/userManage/resetPwd", {
                id :  id
            }, function(data, status) {
                if (data.success) {
                    location.href=$.ctx + '/userManage/main?t='+new Date() ;
                }
                else {
                    $.messager.showError(data.message);
                }
            }, "json");
        }
    });
}