/**
 * 系统首页
 * 
 * @author 袁晓冬
 */
$.namespace("org.main");
/** 菜单树 */
org.main.$orgTree = null;
/** 一览控件 */
org.main.$grid = null;
/** 新增窗口 */
org.main.$popWin = null;
/** 用户窗口 */
org.main.$userWin = null;
/** 查询面板-组织名 */
org.main.q$orgname = null;
/** 查询面板-是否有效 */
org.main.q$valid = null;
/** 是否公用代码 */
org.main.sfCodeArray = null;
/** 初始化组件引用 */
org.main.initComp = function() {
    org.main.$orgTree = $('#orgTree');
    org.main.$grid = $('#grid');
    org.main.q$valid = $('#qvalid');
    org.main.q$orgname = $('#qorgname');
    org.main.$popWin = $('#popWin');
    org.main.$userWin =  $('#userWin');
}
org.main.refreshTree = function() {
    // 初始化字典树
    org.main.$orgTree.tree({
        url : $.ctx + "/org/tree",
        method : 'get',
        checkbox : false,
        queryParams : {},
        onClick : function(node) {
            org.main.refreshGrid(node);
        }
    });
}

/** 页面初始化 */
org.main.init = function() {
    org.main.initComp();
    org.main.initCombox();
    org.main.refreshTree();
    // 初始化一览
    org.main.$grid.datagrid({
        pageSize : 20,
        onBeforeLoad : function(param) {
            param.orgname = $.trim(org.main.q$orgname.val());
            param.valid = org.main.q$valid.combobox('getValue');
        }
    });
}
/**
 * 初始化下拉框
 */
org.main.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(org.main.sfCodeArray);
    dataArr.push({
        'code' : '',
        'text' : '全部'
    });
    org.main.q$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false
    });
};
/** 根据树图所选择的节点刷新一览列表 */
org.main.refreshGrid = function(node) {
    if (!node) {
        node = org.main.$orgTree.tree('getSelected');
    }
    if (!node) { return; }
    // 刷新一览列表
    org.main.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/org/list",
        queryParams : {
            pid : node.id
        }
    });
}
/**
 * 创建组织处理
 */
org.main.doAddRoot = function() {
    org.main.addOrg();
}
/**
 * 创建下级组织处理
 */
org.main.doAdd = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择上级组织！');
        return;
    }
    if (selectedNode.leaf != 'true') {
        org.main.addOrg(selectedNode.id);
    }
}
/**
 * 记录编辑处理
 */
org.main.doEdit = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织！');
        return;
    }
    window.location=$.ctx + '/orgManage/edit?id=' + selectedNode.id;
           
}
/** 删除处理 */
org.main.doDel = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织！');
        return;
    }

    $.messager.confirm("确认", "确定要删除吗？", function(msg) {
        if (msg) {
            $.post($.ctx + "/org/delete", {
                ids : selectedNode.id
            }, function(data, status) {
                if (data.success) {
                    window.location = $.ctx + '/orgManage/main';
                }
                else {
                    $.messager.showError(data.message);
                }
            }, "json");
        }
    });
  
}
/**
 * 新增菜单
 */
org.main.addOrg = function(pid) {
    if (!pid) pid = ""
        window.location=$.ctx + '/orgManage/add?pid=' + pid;
}

/**
 * 组织性质维护
 */
org.main.attrManeger = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择上级字典编码！');
        return;
    }
    // 组织性质维护
    if (selectedNode.leaf != 'true') {
        org.main.$popWin.dialog({
            href : $.ctx + '/org/attr?id=' + selectedNode.id,
            title : "组织性质维护"
        }).dialog('open');
    }
}
// 刷新树图
org.main.treeReload = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        org.main.$orgTree.tree('reload');
    }
    else {
        org.main.$orgTree.tree('reload', selectedNode.target);
    }
}
//设置权限
org.main.setQx = function() {
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织设置权限！');
        return;
    }   
    window.location= $.ctx + "/orgManage/auth/" + selectedNode.id;
}

//用户管理 
org.main.userMgr = function(){
    var selectedNode = org.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择组织查看用户管理！');
        return;
    }   
    window.location=$.ctx + '/userManage/main?orgid=' + selectedNode.id;
}