/**
 * 菜单详细画面用js
 * 
 * @author 袁晓冬
 */
$.namespace("user.role");
/** 用户窗口 */
user.role.$roleGrid = null;
/** 角色数据 */
user.role.data = null;
/** 初始化组件引用 */
user.role.initComp = function() {
    user.role.$roleGrid = $('#roleGrid');
}
/** 页面初始化 */
user.role.init = function() {
    // 转换数据字符串为对象
    user.role.initComp();
    // 初始化一览列表
    user.role.$roleGrid.datagrid({
        url : $.ctx + "/user/listUserRoles?userid=" + user.role.data["id"],
        pageSize : 20,
        onBeforeLoad : function(param) {
        }
    });
}
/**
 * 保存菜单
 */
user.role.add = function() {
    // 初始化一览列表
    $('#roleListGrid').datagrid({
        url : $.ctx + "/user/listRoles",
        pageSize : 20,
        onBeforeLoad : function(param) {
            param["oid"] = user.role.data["org"];
            param["uid"] = user.role.data["id"];
        },
        onLoadSuccess : function(data) {
            $('#roleListWin').dialog('open');
        }
    });

}
user.role.remove = function() {
    var rows = user.role.$roleGrid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要移除选中的角色吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].id);
                });
                $.post($.ctx + "/user/deleteRoles", {
                    rids : ids.join(","),
                    uid : user.role.data["id"]
                }, function(data, status) {
                    if (data.success) {
                        user.role.$roleGrid.datagrid({
                            url : $.ctx + "/user/listUserRoles?userid=" + user.role.data["id"]
                        });
                    } else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    } else {
        $.messager.alert("提示", "请选择要移除的角色！");
    }
}
user.role.ok = function() {
    var rows = $('#roleListGrid').datagrid("getSelections");
    if (rows.length > 0) {
        // 确认删除
        var ids = [];
        $.each(rows, function(i) {
            ids.push(rows[i].id);
        });
        $.post($.ctx + "/user/addRoles", {
            rids : ids.join(","),
            uid : user.role.data["id"]
        }, function(data, status) {
            if (data.success) {
                $('#roleListWin').dialog('close');
                user.main.refreshGrid();
                user.role.$roleGrid.datagrid({
                    url : $.ctx + "/user/listUserRoles?userid=" + user.role.data["id"]
                });
            } else {
                $.messager.showError(data.message);
            }
        }, "json");
    }
}