/**
 * 菜单维护js
 * 
 * @author 袁晓冬
 */
$.namespace("user.main");
/** 一览控件 */
user.main.$grid = null;
/** 通用弹窗 */
user.main.$popWin = null;
/** 公用代码【是否】 */
user.main.sfCodeArray = null;
/** 查询面板-用户名 */
user.main.q$username = null;
/** 查询面板-是否有效 */
user.main.q$valid = null;
/** 组织树 */
user.main.$orgTree = null;
/** 初始化组件引用 */
user.main.initComp = function() {
    user.main.$grid = $('#grid');
    user.main.q$valid = $('#qvalid');
    user.main.q$username = $('#qusername');
    user.main.$popWin = $('#popWin');
    user.main.$orgTree = $('#orgTree');
}
/** 页面初始化 */
user.main.init = function() {
    user.main.initComp();
    user.main.initCombox();
    // 初始化字典树
    user.main.$orgTree.tree({
        url : $.ctx + "/org/tree",
        method : 'get',
        queryParams : {
            root : "false"
        },
        onClick : function(node) {
            user.main.refreshGrid(node);
        }
    });
    // 初始化一览列表
    user.main.$grid.datagrid({
        pageSize : 20,
        onBeforeLoad : function(param) {
            param.username = $.trim(user.main.q$username.val());
            param.valid = user.main.q$valid.combobox('getValue');
        }
    });
}

/**
 * 初始化下拉框
 */
user.main.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(user.main.sfCodeArray);
    dataArr.push({
        'code' : '',
        'text' : '全部'
    });
    user.main.q$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false
    });
};
/** 根据树图所选择的节点刷新一览列表 */
user.main.refreshGrid = function(node) {
    if (!node) {
        node = user.main.$orgTree.tree('getSelected');
    }
    if (!node) {
        return;
    }
    // 刷新一览列表
    user.main.$grid.datagrid({
        url : $.ctx + "/user/list",
        queryParams : {
            orgid : node.id
        }
    });
}
/**
 * 记录新增处理
 */
user.main.doAdd = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        $.messager.alert('提示', '请选择用户所属组织！');
        return;
    }
    user.main.$popWin.dialog({
        href : $.ctx + '/user/add?orgid=' + selectedNode.id,
        title : "用户新增"
    }).dialog('open');

}
/**
 * 记录编辑处理
 */
user.main.doEdit = function() {
    var rows = user.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            user.main.$popWin.dialog({
                href : $.ctx + "/user/edit",
                title : "编辑",
                queryParams : {
                    id : rows[0].id
                },
                onClose : user.main.refreshGrid
            }).dialog('open');
        } else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    } else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }
}
/** 删除处理 */
user.main.doDel = function() {
    var rows = user.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].id);
                });
                $.post($.ctx + "/user/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        user.main.$popWin.dialog('close');
                        user.main.refreshGrid();
                    } else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    } else {
        $.messager.alert("提示", "请选择记录！");
    }
}
/**
 * 用户角色维护
 */
user.main.roleManager = function() {
    var rows = user.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            user.main.$popWin.dialog({
                href : $.ctx + "/user/roleManager",
                title : "角色关联",
                width : 450,
                queryParams : {
                    id : rows[0].id
                },
                onClose : user.main.refreshGrid
            }).dialog('open');
        } else {
            $.messager.alert("提示", "只能选择一个用户！");
        }
    } else {
        $.messager.alert("提示", "请选择要要维护的用户！");
    }
}
//刷新树图
user.main.treeReload = function() {
    var selectedNode = user.main.$orgTree.tree('getSelected');
    if(!selectedNode){
    	user.main.$orgTree.tree('reload');	    	
    }else{
    	user.main.$orgTree.tree('reload', selectedNode.target);	
    }
}