/**
 * 待办收文mainjs
 * 
 * @author xuhx
 */
$.namespace("swgl.dbsw.main");

/** 一览控件 */
swgl.dbsw.main.$grid = null;
swgl.dbsw.main.$popWin=null;
/** 通用弹窗 */

/** 页面初始化 */
swgl.dbsw.main.init= function() {
    swgl.dbsw.main.$popWin=$('#popWin');
    swgl.dbsw.main.initpage();
}

swgl.dbsw.main.query = function(){
    $("#dbswform").submit();
}

swgl.dbsw.main.refreshGrid=function(){
    // 初始化一览列表
    swgl.dbsw.main.$grid.datagrid({
        url : $.ctx + '/dbsw/list',
        pageSize : 20
    });
}
/**
 * 记录新增处理
 */
swgl.dbsw.main.doAdd = function() {
   window.location= $.ctx + '/dbsw/add';
}

/**
 * 记录编辑处理
 */
swgl.dbsw.main.doEdit = function(a) {
	$.post($.ctx + "/wf/task/isExit", {
        id:a
    }, function(data, status) {
        if (data.success) {
		    //待办
		    window.location=$.ctx + '/dbsw/view?flag=0&rflag=0&id='+a+'&cltype='+data.attrs.cltype;
        }else{
        	$.messager.alert("提示", data.message, "info", function () {
                window.location=$.ctx+"/dbsw/main";
            });
        }
    }, "json");
}
/**
 * 分页
 */
swgl.dbsw.main.initpage = function() {
    $("#pagetools button").click(function(){
       // swgl.dbsw.main.doDel();
    });
    //把form传入，构造翻页控件
    pageinfo($("#dbswform"));
}
swgl.dbsw.main.setSort=function(sortname,order){
    $("#pagesort").val(sortname);
    $("#pageorder").val(order);
    $("#dbswform").submit();
}
/**
 * 全选/全不选
 */
swgl.dbsw.main.all = function(){
    if($("#all").prop("checked")){
        $(".fwgl_table_checkbox").each(function(){
            $(this).prop("checked",true);
        });
    }else{
        $(".fwgl_table_checkbox").each(function(){
            $(this).prop("checked",false);
        });  
    }
}

/**
 * 获取选中的数据
 * 返回选中数据的id数组
 */
swgl.dbsw.main.getSelectedRecords = function(){
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function(){
        if($(this).prop("checked")){
            ids.push($(this).val());
        }
    }); 
   return ids;
};

/** 删除处理 */
swgl.dbsw.main.doDel = function() {
    var ids = swgl.dbsw.main.getSelectedRecords();
    if (ids.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/dbsw/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        location.href=$.ctx+"/dbsw/main";
                    } else {
                        $.messager.alert("提示", data.message);
                    }
                }, "json");
            }
            ;
        });
    } else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}

swgl.dbsw.main.showWin = function(id){
    $dialog = swgl.dbsw.main.$popWin.dialog({
       href : $.ctx + '/wf/task/hisWf?id='+id,
       title : "历史流程",
       width : 800,
       height :400,
       top:$(document).scrollTop() + ($(window).height()-400) * 0.5,
       left:$(document).scrollLeft() + ($(window).width()-600) * 0.5,
       onClose : function() {
           $dialog.dialog('destroy');
       },
       buttons : [ {
           text : '关闭',
           iconCls : 'icon-cancel',
           handler : function() {
               
               $dialog.dialog('close');
           }
       } ]
   });
   $dialog.dialog('open');
}
