/**
 * 菜单维护js
 * 
 * @author 袁晓冬
 */
$.namespace("role.main");

/** 通用弹窗 */
role.main.$popWin = null;

/** 初始化组件引用 */
role.main.initComp = function() {
    role.main.$popWin = $('#popWin');
}
/** 页面初始化 */
role.main.init = function() {
    role.main.initComp();
    role.main.initpage();
}


/** 页面初始化 */
role.main.initpage = function() {
    $("#pagetools").hide();
    // 把form传入，构造翻页控件
    pageinfo($("#roleform"));// 见common.js
}

// 选择组织
role.main.doAdd = function() {
   var config = config || {};
    $dialog = role.main.$popWin.dialog({
        href : $.ctx + '/role/add',
        title : "新增角色",
        width : 260,
        height : 150,
        onClose : function() {
            $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '完成',
            iconCls : 'icon-xt-ok',
            handler : function() {
                if(isEmpty($("#name").val())){
                    $.messager.alert("提示","名称不能为空！");
                    return false;
                }
                if(isEmpty($("#sortno").val())){
                    $.messager.alert("提示","排序号不能为空！");
                    return false;
                }
                $("#sortno").val(Number($("#sortno").val())) ;
                
                role.main.save();
                if (config.callback && typeof config.callback == 'function') {
                    config.callback(true, rows);
                }
                $dialog.dialog('close');
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                if (config.callback && typeof config.callback == 'function') {
                    config.callback(false);
                }
                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

/**
 * 判断是否为空
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str){
    if(str!=null&&str!=""&&str.length!=0){
        return false;
    }else{
        return true;
    }
}

/**
 * 保存菜单
 */
role.main.save = function() {
    $('#rform').form('submit', {
        url : $.ctx + '/role/save',
        onSubmit : function() {
            return $(this).form('validate');
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                window.location = $.ctx + '/role/main';
            }
            else {
                $.messager.showError(data.message);
            }
        }
    });
}

role.main.doRoleUser = function(id) {
    window.location = $.ctx + '/role/roleUsers/' + id;
}

/**
 * 全选/全不选
 */
role.main.all = function() {
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

/**
 * 获取选中的数据 返回选中数据的id数组
 */
role.main.getSelectedRecords = function() {
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function() {
        if ($(this).prop("checked")) {
            ids.push($(this).val());
        }
    });
    return ids;
}

/**
 * 记录编辑处理
 */
role.main.doEdit = function() {
    var rows = role.main.getSelectedRecords();
    if (rows.length > 0) {
        if (rows.length == 1) {
            var config = config || {};
            $dialog = role.main.$popWin.dialog({
                href : $.ctx + "/role/edit",
                title : "编辑角色",
                queryParams : {
                    id : rows[0]
                },
                width : 260,
                height : 150,
                onClose : function() {
                    $dialog.dialog('destroy');
                },
                buttons : [ {
                    text : '完成',
                    iconCls : 'icon-xt-ok',
                    handler : function() {
                        role.main.save();
                        if (config.callback && typeof config.callback == 'function') {
                            config.callback(true, rows);
                        }
                        $dialog.dialog('close');
                    }
                }, {
                    text : '取消',
                    iconCls : 'icon-cancel',
                    handler : function() {
                        if (config.callback && typeof config.callback == 'function') {
                            config.callback(false);
                        }
                        $dialog.dialog('close');
                    }
                } ]
            });
            $dialog.dialog('open');
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    }
    else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }

}
/** 删除处理 */
role.main.doDel = function() {
    var rows = role.main.getSelectedRecords();
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/role/delete", {
                    ids : rows.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        role.main.$popWin.dialog('close');
                        window.location = $.ctx + "/role/main";
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}
// 刷新树图
role.main.treeReload = function() {
    var selectedNode = role.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        role.main.$orgTree.tree('reload');
    }
    else {
        role.main.$orgTree.tree('reload', selectedNode.target);
    }
}
role.main.setQx = function(val, row) {
    /*
     * var ret = '<a href="#" onclick="role.main.setPermission(\''+val+'\')" >设置</a> '; return ret;
     */
}
role.main.setPermission = function(roleId) {
    // window.location= $.ctx + "/role/menuAuthTree" + "?roleid=" + roleId;
    window.location = $.ctx + "/role/auth/" + roleId;
}