/**
 * 菜单详细画面用js
 * 
 * @author 袁晓冬
 */
$.namespace("menu.detail");
/** 是否公用代码 */
menu.detail.sfCodeArray = null;
menu.detail.$leaf = null;
menu.detail.$valid = null;
/** 初始化组件引用 */
menu.detail.initComp = function() {
    menu.detail.$leaf = $('#leaf');
    menu.detail.$valid = $('#valid');
}
/** 页面初始化 */
menu.detail.init = function() {
    // 转换数据字符串为对象
    if (menu.detail.data) {
        menu.detail.data = $.parseJSON(menu.detail.data);
    }
    menu.detail.initComp();
    menu.detail.initCombox();
}
/**
 * 初始化下拉框
 */
menu.detail.initCombox = function() {
    // 初始化人员状态下拉框
    var dataArr = new Array();
    dataArr = dataArr.concat(menu.detail.sfCodeArray);
    menu.detail.$leaf.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (menu.detail.data["leaf"] === 'N') {
                menu.detail.$leaf.combobox('select', consts.CODE_TY_SF_F);
            } else {
                menu.detail.$leaf.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
    menu.detail.$valid.combobox({
        valueField : 'code',
        textField : 'text',
        data : dataArr,
        editable : false,
        onLoadSuccess : function() {
            // 默认选中可用
            if (menu.detail.data["valid"] === 'N') {
                menu.detail.$valid.combobox('select', consts.CODE_TY_SF_F);
            } else {
                menu.detail.$valid.combobox('select', consts.CODE_TY_SF_S);
            }
        }
    });
};
/**
 * 保存菜单
 */
menu.detail.save = function() {
    $('#rform').form('submit', {
        url : $.ctx + '/menu/save',
        onSubmit : function() {
            return $(this).form('validate');
        },
        success : function(data, status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success) {
                // close the dialog
                menu.main.$popWin.dialog('close');
                // 刷新树图
                var selectedNode = menu.main.$menuBtnTree.tree('getSelected');
                menu.main.$menuBtnTree.tree('reload', selectedNode.target);
                menu.main.refreshGrid(selectedNode);
            } else {
                $.messager.showError(data.message);
            }
        }
    });
}