/**
 * 增加命名空间方法<br>
 * <p>
 * 用法：$.namespace("a.b.c"); a.b.c.testFunction=function(...);
 */
$.extend($, {
    namespace : function() {
        var o, d;
        for (var i = 0, len = arguments.length; i < len; i++) {
            d = arguments[i].split(".");
            o = window[d[0]] = window[d[0]] || {};
            var left = d.slice(1);
            for (var i = 0, len = left.length; i < len; i++) {
                o = o[left[i]] = o[left[i]] || {};
            }
        }
        return o;
    },
    SUCCESS : "success",
    ERROR : "error",
    BLANK_UUID : "00"
});
// 重写ajax
(function($){  
    if(!$.ctx){
        var pathName = document.location.pathname;
        var index = pathName.substr(1).indexOf("/");
        $.ctx = pathName.substr(0, index + 1);
    }
    //备份jquery的ajax方法  
    var _ajax=$.ajax;  
    //重写jquery的ajax方法  
    $.ajax=function(opt){  
        //备份opt中error和success方法  
        var fn = {  
            error:function(XMLHttpRequest, textStatus, errorThrown){},  
            success:function(data, textStatus){}  
        }  
        if(opt.error){  
            fn.error=opt.error;  
        }  
        if(opt.success){  
            fn.success=opt.success;  
        }  
        //扩展增强处理  
        var _opt = $.extend(opt,{  
            error:function(XMLHttpRequest, textStatus, errorThrown){  
                //错误方法增强处理  
                fn.error(XMLHttpRequest, textStatus, errorThrown);  
            },  
            success:function(data, textStatus){  
                if(data.success ==false  && data.message=="_redirect_"&&data.attrs&&data.attrs.url){
                    window.location.href= $.ctx + data.attrs.url;  
                    return;
                }
                //成功回调方法增强处理  
                fn.success(data, textStatus);  
            }  
        });  
        _ajax(_opt);  
    };  
})(jQuery);  
/*
 * datagrid json节点的解析
 */
$.extend($.fn.datagrid.defaults, {
    loader : function(param, success, error) {
        var opts = $(this).datagrid("options");
        if (!opts.url) { return false; }
        $.ajax({
            type : opts.method,
            url : opts.url,
            data : param,
            dataType : "json",
            success : function(data) {
                if (!data) {
                    success(data);
                }
                // 同步前后台
                if (!data.rows) {
                    data.rows = data.content;
                }
                if (!data.total) {
                    data.total = data.totalElements;
                }
                success(data);
            },
            error : function() {
                error.apply(this, arguments);
            }
        });
    }
});

/*
 * 日期默认为yyyy/MM/dd
 */
/*$.extend($.fn.datebox.defaults, {
    formatter : function(date) {
        var y = date.getFullYear();
        var m = date.getMonth() + 1;
        var d = date.getDate();
        return y + '/' + (m < 10 ? ('0' + m) : m) + '/' + (d < 10 ? ('0' + d) : d);
    }
});*/

$.extend($.messager, {
    showMsg : function(msg, timeout) {
        var win = $.messager.alert("提示", msg)
        setTimeout(function() {
            win.window('close');
        }, timeout ? timeout : 800);
        return win;
    },
    showError : function(msg, timeout) {
        if (!msg) {
            msg = "未知错误";
        }
        $.messager.alert("错误", msg);
    }
});

$.extend($.fn.combobox.defaults, {
    panelHeight : 'auto',
    loader : function(param, success, error) {
        var opts = $(this).combobox('options');
        if (!opts.url) return false;
        $.ajax({
            type : opts.method,
            url : opts.url,
            data : param,
            dataType : 'json',
            success : function(data) {
                $(data).each(function() {
                    if (this.isDefault == 'Y') {
                        this.selected = true;
                    }
                })
                success(data);
            },
            error : function() {
                error.apply(this, arguments);
            }
        });
    }
});

jQuery.fn.extend({

    on : function(types, selector, data, fn, /* INTERNAL */one) {
        var origFn, type;

        // Types can be a map of types/handlers
        if (typeof types === "object") {
            // ( types-Object, selector, data )
            if (typeof selector !== "string") {
                // ( types-Object, data )
                data = selector;
                selector = undefined;
            }
            for (type in types) {
                this.on(type, selector, data, types[type], one);
            }
            return this;
        }

        if (data == null && fn == null) {
            // ( types, fn )
            fn = selector;
            data = selector = undefined;
        }
        else if (fn == null) {
            if (typeof selector === "string") {
                // ( types, selector, fn )
                fn = data;
                data = undefined;
            }
            else {
                // ( types, data, fn )
                fn = data;
                data = selector;
                selector = undefined;
            }
        }
        if (fn === false) {
            fn = returnFalse;
        }
        else if (!fn) { return this; }

        if (one === 1) {
            origFn = fn;
            fn = function(event) {
                // Can use an empty set, since event contains the info
                jQuery().off(event);
                return origFn.apply(this, arguments);
            };
            // Use same guid so caller can remove using origFn
            fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
        }
        return this.each(function() {
            jQuery.event.add(this, types, fn, data, selector);
        });
    },
    one : function(types, selector, data, fn) {
        return this.on.call(this, types, selector, data, fn, 1);
    },
    off : function(types, selector, fn) {
        if (types && types.preventDefault && types.handleObj) {
            // ( event ) dispatched jQuery.Event
            var handleObj = types.handleObj;
            jQuery(types.delegateTarget).off(
                    handleObj.namespace ? handleObj.type + "." + handleObj.namespace : handleObj.type,
                    handleObj.selector, handleObj.handler);
            return this;
        }
        if (typeof types === "object") {
            // ( types-object [, selector] )
            for ( var type in types) {
                this.off(type, selector, types[type]);
            }
            return this;
        }
        if (selector === false || typeof selector === "function") {
            // ( types [, fn] )
            fn = selector;
            selector = undefined;
        }
        if (fn === false) {
            fn = returnFalse;
        }
        return this.each(function() {
            jQuery.event.remove(this, types, fn, selector);
        });
    },

    bind : function(types, data, fn) {
        return this.on(types, null, data, fn);
    },
    unbind : function(types, fn) {
        return this.off(types, null, fn);
    },

    live : function(types, data, fn) {
        jQuery(this.context).on(types, this.selector, data, fn);
        return this;
    },
    die : function(types, fn) {
        jQuery(this.context).off(types, this.selector || "**", fn);
        return this;
    },

    delegate : function(selector, types, data, fn) {
        return this.on(types, selector, data, fn);
    },
    undelegate : function(selector, types, fn) {
        // ( namespace ) or ( selector, types [, fn] )
        return arguments.length == 1 ? this.off(selector, "**") : this.off(types, selector, fn);
    },

    trigger : function(type, data) {
        return this.each(function() {
            jQuery.event.trigger(type, data, this);
        });
    },
    triggerHandler : function(type, data) {
        if (this[0]) { return jQuery.event.trigger(type, data, this[0], true); }
    },

    toggle : function(fn) {
        // Save reference to arguments for access in closure
        var args = arguments, guid = fn.guid || jQuery.guid++, i = 0, toggler = function(event) {
            // Figure out which function to execute
            var lastToggle = (jQuery._data(this, "lastToggle" + fn.guid) || 0) % i;
            jQuery._data(this, "lastToggle" + fn.guid, lastToggle + 1);

            // Make sure that clicks stop
            event.preventDefault();

            // and execute the function
            return args[lastToggle].apply(this, arguments) || false;
        };

        // link all the functions, so any of them can unbind this click handler
        toggler.guid = guid;
        while (i < args.length) {
            args[i++].guid = guid;
        }

        return this.click(toggler);
    },

    hover : function(fnOver, fnOut) {
        return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
    }
});
//$(document).ajaxSuccess(function(event, xhr, settings) {
//});
//
//$(document).ajaxStop(function() {
//});
//
//$(document).ajaxError(function(event, jqxhr, settings, exception) {
//    $.messager.alert({
//        title : '错误',
//        width : 450,
//        height : 300,
//        modal : true,
//        closed : true,
//        maximizable : true,
//        msg : jqxhr.responseText
//    });
//});

/**
 * 匹配中文 数字 字母 下划线
 */

function checkInput(str) {
    var pattern = /^[\w\u4e00-\u9fa5]+$/gi;
    if (pattern.test(str)) { return false; }
    return true;
}

// 取消后退键退出系统
$(document).keydown(
        function(e) { // 绑定键盘按下事件
            var doPrevent;
            // for IE && Firefox
            var varkey = (e.keyCode) || (e.which) || (e.charCode);
            if (varkey == 8) {
                var d = e.srcElement || e.target;
                if (d.tagName.toUpperCase() == 'INPUT' || d.tagName.toUpperCase() == 'TEXTAREA') {
                    doPrevent = d.readOnly || d.disabled;
                    if (d.type.toUpperCase() == 'SUBMIT' || d.type.toUpperCase() == 'RADIO'
                            || d.type.toUpperCase() == 'CHECKBOX' || d.type.toUpperCase() == 'BUTTON') {
                        doPrevent = true;
                    }
                }
                else {
                    doPrevent = true;
                }
            }
            else {
                doPrevent = false;
            }
            if (doPrevent) {
                e.preventDefault();
            }
        });
/**
 * 用法<input name="age" class="easyui-validatebox" data-options="required:true,validType:'integer'"/>
 */
$.extend($.fn.validatebox.defaults.rules, {
    minLength : { // 判断最小长度
        validator : function(value, param) {
            return value.length >= param[0];
        },
        message : '最少输入 {0} 个字符。'
    },
    length : {
        validator : function(value, param) {
            var len = $.trim(value).length;
            return len >= param[0] && len <= param[1];
        },
        message : "内容长度介于{0}和{1}之间."
    },
    floatOrInt : { // 验证是否为小数或整数
        validator : function(value) {
            return /^(\d{1,3}(,\d\d\d)*(\.\d{1,3}(,\d\d\d)*)?|\d+(\.\d+))?$/i.test(value);
        },
        message : '请输入数字，并保证格式正确'
    },
    currency : { // 验证货币
        validator : function(value) {
            return /^d{0,}(\.\d+)?$/i.test(value);
        },
        message : '货币格式不正确'
    },
    integer : { // 验证整数
        validator : function(value) {
            return /^[+]?[1-9]+\d*$/i.test(value);
        },
        message : '请输入整数'
    },
    chinese : { // 验证中文
        validator : function(value) {
            return /^[\u0391-\uFFE5]+$/i.test(value);
        },
        message : '请输入中文'
    },
    english : { // 验证英语
        validator : function(value) {
            return /^[A-Za-z]+$/i.test(value);
        },
        message : '请输入英文'
    },
    unnormal : { // 验证是否包含空格和非法字符
        validator : function(value) {
            return /.+/i.test(value);
        },
        message : '输入值不能为空和包含其他非法字符'
    },
    phone : { // 验证电话号码
        validator : function(value) {
            return /^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/i.test(value);
        },
        message : '格式不正确,请使用下面格式:020-88888888'
    },
    mobile : { // 验证手机号码
        validator : function(value) {
            return /^(13|15|18)\d{9}$/i.test(value);
        },
        message : '手机号码格式不正确'
    },
    idcard : { // 验证身份证
        validator : function(value) {
            return /^\d{15}(\d{2}[A-Za-z0-9])?$/i.test(value);
        },
        message : '身份证号码格式不正确'
    },
    qq : { // 验证QQ,从10000开始
        validator : function(value) {
            return /^[1-9]\d{4,9}$/i.test(value);
        },
        message : 'QQ号码格式不正确'
    },
    username : { // 验证用户名
        validator : function(value) {
            return /^[a-zA-Z][a-zA-Z0-9_]{5,15}$/i.test(value);
        },
        message : '用户名不合法（字母开头，允许6-16字节，允许字母数字下划线）'
    },
    faxno : { // 验证传真
        validator : function(value) {
            // return /^[+]{0,1}(\d){1,3}[ ]?([-]?((\d)|[
            // ]){1,12})+$/i.test(value);
            return /^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/i.test(value);
        },
        message : '传真号码不正确'
    },
    zip : { // 验证邮政编码
        validator : function(value) {
            return /^[1-9]\d{5}$/i.test(value);
        },
        message : '邮政编码格式不正确'
    },
    ip : { // 验证IP地址
        validator : function(value) {
            return /d+.d+.d+.d+/i.test(value);
        },
        message : 'IP地址格式不正确'
    },
    name : { // 验证姓名，可以是中文或英文
        validator : function(value) {
            return /^[\u0391-\uFFE5]+$/i.test(value) | /^\w+[\w\s]+\w+$/i.test(value);
        },
        message : '请输入姓名'
    },
    carNo : {
        validator : function(value) {
            return /^[\u4E00-\u9FA5][\da-zA-Z]{6}$/.test(value);
        },
        message : '车牌号码无效（例：粤J12350）'
    },
    carenergin : {
        validator : function(value) {
            return /^[a-zA-Z0-9]{16}$/.test(value);
        },
        message : '发动机型号无效(例：FG6H012345654584)'
    },
    email : {
        validator : function(value) {
            return /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/.test(value);
        },
        message : '请输入有效的电子邮件账号(例：abc@126.com)'
    },
    msn : {
        validator : function(value) {
            return /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/.test(value);
        },
        message : '请输入有效的msn账号(例：abc@hotnail(msn/live).com)'
    },
    same : {
        validator : function(value, param) {
            if ($("#" + param[0]).val() != "" && value != "") {
                return $("#" + param[0]).val() == value;
            }
            else {
                return true;
            }
        },
        message : '两次输入的密码不一致！'
    },
    date : {
        validator : function(value) {
            return /^((?:19|20)\d\d)\/(0[1-9]|1[012])\/(0[1-9]|[12][0-9]|3[01])$/.test(value);
        },
        message : '请输入有效的日期格式(例：YYYY/MM/DD)'
    }
});

function comboxformatter(value, row, index, codelist) {
    for (var i = 0; i < codelist.length; i++) {
        if (value == codelist[i].code) { return codelist[i].name; }
    }
}

function pageinit(cfg, callback) {
    var codeVar = cfg.getCodeCfg.codeVar;
    var codeSign = cfg.getCodeCfg.groupCode;
    var script = "$.when(";
    for (var i = 0; i < codeVar.length; i++) {
        script += "$.ajax({method : 'get',url : '" + codeSign[i] + "',dataType : 'json'}),";
    }
    script = script.substring(0, script.length - 1) + ");";
    var whenstr = eval(script);
    whenstr.done(function() {
        for (var i = 0; i < arguments.length; i++) {
            cfg.getCodeCfg.codeVar[i] = arguments[i][0];
        }
        callback(cfg);
    });
}

// 备注长度限制

function limitTextArea(field) {
    var maxlimit = 250;
    if (field.value.length > maxlimit) field.value = field.value.substring(0, maxlimit);
}

// 根据数据库中字段的长度要求截取文本输入框中输入的字符串

function limitTextArea(field, maxLength) {
    if (field.value.length > maxLength) field.value = field.value.substring(0, maxLength);
}

// tree 获取一级子节点
$.extend($.fn.tree.methods, {
    getLeafChildren : function(jq, params) {
        var nodes = [];
        $(params).next().children().children("div.tree-node").each(function() {
            nodes.push($(jq[0]).tree('getNode', this));
        });
        return nodes;
    }
});
/**
 * 获取元素的outerHTML
 */
$.fn.outerHTML = function() {

    // IE, Chrome & Safari will comply with the non-standard outerHTML, all others (FF) will have a fall-back for
    // cloning
    return (!this.length) ? this : (this[0].outerHTML || (function(el) {
        var div = document.createElement('div');
        div.appendChild(el.cloneNode(true));
        var contents = div.innerHTML;
        div = null;
        return contents;
    })(this[0]));

};
// 判断页面中是否存在重复的ID的方法

function checkDuplicate() {
    var i = 0;
    var duplicateIds = new Array();
    $("body [id]").each(function() {
        var id = $(this).attr("id");
        if (id != "" && $("body [id=" + id + "]").length >= 2) {
            // 判断是否已记录重复的值
            if (!contains(duplicateIds, id)) {
                duplicateIds[i] = id;
                $.messager.alert("提示", "id为" + id + "的重复了。");
            }
        }
        i++;
    });
    if (duplicateIds.length == 0) {
        $.messager.alert("提示", "HTML DOM中没有重复的ID")
    }
    return duplicateIds;
}

// 判断某个e元素是否存在于数组a中
function contains(a, e) {
    for (j = 0; j < a.length; j++)
        if (a[j] == e) return true;
    return false;
}
/**
 * “是否”格式化
 * 
 * @param value
 * @param rowData
 * @param rowIndex
 * @returns {String}
 */
function sfFormatter(value, rowData, rowIndex) {
    if (value === 'N') return "否";
    return "是";
}
/**
 * 查看流转过程
 * 
 * @param options
 */
function graphTrace(options) {
    var _defaults = {
        srcEle : this,
        pid : $(this).attr('pid')
    };
    var opts = $.extend(true, _defaults, options);
    // 获取图片资源
    var imageUrl = $.ctx + "/wf/instance/readResource?processInstanceId=" + opts.pid + "&resourceType=image";
    /** 节点信息获取后处理 */
    var traceBackFun = function(infos) {
        var positionHtml = "";
        // 生成图片
        var varsArray = new Array();
        $.each(infos, function(i, v) {
            var $positionDiv = $('<div/>', {
                'class' : 'activity-attr'
            }).css({
                position : 'absolute',
                left : (v.x - 1),
                top : (v.y - 1),
                width : (v.width - 2),
                height : (v.height - 2),
                backgroundColor : 'black',
                opacity : 0,
                zIndex : $.fn.qtip.zindex - 1
            });
            // 节点边框
            var $border = $('<div/>', {
                'class' : 'activity-attr-border'
            }).css({
                position : 'absolute',
                left : (v.x - 1),
                top : (v.y - 1),
                width : (v.width - 4),
                height : (v.height - 3),
                zIndex : $.fn.qtip.zindex - 2
            });
            if (v.currentActiviti) {
                $border.addClass('ui-corner-all-12').css({
                    border : '3px solid red'
                });
            }
            positionHtml += $positionDiv.outerHTML() + $border.outerHTML();
            varsArray[varsArray.length] = v.vars;
        });

        if ($('#workflowTraceDialog').length == 0) {
            $(
                    '<div/>',
                    {
                        id : 'workflowTraceDialog',
                        title : '查看流程（按ESC键可以关闭）',
                        html : "<div style='background-color:gray;width:100%;height:100%;position:absolute; left:60px; top:60px;'><img src='"
                                + imageUrl
                                + "' style='position:absolute; left:0px; top:60px;' />"
                                + "<div id='processImageBorder'>" + positionHtml + "</div>" + "</div>"
                    }).appendTo('body');
        }
        else {
            $('#workflowTraceDialog img').attr('src', imageUrl);
            $('#workflowTraceDialog #processImageBorder').html(positionHtml);
        }

        // 设置每个节点的data
        $('#workflowTraceDialog .activity-attr').each(function(i, v) {
            $(this).data('vars', varsArray[i]);
        });

        // 打开对话框
        $('#workflowTraceDialog').dialog(
                {
                    modal : true,
                    resizable : false,
                    dragable : false,
                    open : function() {
                        $('#workflowTraceDialog').dialog('option', 'title', '查看流程（按ESC键可以关闭）');
                        $('#workflowTraceDialog').css('padding', '0.2em');
                        $('#workflowTraceDialog .ui-accordion-content').css('padding', '0.2em').height(
                                $('#workflowTraceDialog').height() - 75);

                        // 此处用于显示每个节点的信息，如果不需要可以删除
                        $('.activity-attr').qtip(
                                {
                                    content : function() {
                                        $.messager.alert("提示", 123);
                                        var vars = $(this).data('vars');
                                        var tipContent = "<table class='need-border'>";
                                        $.each(vars, function(varKey, varValue) {
                                            if (varValue) {
                                                tipContent += "<tr><td class='label'>" + varKey + "</td><td>"
                                                        + varValue + "<td/></tr>";
                                            }
                                        });
                                        tipContent += "</table>";
                                        return tipContent;
                                    },
                                    position : {
                                        at : 'bottom left',
                                        adjust : {
                                            x : 3
                                        }
                                    }
                                });
                        // end qtip
                    },
                    close : function() {
                        $('#workflowTraceDialog').remove();
                    },
                    width : document.documentElement.clientWidth * 0.90,
                    height : document.documentElement.clientHeight * 0.90
                });

    }
    $.getJSON($.ctx + '/wf/process/trace?processInstanceId=' + opts.pid, traceBackFun);
}

/**
 * 动态加载js<br>
 * <p>
 * eg. loadScript.load(["b.js", "a.js"]).done(function() {test();});
 * <p>
 * 参考userMap.js role.usermap.addRoleUser
 */
$.loadScript = (function() {
    var loadOne = function(url) {
        var dtd = $.Deferred();
        var node = document.createElement('script');
        node.type = "text/javascript";
        var onload = function() {
            dtd.resolve();
        };
        $(node).load(onload).bind('readystatechange', function() {
            if (node.readyState == 'loaded') {
                onload();
            }
        });
        document.getElementsByTagName('head')[0].appendChild(node);
        node.src = url;
        return dtd.promise();
    };

    var load = function(urls) {
        if (!$.isArray(urls)) { return load([ urls ]); }
        var ret = [];
        for (var i = 0; i < urls.length; i++) {
            ret[i] = loadOne(urls[i]);
        }
        return $.when.apply($, ret);
    }

    return {
        load : load
    };
})();

function pageinfo(form){
    $("#pagesize").change(function() {
        $("#pagejump").val(1);
        form.submit();
    });
    $("#pagesize").val($("#pagesize").attr("num"));
    $("#pagefirst").click(function() {
        if ($("#pagecur").val() == 1) {
        	 $.messager.alert("提示","已到第一页");
            return;
        }
        else {
            $("#pagejump").val(1);
            form.submit();
        }
    });
    $("#pageprev").click(function() {
        if ($("#pagecur").val() == 1) {
        	 $.messager.alert("提示","已到第一页");
            return;
        }
        else {
            $("#pagejump").val(parseInt($("#pagecur").val()) - 1);
            form.submit();
        }
    });
    $("#pagejump").keydown(
            function(event, p) {
                if (event.keyCode == 13) {
                    if ($.isNumeric($("#pagejump").val()) && (parseInt($("#pagejump").val()) >= 1)
                            && (parseInt($("#pagejump").val()) <= parseInt($("#pagetotal").val()))) {
                    }
                    else {
                    	 $.messager.alert("提示","请输入有效数字");
                        return false;
                    }
                    form.submit();
                }
            });
    $("#pagenext").click(function() {
        if(parseInt($("#pagetotal").val())<=1){
        	 $.messager.alert("提示","已到最后一页");
            return;
        }
        if ($("#pagecur").val() == $("#pagetotal").val()) {
        	 $.messager.alert("提示","已到最后一页");
            return;
        }
        else {
            $("#pagejump").val(parseInt($("#pagecur").val()) + 1);
            form.submit();
        }
    });
    $("#pagelast").click(function() {
        if(parseInt($("#pagetotal").val())<=1){
        	 $.messager.alert("提示","已到最后一页");
            return;
        }
        if ($("#pagecur").val() == $("#pagetotal").val()) {
        	 $.messager.alert("提示","已到最后一页");
            return;
        }
        else {
            $("#pagejump").val($("#pagetotal").val());
            form.submit();
        }
    });
}