/**
 * 菜单维护js
 * 
 * @author 袁晓冬
 */
$.namespace("auth.roleAuth");
/** 组织树 */
auth.roleAuth.$roleTree = null;
/** 菜单树 */
auth.roleAuth.$menuTree = null;
auth.roleAuth.roleId = null;
/** 初始化组件引用 */
auth.roleAuth.initComp = function() {
    auth.roleAuth.$roleTree = $('#roleTree');
    auth.roleAuth.$menuTree = $('#menuTree');
}
/** 页面初始化 */
auth.roleAuth.init = function(roleId) {
    auth.roleAuth.roleId = roleId;
    auth.roleAuth.initComp();
    var expandAll=true;
    // 初始化授权树
    auth.roleAuth.$menuTree.tree({
        url : $.ctx + "/menu/menuAuthTree" + "?roleid=" + roleId,
        method : 'get',
        checkbox : true,
        lines : true,
        animate : true,
        cascadeCheck : false,
        queryParams : {
            root : "false"
        },
        onClick : function(node) {
        },
        onCheck : function(node, checked) {
            if (checked) {
                var parentNode = auth.roleAuth.$menuTree.tree('getParent', node.target);
                if (parentNode != null) {
                    auth.roleAuth.$menuTree.tree('check', parentNode.target);
                }
            }
            else {
                var childNode = auth.roleAuth.$menuTree.tree('getChildren', node.target);
                if (childNode.length > 0) {
                    for (var i = 0; i < childNode.length; i++) {
                        auth.roleAuth.$menuTree.tree('uncheck', childNode[i].target);
                    }
                }
            }
        },
        onLoadSuccess : function(node, data) {
            if(expandAll){
                auth.roleAuth.$menuTree.tree('expandAll');
                expandAll=false;
            }
        }
    });

}

/**
 * 角色授权保存
 */
auth.roleAuth.save = function() {
    var nodes = auth.roleAuth.$menuTree.tree('getChecked');
    // 确认删除
    var mids = [];
    var fids = [];
    if (nodes) {
        $.each(nodes, function(i) {
            var type = nodes[i].attributes.type;
            if (type == "function") {
                fids.push(nodes[i].id);
            }
            else {
                mids.push(nodes[i].id);
            }
        });
    }
    $.post($.ctx + "/role/saveRoleAuth", {
        mids : mids.join(","),
        fids : fids.join(","),
        roleid : auth.roleAuth.roleId
    }, function(data, status) {
        if (data.success) {
            $.messager.showMsg("保存成功!");
        }
        else {
            $.messager.showError(data.message);
        }
    }, "json");
}
// 刷新树图
auth.roleAuth.treeReload = function() {
    var selectedNode = auth.roleAuth.$roleTree.tree('getSelected');
    if (!selectedNode) {
        auth.roleAuth.$roleTree.tree('reload');
    }
    else {
        auth.roleAuth.$roleTree.tree('reload', selectedNode.target);
    }
}