/**
 * 活动结点授权js
 * 
 * @author 罗东
 */
$.namespace("aman.main");
/** 当前结点控件 */
aman.main.$gridl = null;
/** 当前结点控件 */
aman.main.$grid = null;
/** 向上一览控件 */
aman.main.$gridu = null;
/** 向下一览控件 */
aman.main.$gridd = null;
/** 通用弹窗 */
aman.main.$popWin = null;
/** 当前节点树 */
aman.main.$nodeTree = null;
/** 初始化组件引用 */
aman.main.initComp = function() {
	aman.main.$grid = $('#grid');
	aman.main.$gridl = $('#gridl');
	aman.main.$gridd = $('#gridd');
	aman.main.$gridu = $('#gridu');
	aman.main.$popWin = $('#popWin');
	aman.main.$nodeTree = $('#nodeTree');
}
/** 页面初始化 */
aman.main.init = function() {
	aman.main.initComp();
	// aman.main.initCombox();
	// 初始化字典树
	// 初始化当前一览列表
	aman.main.$grid.datagrid({
		pageSize : 20,
		onClickRow : function() {
			aman.main.refreshGrid();
		}
	});
	// 初始化任务列表
	aman.main.$gridl.datagrid({
		pageSize : 2,
		url : $.ctx + "/aman/listl",
		onClickRow : function() {
			aman.main.refreshAll();
		}
	});
	// 初始化向上一览列表
	aman.main.$gridu.datagrid({
		pageSize : 20,
	});
	// 初始化向下一览列表
	aman.main.$gridd.datagrid({
		pageSize : 20,
	});
}
/** 刷新任务栏 */
aman.main.refreshTask = function() {
	// 初始化任务列表
	aman.main.$gridl.datagrid({
		pageSize : 2,
		url : $.ctx + "/aman/listl",
	});
}
/** 刷新当前列表 */
aman.main.refreshAll = function(task) {
	if (!task) {
		task = aman.main.$gridl.datagrid('getSelected');
	}
	if (!task) {
		return;
	}
	aman.main.$grid.datagrid({
		pageSize : 20,
		url : $.ctx + "/aman/list",
		queryParams : {
			wfid : task.key
		}
	});
}
/** 根据当前结点刷新向下和驳回结点 */
aman.main.refreshGrid = function(task, selected) {
	if (!task) {
		task = aman.main.$gridl.datagrid('getSelected');
	}
	if (!selected) {
		selected = aman.main.$grid.datagrid("getSelected");
	}
	if (!task || !selected) {
		return;
	}
	// 刷新向上一览列表
	aman.main.$gridu.datagrid({
		pageSize : 20,
		url : $.ctx + "/aman/listu",

		queryParams : {
			nid : selected.id,
			wfid : task.key
		},
		onLoadSuccess:function(){
			aman.main.undoup();
		}
	});
	
	
	// 刷新向下一览列表
	aman.main.$gridd.datagrid({
		pageSize : 20,
		url : $.ctx + "/aman/listd",

		queryParams : {
			nid : selected.id,
			wfid : task.key
		},
		onLoadSuccess:function(){
			aman.main.undodown();
		}
	});
	
	
}

/** 选中全部驳回结点 */
aman.main.resetup = function() {
	aman.main.$gridu.datagrid("selectAll");
}
/** 清空全部驳回结点 */
aman.main.releaseup = function() {
	aman.main.$gridu.datagrid("unselectAll");
}

/** 恢复初始驳回结点 */
aman.main.undoup = function(task, now) {
	if (!task) {
		task = aman.main.$gridl.datagrid('getSelected');
	}
	if (!now) {
		now = aman.main.$grid.datagrid("getSelected");
	}
	if (!task || !now) {
		return;
	}
	$.post($.ctx + "/aman/reload", {
		dir : "up",
		wfid : task.key,
		nid : now.id
	}, function(data, status) {
		if (data.success) {
			$.each(data.attrs.ids, function(i, value) {
				aman.main.$gridu.datagrid("selectRow", value);
			});
		} else {
			$.messager.showError(data.message);
		}
	}, "json");
}

/** 保存选择的驳回结点 */
aman.main.saveup = function() {
	var task = aman.main.$gridl.datagrid("getSelected");
	var now = aman.main.$grid.datagrid("getSelected");
	if (null == task || now == null) {
		$.messager.alert("提示", "请先选择任务和当前结点")
		return;
	}
	var rows = aman.main.$gridu.datagrid('getSelections');
	var mids = [];
	$.each(rows, function(i) {
		mids.push(rows[i].id);
	});
	$.post($.ctx + "/aman/save", {
		dir : "up",
		ids : mids.join(","),
		wfid : task.key,
		nid : now.id
	}, function(data, status) {
		if (data.success) {
			$.messager.alert("提示", "保存成功");
		} else {
			$.messager.showError(data.message);
		}
	}, "json");
}

/** 选中全部向下结点 */
aman.main.resetdown = function() {
	aman.main.$gridd.datagrid("selectAll");
}
/** 清空全部向下结点 */
aman.main.releasedown = function() {
	aman.main.$gridd.datagrid("unselectAll");
}
/** 恢复初始全部向下结点 */
aman.main.undodown = function(task, now) {
	if (!task) {
		task = aman.main.$gridl.datagrid('getSelected');
	}
	if (!now) {
		now = aman.main.$grid.datagrid("getSelected");
	}
	if (!task || !now) {
		alert("Null");
		return;
	}

	$.post($.ctx + "/aman/reload", {
		dir : "down",
		wfid : task.key,
		nid : now.id
	}, function(data, status) {
		if (data.success) {
			$.each(data.attrs.ids, function(i, value) {
				aman.main.$gridd.datagrid("selectRow", value);
			});
		} else {
			$.messager.showError(data.message);
		}
	}, "json");
}
/** 保存向下结点 */
aman.main.savedown = function() {
	var task = aman.main.$gridl.datagrid("getSelected");
	var now = aman.main.$grid.datagrid("getSelected");
	if (null == task || now == null) {
		$.messager.alert("提示", "请先选择任务和当前结点")
		return;
	}
	var rows = aman.main.$gridd.datagrid('getSelections');
	var mids = [];
	if(null == rows){
		$.messager.alert("提示", "确认清空当前结点的驳回列表？");
		
		return;
	}
	$.each(rows, function(i) {
		mids.push(rows[i].id);
	});
	$.post($.ctx + "/aman/save", {
		dir : "down",
		ids : mids.join(","),
		wfid : task.key,
		nid : now.id
	}, function(data, status) {
		if (data.success) {
			// user.main.refreshGrid();
			$.messager.alert("提示", "保存成功");
		} else {
			$.messager.showError(data.message);
		}
	}, "json");
}