<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>年度预算</title>
<%@ include file="../../include/common.jsp"%>
<script type="text/javascript" src="${ctx}/static/xt/js/qlgk/ndys/detail.js"></script>
<script type="text/javascript" src="${ctx}/static/xt/js/qlgk/ndys/main.js"></script>
<script type="text/javascript">
    // 页面加载完成后执行
    $(document).ready(function() {
        qlgk.ndys.main.init();
    });
</script>
</head>
<body>
	<!-----------右边开始------------>
	<form action="${ctx}/ndys/main" method="post" id="ndysform">
		<div class="work_box">
		<h1 class="work_title"><span >${menuPath }</span></h1>
			<table class="btn_left_1">
				<tr>
					<td class="input_data"><span>预算标题</span><input type="text" name="title" id="title" value="${title }"></td>
					<td class="input_data"><span>预算年度</span><input type="text" name="ysnd" id="ysnd" value="${ysnd }"></td>
					<td class="input_data"><span>预算摘要</span><input type="text" name="yszy" id="yszy" value="${yszy }"></td>
				</tr>
				<tr>
					<td class="input_data"><span style="margin-right: 6px;">编制日期起</span>
						<input type="text" id="addTimeStart" name="addTimeStart" class="Wdate" readonly 
							onclick="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'addTimeEnd\')}'})" 
							style="cursor: pointer;" value="${addTimeStart }" />
					</td>
					<td class="input_data"><span style="margin-right: 6px;">编制日期止</span>
						<input type="text" id="addTimeEnd" name="addTimeEnd" class="Wdate" readonly 
							onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'addTimeStart\')}'})" 
							style="cursor: pointer;" value="${addTimeEnd }" />
					</td>
					<td class="input_data_1" >
						<authz:hasPermission name="${app}:ndys:main">
                    		<button type="button" class="fwgl_sy_cx_btn" onclick="qlgk.ndys.main.query()"><span>查询</span></button>
                    	</authz:hasPermission>
                        <authz:hasPermission name="${app}:ndys:add">
	                		<button type="button" class="ndys_bz_btn" onclick="qlgk.ndys.main.add()"><span>编制</span></button>
	              		</authz:hasPermission>
	              		<authz:hasPermission name="${app}:ndys:delete">
	              	 		<button type="button" class="ndys_delete_btn" onclick="qlgk.ndys.main.doDel()"><span>删除</span></button>
	              		</authz:hasPermission>
                    </td>
				</tr>
		</table>
                
		<table class="fwgl_table" id="list">
			<tr align="center" style="font-weight: bolder; font-size: 15px;" class="fwgl_table_title">
				<td width="32px">
					<input type="checkbox" value="" name="" id="all" onclick="qlgk.ndys.main.all()">
				</td>
				<td width="263px">预算标题</td>
				<td width="160px">预算年度</td>
				<td width="160px">预算摘要</td>
				<td width="194px">预算编制人</td>
				<td width="249px" class="fwgl_table_data">编制日期
					<span>
						<a href="#" onclick="qlgk.ndys.main.setSort('addDate','desc')" style="${flag==0?'display:none':''}">
							<img src="${ctx}/static/xt/images/gwgl_icon_3.png">
						</a>
						<a href="#" onclick="qlgk.ndys.main.setSort('addDate','asc')" style="${flag==1?'display:none':''}">
							<img src="${ctx}/static/xt/images/gwgl_icon_4.png"></a>
					</span>
				</td>
				<td width="104px">当前环节</td>
				<td width="104px">操作</td>
				<td width="104px">流程历史</td>
			</tr>
			<c:forEach items="${list}" var="ndysVo">
				<tr align="center">
					<td><input type="checkbox" value="${ndysVo.id}" name="" class="fwgl_table_checkbox"></td>
					<td>
						<a href="${ctx}/ndys/edit?id=${ndysVo.id }&method=view">
						<span class="main_title">${ndysVo.title}</span>
						</a>
					</td>
					<td>${ndysVo.ysnd}</td>
					<td>${ndysVo.yszy}</td>
					<td>${ndysVo.addUsername}</td>
					<td>${fn:substring(ndysVo.addDate,0,10)}</td>
					<td>${ndysVo.status}</td>
					<td>
						<c:if test="${ndysVo.isDone==1 }">
							<a href="${ctx}/ndys/edit?id=${ndysVo.id }&method=workflow">
								<span class="main_title">办理</span>
							</a>
						</c:if>
					</td>
					<td class="swdb_table_history">
						<a href="#"  onclick="qlgk.ndys.main.showWin('${ndysVo.id}')" >
							<img src="${ctx}/static/xt/images/swgl_icon_11.png">
						</a>
					</td>
				</tr>
			</c:forEach>
			<tr>
				<td colspan="9" class="last_page_td" style="height: 28px; line-height: 31px;">
					<jsp:include page="../../include/pageinfo.jsp"></jsp:include>
				</td>
			</tr>
		</table>
			</div>
	</form>
	<div id="popWin" class="easyui-dialog" title=""  data-options="modal:true,closed:true"></div>
</body>
</html>