CREATE TABLE ACT_GE_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    PRIMARY KEY (NAME_)
);

INSERT INTO ACT_GE_PROPERTY VALUES ('schema.version', '5.16', 1);

INSERT INTO ACT_GE_PROPERTY VALUES ('schema.history', 'create(5.16)', 1);

INSERT INTO ACT_GE_PROPERTY VALUES ('next.dbid', '1', 1);

CREATE TABLE ACT_GE_BYTEARRAY (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    DEPLOYMENT_ID_ NVARCHAR2(64),
    BYTES_ BLOB,
    GENERATED_ NUMBER(1,0) CHECK (GENERATED_ IN (1,0)),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RE_DEPLOYMENT (
    ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    CATEGORY_ NVARCHAR2(255),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    DEPLOY_TIME_ TIMESTAMP(6),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RE_MODEL (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    KEY_ NVARCHAR2(255),
    CATEGORY_ NVARCHAR2(255),
    CREATE_TIME_ TIMESTAMP(6),
    LAST_UPDATE_TIME_ TIMESTAMP(6),
    VERSION_ INTEGER,
    META_INFO_ NVARCHAR2(2000),
    DEPLOYMENT_ID_ NVARCHAR2(64),
    EDITOR_SOURCE_VALUE_ID_ NVARCHAR2(64),
    EDITOR_SOURCE_EXTRA_VALUE_ID_ NVARCHAR2(64),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_EXECUTION (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    PROC_INST_ID_ NVARCHAR2(64),
    BUSINESS_KEY_ NVARCHAR2(255),
    PARENT_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    SUPER_EXEC_ NVARCHAR2(64),
    ACT_ID_ NVARCHAR2(255),
    IS_ACTIVE_ NUMBER(1,0) CHECK (IS_ACTIVE_ IN (1,0)),
    IS_CONCURRENT_ NUMBER(1,0) CHECK (IS_CONCURRENT_ IN (1,0)),
    IS_SCOPE_ NUMBER(1,0) CHECK (IS_SCOPE_ IN (1,0)),
    IS_EVENT_SCOPE_ NUMBER(1,0) CHECK (IS_EVENT_SCOPE_ IN (1,0)),
    SUSPENSION_STATE_ INTEGER,
    CACHED_ENT_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    NAME_ NVARCHAR2(255),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_JOB (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ NVARCHAR2(255) NOT NULL,
    LOCK_EXP_TIME_ TIMESTAMP(6),
    LOCK_OWNER_ NVARCHAR2(255),
    EXCLUSIVE_ NUMBER(1,0) CHECK (EXCLUSIVE_ IN (1,0)),
    EXECUTION_ID_ NVARCHAR2(64),
    PROCESS_INSTANCE_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    RETRIES_ INTEGER,
    EXCEPTION_STACK_ID_ NVARCHAR2(64),
    EXCEPTION_MSG_ NVARCHAR2(2000),
    DUEDATE_ TIMESTAMP(6),
    REPEAT_ NVARCHAR2(255),
    HANDLER_TYPE_ NVARCHAR2(255),
    HANDLER_CFG_ NVARCHAR2(2000),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RE_PROCDEF (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    CATEGORY_ NVARCHAR2(255),
    NAME_ NVARCHAR2(255),
    KEY_ NVARCHAR2(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ NVARCHAR2(64),
    RESOURCE_NAME_ NVARCHAR2(2000),
    DGRM_RESOURCE_NAME_ VARCHAR(4000),
    DESCRIPTION_ NVARCHAR2(2000),
    HAS_START_FORM_KEY_ NUMBER(1,0) CHECK (HAS_START_FORM_KEY_ IN (1,0)),
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_TASK (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    PARENT_TASK_ID_ NVARCHAR2(64),
    DESCRIPTION_ NVARCHAR2(2000),
    TASK_DEF_KEY_ NVARCHAR2(255),
    OWNER_ NVARCHAR2(255),
    ASSIGNEE_ NVARCHAR2(255),
    DELEGATION_ NVARCHAR2(64),
    PRIORITY_ INTEGER,
    CREATE_TIME_ TIMESTAMP(6),
    DUE_DATE_ TIMESTAMP(6),
    CATEGORY_ NVARCHAR2(255),
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    FORM_KEY_ NVARCHAR2(255),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_IDENTITYLINK (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    GROUP_ID_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_VARIABLE (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ NVARCHAR2(255) NOT NULL,
    NAME_ NVARCHAR2(255) NOT NULL,
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_RU_EVENT_SUBSCR (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    EVENT_TYPE_ NVARCHAR2(255) NOT NULL,
    EVENT_NAME_ NVARCHAR2(255),
    EXECUTION_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    ACTIVITY_ID_ NVARCHAR2(64),
    CONFIGURATION_ NVARCHAR2(255),
    CREATED_ TIMESTAMP(6) NOT NULL,
    PROC_DEF_ID_ NVARCHAR2(64),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_EVT_LOG (
    LOG_NR_ NUMBER(19),
    TYPE_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    TIME_STAMP_ TIMESTAMP(6) NOT NULL,
    USER_ID_ NVARCHAR2(255),
    DATA_ BLOB,
    LOCK_OWNER_ NVARCHAR2(255),
    LOCK_TIME_ TIMESTAMP(6) NULL,
    IS_PROCESSED_ NUMBER(3) DEFAULT 0,
    PRIMARY KEY (LOG_NR_)
);

CREATE SEQUENCE ACT_EVT_LOG_SEQ;

CREATE INDEX ACT_IDX_EXEC_BUSKEY ON ACT_RU_EXECUTION(BUSINESS_KEY_);
CREATE INDEX ACT_IDX_TASK_CREATE ON ACT_RU_TASK(CREATE_TIME_);
CREATE INDEX ACT_IDX_IDENT_LNK_USER ON ACT_RU_IDENTITYLINK(USER_ID_);
CREATE INDEX ACT_IDX_IDENT_LNK_GROUP ON ACT_RU_IDENTITYLINK(GROUP_ID_);
CREATE INDEX ACT_IDX_EVENT_SUBSCR_CONFIG_ ON ACT_RU_EVENT_SUBSCR(CONFIGURATION_);
CREATE INDEX ACT_IDX_VARIABLE_TASK_ID ON ACT_RU_VARIABLE(TASK_ID_);

CREATE INDEX ACT_IDX_BYTEAR_DEPL ON ACT_GE_BYTEARRAY(DEPLOYMENT_ID_);
ALTER TABLE ACT_GE_BYTEARRAY
ADD CONSTRAINT ACT_FK_BYTEARR_DEPL
FOREIGN KEY (DEPLOYMENT_ID_) 
REFERENCES ACT_RE_DEPLOYMENT (ID_);

ALTER TABLE ACT_RE_PROCDEF
    ADD CONSTRAINT ACT_UNIQ_PROCDEF
    UNIQUE (KEY_,VERSION_, TENANT_ID_);
    
CREATE INDEX ACT_IDX_EXE_PROCINST ON ACT_RU_EXECUTION(PROC_INST_ID_);
ALTER TABLE ACT_RU_EXECUTION
    ADD CONSTRAINT ACT_FK_EXE_PROCINST
    FOREIGN KEY (PROC_INST_ID_) 
    REFERENCES ACT_RU_EXECUTION (ID_);

CREATE INDEX ACT_IDX_EXE_PARENT ON ACT_RU_EXECUTION(PARENT_ID_);
ALTER TABLE ACT_RU_EXECUTION
    ADD CONSTRAINT ACT_FK_EXE_PARENT
    FOREIGN KEY (PARENT_ID_) 
    REFERENCES ACT_RU_EXECUTION (ID_);
    
CREATE INDEX ACT_IDX_EXE_SUPER ON ACT_RU_EXECUTION(SUPER_EXEC_);
ALTER TABLE ACT_RU_EXECUTION
    ADD CONSTRAINT ACT_FK_EXE_SUPER
    FOREIGN KEY (SUPER_EXEC_) 
    REFERENCES ACT_RU_EXECUTION (ID_);
    
CREATE INDEX ACT_IDX_EXE_PROCDEF ON ACT_RU_EXECUTION(PROC_DEF_ID_);
ALTER TABLE ACT_RU_EXECUTION
    ADD CONSTRAINT ACT_FK_EXE_PROCDEF 
    FOREIGN KEY (PROC_DEF_ID_) 
    REFERENCES ACT_RE_PROCDEF (ID_);    

CREATE INDEX ACT_IDX_TSKASS_TASK ON ACT_RU_IDENTITYLINK(TASK_ID_);
--alter table ACT_RU_IDENTITYLINK add constraint ACT_FK_TSKASS_TASK foreign key (TASK_ID_) references ACT_RU_TASK (ID_);

CREATE INDEX ACT_IDX_ATHRZ_PROCEDEF  ON ACT_RU_IDENTITYLINK(PROC_DEF_ID_);
ALTER TABLE ACT_RU_IDENTITYLINK
    ADD CONSTRAINT ACT_FK_ATHRZ_PROCEDEF
    FOREIGN KEY (PROC_DEF_ID_) 
    REFERENCES ACT_RE_PROCDEF (ID_);
    
CREATE INDEX ACT_IDX_IDL_PROCINST ON ACT_RU_IDENTITYLINK(PROC_INST_ID_);
ALTER TABLE ACT_RU_IDENTITYLINK
    ADD CONSTRAINT ACT_FK_IDL_PROCINST
    FOREIGN KEY (PROC_INST_ID_) 
    REFERENCES ACT_RU_EXECUTION (ID_);    

CREATE INDEX ACT_IDX_TASK_EXEC ON ACT_RU_TASK(EXECUTION_ID_);
--alter table ACT_RU_TASK add constraint ACT_FK_TASK_EXE foreign key (EXECUTION_ID_) references ACT_RU_EXECUTION (ID_);
    
CREATE INDEX ACT_IDX_TASK_PROCINST ON ACT_RU_TASK(PROC_INST_ID_);
ALTER TABLE ACT_RU_TASK
    ADD CONSTRAINT ACT_FK_TASK_PROCINST
    FOREIGN KEY (PROC_INST_ID_)
    REFERENCES ACT_RU_EXECUTION (ID_);
    
CREATE INDEX ACT_IDX_TASK_PROCDEF ON ACT_RU_TASK(PROC_DEF_ID_);
ALTER TABLE ACT_RU_TASK
  ADD CONSTRAINT ACT_FK_TASK_PROCDEF
  FOREIGN KEY (PROC_DEF_ID_)
  REFERENCES ACT_RE_PROCDEF (ID_);
  
CREATE INDEX ACT_IDX_VAR_EXE ON ACT_RU_VARIABLE(EXECUTION_ID_);
ALTER TABLE ACT_RU_VARIABLE 
    ADD CONSTRAINT ACT_FK_VAR_EXE
    FOREIGN KEY (EXECUTION_ID_) 
    REFERENCES ACT_RU_EXECUTION (ID_);

CREATE INDEX ACT_IDX_VAR_PROCINST ON ACT_RU_VARIABLE(PROC_INST_ID_);
ALTER TABLE ACT_RU_VARIABLE
    ADD CONSTRAINT ACT_FK_VAR_PROCINST
    FOREIGN KEY (PROC_INST_ID_)
    REFERENCES ACT_RU_EXECUTION(ID_);

CREATE INDEX ACT_IDX_VAR_BYTEARRAY ON ACT_RU_VARIABLE(BYTEARRAY_ID_);
ALTER TABLE ACT_RU_VARIABLE 
    ADD CONSTRAINT ACT_FK_VAR_BYTEARRAY 
    FOREIGN KEY (BYTEARRAY_ID_) 
    REFERENCES ACT_GE_BYTEARRAY (ID_);

CREATE INDEX ACT_IDX_JOB_EXCEPTION ON ACT_RU_JOB(EXCEPTION_STACK_ID_);
ALTER TABLE ACT_RU_JOB 
    ADD CONSTRAINT ACT_FK_JOB_EXCEPTION
    FOREIGN KEY (EXCEPTION_STACK_ID_) 
    REFERENCES ACT_GE_BYTEARRAY (ID_);
    
CREATE INDEX ACT_IDX_EVENT_SUBSCR ON ACT_RU_EVENT_SUBSCR(EXECUTION_ID_);
ALTER TABLE ACT_RU_EVENT_SUBSCR
    ADD CONSTRAINT ACT_FK_EVENT_EXEC
    FOREIGN KEY (EXECUTION_ID_)
    REFERENCES ACT_RU_EXECUTION(ID_);

CREATE INDEX ACT_IDX_MODEL_SOURCE ON ACT_RE_MODEL(EDITOR_SOURCE_VALUE_ID_);
ALTER TABLE ACT_RE_MODEL 
    ADD CONSTRAINT ACT_FK_MODEL_SOURCE 
    FOREIGN KEY (EDITOR_SOURCE_VALUE_ID_) 
    REFERENCES ACT_GE_BYTEARRAY (ID_);

CREATE INDEX ACT_IDX_MODEL_SOURCE_EXTRA ON ACT_RE_MODEL(EDITOR_SOURCE_EXTRA_VALUE_ID_);
ALTER TABLE ACT_RE_MODEL 
    ADD CONSTRAINT ACT_FK_MODEL_SOURCE_EXTRA 
    FOREIGN KEY (EDITOR_SOURCE_EXTRA_VALUE_ID_) 
    REFERENCES ACT_GE_BYTEARRAY (ID_);
    
CREATE INDEX ACT_IDX_MODEL_DEPLOYMENT ON ACT_RE_MODEL(DEPLOYMENT_ID_);    
ALTER TABLE ACT_RE_MODEL 
    ADD CONSTRAINT ACT_FK_MODEL_DEPLOYMENT 
    FOREIGN KEY (DEPLOYMENT_ID_) 
    REFERENCES ACT_RE_DEPLOYMENT (ID_);        
    
-- histroy

CREATE TABLE ACT_HI_PROCINST (
    ID_ NVARCHAR2(64) NOT NULL,
    PROC_INST_ID_ NVARCHAR2(64) NOT NULL,
    BUSINESS_KEY_ NVARCHAR2(255),
    PROC_DEF_ID_ NVARCHAR2(64) NOT NULL,
    START_TIME_ TIMESTAMP(6) NOT NULL,
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    START_USER_ID_ NVARCHAR2(255),
    START_ACT_ID_ NVARCHAR2(255),
    END_ACT_ID_ NVARCHAR2(255),
    SUPER_PROCESS_INSTANCE_ID_ NVARCHAR2(64),
    DELETE_REASON_ NVARCHAR2(2000),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    NAME_ NVARCHAR2(255),
    PRIMARY KEY (ID_),
    UNIQUE (PROC_INST_ID_)
);

CREATE TABLE ACT_HI_ACTINST (
    ID_ NVARCHAR2(64) NOT NULL,
    PROC_DEF_ID_ NVARCHAR2(64) NOT NULL,
    PROC_INST_ID_ NVARCHAR2(64) NOT NULL,
    EXECUTION_ID_ NVARCHAR2(64) NOT NULL,
    ACT_ID_ NVARCHAR2(255) NOT NULL,
    TASK_ID_ NVARCHAR2(64),
    CALL_PROC_INST_ID_ NVARCHAR2(64),
    ACT_NAME_ NVARCHAR2(255),
    ACT_TYPE_ NVARCHAR2(255) NOT NULL,
    ASSIGNEE_ NVARCHAR2(255),
    START_TIME_ TIMESTAMP(6) NOT NULL,
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_TASKINST (
    ID_ NVARCHAR2(64) NOT NULL,
    PROC_DEF_ID_ NVARCHAR2(64),
    TASK_DEF_KEY_ NVARCHAR2(255),
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    PARENT_TASK_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255),
    DESCRIPTION_ NVARCHAR2(2000),
    OWNER_ NVARCHAR2(255),
    ASSIGNEE_ NVARCHAR2(255),
    START_TIME_ TIMESTAMP(6) NOT NULL,
    CLAIM_TIME_ TIMESTAMP(6),
    END_TIME_ TIMESTAMP(6),
    DURATION_ NUMBER(19,0),
    DELETE_REASON_ NVARCHAR2(2000),
    PRIORITY_ INTEGER,
    DUE_DATE_ TIMESTAMP(6),
    FORM_KEY_ NVARCHAR2(255),
    CATEGORY_ NVARCHAR2(255),
    TENANT_ID_ NVARCHAR2(255) DEFAULT '',
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_VARINST (
    ID_ NVARCHAR2(64) NOT NULL,
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255) NOT NULL,
    VAR_TYPE_ NVARCHAR2(100),
    REV_ INTEGER,
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),
    CREATE_TIME_ TIMESTAMP(6),
    LAST_UPDATED_TIME_ TIMESTAMP(6),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_DETAIL (
    ID_ NVARCHAR2(64) NOT NULL,
    TYPE_ NVARCHAR2(255) NOT NULL,
    PROC_INST_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    TASK_ID_ NVARCHAR2(64),
    ACT_INST_ID_ NVARCHAR2(64),
    NAME_ NVARCHAR2(255) NOT NULL,
    VAR_TYPE_ NVARCHAR2(64),
    REV_ INTEGER,
    TIME_ TIMESTAMP(6) NOT NULL,
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_COMMENT (
    ID_ NVARCHAR2(64) NOT NULL,
    TYPE_ NVARCHAR2(255),
    TIME_ TIMESTAMP(6) NOT NULL,
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    ACTION_ NVARCHAR2(255),
    MESSAGE_ NVARCHAR2(2000),
    FULL_MSG_ BLOB,
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_ATTACHMENT (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    USER_ID_ NVARCHAR2(255),
    NAME_ NVARCHAR2(255),
    DESCRIPTION_ NVARCHAR2(2000),
    TYPE_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    URL_ NVARCHAR2(2000),
    CONTENT_ID_ NVARCHAR2(64),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_HI_IDENTITYLINK (
    ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    USER_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_HI_PRO_INST_END ON ACT_HI_PROCINST(END_TIME_);
CREATE INDEX ACT_IDX_HI_PRO_I_BUSKEY ON ACT_HI_PROCINST(BUSINESS_KEY_);
CREATE INDEX ACT_IDX_HI_ACT_INST_START ON ACT_HI_ACTINST(START_TIME_);
CREATE INDEX ACT_IDX_HI_ACT_INST_END ON ACT_HI_ACTINST(END_TIME_);
CREATE INDEX ACT_IDX_HI_DETAIL_PROC_INST ON ACT_HI_DETAIL(PROC_INST_ID_);
CREATE INDEX ACT_IDX_HI_DETAIL_ACT_INST ON ACT_HI_DETAIL(ACT_INST_ID_);
CREATE INDEX ACT_IDX_HI_DETAIL_TIME ON ACT_HI_DETAIL(TIME_);
CREATE INDEX ACT_IDX_HI_DETAIL_NAME ON ACT_HI_DETAIL(NAME_);
CREATE INDEX ACT_IDX_HI_DETAIL_TASK_ID ON ACT_HI_DETAIL(TASK_ID_);
CREATE INDEX ACT_IDX_HI_PROCVAR_PROC_INST ON ACT_HI_VARINST(PROC_INST_ID_);
CREATE INDEX ACT_IDX_HI_PROCVAR_NAME_TYPE ON ACT_HI_VARINST(NAME_, VAR_TYPE_);
CREATE INDEX ACT_IDX_HI_IDENT_LNK_USER ON ACT_HI_IDENTITYLINK(USER_ID_);
CREATE INDEX ACT_IDX_HI_IDENT_LNK_TASK ON ACT_HI_IDENTITYLINK(TASK_ID_);
CREATE INDEX ACT_IDX_HI_IDENT_LNK_PROCINST ON ACT_HI_IDENTITYLINK(PROC_INST_ID_);

CREATE INDEX ACT_IDX_HI_ACT_INST_PROCINST ON ACT_HI_ACTINST(PROC_INST_ID_, ACT_ID_);
CREATE INDEX ACT_IDX_HI_ACT_INST_EXEC ON ACT_HI_ACTINST(EXECUTION_ID_, ACT_ID_);


-- identity

CREATE TABLE ACT_ID_GROUP (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_ID_MEMBERSHIP (
    USER_ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(64),
    PRIMARY KEY (USER_ID_, GROUP_ID_)
);

CREATE TABLE ACT_ID_USER (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    FIRST_ NVARCHAR2(255),
    LAST_ NVARCHAR2(255),
    EMAIL_ NVARCHAR2(255),
    PWD_ NVARCHAR2(255),
    PICTURE_ID_ NVARCHAR2(64),
    PRIMARY KEY (ID_)
);

CREATE TABLE ACT_ID_INFO (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    USER_ID_ NVARCHAR2(64),
    TYPE_ NVARCHAR2(64),
    KEY_ NVARCHAR2(255),
    VALUE_ NVARCHAR2(255),
    PASSWORD_ BLOB,
    PARENT_ID_ NVARCHAR2(255),
    PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_MEMB_GROUP ON ACT_ID_MEMBERSHIP(GROUP_ID_);
ALTER TABLE ACT_ID_MEMBERSHIP 
    ADD CONSTRAINT ACT_FK_MEMB_GROUP 
    FOREIGN KEY (GROUP_ID_) 
    REFERENCES ACT_ID_GROUP (ID_);

CREATE INDEX ACT_IDX_MEMB_USER ON ACT_ID_MEMBERSHIP(USER_ID_);
ALTER TABLE ACT_ID_MEMBERSHIP 
    ADD CONSTRAINT ACT_FK_MEMB_USER
    FOREIGN KEY (USER_ID_) 
    REFERENCES ACT_ID_USER (ID_);
