-----------------------------------------------------
-- EXPORT FILE FOR USER GKOA                       --
-- CREATED BY ADMINISTRATOR ON 2016-1-18, 16:03:39 --
-----------------------------------------------------

--活动记录表
CREATE TABLE T_OA_ACTIVITY
(
  WFID     VARCHAR2(255) NOT NULL,
  CURR_ACT VARCHAR2(255) NOT NULL,
  DIR      VARCHAR2(255) NOT NULL,
  NEXT_ACT VARCHAR2(255) NOT NULL,
  ID       VARCHAR2(255) NOT NULL
);
COMMENT ON TABLE T_OA_ACTIVITY  IS '活动记录表';
ALTER TABLE T_OA_ACTIVITY  ADD PRIMARY KEY (ID);
 

--大字段表
CREATE TABLE T_OA_BLOB
(
  ID            VARCHAR2(40) NOT NULL,
  VALUE         BLOB,
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_BLOB  IS '大字段表';
ALTER TABLE T_OA_BLOB  ADD PRIMARY KEY (ID);
  

--办理提醒
CREATE TABLE T_OA_BLTX
(
  ID            VARCHAR2(40) NOT NULL,
  SHR           VARCHAR2(40),
  CONTENT       VARCHAR2(500),
  STATUS        CHAR(1),
  BUSKEY        VARCHAR2(40),
  STEP          VARCHAR2(40),
  END_DATE      TIMESTAMP(6),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1),
  LX            VARCHAR2(10)
);
COMMENT ON TABLE T_OA_BLTX  IS '办理提醒表';
ALTER TABLE T_OA_BLTX  ADD PRIMARY KEY (ID);
 
  
--单位表
CREATE TABLE T_OA_DW
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(40),
  USERID        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_DW  IS '单位表';
ALTER TABLE T_OA_DW  ADD PRIMARY KEY (ID);
 

--资料文件表
CREATE TABLE T_OA_FILE
(
  ID            VARCHAR2(40) NOT NULL,
  VERID         VARCHAR2(40),
  STATUS        VARCHAR2(40),
  NAME          VARCHAR2(200),
  FILETYPE      VARCHAR2(40),
  FILESIZE      VARCHAR2(40),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  FILEID        VARCHAR2(200),
  RESERVE2      VARCHAR2(200),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40),
  FILE_ROUTE    VARCHAR2(500),
  WJJ_ID        VARCHAR2(500),
  RESERVE1      VARCHAR2(40),
  BMQX          VARCHAR2(1000),
  CKRR          VARCHAR2(1000),
  PCRR          VARCHAR2(1000)
);
COMMENT ON TABLE  T_OA_FILE  IS '资料文件表';
COMMENT ON COLUMN T_OA_FILE.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FILE.VERID  IS '版本ID';
COMMENT ON COLUMN T_OA_FILE.STATUS  IS '文件状态';
COMMENT ON COLUMN T_OA_FILE.NAME  IS '文件名';
COMMENT ON COLUMN T_OA_FILE.FILETYPE  IS '文件类型';
COMMENT ON COLUMN T_OA_FILE.FILESIZE  IS '文件大小';
COMMENT ON COLUMN T_OA_FILE.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FILE.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FILE.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILE.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILE.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILE.FILEID  IS '上传到本地的文件名';
COMMENT ON COLUMN T_OA_FILE.RESERVE2  IS '备注字段';
COMMENT ON COLUMN T_OA_FILE.RESERVE3  IS '备注字段';
COMMENT ON COLUMN T_OA_FILE.RESERVE4  IS '备注字段';
COMMENT ON COLUMN T_OA_FILE.RESERVE5  IS '备注字段';
COMMENT ON COLUMN T_OA_FILE.FILE_ROUTE  IS '文件在服务器中的路径';
COMMENT ON COLUMN T_OA_FILE.WJJ_ID  IS '在系统中直接所属的文件夹ID';
COMMENT ON COLUMN T_OA_FILE.RESERVE1  IS '备注字段';
COMMENT ON COLUMN T_OA_FILE.BMQX  IS '部门权限';
COMMENT ON COLUMN T_OA_FILE.CKRR  IS '查看人员';
COMMENT ON COLUMN T_OA_FILE.PCRR  IS '排除人员';
ALTER TABLE T_OA_FILE  ADD PRIMARY KEY (ID);


--标注文件表
CREATE TABLE T_OA_FILELABLE
(
  ID            VARCHAR2(40) NOT NULL,
  LABLETIME     TIMESTAMP(6),
  USERID        VARCHAR2(40),
  FILEID        VARCHAR2(40),
  OPSTATUS      CHAR(1),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  RESERVE1      VARCHAR2(40),
  RESERVE2      VARCHAR2(40),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_FILELABLE  IS '标注文件表';
COMMENT ON COLUMN T_OA_FILELABLE.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FILELABLE.LABLETIME  IS '标注时间';
COMMENT ON COLUMN T_OA_FILELABLE.USERID  IS '用户ID';
COMMENT ON COLUMN T_OA_FILELABLE.FILEID  IS '文件ID';
COMMENT ON COLUMN T_OA_FILELABLE.OPSTATUS  IS '操作状态1标注0未标注';
COMMENT ON COLUMN T_OA_FILELABLE.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FILELABLE.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FILELABLE.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILELABLE.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILELABLE.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILELABLE.RESERVE1  IS '备注字段';
COMMENT ON COLUMN T_OA_FILELABLE.RESERVE2  IS '备注字段';
COMMENT ON COLUMN T_OA_FILELABLE.RESERVE3  IS '备注字段';
COMMENT ON COLUMN T_OA_FILELABLE.RESERVE4  IS '备注字段';
COMMENT ON COLUMN T_OA_FILELABLE.RESERVE5  IS '备注字段';
ALTER TABLE T_OA_FILELABLE  ADD PRIMARY KEY (ID);


--文件操作备注表
CREATE TABLE T_OA_FILEOPREMARK
(
  ID            VARCHAR2(40) NOT NULL,
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  FILEID        VARCHAR2(40),
  REMARKS       NVARCHAR2(200),
  STATUS        VARCHAR2(10),
  RESERVE1      VARCHAR2(40),
  RESERVE2      VARCHAR2(40),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40),
  OPER_TYPE     VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_FILEOPREMARK  IS '文件操作备注表';
COMMENT ON COLUMN T_OA_FILEOPREMARK.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FILEOPREMARK.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FILEOPREMARK.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FILEOPREMARK.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILEOPREMARK.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILEOPREMARK.FILEID  IS '文件ID';
COMMENT ON COLUMN T_OA_FILEOPREMARK.REMARKS  IS '备注';
COMMENT ON COLUMN T_OA_FILEOPREMARK.STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RESERVE1  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RESERVE2  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RESERVE3  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RESERVE4  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEOPREMARK.RESERVE5  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEOPREMARK.OPER_TYPE  IS '操作类型';
ALTER TABLE T_OA_FILEOPREMARK  ADD PRIMARY KEY (ID);


--文件备注表
CREATE TABLE T_OA_FILEREMARK
(
  ID            VARCHAR2(40) NOT NULL,
  FILEID        VARCHAR2(40),
  REMARKS       NVARCHAR2(200),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  RESERVE1      VARCHAR2(40),
  RESERVE2      VARCHAR2(40),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_FILEREMARK  IS '文件备注表';
COMMENT ON COLUMN T_OA_FILEREMARK.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FILEREMARK.FILEID  IS '文件ID';
COMMENT ON COLUMN T_OA_FILEREMARK.REMARKS  IS '备注';
COMMENT ON COLUMN T_OA_FILEREMARK.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FILEREMARK.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FILEREMARK.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILEREMARK.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILEREMARK.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILEREMARK.RESERVE1  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEREMARK.RESERVE2  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEREMARK.RESERVE3  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEREMARK.RESERVE4  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEREMARK.RESERVE5  IS '备注字段';
ALTER TABLE T_OA_FILEREMARK  ADD PRIMARY KEY (ID);

  
--文件版本表
CREATE TABLE T_OA_FILEVER
(
  ID            VARCHAR2(40) NOT NULL,
  VERNAME       NVARCHAR2(64),
  WJURL         NVARCHAR2(64),
  FILENAME      NVARCHAR2(64),
  WJJNAME       NVARCHAR2(64),
  WJJID         NVARCHAR2(64),
  VERSTATUS     CHAR(1),
  RESERVE1      VARCHAR2(40),
  RESERVE2      VARCHAR2(40),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  FILEID        NVARCHAR2(64),
  FILETYPE      VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_FILEVER  IS '文件版本表';
COMMENT ON COLUMN T_OA_FILEVER.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FILEVER.VERNAME  IS '版本名称';
COMMENT ON COLUMN T_OA_FILEVER.WJURL  IS '文件路径';
COMMENT ON COLUMN T_OA_FILEVER.FILENAME  IS '文件名称';
COMMENT ON COLUMN T_OA_FILEVER.WJJNAME  IS '文件夹名称';
COMMENT ON COLUMN T_OA_FILEVER.WJJID  IS '文件夹ID';
COMMENT ON COLUMN T_OA_FILEVER.VERSTATUS  IS '版本状态1有效0无效';
COMMENT ON COLUMN T_OA_FILEVER.RESERVE1  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEVER.RESERVE2  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEVER.RESERVE3  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEVER.RESERVE4  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEVER.RESERVE5  IS '备注字段';
COMMENT ON COLUMN T_OA_FILEVER.ADD_DATE  IS '创建人';
COMMENT ON COLUMN T_OA_FILEVER.ADD_USER  IS '创建时间';
COMMENT ON COLUMN T_OA_FILEVER.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILEVER.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILEVER.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_FILEVER.FILEID  IS '文件编号';
COMMENT ON COLUMN T_OA_FILEVER.FILETYPE  IS '文件类型';
ALTER TABLE T_OA_FILEVER  ADD PRIMARY KEY (ID);


--文件权限
CREATE TABLE T_OA_FILE_FUN
(
  ID            VARCHAR2(40) NOT NULL,
  FILEID        VARCHAR2(40),
  FUNID         VARCHAR2(40),
  USERID        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_FILE_FUN  IS '文件权限';
COMMENT ON COLUMN T_OA_FILE_FUN.ID  IS '主键';
COMMENT ON COLUMN T_OA_FILE_FUN.FILEID  IS '文件 ID';
COMMENT ON COLUMN T_OA_FILE_FUN.FUNID  IS '查看为1，下载为2';
COMMENT ON COLUMN T_OA_FILE_FUN.USERID  IS '用户ID';
COMMENT ON COLUMN T_OA_FILE_FUN.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FILE_FUN.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FILE_FUN.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FILE_FUN.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FILE_FUN.RECORD_STATUS  IS '数据状态';
ALTER TABLE T_OA_FILE_FUN  ADD PRIMARY KEY (ID);


--附件表
CREATE TABLE T_OA_FJB
(
  ID            VARCHAR2(40) NOT NULL,
  WJM           VARCHAR2(400),
  WJHZM         VARCHAR2(400),
  BZ            VARCHAR2(1000),
  WJNR          VARCHAR2(40),
  WJDX          NUMBER,
  SSID          VARCHAR2(40),
  SSTYPE        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_FJB  IS '附件表';
COMMENT ON COLUMN T_OA_FJB.ID  IS 'ID';
COMMENT ON COLUMN T_OA_FJB.WJM  IS '文件名';
COMMENT ON COLUMN T_OA_FJB.WJHZM  IS '文件后缀名';
COMMENT ON COLUMN T_OA_FJB.BZ  IS '备注';
COMMENT ON COLUMN T_OA_FJB.WJNR  IS '文件内容';
COMMENT ON COLUMN T_OA_FJB.WJDX  IS '文件大小';
COMMENT ON COLUMN T_OA_FJB.SSID  IS '所属ID关联实体ID';
COMMENT ON COLUMN T_OA_FJB.SSTYPE  IS '所属类型关联业务表';
ALTER TABLE T_OA_FJB  ADD PRIMARY KEY (ID);


--发文
CREATE TABLE T_OA_FW
(
  ID              VARCHAR2(40) NOT NULL,
  TITLE           VARCHAR2(200),
  NO              VARCHAR2(100),
  FWDATE          TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP,
  ZSDW            VARCHAR2(200),
  CSDW            VARCHAR2(200),
  MJ              VARCHAR2(40),
  FS              VARCHAR2(100),
  CBDW            VARCHAR2(100),
  NGYJ            VARCHAR2(1000),
  BMHGYJ          VARCHAR2(1000),
  HQYJ            VARCHAR2(1000),
  QFYJ            VARCHAR2(1000),
  ADD_DATE        TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER        VARCHAR2(40),
  UPDATE_USER     VARCHAR2(40),
  UPDATE_DATE     TIMESTAMP(6),
  JDYJ            VARCHAR2(1000),
  PBYJ            VARCHAR2(1000),
  DYYJ            VARCHAR2(1000),
  RECORD_STATUS   CHAR(1),
  FGLDYJ          VARCHAR2(1000),
  WSCL            VARCHAR2(1000),
  BH              VARCHAR2(1000),
  PB              VARCHAR2(1000),
  DZGZ            VARCHAR2(1000),
  GD              VARCHAR2(1000),
  GKLY            VARCHAR2(500),
  MM              VARCHAR2(40),
  SENDFWSTATUS    CHAR(1),
  SENDFWDATE      TIMESTAMP(6),
  SENDUSERNAME    VARCHAR2(100),
  RECEVEUSERNAMES VARCHAR2(4000),
  ISGD            CHAR(1)
);
COMMENT ON TABLE  T_OA_FW  IS '发文表';
COMMENT ON COLUMN T_OA_FW.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_FW.TITLE  IS '文件标题';
COMMENT ON COLUMN T_OA_FW.NO  IS '编号';
COMMENT ON COLUMN T_OA_FW.FWDATE  IS '拟稿时间';
COMMENT ON COLUMN T_OA_FW.ZSDW  IS '主送单位';
COMMENT ON COLUMN T_OA_FW.CSDW  IS '抄送单位';
COMMENT ON COLUMN T_OA_FW.MJ  IS '密级';
COMMENT ON COLUMN T_OA_FW.FS  IS '份数';
COMMENT ON COLUMN T_OA_FW.CBDW  IS '承办单位';
COMMENT ON COLUMN T_OA_FW.NGYJ  IS '拟稿意见';
COMMENT ON COLUMN T_OA_FW.BMHGYJ  IS '部门核稿意见';
COMMENT ON COLUMN T_OA_FW.HQYJ  IS '会签意见';
COMMENT ON COLUMN T_OA_FW.QFYJ  IS '签发意见';
COMMENT ON COLUMN T_OA_FW.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_FW.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_FW.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_FW.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_FW.JDYJ  IS '校对意见';
COMMENT ON COLUMN T_OA_FW.PBYJ  IS '排版意见';
COMMENT ON COLUMN T_OA_FW.DYYJ  IS '打印意见';
COMMENT ON COLUMN T_OA_FW.RECORD_STATUS  IS '数据状态';
COMMENT ON COLUMN T_OA_FW.WSCL  IS '文书处理';
COMMENT ON COLUMN T_OA_FW.BH  IS '编号';
COMMENT ON COLUMN T_OA_FW.PB  IS '排版';
COMMENT ON COLUMN T_OA_FW.DZGZ  IS '监制';
COMMENT ON COLUMN T_OA_FW.GD  IS '归档';
COMMENT ON COLUMN T_OA_FW.GKLY  IS '公开理由';
COMMENT ON COLUMN T_OA_FW.MM  IS '秘密';
COMMENT ON COLUMN T_OA_FW.SENDFWSTATUS  IS '分发状态';
COMMENT ON COLUMN T_OA_FW.SENDFWDATE  IS '分发时间';
COMMENT ON COLUMN T_OA_FW.SENDUSERNAME  IS '分发人姓名';
COMMENT ON COLUMN T_OA_FW.RECEVEUSERNAMES  IS '收件人姓名';
COMMENT ON COLUMN T_OA_FW.ISGD  IS '是否归档';
ALTER TABLE T_OA_FW  ADD PRIMARY KEY (ID);


--发文分发
CREATE TABLE T_OA_FWFF
(
  ID            VARCHAR2(40),
  BUSINESSKEY   VARCHAR2(40),
  SENDUSERID    VARCHAR2(40),
  SENDUSERNAME  VARCHAR2(100),
  RECEIVEID     VARCHAR2(40),
  RECEIVENAME   VARCHAR2(100),
  SENDDATE      TIMESTAMP(6),
  READDATE      TIMESTAMP(6),
  TITLE         VARCHAR2(4000),
  NO            VARCHAR2(100),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_FWFF  IS '发文分发表';
ALTER TABLE T_OA_FWFF  ADD PRIMARY KEY (ID);


--干部培训
CREATE TABLE T_OA_GBPX
(
  ID            VARCHAR2(40) NOT NULL,
  RDATE         TIMESTAMP(6),
  ADDRESS       VARCHAR2(200),
  TEACHER       VARCHAR2(40),
  AUTHOR        VARCHAR2(40),
  CONTENT       VARCHAR2(400),
  KJID          VARCHAR2(40),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_GBPX  IS '干部培训';
ALTER TABLE T_OA_GBPX  ADD PRIMARY KEY (ID);
 

--干部选拔
CREATE TABLE T_OA_GBXB
(
  ID            VARCHAR2(40) NOT NULL,
  GSTITLE       NVARCHAR2(200),
  GSSUM         NVARCHAR2(500),
  WJTITLE       NVARCHAR2(200),
  WJSUM         NVARCHAR2(500),
  FJAID         NVARCHAR2(500),
  FJBID         NVARCHAR2(500),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_GBXB  IS '干部选拔';
ALTER TABLE T_OA_GBXB  ADD PRIMARY KEY (ID);
  

--归档流水号
CREATE TABLE T_OA_GDLSH
(
  ID            VARCHAR2(40),
  BUSINESSKEY   VARCHAR2(40),
  LSH           VARCHAR2(40),
  GDTYPE        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_GDLSH  IS '归档流水号';
ALTER TABLE T_OA_GDLSH  ADD PRIMARY KEY (ID);


--公告范围
CREATE TABLE T_OA_GGFW
(
  ID            VARCHAR2(40) NOT NULL,
  GGID          VARCHAR2(40),
  SENDUSER      VARCHAR2(40),
  GGR           VARCHAR2(40),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_GGFW  IS '公告范围';
COMMENT ON COLUMN T_OA_GGFW.GGID  IS '公告ID';
COMMENT ON COLUMN T_OA_GGFW.SENDUSER  IS '发布人';
COMMENT ON COLUMN T_OA_GGFW.GGR  IS '能看到该公告的人';
ALTER TABLE T_OA_GGFW  ADD PRIMARY KEY (ID);


--公告管理
CREATE TABLE T_OA_GGGL
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(100),
  ANNEX         NVARCHAR2(2000),
  CONTENT       NVARCHAR2(2000),
  ISTOP         CHAR(1) DEFAULT 0,
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  SEND_STATUS   CHAR(1),
  SEND_DATE     TIMESTAMP(6),
  TOP_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  SENDUSER      VARCHAR2(20)
);
COMMENT ON TABLE  T_OA_GGGL  IS '公告管理';
COMMENT ON COLUMN T_OA_GGGL.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_GGGL.ANNEX  IS '附件';
COMMENT ON COLUMN T_OA_GGGL.CONTENT  IS '公告内容';
COMMENT ON COLUMN T_OA_GGGL.ISTOP  IS '是否置顶.0、否；1、是';
COMMENT ON COLUMN T_OA_GGGL.ADD_USER  IS '公告添加人';
COMMENT ON COLUMN T_OA_GGGL.ADD_DATE  IS '添加日期';
COMMENT ON COLUMN T_OA_GGGL.SEND_STATUS  IS '是否发布；0、否；1、是';
COMMENT ON COLUMN T_OA_GGGL.SEND_DATE  IS '发布时间';
COMMENT ON COLUMN T_OA_GGGL.TOP_DATE  IS '置顶时间';
COMMENT ON COLUMN T_OA_GGGL.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_GGGL.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_GGGL.SENDUSER  IS '公告发起人';
ALTER TABLE T_OA_GGGL  ADD PRIMARY KEY (ID);


-- 港口项目
CREATE TABLE T_OA_GKXM
(
  TITLE               VARCHAR2(100),
  PROJECT_INFORMATION NVARCHAR2(2000),
  ANNEX               NVARCHAR2(2000),
  FINANCIAL_SUBSIDY   NUMBER,
  EXPERT_OPINION      NVARCHAR2(2000),
  ID                  VARCHAR2(40) NOT NULL,
  ESTABLISH_TIME      TIMESTAMP(6),
  ADD_USER            VARCHAR2(40),
  ADD_DATE            TIMESTAMP(6),
  UPDATE_USER         VARCHAR2(40),
  UPDATE_DATE         TIMESTAMP(6),
  RECORD_STATUS       CHAR(1)
);
COMMENT ON TABLE  T_OA_GKXM  IS '港口项目';
COMMENT ON COLUMN T_OA_GKXM.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_GKXM.PROJECT_INFORMATION  IS '申报项目基本信息';
COMMENT ON COLUMN T_OA_GKXM.ANNEX  IS '附件';
COMMENT ON COLUMN T_OA_GKXM.FINANCIAL_SUBSIDY  IS '财政补助';
COMMENT ON COLUMN T_OA_GKXM.EXPERT_OPINION  IS '专家意见';
COMMENT ON COLUMN T_OA_GKXM.ESTABLISH_TIME  IS '立项时间';
ALTER TABLE T_OA_GKXM  ADD PRIMARY KEY (ID);


--公务出差
CREATE TABLE T_OA_GWCC
(
  ID            VARCHAR2(40),
  SQRID         VARCHAR2(40),
  SQRNAME       VARCHAR2(80),
  TXRY          VARCHAR2(400),
  CCRS          NUMBER,
  SQBM          VARCHAR2(40),
  SQBMNAME      VARCHAR2(400),
  SQREASON      VARCHAR2(400),
  SQDATE        TIMESTAMP(6),
  STARTDATE1    TIMESTAMP(6),
  ENDDATE1      TIMESTAMP(6),
  STARTDATE2    TIMESTAMP(6),
  ENDDATE2      TIMESTAMP(6),
  STARTDATE3    TIMESTAMP(6),
  ENDDATE3      TIMESTAMP(6),
  STARTDATE4    TIMESTAMP(6),
  ENDDATE4      TIMESTAMP(6),
  STARTADDR1    VARCHAR2(400),
  ENDADDR1      VARCHAR2(400),
  STARTADDR2    VARCHAR2(400),
  ENDADDR2      VARCHAR2(400),
  STARTADDR3    VARCHAR2(400),
  ENDADDR3      VARCHAR2(400),
  STARTADDR4    VARCHAR2(400),
  ENDADDR4      VARCHAR2(400),
  SFDWPC        VARCHAR2(20),
  JSY           VARCHAR2(200),
  QTBC          VARCHAR2(20),
  JTGJ          VARCHAR2(40),
  REMARK        VARCHAR2(400),
  SQ            VARCHAR2(2000),
  BMSH          VARCHAR2(2000),
  ZHKSH         VARCHAR2(2000),
  FGLDSP        VARCHAR2(2000),
  ZYLDSP        VARCHAR2(2000),
  SQRQR         VARCHAR2(2000),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_GWCC  IS '公务出差';
ALTER TABLE T_OA_GWCC  ADD PRIMARY KEY (ID);


--结果公开
CREATE TABLE T_OA_JGGK
(
  ID            VARCHAR2(40) NOT NULL,
  TYPE          VARCHAR2(40),
  TITLE         NVARCHAR2(500),
  BM            VARCHAR2(40),
  USERID        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   NVARCHAR2(40),
  RECORD_STATUS CHAR(1),
  BUSSKEYID     VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_JGGK  IS '结果公开';
COMMENT ON COLUMN T_OA_JGGK.ID  IS '主键';
COMMENT ON COLUMN T_OA_JGGK.TYPE  IS '类型';
COMMENT ON COLUMN T_OA_JGGK.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_JGGK.BM  IS '部门ID';
COMMENT ON COLUMN T_OA_JGGK.USERID  IS '用户ID';
COMMENT ON COLUMN T_OA_JGGK.ADD_DATE  IS '创建人ID';
COMMENT ON COLUMN T_OA_JGGK.ADD_USER  IS '创建日期';
COMMENT ON COLUMN T_OA_JGGK.UPDATE_DATE  IS '修改日期';
COMMENT ON COLUMN T_OA_JGGK.UPDATE_USER  IS '修改人ID';
COMMENT ON COLUMN T_OA_JGGK.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_JGGK.BUSSKEYID  IS '业务ID';
ALTER TABLE T_OA_JGGK  ADD PRIMARY KEY (ID);


--建设提案办理
CREATE TABLE T_OA_JSTA
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(100),
  NO            VARCHAR2(100),
  FWDATE        TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP,
  ZSDW          VARCHAR2(100),
  CSDW          VARCHAR2(100),
  MJ            VARCHAR2(40),
  FS            VARCHAR2(100),
  CBDW          VARCHAR2(100),
  NGYJ          VARCHAR2(1000),
  BMHGYJ        VARCHAR2(1000),
  HQYJ          VARCHAR2(1000),
  QFYJ          VARCHAR2(1000),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  JDYJ          VARCHAR2(1000),
  PBYJ          VARCHAR2(1000),
  DYYJ          VARCHAR2(1000),
  RECORD_STATUS CHAR(1),
  FGLDYJ        VARCHAR2(1000),
  GKLY          VARCHAR2(500),
  MM            VARCHAR2(40),
  WSCL          VARCHAR2(1000),
  BH            VARCHAR2(1000),
  PB            VARCHAR2(1000),
  DZGZ          VARCHAR2(1000),
  GD            VARCHAR2(1000)
);
COMMENT ON TABLE  T_OA_JSTA  IS '建设提案表';
COMMENT ON COLUMN T_OA_JSTA.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_JSTA.TITLE  IS '文件标题';
COMMENT ON COLUMN T_OA_JSTA.NO  IS '编号';
COMMENT ON COLUMN T_OA_JSTA.FWDATE  IS '拟稿时间';
COMMENT ON COLUMN T_OA_JSTA.ZSDW  IS '主送单位';
COMMENT ON COLUMN T_OA_JSTA.CSDW  IS '抄送单位';
COMMENT ON COLUMN T_OA_JSTA.MJ  IS '密级';
COMMENT ON COLUMN T_OA_JSTA.FS  IS '份数';
COMMENT ON COLUMN T_OA_JSTA.CBDW  IS '承办单位';
COMMENT ON COLUMN T_OA_JSTA.NGYJ  IS '拟稿意见';
COMMENT ON COLUMN T_OA_JSTA.BMHGYJ  IS '部门核稿意见';
COMMENT ON COLUMN T_OA_JSTA.HQYJ  IS '会签意见';
COMMENT ON COLUMN T_OA_JSTA.QFYJ  IS '签发意见';
COMMENT ON COLUMN T_OA_JSTA.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_JSTA.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_JSTA.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_JSTA.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_JSTA.JDYJ  IS '校对意见';
COMMENT ON COLUMN T_OA_JSTA.PBYJ  IS '排版意见';
COMMENT ON COLUMN T_OA_JSTA.DYYJ  IS '打印意见';
COMMENT ON COLUMN T_OA_JSTA.RECORD_STATUS  IS '数据状态';
COMMENT ON COLUMN T_OA_JSTA.GKLY  IS '公开理由';
COMMENT ON COLUMN T_OA_JSTA.MM  IS '秘密';
COMMENT ON COLUMN T_OA_JSTA.WSCL  IS '文书处理';
COMMENT ON COLUMN T_OA_JSTA.BH  IS '编号';
COMMENT ON COLUMN T_OA_JSTA.PB  IS '排版';
COMMENT ON COLUMN T_OA_JSTA.DZGZ  IS '监印';
COMMENT ON COLUMN T_OA_JSTA.GD  IS '归档';
ALTER TABLE T_OA_JSTA  ADD PRIMARY KEY (ID);


--内部邮件管理表
CREATE TABLE T_OA_MAIL
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(256),
  CONTENT       VARCHAR2(4000),
  SEND_DATE     TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP,
  SEND_USER     VARCHAR2(40),
  STATUS        NUMBER,
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_MAIL  IS '内部邮件管理表';
COMMENT ON COLUMN T_OA_MAIL.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_MAIL.TITLE  IS '主题';
COMMENT ON COLUMN T_OA_MAIL.CONTENT  IS '正文';
COMMENT ON COLUMN T_OA_MAIL.SEND_DATE  IS '邮件发送时间';
COMMENT ON COLUMN T_OA_MAIL.SEND_USER  IS '发件人';
COMMENT ON COLUMN T_OA_MAIL.STATUS  IS '1草稿2已发送';
ALTER TABLE T_OA_MAIL  ADD PRIMARY KEY (ID);


--内部邮件发收管理表
CREATE TABLE T_OA_MAIL_USER
(
  ID            VARCHAR2(40) NOT NULL,
  RECEIVE_USER  VARCHAR2(40),
  TYPE          NUMBER,
  STATUS        NUMBER,
  MAILID        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_MAIL_USER  IS '内部邮件发收管理表';
COMMENT ON COLUMN T_OA_MAIL_USER.ID  IS '邮件标识';
COMMENT ON COLUMN T_OA_MAIL_USER.RECEIVE_USER  IS '接收人';
COMMENT ON COLUMN T_OA_MAIL_USER.TYPE  IS '1收件人2抄送人';
COMMENT ON COLUMN T_OA_MAIL_USER.STATUS  IS '1已读2未读';
COMMENT ON COLUMN T_OA_MAIL_USER.MAILID  IS '邮件标识';
ALTER TABLE T_OA_MAIL_USER  ADD PRIMARY KEY (ID);


--年度预算
CREATE TABLE T_OA_NDYS
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(200),
  YSND          VARCHAR2(20),
  YSZY          VARCHAR2(400),
  TWHZY         VARCHAR2(400),
  CZTZY         VARCHAR2(400),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_NDYS  IS '年度预算';
COMMENT ON COLUMN T_OA_NDYS.TITLE  IS '预算标题';
COMMENT ON COLUMN T_OA_NDYS.YSND  IS '预算年度';
COMMENT ON COLUMN T_OA_NDYS.YSZY  IS '预算摘要';
COMMENT ON COLUMN T_OA_NDYS.TWHZY  IS '厅务会审议摘要';
COMMENT ON COLUMN T_OA_NDYS.CZTZY  IS '省财政厅审核并批复下达摘要';
ALTER TABLE T_OA_NDYS  ADD PRIMARY KEY (ID);
  

--意见表
CREATE TABLE T_OA_OPINION
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(400),
  USERID        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_OPINION  IS '意见表';
ALTER TABLE T_OA_OPINION  ADD PRIMARY KEY (ID);


--港口项目子表
CREATE TABLE T_OA_PROJECT
(
  ID                  VARCHAR2(40) NOT NULL,
  PROJECT_NAME        VARCHAR2(40),
  APPLY_COMPANY       VARCHAR2(200),
  PROJECT_LOADER      VARCHAR2(40),
  EXPECTED_START_TIME TIMESTAMP(6),
  EXPECTED_END_TIME   TIMESTAMP(6),
  TOTAL_FUND          NUMBER,
  APPLY_FUND          NUMBER,
  PER_ID              VARCHAR2(40),
  ADD_USER            VARCHAR2(40),
  ADD_DATE            TIMESTAMP(6),
  UPDATE_USER         VARCHAR2(40),
  UPDATE_DATE         TIMESTAMP(6),
  RECORD_STATUS       CHAR(1)
);
COMMENT ON TABLE  T_OA_PROJECT  IS '港口项目子表';
COMMENT ON COLUMN T_OA_PROJECT.PROJECT_NAME  IS '项目名称';
COMMENT ON COLUMN T_OA_PROJECT.APPLY_COMPANY  IS '申请单位';
COMMENT ON COLUMN T_OA_PROJECT.PROJECT_LOADER  IS '项目负责人';
COMMENT ON COLUMN T_OA_PROJECT.EXPECTED_START_TIME  IS '预计开始时间';
COMMENT ON COLUMN T_OA_PROJECT.EXPECTED_END_TIME  IS '预计结束时间';
COMMENT ON COLUMN T_OA_PROJECT.TOTAL_FUND  IS '总经费';
COMMENT ON COLUMN T_OA_PROJECT.APPLY_FUND  IS '申请经费';
COMMENT ON COLUMN T_OA_PROJECT.PER_ID  IS '归属立项ID';
ALTER TABLE T_OA_PROJECT  ADD PRIMARY KEY (ID);


--签报
CREATE TABLE T_OA_QB
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(1000),
  COMPANY       VARCHAR2(100),
  BMOPINION     VARCHAR2(4000),
  HBOPINION     VARCHAR2(4000),
  LDOPINION     VARCHAR2(4000),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  NO            VARCHAR2(200),
  BL            VARCHAR2(4000),
  WSCL          VARCHAR2(4000),
  QGJD          VARCHAR2(4000),
  CY            VARCHAR2(4000),
  GD            VARCHAR2(4000)
);
COMMENT ON TABLE  T_OA_QB  IS '签报表';
COMMENT ON COLUMN T_OA_QB.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_QB.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_QB.COMPANY  IS '单位';
COMMENT ON COLUMN T_OA_QB.BMOPINION  IS '部门意见';
COMMENT ON COLUMN T_OA_QB.HBOPINION  IS '会办意见';
COMMENT ON COLUMN T_OA_QB.LDOPINION  IS '领导意见';
COMMENT ON COLUMN T_OA_QB.BL  IS '办理';
COMMENT ON COLUMN T_OA_QB.WSCL  IS '文书处理';
COMMENT ON COLUMN T_OA_QB.QGJD  IS '清稿校对';
COMMENT ON COLUMN T_OA_QB.CY  IS '传阅';
COMMENT ON COLUMN T_OA_QB.GD  IS '归档';
ALTER TABLE T_OA_QB  ADD PRIMARY KEY (ID);


--日程安排管理表
CREATE TABLE T_OA_SCHEDULE
(
  ID            VARCHAR2(40) NOT NULL,
  USERID        VARCHAR2(40),
  SCHEDULE      VARCHAR2(256),
  SCHEDULEINFO  VARCHAR2(2000),
  SCHEDULETYPE  CHAR(1),
  REMINDTIME    TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP,
  CREATETIME    TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP,
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  STATUS        CHAR(1)
);
COMMENT ON TABLE  T_OA_SCHEDULE  IS '日程安排管理表';
COMMENT ON COLUMN T_OA_SCHEDULE.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_SCHEDULE.USERID  IS '用户标识';
COMMENT ON COLUMN T_OA_SCHEDULE.SCHEDULE  IS '日程略';
COMMENT ON COLUMN T_OA_SCHEDULE.SCHEDULEINFO  IS '日程内容';
COMMENT ON COLUMN T_OA_SCHEDULE.SCHEDULETYPE  IS '日程状态';
COMMENT ON COLUMN T_OA_SCHEDULE.REMINDTIME  IS '日程提醒时间';
COMMENT ON COLUMN T_OA_SCHEDULE.CREATETIME  IS '日程创建时间';
ALTER TABLE T_OA_SCHEDULE  ADD PRIMARY KEY (ID);


--收文
CREATE TABLE T_OA_SW
(
  ID               VARCHAR2(40) NOT NULL,
  SWNUM            VARCHAR2(100),
  NO               VARCHAR2(100),
  COMPANY          VARCHAR2(100),
  TITLE            VARCHAR2(1000),
  SWDATE           TIMESTAMP(6),
  YBOPINION        VARCHAR2(2000),
  LDINSTRUCTIONS   VARCHAR2(2000),
  FGLDINSTRUCTIONS VARCHAR2(2000),
  BMOPINION        VARCHAR2(2000),
  OPINION          VARCHAR2(4000),
  REMARKS          VARCHAR2(2000),
  UPDATEDATE       TIMESTAMP(6),
  ADDDATE          TIMESTAMP(6),
  ADDUSER          VARCHAR2(40),
  UPDATEUSER       VARCHAR2(40),
  RECORDSTATUS     CHAR(1),
  SWTYPE           VARCHAR2(100),
  ADD_DATE         TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER         VARCHAR2(40),
  UPDATE_USER      VARCHAR2(40),
  UPDATE_DATE      TIMESTAMP(6),
  RECORD_STATUS    CHAR(1),
  BLOPINION        VARCHAR2(4000),
  ISGD             CHAR(1)
);
COMMENT ON TABLE  T_OA_SW  IS '收文表';
COMMENT ON COLUMN T_OA_SW.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_SW.SWNUM  IS '收文编号';
COMMENT ON COLUMN T_OA_SW.NO  IS '文件号';
COMMENT ON COLUMN T_OA_SW.COMPANY  IS '来文单位';
COMMENT ON COLUMN T_OA_SW.TITLE  IS '来文标题';
COMMENT ON COLUMN T_OA_SW.SWDATE  IS '收文日期';
COMMENT ON COLUMN T_OA_SW.YBOPINION  IS '拟办意见';
COMMENT ON COLUMN T_OA_SW.LDINSTRUCTIONS  IS '领导批示';
COMMENT ON COLUMN T_OA_SW.FGLDINSTRUCTIONS  IS '分管领导批示';
COMMENT ON COLUMN T_OA_SW.BMOPINION  IS '部门办理意见';
COMMENT ON COLUMN T_OA_SW.OPINION  IS '处理意见';
COMMENT ON COLUMN T_OA_SW.REMARKS  IS '备注';
COMMENT ON COLUMN T_OA_SW.UPDATEDATE  IS '修改时间';
COMMENT ON COLUMN T_OA_SW.ADDUSER  IS '创建人';
COMMENT ON COLUMN T_OA_SW.UPDATEUSER  IS '修改人';
COMMENT ON COLUMN T_OA_SW.RECORDSTATUS  IS '数据状态';
COMMENT ON COLUMN T_OA_SW.SWTYPE  IS '来文类型';
COMMENT ON COLUMN T_OA_SW.ISGD  IS '是否归档';
ALTER TABLE T_OA_SW  ADD PRIMARY KEY (ID);


--通讯录
CREATE TABLE T_OA_TXL
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(200),
  TEL           VARCHAR2(40),
  MOBILE        VARCHAR2(40),
  EMAIL         VARCHAR2(200),
  ORGID         VARCHAR2(40),
  ORGNAME       VARCHAR2(200),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  ZMID          VARCHAR2(40),
  USERID        VARCHAR2(40),
  SORTNO        INTEGER
);
COMMENT ON TABLE  T_OA_TXL  IS '通讯录表';
ALTER TABLE T_OA_TXL  ADD PRIMARY KEY (ID);


--通讯录组名表
CREATE TABLE T_OA_TXLZM
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(40),
  REASON        VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1),
  USERID        VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_TXLZM  IS '通讯录组名表';  
ALTER TABLE T_OA_TXLZM  ADD PRIMARY KEY (ID);


--帐号和微信分组关联
CREATE TABLE T_OA_USER_BM
(
  ID            VARCHAR2(40) NOT NULL,
  UNAME         VARCHAR2(80),
  BMID          NUMBER,
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_USER_BM  IS '帐号和微信分组关联';   
ALTER TABLE T_OA_USER_BM  ADD PRIMARY KEY (ID);


--用户详细信息表
CREATE TABLE T_OA_USER_INFO
(
  ID            VARCHAR2(40) NOT NULL,
  USERID        VARCHAR2(40) NOT NULL,
  EMPLOYEENO    VARCHAR2(40),
  SEX           CHAR(1),
  TELNO         VARCHAR2(44),
  TELPHONENO    VARCHAR2(44),
  ADDR          VARCHAR2(2000),
  MSN           VARCHAR2(256),
  QQ            VARCHAR2(256),
  EMAIL         VARCHAR2(256),
  NAME          VARCHAR2(200),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  DEPARTMENT    VARCHAR2(100)
);
COMMENT ON TABLE  T_OA_USER_INFO  IS '用户详细信息表';
COMMENT ON COLUMN T_OA_USER_INFO.ID  IS '唯一标识';
COMMENT ON COLUMN T_OA_USER_INFO.USERID  IS '用户标识';
COMMENT ON COLUMN T_OA_USER_INFO.EMPLOYEENO  IS '工号';
COMMENT ON COLUMN T_OA_USER_INFO.SEX  IS '性别';
COMMENT ON COLUMN T_OA_USER_INFO.TELNO  IS '电话号码';
COMMENT ON COLUMN T_OA_USER_INFO.TELPHONENO  IS '电话号码';
COMMENT ON COLUMN T_OA_USER_INFO.ADDR  IS '地址';
COMMENT ON COLUMN T_OA_USER_INFO.MSN  IS 'MSN';
COMMENT ON COLUMN T_OA_USER_INFO.QQ  IS 'QQ';
COMMENT ON COLUMN T_OA_USER_INFO.EMAIL  IS '邮件';
COMMENT ON COLUMN T_OA_USER_INFO.DEPARTMENT  IS '部门';
ALTER TABLE T_OA_USER_INFO  ADD PRIMARY KEY (ID);


--针对微信 待办已读未读区分
CREATE TABLE T_OA_VIEWFLAG
(
  ID            VARCHAR2(40) NOT NULL,
  WFID          VARCHAR2(40),
  USERID        VARCHAR2(40),
  STEPNAME      VARCHAR2(200),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);  
COMMENT ON TABLE  T_OA_VIEWFLAG  IS '针对微信待办已读未读区分';
ALTER TABLE T_OA_VIEWFLAG  ADD PRIMARY KEY (ID);


--文件夹表
CREATE TABLE T_OA_WJJ
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          NVARCHAR2(64),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1),
  RESERVE1      VARCHAR2(40),
  RESERVE2      VARCHAR2(40),
  RESERVE3      VARCHAR2(40),
  RESERVE4      VARCHAR2(40),
  RESERVE5      VARCHAR2(40),
  PRI_ID        VARCHAR2(500),
  DIRID         VARCHAR2(40),
  BMQX          VARCHAR2(1000),
  CKRR          VARCHAR2(1000),
  PCRR          VARCHAR2(1000),
  LOCATION      VARCHAR2(500)
);
COMMENT ON TABLE  T_OA_WJJ  IS '文件夹表';
COMMENT ON COLUMN T_OA_WJJ.ID  IS '主键ID';
COMMENT ON COLUMN T_OA_WJJ.NAME  IS '文件夹名';
COMMENT ON COLUMN T_OA_WJJ.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_WJJ.ADD_USER  IS '创建人员';
COMMENT ON COLUMN T_OA_WJJ.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_WJJ.UPDATE_USER  IS '修改人员';
COMMENT ON COLUMN T_OA_WJJ.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_WJJ.RESERVE1  IS '备用字段';
COMMENT ON COLUMN T_OA_WJJ.RESERVE2  IS '备用字段';
COMMENT ON COLUMN T_OA_WJJ.RESERVE3  IS '备用字段';
COMMENT ON COLUMN T_OA_WJJ.RESERVE4  IS '备用字段';
COMMENT ON COLUMN T_OA_WJJ.RESERVE5  IS '备用字段';
COMMENT ON COLUMN T_OA_WJJ.PRI_ID  IS '上级文件夹';
COMMENT ON COLUMN T_OA_WJJ.DIRID  IS '文件夹ID';
COMMENT ON COLUMN T_OA_WJJ.BMQX  IS '部门权限';
COMMENT ON COLUMN T_OA_WJJ.CKRR  IS '查看人员权限';
COMMENT ON COLUMN T_OA_WJJ.PCRR  IS '排除人员权限';
COMMENT ON COLUMN T_OA_WJJ.LOCATION  IS '全路径';
ALTER TABLE T_OA_WJJ  ADD PRIMARY KEY (ID);


--文件夹权限
CREATE TABLE T_OA_WJJ_FUN
(
  ID            VARCHAR2(40) NOT NULL,
  WJJID         VARCHAR2(40),
  USERID        VARCHAR2(40),
  FUNID         VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_WJJ_FUN  IS '文件夹权限';
COMMENT ON COLUMN T_OA_WJJ_FUN.ID  IS '主键';
COMMENT ON COLUMN T_OA_WJJ_FUN.WJJID  IS '文件ID';
COMMENT ON COLUMN T_OA_WJJ_FUN.USERID  IS '用户ID';
COMMENT ON COLUMN T_OA_WJJ_FUN.FUNID  IS '查看为1 下载为2';
COMMENT ON COLUMN T_OA_WJJ_FUN.ADD_DATE  IS '创建时间';
COMMENT ON COLUMN T_OA_WJJ_FUN.ADD_USER  IS '创建人';
COMMENT ON COLUMN T_OA_WJJ_FUN.UPDATE_USER  IS '修改人';
COMMENT ON COLUMN T_OA_WJJ_FUN.UPDATE_DATE  IS '修改时间';
COMMENT ON COLUMN T_OA_WJJ_FUN.RECORD_STATUS  IS '数据状态';
ALTER TABLE T_OA_WJJ_FUN  ADD PRIMARY KEY (ID);


--发送微信企业号消息表
CREATE TABLE T_OA_WX_MSG
(
  ID            VARCHAR2(40) NOT NULL,
  WEIXINID      VARCHAR2(80),
  AGENTID       NUMBER,
  CONTENT       VARCHAR2(2000),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  TITLE         VARCHAR2(400),
  UNAME         VARCHAR2(100),
  STATUS        CHAR(1),
  BUSSKEY       VARCHAR2(40),
  MK            VARCHAR2(50),
  OAUSERID      VARCHAR2(40)
);
COMMENT ON TABLE  T_OA_WX_MSG  IS '发送微信企业号消息表';
COMMENT ON COLUMN T_OA_WX_MSG.WEIXINID  IS '微信号';
COMMENT ON COLUMN T_OA_WX_MSG.AGENTID  IS '企业应用的ID，整型。可在应用的设置页面查看';
COMMENT ON COLUMN T_OA_WX_MSG.CONTENT  IS '消息内容';
COMMENT ON COLUMN T_OA_WX_MSG.TITLE  IS '消息标题';
COMMENT ON COLUMN T_OA_WX_MSG.UNAME  IS '登入帐号';
COMMENT ON COLUMN T_OA_WX_MSG.STATUS  IS '状态';
COMMENT ON COLUMN T_OA_WX_MSG.OAUSERID  IS 'OA中USERID';
ALTER TABLE T_OA_WX_MSG  ADD PRIMARY KEY (ID);
  
  
--信访件办理
CREATE TABLE T_OA_XFJBL
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(40),
  TEL           VARCHAR2(15),
  MOBILE        VARCHAR2(15),
  EMAIL         VARCHAR2(50),
  ADDR          VARCHAR2(400),
  POSTCODE      VARCHAR2(10),
  CARD_TYPE     VARCHAR2(50),
  SEX           NUMBER,
  CARD_NO       VARCHAR2(30),
  AGE           NUMBER,
  TITLE         VARCHAR2(200),
  CONTENT       VARCHAR2(4000),
  IS_GK         NUMBER,
  COMMIT_DATE   DATE,
  BJ_NO         VARCHAR2(30),
  BJ_TYPE       VARCHAR2(200),
  FJ_IP         VARCHAR2(50),
  NG            VARCHAR2(200),
  BMHG          VARCHAR2(400),
  HQ            VARCHAR2(400),
  BGSHG         VARCHAR2(400),
  FGLDSQ        VARCHAR2(400),
  QF            VARCHAR2(400),
  JD            VARCHAR2(400),
  JY            VARCHAR2(400),
  DFJG          VARCHAR2(200),
  DF_DATE       DATE,
  DF_CONTENT    VARCHAR2(4000),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      DATE,
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   DATE,
  RECORD_STATUS NUMBER
);
COMMENT ON TABLE  T_OA_XFJBL  IS '信访件办理表';
COMMENT ON COLUMN T_OA_XFJBL.NAME  IS '姓名';
COMMENT ON COLUMN T_OA_XFJBL.TEL  IS '电话';
COMMENT ON COLUMN T_OA_XFJBL.MOBILE  IS '手机号';
COMMENT ON COLUMN T_OA_XFJBL.ADDR  IS '联系地址';
COMMENT ON COLUMN T_OA_XFJBL.POSTCODE  IS '邮政编码';
COMMENT ON COLUMN T_OA_XFJBL.CARD_TYPE  IS '证件类型';
COMMENT ON COLUMN T_OA_XFJBL.SEX  IS '性别';
COMMENT ON COLUMN T_OA_XFJBL.CARD_NO  IS '证件号码';
COMMENT ON COLUMN T_OA_XFJBL.AGE  IS '年龄';
COMMENT ON COLUMN T_OA_XFJBL.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_XFJBL.CONTENT  IS '内容';
COMMENT ON COLUMN T_OA_XFJBL.IS_GK  IS '是否公开';
COMMENT ON COLUMN T_OA_XFJBL.COMMIT_DATE  IS '提交时间';
COMMENT ON COLUMN T_OA_XFJBL.BJ_NO  IS '办件编号';
COMMENT ON COLUMN T_OA_XFJBL.BJ_TYPE  IS '办件类型';
COMMENT ON COLUMN T_OA_XFJBL.FJ_IP  IS '发件IP';
COMMENT ON COLUMN T_OA_XFJBL.NG  IS '拟稿意见';
COMMENT ON COLUMN T_OA_XFJBL.BMHG  IS '部门核稿意见';
COMMENT ON COLUMN T_OA_XFJBL.HQ  IS '会签';
COMMENT ON COLUMN T_OA_XFJBL.BGSHG  IS '综合科核稿';
COMMENT ON COLUMN T_OA_XFJBL.FGLDSQ  IS '分管领导审签';
COMMENT ON COLUMN T_OA_XFJBL.QF  IS '签发';
COMMENT ON COLUMN T_OA_XFJBL.JD  IS '校对';
COMMENT ON COLUMN T_OA_XFJBL.JY  IS '监印';
COMMENT ON COLUMN T_OA_XFJBL.DFJG  IS '答复机构';
COMMENT ON COLUMN T_OA_XFJBL.DF_DATE  IS '答复时间';
COMMENT ON COLUMN T_OA_XFJBL.DF_CONTENT  IS '答复内容';
ALTER TABLE T_OA_XFJBL  ADD PRIMARY KEY (ID);
  

--因公出国
CREATE TABLE T_OA_YGCG
(
  ID             VARCHAR2(40) NOT NULL,
  APPUSERID      VARCHAR2(40),
  BM             VARCHAR2(40),
  COLLEAGUE      NVARCHAR2(500),
  NUM            NUMBER,
  TRANSPORTATION VARCHAR2(40),
  BEGINTIME      TIMESTAMP(6),
  ENDTIME        TIMESTAMP(6),
  ADD_USER       VARCHAR2(40),
  ADD_DATE       TIMESTAMP(6),
  UPDATE_USER    VARCHAR2(40),
  UPDATE_DATE    TIMESTAMP(6),
  RECORD_STATUS  CHAR(1),
  LOCATION       NVARCHAR2(500),
  REASON         NVARCHAR2(2000),
  BMOPINION      NVARCHAR2(500),
  LDOPINION      NVARCHAR2(500)
);
COMMENT ON TABLE  T_OA_YGCG  IS '因公出国'; 
COMMENT ON COLUMN T_OA_YGCG.ID  IS '主键';
COMMENT ON COLUMN T_OA_YGCG.APPUSERID  IS '用户ID';
COMMENT ON COLUMN T_OA_YGCG.BM  IS '部门';
COMMENT ON COLUMN T_OA_YGCG.COLLEAGUE  IS '同行人员';
COMMENT ON COLUMN T_OA_YGCG.NUM  IS '人数';
COMMENT ON COLUMN T_OA_YGCG.TRANSPORTATION  IS '交通工具';
COMMENT ON COLUMN T_OA_YGCG.BEGINTIME  IS '开始时间';
COMMENT ON COLUMN T_OA_YGCG.ENDTIME  IS '结束时间';
COMMENT ON COLUMN T_OA_YGCG.ADD_USER  IS '创建人ID';
COMMENT ON COLUMN T_OA_YGCG.ADD_DATE  IS '创建日期';
COMMENT ON COLUMN T_OA_YGCG.UPDATE_USER  IS '修改人ID';
COMMENT ON COLUMN T_OA_YGCG.UPDATE_DATE  IS '修改日期';
COMMENT ON COLUMN T_OA_YGCG.RECORD_STATUS  IS '状态';
COMMENT ON COLUMN T_OA_YGCG.LOCATION  IS '地点';
COMMENT ON COLUMN T_OA_YGCG.REASON  IS '事由';
COMMENT ON COLUMN T_OA_YGCG.BMOPINION  IS '部门意见';
COMMENT ON COLUMN T_OA_YGCG.LDOPINION  IS '领导意见';
ALTER TABLE T_OA_YGCG  ADD PRIMARY KEY (ID);


--预算执行
CREATE TABLE T_OA_YSZX
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(200),
  REASON        NVARCHAR2(500),
  BMOPINION     NVARCHAR2(400),
  LDOPINION     NVARCHAR2(400),
  TWHOPINION    NVARCHAR2(400),
  JHOPINION     NVARCHAR2(400),
  ADD_DATE      TIMESTAMP(6),
  ADD_USER      VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_YSZX  IS '预算执行';  
COMMENT ON COLUMN T_OA_YSZX.ID  IS '主键';
COMMENT ON COLUMN T_OA_YSZX.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_YSZX.REASON  IS '事由';
COMMENT ON COLUMN T_OA_YSZX.BMOPINION  IS '部门意见';
COMMENT ON COLUMN T_OA_YSZX.LDOPINION  IS '领导意见';
COMMENT ON COLUMN T_OA_YSZX.TWHOPINION  IS '厅务会议研究意见';
COMMENT ON COLUMN T_OA_YSZX.JHOPINION  IS '拟文会同省发改委下过计划意见';
COMMENT ON COLUMN T_OA_YSZX.ADD_DATE  IS '创建日期';
COMMENT ON COLUMN T_OA_YSZX.ADD_USER  IS '创建人ID';
COMMENT ON COLUMN T_OA_YSZX.UPDATE_DATE  IS '修改日期';
COMMENT ON COLUMN T_OA_YSZX.UPDATE_USER  IS '修改人ID';
COMMENT ON COLUMN T_OA_YSZX.RECORD_STATUS  IS '状态';
ALTER TABLE T_OA_YSZX  ADD PRIMARY KEY (ID);


--资产表
CREATE TABLE T_OA_ZC
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(200),
  GGXH          VARCHAR2(100),
  ZCFL          VARCHAR2(100),
  GZDATE        TIMESTAMP(6),
  ORGID         VARCHAR2(40),
  ORGNAME       VARCHAR2(200),
  SAVEUSERID    VARCHAR2(40),
  SAVEUSERNAME  VARCHAR2(40),
  ZCBH          VARCHAR2(200),
  STATUS        VARCHAR2(10),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE  T_OA_ZC  IS '资产表';  
COMMENT ON COLUMN T_OA_ZC.NAME  IS '资产名称';
COMMENT ON COLUMN T_OA_ZC.GGXH  IS '规格型号';
COMMENT ON COLUMN T_OA_ZC.ZCFL  IS '资产分类';
COMMENT ON COLUMN T_OA_ZC.GZDATE  IS '购置日期';
COMMENT ON COLUMN T_OA_ZC.ORGID  IS '部门ID';
COMMENT ON COLUMN T_OA_ZC.ORGNAME  IS '部门名称';
COMMENT ON COLUMN T_OA_ZC.SAVEUSERID  IS '保管人账号';
COMMENT ON COLUMN T_OA_ZC.SAVEUSERNAME  IS '保管人姓名';
COMMENT ON COLUMN T_OA_ZC.ZCBH  IS '资产编号';
COMMENT ON COLUMN T_OA_ZC.STATUS  IS '状态0：正常，1：报废';
ALTER TABLE T_OA_ZC  ADD PRIMARY KEY (ID);


--资产管理表
CREATE TABLE T_OA_ZCGL
(
  ID            VARCHAR2(40) NOT NULL,
  NAME          VARCHAR2(200),
  GGXH          VARCHAR2(100),
  ZCFL          VARCHAR2(100),
  GZ_DATE       TIMESTAMP(6),
  ORGID         VARCHAR2(40),
  SAVEUSER      VARCHAR2(40),
  STATUS        VARCHAR2(10),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  ZCBH          VARCHAR2(200),
  ZMJZ          NUMBER,
  SGID          VARCHAR2(40),
  SGSLID        VARCHAR2(40),
  ORGNAME       VARCHAR2(200)
);
COMMENT ON TABLE  T_OA_ZCGL  IS '固定资产分类';
COMMENT ON COLUMN T_OA_ZCGL.NAME  IS '资产名称';
COMMENT ON COLUMN T_OA_ZCGL.GGXH  IS '规格型号';
COMMENT ON COLUMN T_OA_ZCGL.ZCFL  IS '资产分类';
COMMENT ON COLUMN T_OA_ZCGL.GZ_DATE  IS '购置时间';
COMMENT ON COLUMN T_OA_ZCGL.ORGID  IS '购置部门';
COMMENT ON COLUMN T_OA_ZCGL.SAVEUSER  IS '保管人';
COMMENT ON COLUMN T_OA_ZCGL.STATUS  IS '状态';
COMMENT ON COLUMN T_OA_ZCGL.ZCBH  IS '资产编号';
COMMENT ON COLUMN T_OA_ZCGL.ZMJZ  IS '账面价值';
COMMENT ON COLUMN T_OA_ZCGL.SGID  IS '申购表ID';
COMMENT ON COLUMN T_OA_ZCGL.SGSLID  IS '申购数量表ID';
COMMENT ON COLUMN T_OA_ZCGL.ORGNAME  IS '部门名称';
ALTER TABLE T_OA_ZCGL  ADD PRIMARY KEY (ID);


--资产申购
CREATE TABLE T_OA_ZCSG
(
  ID            VARCHAR2(40) NOT NULL,
  SQBM          VARCHAR2(40),
  YSZE          NUMBER,
  GZREASON      VARCHAR2(200),
  KSSH          VARCHAR2(200),
  ZCBSH         VARCHAR2(200),
  CWBSH         VARCHAR2(200),
  JLDSH         VARCHAR2(200),
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1),
  JBR           VARCHAR2(200),
  SQBMNAME      VARCHAR2(200)
);
COMMENT ON TABLE T_OA_ZCSG  IS '资产申购';
ALTER TABLE T_OA_ZCSG  ADD PRIMARY KEY (ID);


--资产申购数量
CREATE TABLE T_OA_ZCSGSL
(
  ID            VARCHAR2(40) NOT NULL,
  SGID          VARCHAR2(40),
  ZCNAME        VARCHAR2(200),
  ZCFL          VARCHAR2(200),
  GGXH          VARCHAR2(200),
  ZMJZ          NUMBER,
  ZCSL          NUMBER,
  ADD_USER      VARCHAR2(40),
  ADD_DATE      TIMESTAMP(6),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  RECORD_STATUS CHAR(1)
);
COMMENT ON TABLE T_OA_ZCSGSL  IS '资产申购数量表';
ALTER TABLE T_OA_ZCSGSL  ADD PRIMARY KEY (ID);


--政务信息表
CREATE TABLE T_OA_ZW
(
  ID            VARCHAR2(40) NOT NULL,
  TITLE         VARCHAR2(2000),
  TYPE          VARCHAR2(100),
  BMOPINION     VARCHAR2(1000),
  BGSOPINION    VARCHAR2(1000),
  LDOPINION     VARCHAR2(1000),
  NGOPINION     VARCHAR2(200),
  ADD_DATE      TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP,
  ADD_USER      VARCHAR2(40),
  UPDATE_USER   VARCHAR2(40),
  UPDATE_DATE   TIMESTAMP(6),
  ZSDW          VARCHAR2(2000),
  CSDW          VARCHAR2(2000),
  RECORD_STATUS CHAR(1),
  KSSH          VARCHAR2(2000),
  WSCL          VARCHAR2(2000),
  QGJD          VARCHAR2(2000),
  GD            VARCHAR2(2000)
);
COMMENT ON TABLE  T_OA_ZW  IS '政务信息表';
COMMENT ON COLUMN T_OA_ZW.TITLE  IS '标题';
COMMENT ON COLUMN T_OA_ZW.TYPE  IS '类型';
COMMENT ON COLUMN T_OA_ZW.BMOPINION  IS '部门意见';
COMMENT ON COLUMN T_OA_ZW.BGSOPINION  IS '综合科意见';
COMMENT ON COLUMN T_OA_ZW.LDOPINION  IS '领导意见';
COMMENT ON COLUMN T_OA_ZW.ZSDW  IS '主送单位';
COMMENT ON COLUMN T_OA_ZW.CSDW  IS '抄送单位';
COMMENT ON COLUMN T_OA_ZW.KSSH  IS '科室审核';
COMMENT ON COLUMN T_OA_ZW.WSCL  IS '文书处理';
COMMENT ON COLUMN T_OA_ZW.QGJD  IS '清稿校对';
COMMENT ON COLUMN T_OA_ZW.GD  IS '归档';
ALTER TABLE T_OA_ZW  ADD PRIMARY KEY (ID);


-- 发文编号
create table T_OA_FWBH
(
  id            VARCHAR2(40),
  lx            NVARCHAR2(40),
  nf            NVARCHAR2(4),
  bh            NVARCHAR2(1000),
  bz            NVARCHAR2(40),
  add_date      TIMESTAMP(6),
  add_user      VARCHAR2(40),
  update_user   VARCHAR2(40),
  update_date   TIMESTAMP(6),
  record_status CHAR(1)
)
tablespace USERS
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 64
    next 8
    minextents 1
    maxextents unlimited
  );
-- Add comments to the columns 
comment on column T_OA_FWBH.id
  is '唯一';
comment on column T_OA_FWBH.lx
  is '类型';
comment on column T_OA_FWBH.nf
  is '年份';
comment on column T_OA_FWBH.bh
  is '编号';
comment on column T_OA_FWBH.bz
  is '备注';

