/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.support;

import com.xtframe.core.utils.SystemParam;
import com.xtframe.sec.common.SystemParamEntity;
import com.xtframe.sec.support.SpringBeanFactoryProxyMap;
import com.xtframe.sec.support.XtSecurityConfiguration;
import com.xtframe.sec.support.XtSecurityContext;
import com.xtframe.util.Reflections;
import com.xtframe.util.StringUtils;
import com.xtframe.web.support.XtWebContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class XtWebConfiguration {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EntityManager entityManager;
    protected EntityManagerFactory entityManagerFactory;
    private XtWebContext webContext;
    private XtSecurityContext securityContext;
    private ApplicationContext applicationContext;
    private String appName = "frame";

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public XtWebContext buildFrameContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.init();
        return new XtWebContext(this);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public XtSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public XtWebContext getWebContext() {
        return this.webContext;
    }

    protected void init() {
        this.initServices();
        this.initSystemParam();
    }

    private void initServices() {
        if (this.securityContext == null) {
            XtSecurityConfiguration securityConfiguration = new XtSecurityConfiguration();
            securityConfiguration.setEntityManagerFactory(this.entityManagerFactory);
            securityConfiguration.setEntityManager(this.entityManager);
            if (securityConfiguration.getBeans() == null) {
                securityConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
            }
            this.securityContext = securityConfiguration.buildFrameContext();
        }
    }

    private void initSystemParam() {
        if (this.securityContext == null || this.securityContext.getQueryService() == null) {
            this.logger.info("\u65e0\u6cd5\u83b7\u53d6\u67e5\u8be2\u670d\u52a1\uff0c\u7cfb\u7edf\u53c2\u6570\u521d\u59cb\u5316\u5931\u8d25\uff01");
            return;
        }
        List params = this.securityContext.getQueryService().findAll(null, SystemParamEntity.class);
        HashMap<String, String> sysParamMap = new HashMap<String, String>();
        for (SystemParamEntity sp : params) {
            if (!sp.getValid().booleanValue() || !StringUtils.isEmpty((Object)sp.getClazz()) && !sp.getClazz().equalsIgnoreCase(SystemParam.class.getName())) continue;
            try {
                Reflections.setFieldValue(SystemParam.class, (String)sp.getKey(), (Object)sp.getValue());
            }
            catch (Exception e) {
                sysParamMap.put(sp.getKey(), sp.getValue());
            }
        }
        Reflections.setFieldValue(SystemParam.class, (String)"paramMap", sysParamMap);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setSecurityContext(XtSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void setWebContext(XtWebContext webContext) {
        this.webContext = webContext;
    }
}

