/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.support;

import com.xtframe.core.log.BizLogRecorder;
import com.xtframe.core.utils.SystemParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LoggerInterceptor
extends HandlerInterceptorAdapter {
    private NamedThreadLocal<Long> startTimeThreadLocal = new NamedThreadLocal("StopWatch-StartTime");
    private BizLogRecorder bizLogRecorder = new BizLogRecorder(){

        public void log(Object request, Object response, Object handler, BizLogRecorder.HandlerType type, long cost) {
        }
    };

    public BizLogRecorder getBizLogRecorder() {
        return this.bizLogRecorder;
    }

    public void setBizLogRecorder(BizLogRecorder bizLogRecorder) {
        this.bizLogRecorder = bizLogRecorder;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (SystemParam.isSaveBizLog()) {
            long beginTime = System.currentTimeMillis();
            this.startTimeThreadLocal.set((Object)beginTime);
            this.bizLogRecorder.log((Object)request, (Object)response, handler, BizLogRecorder.HandlerType.PreHandle, 0L);
        }
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (SystemParam.isSaveBizLog()) {
            long endTime = System.currentTimeMillis();
            long beginTime = (Long)this.startTimeThreadLocal.get();
            long consumeTime = endTime - beginTime;
            this.bizLogRecorder.log((Object)request, (Object)response, handler, BizLogRecorder.HandlerType.PostHandle, consumeTime);
        }
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (SystemParam.isSaveBizLog()) {
            long endTime = System.currentTimeMillis();
            long beginTime = (Long)this.startTimeThreadLocal.get();
            long consumeTime = endTime - beginTime;
            this.bizLogRecorder.log((Object)request, (Object)response, handler, BizLogRecorder.HandlerType.AfterCompletion, consumeTime);
        }
        super.afterCompletion(request, response, handler, ex);
    }
}

