/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.web.authz;

import com.xtframe.core.anon.auth.Logical;
import com.xtframe.core.anon.auth.RequiresRoles;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

public class RoleAnnotationHandler
extends AuthorizingAnnotationHandler {
    public RoleAnnotationHandler() {
        super(RequiresRoles.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresRoles)) {
            return;
        }
        RequiresRoles rrAnnotation = (RequiresRoles)a;
        String[] roles = rrAnnotation.value();
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
            return;
        }
        if (Logical.AND.equals((Object)rrAnnotation.logical())) {
            this.getSubject().checkRoles(Arrays.asList(roles));
            return;
        }
        if (Logical.OR.equals((Object)rrAnnotation.logical())) {
            boolean hasAtLeastOneRole = false;
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (this.getSubject().hasRole(role)) {
                    hasAtLeastOneRole = true;
                }
                ++n2;
            }
            if (!hasAtLeastOneRole) {
                this.getSubject().checkRole(roles[0]);
            }
        }
    }
}

