/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.query.StringQueryParameterBinder;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;

class SpelExpressionStringQueryParameterBinder
extends StringQueryParameterBinder {
    private final StringQuery query;

    public SpelExpressionStringQueryParameterBinder(JpaParameters parameters, Object[] values, StringQuery query, EvaluationContextProvider evaluationContextProvider) {
        super(parameters, values, query, evaluationContextProvider);
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        this.query = query;
    }

    @Override
    public <T extends Query> T bind(T jpaQuery) {
        return this.potentiallyBindExpressionParameters(super.bind(jpaQuery));
    }

    private <T extends Query> T potentiallyBindExpressionParameters(T jpaQuery) {
        if (this.isJpaParameterInformationReliable(jpaQuery) && jpaQuery.getParameters().isEmpty()) {
            return jpaQuery;
        }
        for (StringQuery.ParameterBinding binding : this.query.getParameterBindings()) {
            if (!binding.isExpression()) continue;
            Expression expr = this.parseExpressionString(binding.getExpression());
            Object value = this.evaluateExpression(expr);
            try {
                if (binding.getName() != null) {
                    jpaQuery.setParameter(binding.getName(), binding.prepare(value));
                    continue;
                }
                jpaQuery.setParameter(binding.getPosition().intValue(), binding.prepare(value));
            }
            catch (IllegalArgumentException iae) {}
        }
        return jpaQuery;
    }

    private <T extends Query> boolean isJpaParameterInformationReliable(T jpaQuery) {
        String className = jpaQuery.getClass().getName();
        return className.startsWith("org.apache.openjpa") || className.startsWith("org.hibernate");
    }
}

