/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.log.entity;

import com.xtframe.sec.common.BaseEntity;
import com.xtframe.util.StringUtils;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="T_XTFRAME_BIZ_LOG")
public class BizLogEntity
extends BaseEntity<String> {
    private static final long serialVersionUID = 2988511622248982196L;
    private String id;
    private String userid;
    private String logType;
    private String handlerType;
    private String ip;
    private long cost;
    private String method;
    private String param;
    private String url;
    private String browser;
    private String os;
    private String remark;
    private Date insertTime = new Date();

    public String getBrowser() {
        return this.browser;
    }

    public long getCost() {
        return this.cost;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    @Id
    @GenericGenerator(name="systemUUID", strategy="uuid")
    @GeneratedValue(generator="systemUUID")
    public String getId() {
        return this.id;
    }

    public Date getInsertTime() {
        return this.insertTime;
    }

    public String getIp() {
        return this.ip;
    }

    public String getLogType() {
        return this.logType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOs() {
        return this.os;
    }

    public String getParam() {
        return this.param;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public void setHandlerType(String handlerType) {
        this.handlerType = handlerType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInsertTime(Date insertTime) {
        this.insertTime = insertTime;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public void setMethod(String method) {
        this.method = StringUtils.toLimitLength((String)method, (int)250);
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setRemark(String remark) {
        remark = remark.replaceAll("\\s*|\t|\r|\n", "");
        this.remark = StringUtils.toLimitLength((String)remark, (int)250);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }
}

