/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.data.service.impl;

import com.xtframe.core.data.entity.DataPerm;
import com.xtframe.core.data.service.DataPermService;
import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.data.dao.DataPermDao;
import com.xtframe.sec.data.entity.DataPermEntity;
import java.io.Serializable;
import java.util.List;

public class DataPermServiceImpl
extends BaseSecurityService
implements DataPermService {
    private DataPermDao dao;

    public String checkRolePermission(String busskey, String roleCode) {
        List<DataPerm> perms = this.dao.findByBusskeyAndRoleCode(busskey, roleCode);
        return this.toPerms(perms);
    }

    public String checkUserPermission(String busskey, String userId) {
        List<DataPerm> perms = this.dao.findByBusskeyAndUserId(busskey, userId);
        return this.toPerms(perms);
    }

    public String delete(String ... ids) {
        this.dao.delete((Serializable[])ids);
        return null;
    }

    public List<DataPerm> findByBusskey(String busskey) {
        return this.dao.findByBusskey(busskey);
    }

    public List<DataPerm> findByBusskeyAndDataType(String busskey, String dataType) {
        return this.dao.findByBusskeyAndDataType(busskey, dataType);
    }

    public List<DataPerm> findByBusskeyAndUserId(String busskey, String userId) {
        return this.dao.findByBusskeyAndUserId(busskey, userId);
    }

    public DataPerm findOne(String id) {
        return (DataPerm)this.dao.findOne((Serializable)((Object)id));
    }

    public void init() {
        this.dao = (DataPermDao)this.getBeans().get("dataPermDao");
        Assert.notNull((Object)this.dao);
    }

    public DataPerm save(DataPerm dp) {
        Assert.isInstanceOf(DataPermEntity.class, (Object)dp);
        return (DataPerm)this.dao.save((Object)((DataPermEntity)dp));
    }

    private String toPerms(List<DataPerm> perms) {
        if (perms.size() == 0) {
            return null;
        }
        StringBuilder permBuilder = new StringBuilder("");
        for (DataPerm dp : perms) {
            permBuilder.append(dp.getOper());
            permBuilder.append(";");
        }
        if (permBuilder.length() > 0) {
            permBuilder.deleteCharAt(permBuilder.length() - 1);
        }
        return permBuilder.toString();
    }
}

