/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.wf.support;

import com.xtframe.core.role.entity.Role;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.wf.support.WorkflowUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkflowTraceService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ProcessEngine processEngine;
    protected SecurityMgr securityMgr;

    WorkflowTraceService() {
    }

    public List<Map<String, Object>> traceProcess(String processInstanceId) throws Exception {
        Execution execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().executionId(processInstanceId).singleResult();
        Object property = PropertyUtils.getProperty((Object)execution, (String)"activityId");
        String activityId = "";
        if (property != null) {
            activityId = property.toString();
        }
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.processEngine.getRepositoryService()).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        ArrayList<Map<String, Object>> activityInfos = new ArrayList<Map<String, Object>>();
        for (ActivityImpl activity : activitiList) {
            boolean currentActiviti = false;
            String id = activity.getId();
            if (id.equals(activityId)) {
                currentActiviti = true;
            }
            Map<String, Object> activityImageInfo = this.packageSingleActivitiInfo(activity, processInstance, currentActiviti);
            activityInfos.add(activityImageInfo);
        }
        return activityInfos;
    }

    private Map<String, Object> packageSingleActivitiInfo(ActivityImpl activity, ProcessInstance processInstance, boolean currentActiviti) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        HashMap<String, Object> activityInfo = new HashMap<String, Object>();
        activityInfo.put("currentActiviti", currentActiviti);
        this.setPosition(activity, activityInfo);
        this.setWidthAndHeight(activity, activityInfo);
        Map properties = activity.getProperties();
        vars.put("\u4efb\u52a1\u7c7b\u578b", WorkflowUtils.parseToZhType(properties.get("type").toString()));
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        this.logger.debug("activityBehavior={}", (Object)activityBehavior);
        if (activityBehavior instanceof UserTaskActivityBehavior) {
            UserTaskActivityBehavior userTaskActivityBehavior;
            TaskDefinition taskDefinition;
            Set candidateGroupIdExpressions;
            Task currentTask = null;
            if (currentActiviti) {
                currentTask = this.getCurrentTaskInfo(processInstance);
            }
            if (!(candidateGroupIdExpressions = (taskDefinition = (userTaskActivityBehavior = (UserTaskActivityBehavior)activityBehavior).getTaskDefinition()).getCandidateGroupIdExpressions()).isEmpty()) {
                this.setTaskGroup(vars, candidateGroupIdExpressions);
                if (currentTask != null) {
                    this.setCurrentTaskAssignee(vars, currentTask);
                }
            }
        }
        vars.put("\u8282\u70b9\u8bf4\u660e", properties.get("documentation"));
        String description = activity.getProcessDefinition().getDescription();
        vars.put("\u63cf\u8ff0", description);
        this.logger.debug("trace variables: {}", vars);
        activityInfo.put("vars", vars);
        return activityInfo;
    }

    private void setTaskGroup(Map<String, Object> vars, Set<Expression> candidateGroupIdExpressions) {
        String roleNames = "";
        for (Expression expression : candidateGroupIdExpressions) {
            String expressionText = expression.getExpressionText();
            List roles = this.securityMgr.roleService().findByCode(expressionText);
            for (Role r : roles) {
                roleNames = String.valueOf(roleNames) + r.getName();
            }
        }
        vars.put("\u4efb\u52a1\u6240\u5c5e\u89d2\u8272", roleNames);
    }

    private void setCurrentTaskAssignee(Map<String, Object> vars, Task currentTask) {
        String assignee = currentTask.getAssignee();
        if (assignee != null) {
            vars.put("\u5f53\u524d\u5904\u7406\u4eba", this.securityMgr.userService().findById(assignee).getName());
        }
    }

    private Task getCurrentTaskInfo(ProcessInstance processInstance) {
        Task currentTask = null;
        try {
            String activitiId = (String)PropertyUtils.getProperty((Object)processInstance, (String)"activityId");
            this.logger.debug("current activity id: {}", (Object)activitiId);
            currentTask = (Task)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId()).taskDefinitionKey(activitiId).singleResult();
            this.logger.debug("current task for processInstance: {}", (Object)ToStringBuilder.reflectionToString((Object)currentTask));
        }
        catch (Exception e) {
            this.logger.error("can not get property activityId from processInstance: {}", (Object)processInstance);
        }
        return currentTask;
    }

    private void setWidthAndHeight(ActivityImpl activity, Map<String, Object> activityInfo) {
        activityInfo.put("width", activity.getWidth());
        activityInfo.put("height", activity.getHeight());
    }

    private void setPosition(ActivityImpl activity, Map<String, Object> activityInfo) {
        activityInfo.put("x", activity.getX());
        activityInfo.put("y", activity.getY());
    }
}

