/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.wf.support;

import com.xtframe.core.base.service.BaseService;
import com.xtframe.core.exception.BizException;
import com.xtframe.core.org.entity.Org;
import com.xtframe.core.role.entity.Role;
import com.xtframe.core.support.SecurityMgr;
import com.xtframe.core.user.entity.User;
import com.xtframe.core.utils.Assert;
import com.xtframe.core.wf.NextTask;
import com.xtframe.core.wf.ProcessDefinitionInfo;
import com.xtframe.core.wf.ProcessInst;
import com.xtframe.core.wf.StepNode;
import com.xtframe.core.wf.SubmitInfo;
import com.xtframe.core.wf.TaskNode;
import com.xtframe.core.wf.WFStartInfo;
import com.xtframe.core.wf.WfResult;
import com.xtframe.core.wf.WorkFlowEngineClient;
import com.xtframe.core.wf.WorkItem;
import com.xtframe.sec.support.DefaultSecurityMgr;
import com.xtframe.sec.wf.entity.WfConfigClrEntity;
import com.xtframe.sec.wf.entity.WfConfigEntity;
import com.xtframe.sec.wf.entity.WfConfigStepEntity;
import com.xtframe.util.StringUtils;
import com.xtframe.wf.cmd.JumpActivityCmd;
import com.xtframe.wf.engine.ActProcessEngine;
import com.xtframe.wf.support.ProcessDefinitionCache;
import com.xtframe.wf.support.WorkflowTraceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.history.NativeHistoricTaskInstanceQuery;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.NativeTaskQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.ProcessDiagramGenerator;

final class ActWorkFlowEngineClient
extends BaseService
implements WorkFlowEngineClient {
    protected static Map<String, ProcessDefinition> PROCESS_DEFINITION_CACHE = new HashMap<String, ProcessDefinition>();
    protected ActProcessEngine processEngine;
    protected SecurityMgr securityMgr;
    protected WorkflowTraceService traceService;

    ActWorkFlowEngineClient() {
    }

    public void claim(String taskId, String userId) {
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        if (StringUtils.hasLength((String)task.getAssignee())) {
            throw new ActivitiException("task.already.claimed");
        }
        this.processEngine.getTaskService().claim(taskId, userId);
    }

    public WfResult complete(SubmitInfo submitInfo) {
        Assert.notNull((Object)submitInfo, (String)"\u4efb\u52a1\u5b8c\u6210\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasLength((String)submitInfo.getTaskId(), (String)"\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(submitInfo.getTaskId()).active().singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        if (submitInfo.isBack()) {
            List<HistoricTaskInstance> tasks = this.getHistoricTaskInstance(task.getId(), submitInfo.getNextStep());
            Assert.notEmpty(tasks, (String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1\uff01");
            ArrayList<String> handlers = new ArrayList<String>();
            for (HistoricTaskInstance t : tasks) {
                handlers.add(t.getAssignee());
            }
            submitInfo.setHandlers(handlers);
        }
        this.jump(task.getId(), submitInfo.getNextStep(), submitInfo.getVariables(), submitInfo.getTaskVariables());
        List<NextTask> nextList = this.getNextTask(task.getProcessInstanceId());
        WfResult result = new WfResult();
        result.setNextInfo(nextList);
        return result;
    }

    public WfResult complete(SubmitInfo submitInfo, boolean jump) {
        if (jump) {
            return this.complete(submitInfo);
        }
        Assert.notNull((Object)submitInfo, (String)"\u4efb\u52a1\u5b8c\u6210\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasLength((String)submitInfo.getTaskId(), (String)"\u4efb\u52a1\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(submitInfo.getTaskId()).active().singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        this.processEngine.getTaskService().setVariablesLocal(task.getId(), submitInfo.getTaskVariables());
        this.processEngine.getTaskService().complete(task.getId(), submitInfo.getVariables());
        List<NextTask> nextList = this.getNextTask(task.getProcessInstanceId());
        WfResult result = new WfResult();
        result.setNextInfo(nextList);
        return result;
    }

    public ProcessInst create(WFStartInfo info) {
        ProcessInstance processInstance = this.createIntenal(info);
        ProcessInst inst = new ProcessInst();
        inst.setBizKey(processInstance.getBusinessKey());
        inst.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        return inst;
    }

    public ProcessInst createAndFinishFirstStep(WFStartInfo info) {
        ProcessInstance processInstance = this.createIntenal(info);
        List tasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId()).active().orderByTaskCreateTime().asc()).list();
        if (tasks.size() == 1) {
            Task t = (Task)tasks.get(0);
            if (!StringUtils.hasLength((String)t.getAssignee())) {
                this.claim(t.getId(), info.getStartUserId());
            }
            SubmitInfo submitInfo = new SubmitInfo();
            submitInfo.setTaskId(t.getId());
            submitInfo.setNextStep(info.getNextStep());
            submitInfo.setHandlers(info.getHandlers());
            submitInfo.getTaskVariables().putAll(info.getTaskVariables());
            this.complete(submitInfo);
        }
        ProcessInst inst = new ProcessInst();
        inst.setBizKey(processInstance.getBusinessKey());
        inst.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        return inst;
    }

    private ProcessInstance createIntenal(WFStartInfo info) {
        this.processEngine.getIdentityService().setAuthenticatedUserId(info.getStartUserId());
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByKey(info.getProcessDefinitionKey(), info.getBusinessKey(), info.getVariables());
        List tasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId()).active().orderByTaskCreateTime().asc()).list();
        for (Task t : tasks) {
            t.setAssignee(info.getStartUserId());
            this.processEngine.getTaskService().saveTask(t);
        }
        return processInstance;
    }

    public void deleteDeployment(String deploymentId, boolean delete) {
        this.processEngine.getRepositoryService().deleteDeployment(deploymentId, delete);
    }

    public boolean endProcess(String taskId, Map<String, Object> taskVariables) {
        ActivityImpl endActivity = this.findActivitiImpl(taskId, "_end");
        this.processEngine.getTaskService().setVariablesLocal(taskId, taskVariables);
        return this.jump(taskId, endActivity.getId(), null, taskVariables);
    }

    public ActivityImpl findActivitiImpl(String taskId, String activityId) {
        ActivityImpl activityImpl2;
        TaskEntity task = (TaskEntity)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.processEngine.getRepositoryService()).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (StringUtils.isEmpty((Object)activityId)) {
            activityId = task.getTaskDefinitionKey();
        }
        if (activityId.equalsIgnoreCase("_end")) {
            for (ActivityImpl activityImpl2 : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl2.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl2;
            }
        }
        activityImpl2 = processDefinition.findActivity(activityId);
        return activityImpl2;
    }

    public List<TaskNode> findBackNodes(String taskId) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    public List<TaskNode> findBackNodesByActivity(String activity, String wfid) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    private List<HistoricTaskInstance> getHistoricTaskInstance(String taskId, String activityId) {
        TaskEntity task = (TaskEntity)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        List tasks = this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().taskDefinitionKey(activityId).processInstanceId(task.getProcessInstanceId()).list();
        return tasks;
    }

    public List<TaskNode> findNextNodes(TaskNode node) {
        DefaultSecurityMgr mgr = (DefaultSecurityMgr)this.securityMgr;
        List steps = mgr.getWfConfigStepService().findByProcessKeyAndTaskKey(node.getProcessKey(), node.getTaskKey());
        ArrayList<TaskNode> nodeList = new ArrayList<TaskNode>();
        if (steps != null) {
            for (WfConfigStepEntity step : steps) {
                TaskNode nextNode = new TaskNode();
                nextNode.setProcessKey(step.getProcessKey());
                nextNode.setTaskName(step.getNextTaskName());
                nextNode.setTaskKey(step.getNextTaskKey());
                nextNode.setProcessKey(node.getTaskKey());
                nextNode.setStepId(step.getId());
                nextNode.setSfmr(step.getSfmr());
                nodeList.add(nextNode);
                List clrs = mgr.getWfConfigClrService().findByProcessKeyAndTaskKeyAndType(step.getProcessKey(), step.getNextTaskKey(), "3");
                Collections.sort(clrs);
                ArrayList<String> clrNames = new ArrayList<String>();
                ArrayList<String> clrIds = new ArrayList<String>();
                for (WfConfigClrEntity clr : clrs) {
                    if ("3".equals(clr.getType())) {
                        User u = mgr.userService().findById(clr.getClrid());
                        if (u == null || !u.getValid().booleanValue()) continue;
                        clrIds.add(u.getId());
                        clrNames.add(u.getName());
                        continue;
                    }
                    clrIds.add(clr.getClrid());
                    clrNames.add(clr.getClrmc());
                }
                nextNode.setHandlerIds(clrIds.toArray(new String[clrIds.size()]));
                nextNode.setHandlerNames(clrNames.toArray(new String[clrNames.size()]));
            }
        }
        return nodeList;
    }

    @Deprecated
    public List<TaskNode> findJumpNodesByActivity(String activity, String wfid) {
        throw new BizException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    public List<TaskNode> findProcessSteps(String wfkey) {
        Assert.notNull((Object)wfkey, (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<ActivityImpl> rtnList = null;
        ProcessDefinitionEntity pd = (ProcessDefinitionEntity)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(wfkey).latestVersion().active().singleResult();
        pd = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.processEngine.getRepositoryService()).getDeployedProcessDefinition(pd.getId());
        List acts = pd.getActivities();
        rtnList = new ArrayList<ActivityImpl>();
        for (ActivityImpl a : acts) {
            String type = (String)a.getProperty("type");
            if (!type.equalsIgnoreCase("userTask")) continue;
            rtnList.add(a);
        }
        ArrayList<TaskNode> nodeList = new ArrayList<TaskNode>();
        for (ActivityImpl a : rtnList) {
            TaskNode node = new TaskNode();
            node.setProcessKey(wfkey);
            node.setTaskKey(a.getId());
            node.setTaskName(String.valueOf(a.getProperty("name")));
            nodeList.add(node);
        }
        return nodeList;
    }

    public List<String> findRoleByCodeAndOrgCode(String code, String org) {
        org = this.getOrgCode(org);
        List roles = this.securityMgr.roleService().findByCodeAndOrgCodeIn(code, Collections.singletonList(org));
        ArrayList<String> roleStrs = new ArrayList<String>(roles.size());
        for (Role r : roles) {
            roleStrs.add(r.getId());
        }
        return roleStrs;
    }

    public List<String> findRoleByCodeAndPOrgCode(String code, String org) {
        org = this.getOrgCode(org);
        List roles = this.securityMgr.roleService().findByCodeAndPOrgCode(code, org);
        ArrayList<String> roleStrs = new ArrayList<String>(roles.size());
        for (Role r : roles) {
            roleStrs.add(r.getId());
        }
        return roleStrs;
    }

    public List<String> findRoleByCodeAndSubOrgCode(String code, String org) {
        org = this.getOrgCode(org);
        List roles = this.securityMgr.roleService().findByCodeAndSubOrgCode(code, org);
        ArrayList<String> roleStrs = new ArrayList<String>(roles.size());
        for (Role r : roles) {
            roleStrs.add(r.getId());
        }
        return roleStrs;
    }

    public List<String> findRoleByOrgCode(String orgCode) {
        orgCode = this.getOrgCode(orgCode);
        List roles = this.securityMgr.roleService().findByOrgCode(orgCode);
        ArrayList<String> roleStrs = new ArrayList<String>(roles.size());
        for (Role r : roles) {
            roleStrs.add(r.getId());
        }
        return roleStrs;
    }

    public List<String> findUserByOrgCode(String orgCode) {
        orgCode = this.getOrgCode(orgCode);
        List orgs = this.securityMgr.orgService().findByCode(orgCode);
        ArrayList<String> userIds = new ArrayList<String>();
        for (Org o : orgs) {
            List users = this.securityMgr.userService().findByOrg(o.getId());
            for (User u : users) {
                userIds.add(u.getId());
            }
        }
        return userIds;
    }

    private List<NextTask> getNextTask(String processInstanceId) {
        List newtasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(processInstanceId).active().orderByTaskCreateTime().asc()).list();
        ArrayList<NextTask> nextList = new ArrayList<NextTask>();
        for (Task nt : newtasks) {
            NextTask info = new NextTask();
            info.setTaskId(nt.getId());
            info.setAssignee(nt.getAssignee());
            nextList.add(info);
        }
        return nextList;
    }

    private String getOrgCode(String orgCode) {
        if ("currUserOrg".equals(orgCode)) {
            Org orgEntity = this.securityMgr.orgService().findOne(this.securityMgr.getCurrUser().getOrg());
            return orgEntity.getCode();
        }
        return orgCode;
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionId) {
        ProcessDefinition processDefinition = PROCESS_DEFINITION_CACHE.get(processDefinitionId);
        if (processDefinition == null) {
            processDefinition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            PROCESS_DEFINITION_CACHE.put(processDefinitionId, processDefinition);
        }
        return processDefinition;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public Map<String, Object> getProcessVariables(String bussKey) {
        Assert.notNull((Object)bussKey);
        List exes = this.processEngine.getRuntimeService().createExecutionQuery().processInstanceBusinessKey(bussKey).list();
        String eid = "";
        if (exes.size() > 0) {
            eid = ((Execution)exes.get(0)).getId();
        }
        return this.processEngine.getRuntimeService().getVariables(eid);
    }

    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    public void init() {
    }

    public boolean jump(String taskId, String activityId, Map<String, Object> variables, Map<String, Object> taskVariables) {
        if ("_end".equals(activityId)) {
            activityId = this.findActivitiImpl(taskId, "_end").getId();
        }
        JumpActivityCmd cmd = new JumpActivityCmd((DefaultSecurityMgr)this.securityMgr, taskId, activityId, variables, taskVariables);
        this.processEngine.getManagementService().executeCommand((Command)cmd);
        return true;
    }

    public void loadByDeployment(String processDefinitionId, String resourceType, OutputStream out) throws IOException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        String resourceName = "";
        if (resourceType.equals("image")) {
            resourceName = processDefinition.getDiagramResourceName();
        } else if (resourceType.equals("xml")) {
            resourceName = processDefinition.getResourceName();
        }
        InputStream resourceAsStream = this.processEngine.getRepositoryService().getResourceAsStream(processDefinition.getDeploymentId(), resourceName);
        byte[] b = new byte[1024];
        int len = -1;
        while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
            out.write(b, 0, len);
        }
    }

    public void loadByProcessInstance(String processInstanceId, String resourceType, OutputStream out) throws Exception {
        InputStream resourceAsStream = null;
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String resourceName = "";
        if (resourceType.equals("image")) {
            resourceName = processDefinition.getDiagramResourceName();
        } else if (resourceType.equals("xml")) {
            resourceName = processDefinition.getResourceName();
        }
        resourceAsStream = this.processEngine.getRepositoryService().getResourceAsStream(processDefinition.getDeploymentId(), resourceName);
        byte[] b = new byte[1024];
        int len = -1;
        while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
            out.write(b, 0, len);
        }
    }

    public List<String> queryActivityIds(String taskId) {
        Task t = (Task)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).active().singleResult();
        Assert.notNull((Object)t);
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.processEngine.getRepositoryService()).getDeployedProcessDefinition(t.getProcessDefinitionId());
        List acts = def.getActivities();
        ArrayList<String> steps = new ArrayList<String>();
        for (ActivityImpl a : acts) {
            if (!a.getProperty("type").equals("userTask")) continue;
            steps.add(a.getProperty("name") + ":" + a.getId());
        }
        return steps;
    }

    private long queryAllWorkItemInfo(String workFlowCode, int state, int cntPerPage, int currPage, List<WorkItem> items) {
        Assert.notNull(items, (String)"\u63a5\u6536\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        if (currPage < 1) {
            currPage = 1;
        }
        if (cntPerPage < 1) {
            cntPerPage = 10;
        }
        int start = (currPage - 1) * cntPerPage;
        TaskService taskService = this.processEngine.getTaskService();
        TaskQuery query = taskService.createTaskQuery();
        if (StringUtils.hasText((String)workFlowCode)) {
            query.processDefinitionKey(workFlowCode);
        }
        List tasks = query.active().listPage(start, cntPerPage);
        for (Task t : tasks) {
            User u;
            WorkItem wi = this.task2WorkItem(t);
            wi.setAssignee(t.getAssignee());
            if (StringUtils.hasText((String)wi.getAssignee()) && (u = this.securityMgr.userService().findById(wi.getAssignee())) != null) {
                wi.setAssigneeName(u.getName());
            }
            items.add(wi);
        }
        return taskService.createTaskQuery().active().count();
    }

    public long queryProcessDefinition(int cntPerPage, int currPage, List<ProcessDefinitionInfo> processDefinitionInfoList) {
        Assert.notNull(processDefinitionInfoList);
        if (currPage < 1) {
            currPage = 1;
        }
        if (cntPerPage < 1) {
            cntPerPage = 10;
        }
        int start = (currPage - 1) * cntPerPage;
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.processEngine.getRepositoryService().createProcessDefinitionQuery().latestVersion().orderByDeploymentId().desc();
        List processDefinitionList = processDefinitionQuery.listPage(start, cntPerPage);
        for (ProcessDefinition processDefinition : processDefinitionList) {
            String deploymentId = processDefinition.getDeploymentId();
            Deployment deployment = (Deployment)this.processEngine.getRepositoryService().createDeploymentQuery().deploymentId(deploymentId).singleResult();
            ProcessDefinitionInfo info = new ProcessDefinitionInfo();
            info.setDeploymentId(deploymentId);
            info.setDeploymentTime(deployment.getDeploymentTime());
            info.setProcessDefinitionId(processDefinition.getId());
            info.setProcessName(processDefinition.getName());
            info.setKey(processDefinition.getKey());
            info.setVersion(String.valueOf(processDefinition.getVersion()));
            info.setSuspended(Boolean.valueOf(processDefinition.isSuspended()));
            info.setResourceName(processDefinition.getResourceName());
            info.setDiagramResourceName(processDefinition.getDiagramResourceName());
            processDefinitionInfoList.add(info);
        }
        return processDefinitionQuery.count();
    }

    public long queryProcessInstance(int cntPerPage, int currPage, List<ProcessInst> processInsts) {
        if (currPage < 1) {
            currPage = 1;
        }
        if (cntPerPage < 1) {
            cntPerPage = 10;
        }
        int start = (currPage - 1) * cntPerPage;
        ProcessInstanceQuery processInstanceQuery = this.processEngine.getRuntimeService().createProcessInstanceQuery();
        List list = processInstanceQuery.listPage(start, cntPerPage);
        for (ProcessInstance p : list) {
            ProcessInst pi = new ProcessInst();
            pi.setActivityId(p.getActivityId());
            pi.setBizKey(p.getBusinessKey());
            pi.setId(p.getId());
            pi.setParentId(p.getParentId());
            pi.setProcessDefinitionId(p.getProcessDefinitionId());
            pi.setProcessInstanceId(p.getProcessInstanceId());
            pi.setProcessVariables(p.getProcessVariables());
            pi.setSuspended(p.isSuspended());
            pi.setEnded(p.isEnded());
            pi.setActivityName(ProcessDefinitionCache.getActivityName(p.getProcessDefinitionId(), p.getActivityId()));
            processInsts.add(pi);
        }
        return processInstanceQuery.count();
    }

    public List<WorkItem> queryHistoryWorkItemInfo(String bussKey) {
        Assert.notNull((Object)bussKey);
        StringBuilder sqlBuffer = new StringBuilder();
        ManagementService ms = this.processEngine.getManagementService();
        sqlBuffer.append("SELECT DISTINCT T.* FROM ");
        sqlBuffer.append(ms.getTableName(HistoricTaskInstance.class));
        sqlBuffer.append(" T JOIN  ");
        sqlBuffer.append(ms.getTableName(HistoricProcessInstance.class));
        sqlBuffer.append(" P ON T.PROC_INST_ID_=P.ID_ WHERE P.BUSINESS_KEY_=#{bussKey} AND ");
        sqlBuffer.append("(T.DELETE_REASON_ <>#{reason} or T.DELETE_REASON_ IS NULL )");
        sqlBuffer.append(" ORDER BY T .START_TIME_ DESC");
        List tasks = ((NativeHistoricTaskInstanceQuery)((NativeHistoricTaskInstanceQuery)((NativeHistoricTaskInstanceQuery)this.processEngine.getHistoryService().createNativeHistoricTaskInstanceQuery().sql(sqlBuffer.toString())).parameter("bussKey", (Object)bussKey)).parameter("reason", (Object)"deleted")).list();
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (HistoricTaskInstance t : tasks) {
            WorkItem wi = this.histroyTask2WorkItem(t);
            items.add(wi);
        }
        return items;
    }

    public List<WorkItem> queryWorkItemInfo(String bussKey, String assignee) {
        Assert.notNull((Object)bussKey);
        TaskQuery tq = this.processEngine.getTaskService().createTaskQuery().processInstanceBusinessKey(bussKey);
        if (StringUtils.hasText((String)assignee)) {
            tq.taskAssignee(assignee);
        }
        List tasks = tq.list();
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (Task t : tasks) {
            WorkItem wi = this.task2WorkItem(t);
            items.add(wi);
        }
        return items;
    }

    public long queryWorkItemInfo(String userId, String workFlowCode, int state, int cntPerPage, int currPage, List<WorkItem> items) {
        Assert.notNull(items, (String)"\u63a5\u6536\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        if (currPage < 1) {
            currPage = 1;
        }
        if (cntPerPage < 1) {
            cntPerPage = 10;
        }
        int start = (currPage - 1) * cntPerPage;
        if (StringUtils.isEmpty((Object)userId)) {
            return this.queryAllWorkItemInfo(workFlowCode, state, cntPerPage, currPage, items);
        }
        StringBuilder sqlBuffer = new StringBuilder();
        ManagementService ms = this.processEngine.getManagementService();
        sqlBuffer.append(ms.getTableName(Task.class));
        sqlBuffer.append(" T WHERE T .SUSPENSION_STATE_ = 1  ");
        if (StringUtils.hasText((String)workFlowCode)) {
            sqlBuffer.append(" AND EXISTS(SELECT 1 FROM ");
            sqlBuffer.append(ms.getTableName(ProcessDefinition.class));
            sqlBuffer.append(" P WHERE P.ID_=T.PROC_DEF_ID_ AND P.KEY_=#{wfkey})");
        }
        sqlBuffer.append(" ");
        sqlBuffer.append(" AND (T.ASSIGNEE_ = #{userId} ");
        sqlBuffer.append("OR (T.ASSIGNEE_ IS NULL AND EXISTS (SELECT 1 FROM ACT_RU_IDENTITYLINK ");
        sqlBuffer.append(" I WHERE I.TYPE_ = 'candidate' AND I.TASK_ID_ = T .ID_ ");
        sqlBuffer.append("AND (I.USER_ID_ = #{userId} OR I.GROUP_ID_ IN ");
        sqlBuffer.append("(SELECT RU.RID FROM  T_XTFRAME_ROLE_USER RU ");
        sqlBuffer.append("WHERE RU.USERID =#{userId} )))))");
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = ((NativeTaskQuery)((NativeTaskQuery)((NativeTaskQuery)taskService.createNativeTaskQuery().sql("SELECT DISTINCT T.* FROM " + sqlBuffer.toString() + "ORDER BY T .CREATE_TIME_ DESC")).parameter("userId", (Object)userId)).parameter("wfkey", (Object)workFlowCode)).listPage(start, cntPerPage);
        for (Task t : tasks) {
            items.add(this.task2WorkItem(t));
        }
        return ((NativeTaskQuery)((NativeTaskQuery)((NativeTaskQuery)taskService.createNativeTaskQuery().sql("SELECT count(DISTINCT T.id_) FROM " + sqlBuffer.toString())).parameter("userId", (Object)userId)).parameter("wfkey", (Object)workFlowCode)).count();
    }

    public long queryWorkItemInfoByWfkeys(String userId, String[] workFlowCodes, int state, int cntPerPage, int currPage, List<WorkItem> items) {
        Assert.notNull(items, (String)"\u63a5\u6536\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        if (currPage < 1) {
            currPage = 1;
        }
        if (cntPerPage < 1) {
            cntPerPage = 10;
        }
        int start = (currPage - 1) * cntPerPage;
        if (StringUtils.isEmpty((Object)userId)) {
            throw new BizException("userId can't be null!");
        }
        if (workFlowCodes == null || workFlowCodes.length == 0) {
            throw new BizException("workFlowCodes is emperty!");
        }
        StringBuilder sqlBuffer = new StringBuilder();
        ManagementService ms = this.processEngine.getManagementService();
        sqlBuffer.append(ms.getTableName(Task.class));
        sqlBuffer.append(" T WHERE T .SUSPENSION_STATE_ = 1  ");
        sqlBuffer.append(" AND EXISTS(SELECT 1 FROM ");
        sqlBuffer.append(ms.getTableName(ProcessDefinition.class));
        sqlBuffer.append(" P WHERE P.ID_=T.PROC_DEF_ID_ AND P.KEY_ IN (");
        String[] stringArray = workFlowCodes;
        int n = workFlowCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            sqlBuffer.append("'");
            sqlBuffer.append(c);
            sqlBuffer.append("',");
            ++n2;
        }
        sqlBuffer.deleteCharAt(sqlBuffer.length() - 1);
        sqlBuffer.append(")) ");
        sqlBuffer.append(" AND (T.ASSIGNEE_ = #{userId} ");
        sqlBuffer.append("OR (T.ASSIGNEE_ IS NULL AND EXISTS (SELECT 1 FROM ACT_RU_IDENTITYLINK ");
        sqlBuffer.append(" I WHERE I.TYPE_ = 'candidate' AND I.TASK_ID_ = T .ID_ ");
        sqlBuffer.append("AND (I.USER_ID_ = #{userId} OR I.GROUP_ID_ IN ");
        sqlBuffer.append("(SELECT RU.RID FROM  T_XTFRAME_ROLE_USER RU ");
        sqlBuffer.append("WHERE RU.USERID =#{userId} )))))");
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = ((NativeTaskQuery)((NativeTaskQuery)((NativeTaskQuery)taskService.createNativeTaskQuery().sql("SELECT DISTINCT T.* FROM " + sqlBuffer.toString() + "ORDER BY T .CREATE_TIME_ DESC")).parameter("userId", (Object)userId)).parameter("wfkey", (Object)workFlowCodes)).listPage(start, cntPerPage);
        for (Task t : tasks) {
            items.add(this.task2WorkItem(t));
        }
        return ((NativeTaskQuery)((NativeTaskQuery)((NativeTaskQuery)taskService.createNativeTaskQuery().sql("SELECT count(DISTINCT T.id_) FROM " + sqlBuffer.toString())).parameter("userId", (Object)userId)).parameter("wfkey", (Object)workFlowCodes)).count();
    }

    public void readResource(String executionId, OutputStream out) throws Exception {
        int len;
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(executionId).singleResult();
        BpmnModel bpmnModel = this.processEngine.getRepositoryService().getBpmnModel(processInstance.getProcessDefinitionId());
        List activeActivityIds = this.processEngine.getRuntimeService().getActiveActivityIds(executionId);
        ProcessEngineImpl defaultProcessEngine = (ProcessEngineImpl)this.processEngine;
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)defaultProcessEngine.getProcessEngineConfiguration());
        ProcessDiagramGenerator diagramGenerator = defaultProcessEngine.getProcessEngineConfiguration().getProcessDiagramGenerator();
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", activeActivityIds);
        byte[] b = new byte[1024];
        while ((len = imageStream.read(b, 0, 1024)) != -1) {
            out.write(b, 0, len);
        }
    }

    public void setProcessEngine(ActProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    private WorkItem task2WorkItem(Task t) {
        User u;
        ProcessDefinition processDefinition = this.getProcessDefinition(t.getProcessDefinitionId());
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).active().singleResult();
        WorkItem w = new WorkItem();
        w.setTaskId(t.getId());
        w.setBizKey(processInstance.getBusinessKey());
        w.setStepName(t.getName());
        w.setProcessName(processDefinition.getName());
        Map vars = this.processEngine.getTaskService().getVariables(t.getId());
        if (vars.containsKey("parallel_task_id")) {
            w.setParallel(true);
        }
        w.setBizName(StringUtils.toNotNullString(vars.get("s_biz_name")));
        w.setSenderId(StringUtils.toNotNullString(vars.get("s_sender_id")));
        w.setSenderName(StringUtils.toNotNullString(vars.get("s_sender_name")));
        w.setSenderOrgId(StringUtils.toNotNullString(vars.get("s_sender_org_id")));
        w.setSenderOrgName(StringUtils.toNotNullString(vars.get("s_sender_org_name")));
        w.setSenderRoleId(StringUtils.toNotNullString(vars.get("s_sender_roleId")));
        w.setSenderTime((Date)vars.get("s_send_time"));
        w.setUrl(StringUtils.toNotNullString(vars.get("s_task_url")));
        w.setAssignee(t.getAssignee());
        if (StringUtils.hasText((String)w.getAssignee()) && (u = this.securityMgr.userService().findById(w.getAssignee())) != null) {
            w.setAssigneeName(u.getName());
        }
        return w;
    }

    private WorkItem histroyTask2WorkItem(HistoricTaskInstance t) {
        User u;
        ProcessDefinition processDefinition = this.getProcessDefinition(t.getProcessDefinitionId());
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).active().singleResult();
        WorkItem w = new WorkItem();
        w.setTaskId(t.getId());
        if (processInstance == null) {
            HistoricProcessInstance hprocessInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).singleResult();
            w.setBizKey(hprocessInstance.getBusinessKey());
        } else {
            w.setBizKey(processInstance.getBusinessKey());
        }
        w.setStepName(t.getName());
        w.setProcessName(processDefinition.getName());
        List hvis = this.processEngine.getHistoryService().createHistoricVariableInstanceQuery().taskId(t.getId()).list();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (hvis != null) {
            for (HistoricVariableInstance hvi : hvis) {
                vars.put(hvi.getVariableName(), hvi.getValue());
            }
        }
        if (vars.containsKey("parallel_task_id")) {
            w.setParallel(true);
        }
        w.setBizName(StringUtils.toNotNullString(vars.get("s_biz_name")));
        w.setSenderId(StringUtils.toNotNullString(vars.get("s_sender_id")));
        w.setSenderName(StringUtils.toNotNullString(vars.get("s_sender_name")));
        w.setSenderOrgId(StringUtils.toNotNullString(vars.get("s_sender_org_id")));
        w.setSenderOrgName(StringUtils.toNotNullString(vars.get("s_sender_org_name")));
        w.setSenderRoleId(StringUtils.toNotNullString(vars.get("s_sender_roleId")));
        w.setSenderTime((Date)vars.get("s_send_time"));
        w.setUrl(StringUtils.toNotNullString(vars.get("s_task_url")));
        w.setHandleResult(StringUtils.toNotNullString(vars.get("s_handle_result")));
        w.setHandleRemark(StringUtils.toNotNullString(vars.get("s_handle_remark")));
        w.setAssignee(t.getAssignee());
        if (StringUtils.hasText((String)w.getAssignee()) && (u = this.securityMgr.userService().findById(w.getAssignee())) != null) {
            w.setAssigneeName(u.getName());
        }
        return w;
    }

    public List<Map<String, Object>> traceProcess(String processInstanceId) throws Exception {
        List<Map<String, Object>> activityInfos = this.traceService.traceProcess(processInstanceId);
        return activityInfos;
    }

    public void transferTask(String taskId, String userId) {
        this.processEngine.getTaskService().setAssignee(taskId, userId);
    }

    public void updateInstanceState(String state, String processInstanceId) {
        if (state.equals("active")) {
            this.processEngine.getRuntimeService().activateProcessInstanceById(processInstanceId);
        } else if (state.equals("suspend")) {
            this.processEngine.getRuntimeService().suspendProcessInstanceById(processInstanceId);
        }
    }

    public void updateProcessState(String state, String processDefinitionId) {
        if (state.equals("active")) {
            this.processEngine.getRepositoryService().activateProcessDefinitionById(processDefinitionId);
        } else if (state.equals("suspend")) {
            this.processEngine.getRepositoryService().suspendProcessDefinitionById(processDefinitionId);
        }
    }

    public TaskNode findTaskNodeByTaskId(String taskId) {
        TaskNode node = new TaskNode();
        TaskEntity task = (TaskEntity)this.processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        ProcessDefinition processDefinition = this.getProcessDefinition(task.getProcessDefinitionId());
        node.setProcessKey(processDefinition.getKey());
        DefaultSecurityMgr mgr = (DefaultSecurityMgr)this.securityMgr;
        WfConfigEntity configEntity = mgr.getWfConfigService().findByProcessKeyAndTaskKey(processDefinition.getKey(), task.getTaskDefinitionKey());
        Assert.notNull((Object)configEntity, (String)("\u672a\u627e\u5230\u6d41\u7a0b" + processDefinition.getKey() + "\u7684" + task.getTaskDefinitionKey() + "\u914d\u7f6e\u4fe1\u606f\uff01"));
        List allTask = this.processEngine.getTaskService().createTaskQuery().processInstanceId(task.getProcessInstanceId()).active().list();
        if ("1".equals(configEntity.getBlgz())) {
            node.setLastTask(Boolean.valueOf(true));
        } else {
            node.setLastTask(Boolean.valueOf(false));
            if (allTask.size() == 1 && ((Task)allTask.get(0)).getId().equals(task.getId())) {
                node.setLastTask(Boolean.valueOf(true));
            }
        }
        node.setTaskKey(task.getTaskDefinitionKey());
        node.setTaskName(task.getName());
        return node;
    }

    public List<User> findUserByStepId(String stepId) {
        DefaultSecurityMgr mgr = (DefaultSecurityMgr)this.securityMgr;
        WfConfigStepEntity stepEntity = mgr.getWfConfigStepService().findOne(stepId);
        List clrs = mgr.getWfConfigClrService().findByProcessKeyAndTaskKey(stepEntity.getProcessKey(), stepEntity.getNextTaskKey());
        ArrayList<User> users = new ArrayList<User>();
        for (WfConfigClrEntity clr : clrs) {
            if (!clr.getValid().booleanValue()) continue;
            String clrid = clr.getClrid();
            if ("3".equals(clr.getType())) {
                User u = this.securityMgr.userService().findById(clrid);
                if (users.contains(u) || !u.getValid().booleanValue()) continue;
                users.add(u);
                continue;
            }
            if ("2".equals(clr.getType())) {
                List roleUsers = this.securityMgr.userService().findByRole(clrid);
                for (User u : roleUsers) {
                    if (users.contains(u) || !u.getValid().booleanValue()) continue;
                    users.add(u);
                }
                continue;
            }
            if (!"1".equals(clr.getType())) continue;
            List orgUsers = this.securityMgr.userService().findByOrg(clrid);
            for (User u : orgUsers) {
                if (users.contains(u) || !u.getValid().booleanValue()) continue;
                users.add(u);
            }
        }
        return users;
    }

    public List<TaskNode> findJumpNodes(String arg0, String arg1) {
        throw new BizException("\u8bf7\u4f7f\u7528findNextNodes\u65b9\u6cd5");
    }

    public List<StepNode> findHistoryStepNodes(String taskId, String bussKey) {
        List tasks = null;
        if (StringUtils.hasText((String)bussKey)) {
            tasks = this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().processInstanceBusinessKey(bussKey).list();
        } else if (StringUtils.hasText((String)taskId)) {
            HistoricTaskInstance task = (HistoricTaskInstance)this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
            tasks = this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
        }
        HashMap<String, StepNode> steps = new HashMap<String, StepNode>();
        for (HistoricTaskInstance t : tasks) {
            User u;
            StepNode node;
            String groupId = t.getParentTaskId();
            if (StringUtils.isEmpty((Object)groupId)) {
                groupId = "00";
            }
            if ((node = (StepNode)steps.get(groupId)) == null) {
                node = new StepNode();
                node.setTaskKey(t.getTaskDefinitionKey());
                node.setTaskName(t.getName());
                node.setProcessKey(t.getProcessDefinitionId());
                u = this.securityMgr.userService().findById(t.getAssignee());
                if (u != null && u.getValid().booleanValue()) {
                    node.setHandlerIds(new String[]{u.getId()});
                    node.setHandlerNames(new String[]{u.getName()});
                }
                node.setKssj(t.getStartTime());
                node.setJssj(t.getEndTime());
                steps.put(groupId, node);
                continue;
            }
            u = this.securityMgr.userService().findById(t.getAssignee());
            if (u != null && u.getValid().booleanValue()) {
                String[] oldHandlerIds = node.getHandlerIds();
                String[] oldHandlerNames = node.getHandlerNames();
                String[] newHandlerIds = new String[oldHandlerIds.length + 1];
                String[] newHandlerNames = new String[oldHandlerNames.length + 1];
                System.arraycopy(oldHandlerIds, 0, newHandlerIds, 0, oldHandlerIds.length);
                System.arraycopy(oldHandlerNames, 0, newHandlerNames, 0, oldHandlerNames.length);
                newHandlerIds[oldHandlerIds.length] = u.getId();
                newHandlerNames[oldHandlerNames.length] = u.getName();
                node.setHandlerIds(newHandlerIds);
                node.setHandlerNames(newHandlerNames);
            }
            Date oldJssj = node.getJssj();
            if (t.getEndTime() != null && (oldJssj == null || oldJssj.before(t.getEndTime()))) {
                node.setJssj(t.getEndTime());
            }
            if (t.getStartTime() != null || node.getKssj() != null && !node.getKssj().after(t.getStartTime())) continue;
            node.setKssj(t.getStartTime());
        }
        ArrayList<StepNode> nodes = new ArrayList<StepNode>(steps.values());
        Collections.sort(nodes, new Comparator<StepNode>(){

            @Override
            public int compare(StepNode o1, StepNode o2) {
                return o1.getKssj().compareTo(o2.getKssj());
            }
        });
        return nodes;
    }

    public boolean isProcessEnded(String bussKey) {
        HistoricProcessInstance process = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceBusinessKey(bussKey).singleResult();
        return process.getEndTime() != null;
    }

    public List<Map<String, String>> findHistoryTaskInstances(String bussKey) {
        List tasks = null;
        if (StringUtils.hasText((String)bussKey)) {
            tasks = this.processEngine.getHistoryService().createHistoricTaskInstanceQuery().processInstanceBusinessKey(bussKey).list();
        }
        ArrayList<Map<String, String>> maplist = new ArrayList<Map<String, String>>();
        for (HistoricTaskInstance t : tasks) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("assignee", t.getAssignee());
            map.put("deleteReason", t.getDeleteReason());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (t.getEndTime() != null) {
                map.put("endTime", formatter.format(t.getEndTime()));
            }
            if (t.getStartTime() != null) {
                map.put("startTime", formatter.format(t.getStartTime()));
            }
            map.put("executionId", t.getExecutionId());
            map.put("taskId", t.getId());
            map.put("parentTaskId", t.getParentTaskId());
            map.put("name", t.getName());
            map.put("taskkey", t.getTaskDefinitionKey());
            maplist.add(map);
        }
        return maplist;
    }
}

