/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.wf.cmd;

import com.xtframe.sec.support.DefaultSecurityMgr;
import com.xtframe.sec.wf.entity.WfConfigEntity;
import com.xtframe.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.cmd.NewTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;

public class JumpActivityCmd
implements Command<Object> {
    private String activityId;
    private String taskId;
    private String jumpOrigin;
    private Map<String, Object> variables;
    private Map<String, Object> taskVariables;
    private DefaultSecurityMgr securityMgr;

    public JumpActivityCmd(DefaultSecurityMgr securityMgr, String taskId, String activityId, Map<String, Object> variables, Map<String, Object> taskVariables) {
        this(securityMgr, taskId, activityId, variables, taskVariables, "jump");
    }

    public JumpActivityCmd(DefaultSecurityMgr securityMgr, String taskId, String activityId, Map<String, Object> variables, Map<String, Object> taskVariables, String jumpOrigin) {
        this.activityId = activityId;
        this.taskId = taskId;
        this.jumpOrigin = jumpOrigin;
        this.variables = variables;
        this.taskVariables = taskVariables;
        this.securityMgr = securityMgr;
    }

    public Object execute(CommandContext commandContext) {
        TaskEntity t = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        String parallelTaskid = (String)t.getVariableLocal("parallel_task_id");
        if ("ldps".equals(t.getTaskDefinitionKey()) || StringUtils.isEmpty((Object)parallelTaskid)) {
            return this.executeNormal(commandContext);
        }
        if (StringUtils.isEmpty((Object)parallelTaskid)) {
            return this.executeParallel(commandContext);
        }
        return StringUtils.isEmpty((Object)parallelTaskid) ? this.executeNormal(commandContext) : this.executeParallel(commandContext);
    }

    private Object executeNormal(CommandContext commandContext) {
        TaskEntity t = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        this.taskVariables.put("parallel_task_run", "false");
        t.setVariablesLocal(this.taskVariables);
        t.forceUpdate();
        Context.getCommandContext().getTaskEntityManager().deleteTask(t, "completed", false);
        ExecutionEntity exc = commandContext.getExecutionEntityManager().findExecutionById(t.getExecutionId());
        WfConfigEntity configEntity = this.securityMgr.getWfConfigService().findByProcessKeyAndTaskKey(exc.getProcessDefinition().getKey(), t.getTaskDefinitionKey());
        List todos = commandContext.getTaskEntityManager().findTasksByExecutionId(exc.getId());
        if ("1".equals(configEntity.getBlgz()) || "\u88ab\u53ec\u56de".equals(this.taskVariables.get("s_handle_result"))) {
            for (TaskEntity e : todos) {
                if (e.isDeleted()) continue;
                Context.getCommandContext().getTaskEntityManager().deleteTask(e, "deleted", false);
            }
        } else {
            for (TaskEntity e : todos) {
                if (e.isDeleted()) continue;
                return exc;
            }
        }
        if ("_end".equals(this.variables.get("next_step")) && "2".equals(configEntity.getType())) {
            exc.destroyScope("finished");
            exc.removeVariables();
            exc.forceUpdate();
            ProcessDefinitionImpl processDefinition = exc.getProcessDefinition();
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                exc.executeActivity((PvmActivity)activityImpl);
            }
            return exc;
        }
        ActivityImpl activity = this.getLatestActivity(exc.getProcessDefinition().getKey(), this.activityId, commandContext);
        WfConfigEntity newActConfigEntity = this.securityMgr.getWfConfigService().findByProcessKeyAndTaskKey(exc.getProcessDefinition().getKey(), activity.getId());
        List users = (List)this.variables.get("handlers");
        if (users != null) {
            for (String user : users) {
                String taskId = commandContext.getProcessEngineConfiguration().getIdGenerator().getNextId();
                TaskEntity task = (TaskEntity)new NewTaskCmd(taskId).execute(commandContext);
                task.setAssignee(user);
                task.setParentTaskId(this.taskId);
                task.setName((String)activity.getProperty("name"));
                task.setProcessDefinitionId(exc.getProcessDefinitionId());
                task.setProcessInstanceId(exc.getProcessInstanceId());
                task.setTaskDefinitionKey(activity.getId());
                task.setDescription("");
                task.setExecutionId(exc.getId());
                task.setVariables(this.variables);
                if ("4".equals(newActConfigEntity.getType())) {
                    task.setVariableLocal("parallel_task_id", (Object)this.taskId);
                }
                if (("ldps".equals(t.getTaskDefinitionKey()) || "fgldps".equals(t.getTaskDefinitionKey())) && "sw".equals(newActConfigEntity.getProcessKey()) && "bl".equals(newActConfigEntity.getTaskKey())) {
                    task.setVariableLocal("parallel_task_id", (Object)this.taskId);
                }
                task.insert(exc);
            }
        }
        return exc;
    }

    private Object executeParallel(CommandContext commandContext) {
        TaskEntity t = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        String parallelTaskId = (String)t.getVariableLocal("parallel_task_id");
        this.taskVariables.put("parallel_task_run", "false");
        t.setVariablesLocal(this.taskVariables);
        t.forceUpdate();
        Context.getCommandContext().getTaskEntityManager().deleteTask(t, "completed", false);
        ExecutionEntity exc = commandContext.getExecutionEntityManager().findExecutionById(t.getExecutionId());
        WfConfigEntity configEntity = this.securityMgr.getWfConfigService().findByProcessKeyAndTaskKey(exc.getProcessDefinition().getKey(), t.getTaskDefinitionKey());
        if (StringUtils.isEmpty((Object)this.activityId)) {
            HistoricVariableInstanceQueryImpl hisvarquery = new HistoricVariableInstanceQueryImpl(commandContext);
            List hvis = hisvarquery.taskId(parallelTaskId).list();
            HistoricVariableInstance taskRun = null;
            HistoricVariableInstance taskParallelTaskid = null;
            if (hvis != null) {
                for (HistoricVariableInstance variableInstance : hvis) {
                    if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                    if ("parallel_task_run".equals(variableInstance.getVariableName())) {
                        taskRun = variableInstance;
                    }
                    if (!"parallel_task_id".equals(variableInstance.getVariableName())) continue;
                    taskParallelTaskid = variableInstance;
                }
            }
            if ("1".equals(configEntity.getBlgz())) {
                if (taskRun != null) {
                    HistoricTaskInstanceEntity startTask = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(parallelTaskId);
                    ActivityImpl activity = this.getLatestActivity(exc.getProcessDefinition().getKey(), startTask.getTaskDefinitionKey(), commandContext);
                    String taskId = commandContext.getProcessEngineConfiguration().getIdGenerator().getNextId();
                    TaskEntity task = (TaskEntity)new NewTaskCmd(taskId).execute(commandContext);
                    task.setAssignee(startTask.getAssignee());
                    task.setParentTaskId(this.taskId);
                    task.setName((String)activity.getProperty("name"));
                    task.setProcessDefinitionId(exc.getProcessDefinitionId());
                    task.setProcessInstanceId(exc.getProcessInstanceId());
                    task.setTaskDefinitionKey(activity.getId());
                    task.setDescription("");
                    task.setExecutionId(exc.getId());
                    task.setVariables(this.variables);
                    if (taskParallelTaskid != null) {
                        task.setVariableLocal("parallel_task_id", taskParallelTaskid.getValue());
                    }
                    task.insert(exc);
                    ((HistoricVariableInstanceEntity)taskRun).delete();
                }
            } else {
                List todos = commandContext.getTaskEntityManager().findTasksByExecutionId(exc.getId());
                for (TaskEntity todo : todos) {
                    String todoParallelTaskId = (String)todo.getVariableLocal("parallel_task_id");
                    if (!parallelTaskId.equals(todoParallelTaskId) || todo.getId().equals(this.taskId)) continue;
                    return exc;
                }
                HistoricTaskInstanceEntity startTask = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(parallelTaskId);
                ActivityImpl activity = this.getLatestActivity(exc.getProcessDefinition().getKey(), startTask.getTaskDefinitionKey(), commandContext);
                String taskId = commandContext.getProcessEngineConfiguration().getIdGenerator().getNextId();
                TaskEntity task = (TaskEntity)new NewTaskCmd(taskId).execute(commandContext);
                task.setAssignee(startTask.getAssignee());
                task.setParentTaskId(this.taskId);
                task.setName((String)activity.getProperty("name"));
                task.setProcessDefinitionId(exc.getProcessDefinitionId());
                task.setProcessInstanceId(exc.getProcessInstanceId());
                task.setTaskDefinitionKey(activity.getId());
                task.setDescription("");
                task.setExecutionId(exc.getId());
                task.setVariables(this.variables);
                if (taskParallelTaskid != null) {
                    task.setVariableLocal("parallel_task_id", taskParallelTaskid.getValue());
                }
                task.insert(exc);
                ((HistoricVariableInstanceEntity)taskRun).delete();
            }
            return exc;
        }
        ActivityImpl activity = this.getLatestActivity(exc.getProcessDefinition().getKey(), this.activityId, commandContext);
        WfConfigEntity newActConfigEntity = this.securityMgr.getWfConfigService().findByProcessKeyAndTaskKey(exc.getProcessDefinition().getKey(), activity.getId());
        List users = (List)this.variables.get("handlers");
        if (users != null) {
            for (String user : users) {
                String taskId = commandContext.getProcessEngineConfiguration().getIdGenerator().getNextId();
                TaskEntity task = (TaskEntity)new NewTaskCmd(taskId).execute(commandContext);
                task.setAssignee(user);
                task.setParentTaskId(this.taskId);
                task.setName((String)activity.getProperty("name"));
                task.setProcessDefinitionId(exc.getProcessDefinitionId());
                task.setProcessInstanceId(exc.getProcessInstanceId());
                task.setTaskDefinitionKey(activity.getId());
                task.setDescription("");
                task.setExecutionId(exc.getId());
                task.setVariables(this.variables);
                if ("4".equals(newActConfigEntity.getType())) {
                    task.setVariableLocal("parallel_task_id", (Object)this.taskId);
                    task.setVariableLocal("parallel_task_run", (Object)"false");
                } else if (!"1".equals(newActConfigEntity.getBlgz()) && ("bmbl".equals(activity.getId()) || "cb".equals(activity.getId()) || "bl".equals(activity.getId()) || "hb".equals(activity.getId()))) {
                    task.setVariableLocal("parallel_task_id", (Object)parallelTaskId);
                }
                task.insert(exc);
            }
        }
        return exc;
    }

    protected Integer getLoopVariable(ActivityExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        ActivityExecution parent = execution.getParent();
        while (value == null && parent != null) {
            value = parent.getVariableLocal(variableName);
            parent = parent.getParent();
        }
        return (Integer)value;
    }

    private ActivityImpl getLatestActivity(String ProcessKey, String activityId, CommandContext commandContext) {
        ProcessDefinitionEntity pd = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(ProcessKey);
        return pd.findActivity(activityId);
    }
}

