/*
 * $Id: ElementFactory.java,v 1.2 1999/04/04 18:49:00 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.tree;

import org.w3c.dom.Element;


/**
 * This interface defines a factory which can be used by documents
 * to provide namespace-aware element creation.
 *
 * <P> A variety of implementation techniques are possible for this
 * interface.  Among them are compiled-in mappings between element
 * names and classes, mappings defined in configuration files, ones
 * derived from the document as it is parsed, and using namespaces
 * to identify packages to be used with classes whose names correspond
 * to elements.
 *
 * <P> DOM implementations will have constraints on the implementation
 * classes returned by this factory, typically that they be subclasses
 * of their implementation base class.
 *
 * @see DocumentEx
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
public interface ElementFactory
{
    /**
     * This is like the DOM <em>Document.createElement</em> method,
     * except that its return type is different.
     */
    public ElementEx createElementEx (String tag);

    /**
     * Returns an element which may be specialized to support application
     * specific behaviors as associated with the specified namespace.
     */
    public ElementEx createElementEx (String uri, String tag);
}
