/**
 * 数据权限管理js
 * 
 * @author 袁晓冬
 */
$.namespace("job.main");
/** 一览控件 */
job.main.$grid = null;
/** 通用弹窗 */
job.main.$popWin = null;
/** 公用代码【是否】 */
job.main.sfCodeArray = null;
/** 查询面板-角色编码 */
job.main.q$disp = null;
/** 查询面板-数据分类 */
job.main.q$createTime = null;
/** 查询面板-操作权限 */
job.main.q$startTime = null;

/** 初始化组件引用 */
job.main.initComp = function() {
    job.main.$grid = $('#grid');
    job.main.$popWin = $('#popWin');

}
/** 页面初始化 */
job.main.init = function() {
    job.main.initComp();
    // 初始化一览列表
    job.main.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/job/list",
    });

}

/** 根据树图所选择的节点刷新一览列表 */
job.main.refreshGrid = function(node) {

    // 刷新一览列表
    job.main.$grid.datagrid({
        url : $.ctx + "/job/list",
    });
}
/**
 * 记录新增处理
 */
job.main.doAdd = function() {

    job.main.$popWin.dialog({
        href : $.ctx + '/job/add',
        title : "任务新增"
    }).dialog('open');

}
/**
 * 记录编辑处理
 */
job.main.doEdit = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        if (rows.length == 1) {
            job.main.$popWin.dialog({
                href : $.ctx + "/job/edit",
                title : "编辑",
                queryParams : {
                    id : rows[0].id
                },
                onClose : job.main.refreshGrid
            }).dialog('open');
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    }
    else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }
}
/** 删除处理 */
job.main.doDel = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                var ids = [];
                $.each(rows, function(i) {
                    ids.push(rows[i].id);
                });
                $.post($.ctx + "/job/delete", {
                    ids : ids.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择记录！");
    }
}
/** 暂停任务 */
job.main.doPause = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length == 1) {
       /* $.messager.confirm("确认", "确定要暂停吗？", function(msg) {
            if (msg) {*/

                $.post($.ctx + "/job/pauseJob", {
                    id : rows[0].id
                }/*, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        }*/);
    }
}
/** 新增任务 */
job.main.doAddJob = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length == 1) {
       /* $.messager.confirm("确认", "确定要暂停吗？", function(msg) {
            if (msg) {*/

                $.post($.ctx + "/job/addJob", {
                    id : rows[0].id
                }/*, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        }*/);
    }
}
/** 更新任务 */
job.main.doUpdate = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length == 1) {
       /* $.messager.confirm("确认", "确定要暂停吗？", function(msg) {
            if (msg) {*/

                $.post($.ctx + "/job/updateJob", {
                    id : rows[0].id
                }/*, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        }*/);
    }
}
/** 回复任务 */
job.main.doResume = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length == 1) {
       /* $.messager.confirm("确认", "确定要暂停吗？", function(msg) {
            if (msg) {*/

                $.post($.ctx + "/job/resumeJob", {
                    id : rows[0].id
                }/*, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        }*/);
    }
}
/** 删除任务 */
job.main.doDelJob = function() {
    var rows = job.main.$grid.datagrid("getSelections");
    if (rows.length == 1) {
       /* $.messager.confirm("确认", "确定要暂停吗？", function(msg) {
            if (msg) {*/

                $.post($.ctx + "/job/deleteJob", {
                    id : rows[0].id
                }/*, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        job.main.$popWin.dialog('close');
                        job.main.refreshGrid();
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        }*/);
    }
}
