<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>资产管理</title>
<%@ include file="../../include/common.jsp"%>
<script type="text/javascript" src="${ctx}/static/xt/js/common/xt.js"></script>
<script type="text/javascript" src="${ctx}/static/xt/js/qlgk/zcgl/main.js"></script>
<script type="text/javascript">
    // 页面加载完成后执行
    $(document).ready(function() {
        qlgk.zcgl.main.init();
        $('#orgid').combotree('clear');
        $('#orgid').combotree({
            url: '${ctx}/wdgl/showOrgTree',    
            required: false,
            checkbox:true,
            onlyLeafCheck:true,
            cascadeCheck:false,
            multiple:false,
            onLoadSuccess: function (node, data) {
           	 $('#orgid').combotree('setValue', "${orgid}");
           }
        }); 
        $('#bm').combotree({
        	onLoadSuccess: function (node, data) {
        		$('#bm').combotree('setValues', '${bm}');
            }
        }); 
        
        $('#zclb').combobox({    
            url:'${ctx}/zcgl/showZcfl',
            valueField:'text',    
            textField:'text',
            panelHeight : '180'
        });  
        $('#zcname').combogrid({    
            delay: 400,    
            //panelWidth:450, 
            align : 'center',
            mode: 'remote',    
            url: '${ctx}/zcgl/showZcTree',    
            idField: 'id',    
            textField: 'name',    
            columns: [[    
                {field:'name',title:'资产名称',width:100,sortable:true},
                {field:'zcbh',title:'资产编号',width:120,sortable:true},
                {field:'ggxh',title:'规格型号',width:100,sortable:true},
                {field:'zcfl',title:'资产分类',width:130,sortable:true}
            ]],
            onClickRow:function(rowIndex, rowData){
            	$("#ggxh").val(rowData['ggxh']);
            	$("#zcbh").val(rowData['zcbh']);
            	$("#zclb").combobox('setValue',rowData['zcfl']);
            	$("#orgid").combotree('setValue',rowData['orgid']);
            	//alert("test:"+rowData['orgid']+";#zclb:"+$("#zclb").combobox("getValue")+";"+$("#zclb").combobox("getText"));
            }
        });  

    });
</script>
</head>
<body>
	<!-----------右边开始------------>
	<form action="${ctx}/zcgl/main" method="post" id="zcglform">
		<div class="work_box">
		<h1 class="work_title"><span >${menuPath }</span></h1>
			<table class="btn_left_1">
				<tr>
					<td style="width: 17%;text-align: right;height: 40px;"><span style="margin-right: 10px;font-size:15px;color: #3e3e3e;">部门</span>
					     <select class="easyui-combotree" style="width:66.5%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;"  
					       name="bm" id="bm" 
                           data-options="url:'${ctx}/wdgl/showOrgTree',required:false,checkbox:true,onlyLeafCheck:true,multiple:true,cascadeCheck:false" step="" />
					</td>
					<td style="width: 17%;text-align: right;height: 40px;"><span style="margin-right: 10px;font-size:15px;color: #3e3e3e;">资产分类</span>
						<select name="zcfl" id="zcfl" class="easyui-combobox"  style="width:66.5%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;">
							<option value="" >请选择...</option>
                     		<c:forEach items="${zcfllist}" var="zcfl">
                             	<option value="${zcfl.text }" <c:if test="${zcfl.text==zcfl1 }">selected</c:if>>${zcfl.text }</option>
                            </c:forEach>
                        </select>
					</td>
					<td style="width: 17%;text-align: right;height: 40px;"><span style="margin-right: 10px;font-size:15px;color: #3e3e3e;">资产状态</span>
						<select name="zcstatus" id="zcstatus" class="easyui-combobox"  style="width:66.5%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;">
                           	<option value="" >请选择...</option>
                           	<c:if test="${zcstatus==null||zcstatus==''||(zcstatus!=0&&zcstatus!=1) }">
                           		<option value="0" >正常</option>
                           		<option value="1" >已处置</option>
                           	</c:if>
                           	<c:if test="${zcstatus==0&&zcstatus!=null&&zcstatus!='' }">
                           		<option value="0" selected>正常</option>
                           		<option value="1" >已处置</option>
                           	</c:if>
                           	<c:if test="${zcstatus==1&&zcstatus!=null&&zcstatus!='' }">
                           		<option value="0" >正常</option>
                           		<option value="1" selected>已处置</option>
                           	</c:if>
                       	</select>
					</td>
				</tr>
				<tr>
					<td class="input_data"><span>保管人</span>
						<input type="text" name="syuser" id="syuser" value="${syuser }" maxLength="20">
					</td>
					<td class="input_data_1" colspan="2">
						<authz:hasPermission name="${app}:zcgl:main">
							<button type="button" class="fwgl_sy_cx_btn" onclick="qlgk.zcgl.main.query()"><span>查询</span></button>
						</authz:hasPermission>
						<authz:hasPermission name="${app}:zcgl:add">
							<button type="button" class="ndys_bz_btn" onclick="qlgk.zcgl.main.addzc()"><span>新增</span></button>
						</authz:hasPermission>
						<authz:hasPermission name="${app}:zcgl:edit">
							<button type="button" id="editzc" class="ndys_bz_btn" ><span>修改</span></button>
						</authz:hasPermission>
						<authz:hasPermission name="${app}:zcgl:delete">
							<button type="button" class="ndys_delete_btn" onclick="qlgk.zcgl.main.doDel()"><span>删除</span></button>
						</authz:hasPermission>
					</td>
				</tr>
		</table>
                
		<table class="fwgl_table" id="list">
			<tr align="center" style="font-weight: bolder; font-size: 15px;" class="fwgl_table_title">
				<td width="32px">
					<input type="checkbox" value="" name="" id="all" onclick="qlgk.zcgl.main.all()">
				</td>
				<td width="263px">资产名称</td>
				<td width="263px">资产编号</td>
				<td width="160px">规格型号</td>
				<td width="160px">资产分类</td>
				<td width="150px" class="fwgl_table_data">购置日期
					<span>
						<a href="#" onclick="qlgk.zcgl.main.setSort('gzdate','desc')" style="${flag==0?'display:none':''}">
							<img src="${ctx}/static/xt/images/gwgl_icon_3.png">
						</a>
						<a href="#" onclick="qlgk.zcgl.main.setSort('gzdate','asc')" style="${flag==1?'display:none':''}">
							<img src="${ctx}/static/xt/images/gwgl_icon_4.png"></a>
					</span>
				</td>
				<td width="150px">部门</td>
				<td width="104px">保管人账号</td>
				<td width="120px">保管人姓名</td>
				<td width="100px">状态</td>
				<td width="104px">操作</td>
			</tr>
			<c:forEach items="${list}" var="zcglVo">
				<tr align="center">
					<td><input type="checkbox" id="${zcglVo.id}" value="${zcglVo.id}" name="" class="fwgl_table_checkbox">
						<input type="hidden" value="${zcglVo.name}"/>
						<input type="hidden" value="${zcglVo.zcbh}"/>
						<input type="hidden" value="${zcglVo.zcfl}"/>
						<input type="hidden" value="${zcglVo.ggxh}"/>
						<input type="hidden" value="${zcglVo.saveuserid}"/>
						<input type="hidden" value="${zcglVo.saveusername}"/>
						<input type="hidden" value="${zcglVo.orgid}"/>
						<input type="hidden" value="${fn:substring(zcglVo.gzdate,0,10)}"/>
					</td>
					<td>${zcglVo.name}</td>
					<td>${zcglVo.zcbh}</td>
					<td>${zcglVo.ggxh}</td>
					<td>${zcglVo.zcfl}</td>
					<td>${fn:substring(zcglVo.gzdate,0,10)}</td>
					<td>${zcglVo.orgname}</td>
					<td>${zcglVo.saveuserid}</td>
					<td>${zcglVo.saveusername}</td>
					<td>
						<c:if test="${zcglVo.status==0}">
							正常
						</c:if>
						<c:if test="${zcglVo.status==1}">
							已处置
						</c:if>
					</td>
					<td>
						<c:if test="${zcglVo.status!=1}">
							<a href="#" onclick="qlgk.zcgl.main.control('${zcglVo.id }','destroy')">
								<span class="main_title">报废</span>
							</a>
						</c:if>
					</td>
				</tr>
			</c:forEach>
			<tr>
				<td colspan="11" class="last_page_td" style="height: 28px; line-height: 31px;">
					<jsp:include page="../../include/pageinfo.jsp"></jsp:include>
				</td>
			</tr>
		</table>
			</div>
	</form>
	<div id="popWin" class="easyui-dialog" title=""  data-options="modal:true,closed:true"></div>
	<div id="dialogDiv" style="display:none">
		<table style="width:100%;font-size:15px;">
			<tr ><td width="30%"></td><td width="70%"></td></tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">资产名称</td>
				<td width="70%" >
					<input type="hidden" id="id" name="id" value=""/>
					<input id="zcname" name="zcname" maxLength="80" value="" style="width:92%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">资产编号</td>
				<td width="70%" >
					<input type="text" id="zcbh" name="zcbh" value="" maxLength="90" class="document_title" style="background:#fff;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">资产分类</td>
				<td width="70%" >
					<input id="zclb" name="zclb" value="" maxLength="50" style="width:92%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">规格型号</td>
				<td width="70%" >
					<input type="text" id="ggxh" name="ggxh" maxLength="50" value="" class="document_title" style="background:#fff;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">保管人账号</td>
				<td width="70%" >
					<input type="text" id="saveuserid" maxlength="20" name="saveuserid" value="" class="document_title" style="background:#fff;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">保管人姓名</td>
				<td width="70%" >
					<input type="text" id="saveusername" maxlength="20" name="saveusername" value="" class="document_title" style="background:#fff;">
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">部门</td>
				<td width="70%" >
					<select class="easyui-combotree" id="orgid" name="orgid" 
						style="width:92%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;"/>
                </td>
			</tr>
			<tr style="border:1px #dfdee3 solid ;">
				<td width="30%" align="center">购置日期</td>
				<td width="70%" >
					<input type="text" id="gzdate" name="gzdate" class="Wdate" readonly 
							onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'gzdate\')}'})" 
							value="" style="cursor: pointer;width:90%;height:30px;border-radius:5px;border:1px solid #888888;font-size:15px;line-height:30px;padding-left: 1%;"/>
                </td>
			</tr>
		</table>
	</div>
</body>
</html>