/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.user.service.impl;

import com.xtframe.core.user.entity.User;
import com.xtframe.core.user.service.UserService;
import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.menu.dao.MenuDao;
import com.xtframe.sec.role.dao.RoleDao;
import com.xtframe.sec.user.dao.UserDao;
import com.xtframe.sec.user.entity.UserEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.transaction.Transactional;

public class UserServiceImpl
extends BaseSecurityService
implements UserService {
    private UserDao dao;
    private RoleDao roleDao;
    private MenuDao menuDao;

    public User findByUname(String uname) {
        return this.dao.findByUname(uname);
    }

    public User save(User u) {
        Assert.isInstanceOf(UserEntity.class, (Object)u, (String)"\u4f20\u5165\u7684\u7528\u6237\u5bf9\u8c61\u4e0d\u662fUserEntity");
        return (User)this.dao.save((Object)((UserEntity)u));
    }

    public User findById(String id) {
        return this.dao.findById(id);
    }

    public String delete(String ... ids) {
        this.dao.delete((Serializable[])ids);
        return null;
    }

    @Transactional
    public void saveUserRoles(String userid, String[] rids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ROLE_USER where userid=:userid");
        this.dao.nativeUpdate(sqlBuilder.toString(), params);
        sqlBuilder.setLength(0);
        sqlBuilder.append("insert into T_XTFRAME_ROLE_USER(userid,rid)values(:userid,:rid) ");
        String[] stringArray = rids;
        int n = rids.length;
        int n2 = 0;
        while (n2 < n) {
            String rid = stringArray[n2];
            params.put("rid", rid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    @Transactional
    public void deleteUserRoles(String userid, String[] rids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from T_XTFRAME_ROLE_USER where userid=:userid and rid=:rid");
        String[] stringArray = rids;
        int n = rids.length;
        int n2 = 0;
        while (n2 < n) {
            String rid = stringArray[n2];
            params.put("rid", rid);
            this.dao.nativeUpdate(sqlBuilder.toString(), params);
            ++n2;
        }
    }

    public void init() {
        this.dao = (UserDao)this.getBeans().get("userDao");
        this.roleDao = (RoleDao)this.getBeans().get("roleDao");
        this.menuDao = (MenuDao)this.getBeans().get("menuDao");
        Assert.notNull((Object)this.dao);
        Assert.notNull((Object)this.roleDao);
        Assert.notNull((Object)this.menuDao);
    }

    public List<User> findByOrg(String orgId) {
        return this.dao.findByOrgOrderBySortnoAsc(orgId);
    }

    public List<User> findByOrgAndRoleCode(String orgId, List<String> roleCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", orgId);
        params.put("roleid", roleCodes);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select u.* from T_XTFRAME_USER u join T_XTFRAME_ROLE_USER ru on u.id=ru.userid where ru.rid in :roleid and u.org=:orgid order by u.sortno");
        List<UserEntity> mes = this.dao.nativeQuery(sqlBuilder.toString(), UserEntity.class, params);
        ArrayList<User> ms = new ArrayList<User>(mes.size());
        for (User user : mes) {
            ms.add(user);
        }
        return ms;
    }

    public List<User> findByRole(String roleId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleId", roleId);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select u.* from T_XTFRAME_USER u inner join T_XTFRAME_ROLE_USER ru on u.id=ru.userid inner join t_xtframe_org org on u.org = org.id where ru.rid=:roleId order by org.sortno,u.sortno");
        List<UserEntity> mes = this.dao.nativeQuery(sqlBuilder.toString(), UserEntity.class, params);
        ArrayList<User> ms = new ArrayList<User>(mes.size());
        for (User user : mes) {
            ms.add(user);
        }
        return ms;
    }
}

