/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.common;

import com.xtframe.core.base.entity.Entity;
import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.SecRepository;
import com.xtframe.sec.common.SimplePageRequest;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
public class SimpleSecRepository<T extends Entity<ID>, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements SecRepository<T, ID> {
    protected final EntityManager entityManager;

    public Page<T> findAll(Object condition, SimplePageRequest pageRequest) {
        Sort newsort = new Sort(Sort.Direction.fromString((String)pageRequest.getOrder()), new String[]{pageRequest.getSort()});
        PageRequest pageable = new PageRequest(pageRequest.getPage() - 1, pageRequest.getRows(), newsort);
        Assert.isInstanceOf(Specification.class, (Object)condition);
        return this.findAll((Specification)condition, (Pageable)pageable);
    }

    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        TypedQuery query = null;
        Method getCountQuery = null;
        try {
            Method queryMethod = SimpleJpaRepository.class.getDeclaredMethod("getQuery", Specification.class, Pageable.class);
            getCountQuery = SimpleJpaRepository.class.getDeclaredMethod("getCountQuery", Specification.class);
            queryMethod.setAccessible(true);
            getCountQuery.setAccessible(true);
            if (queryMethod != null) {
                query = (TypedQuery)queryMethod.invoke((Object)this, spec, pageable);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (pageable == null) {
            return new PageImpl(query.getResultList());
        }
        query.setFirstResult(pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        TypedQuery countQuery = null;
        try {
            countQuery = (TypedQuery)getCountQuery.invoke((Object)this, spec);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        Long total = QueryUtils.executeCountQuery(countQuery);
        List content = null;
        if (total > (long)pageable.getOffset()) {
            content = query.getResultList();
        } else if (total == 0L) {
            content = Collections.emptyList();
        } else {
            long pages = total / (long)pageable.getPageSize();
            if (total % (long)pageable.getPageSize() == 0L) {
                --pages;
            }
            query.setFirstResult((int)pages * pageable.getPageSize());
            content = query.getResultList();
        }
        return new PageImpl(content, pageable, total.longValue());
    }

    public SimpleSecRepository(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.entityManager = em;
    }

    public SimpleSecRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
    }

    @Override
    public List<T> nativeQuery(String sqlString, Class<T> resultClass, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sqlString, resultClass);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.getResultList();
    }

    @Override
    public List<?> nativeQuery(String sqlString, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sqlString);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.getResultList();
    }

    @Override
    public int nativeUpdate(String sqlString, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sqlString);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query.executeUpdate();
    }

    @Override
    @Transactional
    public void delete(ID[] ids) {
        ID[] IDArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            ID id = IDArray[n2];
            this.delete((Serializable)id);
            ++n2;
        }
    }
}

