/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.ui.TreeComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class TreePopup
extends JPopupMenu
implements ComboPopup {
    private static final long serialVersionUID = 1L;
    protected TreeComboBox m_treeComboBox;
    protected JScrollPane scrollPane;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener m_keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() instanceof JTree) {
                JTree jTree = (JTree)keyEvent.getSource();
                TreePath treePath = jTree.getSelectionPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode.isLeaf()) {
                    TreePopup.this.m_treeComboBox.setSelectedItem(treePath);
                    TreePopup.this.togglePopup();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
                if (!defaultMutableTreeNode.isLeaf()) {
                    TreePopup.this.m_treeComboBox.setSelectedItem(treePath);
                    TreePopup.this.togglePopup();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        }
    };
    private MouseListener _$1 = new MouseAdapter(){

        public void mouseReleased(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            TreePath treePath = jTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.isLeaf() && mouseEvent.getButton() == 1) {
                TreePopup.this.m_treeComboBox.setSelectedItem(treePath);
                TreePopup.this.togglePopup();
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            if (!defaultMutableTreeNode.isLeaf()) {
                TreePopup.this.m_treeComboBox.setSelectedItem(treePath);
                TreePopup.this.togglePopup();
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    };
    protected JList list = new JList();

    public TreePopup(JComboBox jComboBox) {
        this.m_treeComboBox = (TreeComboBox)jComboBox;
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
        JTree jTree = this.m_treeComboBox.getTree();
        if (jTree != null) {
            this.scrollPane = new JScrollPane(jTree);
            this.scrollPane.setBorder(null);
            this.add((Component)this.scrollPane, "Center");
            jTree.addMouseListener(this._$1);
            jTree.addKeyListener(this.m_keyListener);
        }
    }

    public void show() {
        this.updatePopup();
        try {
            this.show(this.m_treeComboBox, 0, this.m_treeComboBox.getHeight());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        this.m_treeComboBox.getTree().requestFocus();
    }

    public void hide() {
        this.setVisible(false);
        this.m_treeComboBox.firePropertyChange("popupVisible", true, false);
    }

    public JList getList() {
        return this.list;
    }

    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionAdapter(){};
        }
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return null;
    }

    public void uninstallingUI() {
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new InvocationMouseHandler();
        }
        return this.mouseListener;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected void updatePopup() {
        this.setPreferredSize(new Dimension(this.m_treeComboBox.getSize().width, 120));
        Object object = this.m_treeComboBox.getSelectedItem();
        if (object != null) {
            TreePath treePath = (TreePath)object;
            this.m_treeComboBox.getTree().setSelectionPath(treePath);
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !TreePopup.this.m_treeComboBox.isEnabled()) {
                return;
            }
            if (TreePopup.this.m_treeComboBox.isEditable()) {
                Component component = TreePopup.this.m_treeComboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
            } else if (TreePopup.this.m_treeComboBox.isRequestFocusEnabled()) {
                TreePopup.this.m_treeComboBox.requestFocus();
            }
            TreePopup.this.togglePopup();
        }
    }
}

