/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class DatasetImageNodeDecorator
implements TreeNodeDecorator {
    DatasetImageNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.DATASETIMAGE)) {
            DatasetImage datasetImage = (DatasetImage)treeNodeData.getData();
            DatasetType datasetType = datasetImage.getType();
            jLabel.setText(datasetImage.getName());
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            if (datasetType.equals((Object)DatasetType.IMAGE)) {
                graphics.drawImage(InternalImageIconFactory.DT_IMAGE.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.WCS)) {
                graphics.drawImage(InternalImageIconFactory.DT_WCS.getImage(), 0, 0, jLabel);
            } else if (datasetType.equals((Object)DatasetType.WMS)) {
                graphics.drawImage(InternalImageIconFactory.DT_WMS.getImage(), 0, 0, jLabel);
            }
            imageIcon.setImage(bufferedImage);
        }
    }
}

