/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.StandardMarginNative;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import com.supermap.data.ToolkitNative;

public class StandardMargin
extends InternalHandleDisposable {
    private MarginOffset _$5;
    private MarginStyle _$4;
    private PrjCoordSys _$3;

    public StandardMargin() {
        long l = StandardMarginNative.jni_New();
        this.setHandle(l, true);
    }

    public StandardMargin(StandardMargin standardMargin) {
        if (standardMargin == null) {
            String string = InternalResource.loadString("margin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(standardMargin);
        if (l == 0L) {
            String string = InternalResource.loadString("margin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = StandardMarginNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(standardMargin);
    }

    public StandardMargin(MarginScaleType marginScaleType) {
        if (marginScaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginScaleType);
        long l = StandardMarginNative.jni_New2(n);
        this.setHandle(l, true);
    }

    public StandardMargin(String string) {
        if (!this.nameIsValid(string)) {
            String string2 = InternalResource.loadString("StandardMargin(String sheetName)", "StandardMargin_SheetName_IsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        long l = StandardMarginNative.jni_New3(string);
        this.setHandle(l, true);
    }

    public StandardMargin(MarginScaleType marginScaleType, Point2D point2D) {
        if (marginScaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = point2D.getX();
        if (d < 0.0) {
            String string = InternalResource.loadString("StandardMargin(MarginScaleType scaleType, Point2D leftBottom)", "StandardMargin_LeftBottomXShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2D.getY();
        if (d2 < 0.0) {
            String string = InternalResource.loadString("StandardMargin(MarginScaleType scaleType, Point2D leftBottom)", "StandardMargin_LeftBottomYShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Enum.internalGetUGCValue(marginScaleType);
        long l = StandardMarginNative.jni_New4(n, d, d2);
        this.setHandle(l, true);
    }

    public StandardMargin(MarginScaleType marginScaleType, MarginLargeScaleSheetType marginLargeScaleSheetType, Rectangle2D rectangle2D) {
        if (marginScaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (marginLargeScaleSheetType == null) {
            String string = InternalResource.loadString("largeScaleSheetType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = marginScaleType.value();
        int n2 = marginLargeScaleSheetType.value();
        long l = StandardMarginNative.jni_New5(n, n2, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        this.setHandle(l, true);
    }

    StandardMargin(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public MarginOffset getOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null) {
            this._$5 = new MarginOffset(this.getHandle());
        }
        return this._$5;
    }

    public MarginStyle getStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            this._$4 = new MarginStyle(this.getHandle());
        }
        return this._$4;
    }

    public boolean get(MarginElementType marginElementType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(MarginElementType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (marginElementType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginElementType);
        return StandardMarginNative.jni_GetItem(this.getHandle(), n);
    }

    public void set(MarginElementType marginElementType, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItem(MarginElementType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (marginElementType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginElementType);
        StandardMarginNative.jni_SetItem(this.getHandle(), n, bl);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        StandardMarginNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D();
        rectangle2D.setLeft(dArray[0]);
        rectangle2D.setBottom(dArray[1]);
        rectangle2D.setRight(dArray[2]);
        rectangle2D.setTop(dArray[3]);
        return rectangle2D;
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = StandardMarginNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this._$3 = PrjCoordSys.createInstance(l, false);
        }
        return this._$3;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(prjCoordSys);
        if (l == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        StandardMarginNative.jni_SetPrjCoordSys(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
    }

    public MarginScaleType getScaleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetScaleType(this.getHandle());
        return (MarginScaleType)Enum.parseUGCValue(MarginScaleType.class, n);
    }

    public MarginStandardType getSheetNameType() {
        return MarginStandardType.GB_T_20257;
    }

    public MarginLargeScaleSheetType getLargeScaleSheetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLargeScaleSheetType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetLargeScaleSheetType(this.getHandle());
        return (MarginLargeScaleSheetType)Enum.parseUGCValue(MarginLargeScaleSheetType.class, n);
    }

    public void setLargeScaleSheetType(MarginLargeScaleSheetType marginLargeScaleSheetType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLargeScaleSheetType(MarginLargeScaleSheetType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (marginLargeScaleSheetType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginLargeScaleSheetType);
        StandardMarginNative.jni_SetLargeScaleSheetType(this.getHandle(), n);
    }

    public MarginLargeScaleCoordSysType getLargeScaleCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLargeScaleCoordSysType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetLargeScaleCoordSysType(this.getHandle());
        return (MarginLargeScaleCoordSysType)Enum.parseUGCValue(MarginLargeScaleCoordSysType.class, n);
    }

    public void setLargeScaleCoordSysType(MarginLargeScaleCoordSysType marginLargeScaleCoordSysType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLargeScaleCoordSysType(MarginLargeScaleCoordSysType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (marginLargeScaleCoordSysType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginLargeScaleCoordSysType);
        StandardMarginNative.jni_SetLargeScaleCoordSysType(this.getHandle(), n);
    }

    public MarginKilometerGridType getKilometerGridType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = StandardMarginNative.jni_GetKilometerGridType(this.getHandle());
        return (MarginKilometerGridType)Enum.parseUGCValue(MarginKilometerGridType.class, n);
    }

    public void setKilometerGridType(MarginKilometerGridType marginKilometerGridType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridType(MarginKilometerGridType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (marginKilometerGridType == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(marginKilometerGridType);
        StandardMarginNative.jni_SetKilometerGridType(this.getHandle(), n);
    }

    public String getMapName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMapName(this.getHandle());
    }

    public void setMapName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setMapName(String mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        StandardMarginNative.jni_SetMapName(this.getHandle(), string);
    }

    public String getSheetName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSheetName(this.getHandle());
    }

    public String getPublisher() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetPublisher(this.getHandle());
    }

    public void setPublisher(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPublisher(String publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        StandardMarginNative.jni_SetPublisher(this.getHandle(), string);
    }

    public String getSafeInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSafeInfo(this.getHandle());
    }

    public void setSafeInfo(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setSafeInfo(String safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        StandardMarginNative.jni_SetSafeInfo(this.getHandle(), string);
    }

    public String[] getInformation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetInformation(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setInformation(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInformation(String[] information)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        StandardMarginNative.jni_SetInformation(this.getHandle(), string);
    }

    public String[] getAnnotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetAnnotation(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setAnnotation(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnnotation(String[] annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        StandardMarginNative.jni_SetAnnotation(this.getHandle(), string);
    }

    public String[] getNeighborMapNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNeighborMapNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetNeighborMapNames(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setNeighborMapNames(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNeighborMapNames(String[] neighborMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        StandardMarginNative.jni_SetNeighborMapNames(this.getHandle(), string);
    }

    public String[] getNeighborSheetNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNeighborSheetNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = StandardMarginNative.jni_GetNeighborSheetNames(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public double getInformationRowSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInformationRowSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetInformationRowSpace(this.getHandle());
    }

    public void setInformationRowSpace(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInformationRowSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetInformationRowSpace(this.getHandle(), d);
    }

    public double getAnnotationRowSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnnotationRowSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetAnnotationRowSpace(this.getHandle());
    }

    public void setAnnotationRowSpace(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnnotationRowSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetAnnotationRowSpace(this.getHandle(), d);
    }

    public double getContourInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getContourInterval()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetContourInterval(this.getHandle());
    }

    public void setContourInterval(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setContourInterval(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetContourInterval(this.getHandle(), d);
    }

    public double getKilometerGridHorizontalSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridHorizontalSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetKilometerGridHorizontalSpace(this.getHandle());
    }

    public void setKilometerGridHorizontalSpace(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridHorizontalSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetKilometerGridHorizontalSpace(this.getHandle(), d);
    }

    public double getKilometerGridVerticalSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKilometerGridVerticalSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetKilometerGridVerticalSpace(this.getHandle());
    }

    public void setKilometerGridVerticalSpace(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKilometerGridVerticalSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetKilometerGridVerticalSpace(this.getHandle(), d);
    }

    public int getSegmentCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetSegmentCount(this.getHandle());
    }

    public void setSegmentCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetSegmentCount(this.getHandle(), n);
    }

    public int getZoneNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZoneNumber()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetZoneNumber(this.getHandle());
    }

    public void setZoneNumber(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZoneNumber(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetZoneNumber(this.getHandle(), n);
    }

    public double getMeridianAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeridianAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMeridianAngle(this.getHandle());
    }

    public void setMeridianAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMeridianAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < -90.0) {
            d = -90.0;
        }
        if (d > 90.0) {
            d = 90.0;
        }
        StandardMarginNative.jni_SetMeridianAngle(this.getHandle(), d);
    }

    public double getMagnetAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMagnetAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetMagnetAngle(this.getHandle());
    }

    public void setMagnetAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMagnetAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < -90.0) {
            d = -90.0;
        }
        if (d > 90.0) {
            d = 90.0;
        }
        StandardMarginNative.jni_SetMagnetAngle(this.getHandle(), d);
    }

    public double getInsideSpace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInsideSpace()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetInsideSpace(this.getHandle());
    }

    public void setInsideSpace(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInsideSpace(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetInsideSpace(this.getHandle(), d);
    }

    public double getOuterBoxLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOuterBoxLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetOuterBoxLineWidth(this.getHandle());
    }

    public void setOuterBoxLineWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOuterBoxLineWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetOuterBoxLineWidth(this.getHandle(), d);
    }

    public double getCrossLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCrossLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return StandardMarginNative.jni_GetCrossLength(this.getHandle());
    }

    public void setCrossLength(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_SetCrossLength(this.getHandle(), d);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            StandardMarginNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void showAllElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("showAllElements()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_ShowAllElements(this.getHandle());
    }

    public void hideAllElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hideAllElements()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StandardMarginNative.jni_HideAllElements(this.getHandle());
    }

    public static String computeSheetName(Point2D point2D, MarginScaleType marginScaleType) {
        if (marginScaleType == null) {
            String string = InternalResource.loadString("scaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        int n = Enum.internalGetUGCValue(marginScaleType);
        return StandardMarginNative.jni_ComputeSheetName(d, d2, n);
    }

    public static DatasetVector createStandardMarginDataset(Datasource datasource, String string, StandardMargin standardMargin) {
        if (datasource == null) {
            String string2 = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        long l = datasource.getHandle();
        if (l == 0L) {
            String string3 = InternalResource.loadString("datasource", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("datasetName", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (standardMargin == null) {
            String string5 = InternalResource.loadString("standardMargin", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        long l2 = standardMargin.getHandle();
        if (l2 == 0L) {
            String string6 = InternalResource.loadString("standardMargin", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        long l3 = ToolkitNative.jni_creatStandardMargin(l, string, l2);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = DatasetVector.createInstance(l3, datasource);
            Datasets.add(datasource.getDatasets(), datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(standardMargin);
        return datasetVector;
    }

    protected void clearHandle() {
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        if (this._$3 != null) {
            this._$3.clearHandle();
            this._$3 = null;
        }
        this.setHandle(0L);
    }

    protected boolean nameIsValid(String string) {
        boolean bl = StandardMarginNative.jni_NameIsValid(string);
        return bl;
    }

    public static class MarginKilometerGridType
    extends Enum {
        public static final MarginKilometerGridType CROSS = new MarginKilometerGridType(0, 0);
        public static final MarginKilometerGridType SOLIDLINE = new MarginKilometerGridType(1, 1);

        private MarginKilometerGridType(int n, int n2) {
            super(n, n2);
        }
    }

    public static class MarginLargeScaleCoordSysType
    extends Enum {
        public static final MarginLargeScaleCoordSysType USERDEFINE = new MarginLargeScaleCoordSysType(0, 0);
        public static final MarginLargeScaleCoordSysType NATIONAL = new MarginLargeScaleCoordSysType(1, 1);

        private MarginLargeScaleCoordSysType(int n, int n2) {
            super(n, n2);
        }
    }

    public static class MarginLargeScaleSheetType
    extends Enum {
        public static final MarginLargeScaleSheetType SHEET40x50 = new MarginLargeScaleSheetType(0, 0);
        public static final MarginLargeScaleSheetType SHEET50x50 = new MarginLargeScaleSheetType(1, 1);
        public static final MarginLargeScaleSheetType USERDEFINE = new MarginLargeScaleSheetType(2, 2);

        private MarginLargeScaleSheetType(int n, int n2) {
            super(n, n2);
        }
    }

    public static class MarginStandardType
    extends Enum {
        public static final MarginStandardType GB_T_20257 = new MarginStandardType(0, 0);

        private MarginStandardType(int n, int n2) {
            super(n, n2);
        }
    }

    public static class MarginScaleType
    extends Enum {
        public static final MarginScaleType SCALE_500 = new MarginScaleType(500, 500);
        public static final MarginScaleType SCALE_1000 = new MarginScaleType(1000, 1000);
        public static final MarginScaleType SCALE_2000 = new MarginScaleType(2000, 2000);
        public static final MarginScaleType SCALE_5000 = new MarginScaleType(5000, 5000);
        public static final MarginScaleType SCALE_10000 = new MarginScaleType(10000, 10000);
        public static final MarginScaleType SCALE_25000 = new MarginScaleType(25000, 25000);
        public static final MarginScaleType SCALE_50000 = new MarginScaleType(50000, 50000);
        public static final MarginScaleType SCALE_100000 = new MarginScaleType(100000, 100000);
        public static final MarginScaleType SCALE_250000 = new MarginScaleType(250000, 250000);
        public static final MarginScaleType SCALE_500000 = new MarginScaleType(500000, 500000);
        public static final MarginScaleType SCALE_1000000 = new MarginScaleType(1000000, 1000000);

        private MarginScaleType(int n, int n2) {
            super(n, n2);
        }
    }

    public static class MarginElementType
    extends Enum {
        public static final MarginElementType SCALE = new MarginElementType(1, 1);
        public static final MarginElementType MAPNAME = new MarginElementType(2, 2);
        public static final MarginElementType INFORMATION = new MarginElementType(4, 4);
        public static final MarginElementType PUBLISHER = new MarginElementType(16, 16);
        public static final MarginElementType GRID = new MarginElementType(32, 32);
        public static final MarginElementType NEIGHBORTABLE = new MarginElementType(64, 64);
        public static final MarginElementType ALTIMETER = new MarginElementType(128, 128);
        public static final MarginElementType DEPTHGAUGE = new MarginElementType(256, 256);
        public static final MarginElementType SLOPERULER = new MarginElementType(512, 512);
        public static final MarginElementType NEIGHBOR_KILOMETER_GRID = new MarginElementType(1024, 1024);
        public static final MarginElementType THREE_NORTH_GRAPH = new MarginElementType(2048, 2048);
        public static final MarginElementType ANNOTATIONS = new MarginElementType(4096, 4096);
        public static final MarginElementType MAPNUMBER = new MarginElementType(8192, 8192);
        public static final MarginElementType SAFEINFO = new MarginElementType(16384, 16384);
        public static final MarginElementType BASICSCALE = new MarginElementType(32768, 32768);
        public static final MarginElementType TEXTSCALE = new MarginElementType(65536, 65536);
        public static final MarginElementType SEASCALE = new MarginElementType(131072, 131072);
        public static final MarginElementType CORNER_MAP_NUMBER = new MarginElementType(262144, 262144);
        public static final MarginElementType CORNER_MAP_NAME = new MarginElementType(524288, 524288);
        public static final MarginElementType NEIGHBOR_SHEET_NAME = new MarginElementType(0x100000, 0x100000);
        public static final MarginElementType NEIGHBOR_MAP_NAME = new MarginElementType(0x200000, 0x200000);

        private MarginElementType(int n, int n2) {
            super(n, n2);
        }
    }

    public class MarginStyle
    extends InternalHandle {
        private TextStyle _$16 = null;
        private TextStyle _$15 = null;
        private TextStyle _$14 = null;
        private TextStyle _$13 = null;
        private TextStyle _$12 = null;
        private TextStyle _$11 = null;
        private TextStyle _$10 = null;
        private TextStyle _$9 = null;
        private TextStyle _$8 = null;
        private TextStyle _$7 = null;
        private TextStyle _$6 = null;
        private TextStyle _$5 = null;
        private TextStyle _$4 = null;
        private TextStyle _$3 = null;
        private TextStyle _$2 = null;

        private MarginStyle(long l) {
            this.setHandle(l);
        }

        public TextStyle getAnnotation() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$11 == null && (l = StandardMarginNative.jni_GetAnnotationStyle(this.getHandle())) != 0L) {
                this._$11 = TextStyle.createInstance(l);
            }
            return this._$11;
        }

        public void setAnnotation(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setAnnotation(TextStyle annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("annotation", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("annotation", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetAnnotationStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getBasicScale() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBasicScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$2 == null && (l = StandardMarginNative.jni_GetBasicScaleStyle(this.getHandle())) != 0L) {
                this._$2 = TextStyle.createInstance(l);
            }
            return this._$2;
        }

        public void setBasicScale(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBasicScale(TextStyle basicScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("basicScale", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("basicScale", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetBasicScaleStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getCornerMapName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getCornerMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$4 == null && (l = StandardMarginNative.jni_GetCornerMapNameStyle(this.getHandle())) != 0L) {
                this._$4 = TextStyle.createInstance(l);
            }
            return this._$4;
        }

        public void setCornerMapName(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setCornerMapName(TextStyle cornerMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("cornerMapName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("cornerMapName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetCornerMapNameStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getCornerSheetName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getCornerSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$5 == null && (l = StandardMarginNative.jni_GetCornerSheetNameStyle(this.getHandle())) != 0L) {
                this._$5 = TextStyle.createInstance(l);
            }
            return this._$5;
        }

        public void setCornerSheetName(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setCornerSheetName(TextStyle cornerSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("cornerSheetName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("cornerSheetName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetCornerSheetNameStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getInformation() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$12 == null && (l = StandardMarginNative.jni_GetInformationStyle(this.getHandle())) != 0L) {
                this._$12 = TextStyle.createInstance(l);
            }
            return this._$12;
        }

        public void setInformation(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setInformation(TextStyle information)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("information", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("information", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetInformationStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getLongitudeAndLatitude() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getLongitudeAndLatitude()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$3 == null && (l = StandardMarginNative.jni_GetLongitudeAndLatitudeStyle(this.getHandle())) != 0L) {
                this._$3 = TextStyle.createInstance(l);
            }
            return this._$3;
        }

        public void setLongitudeAndLatitude(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setLongitudeAndLatitude(TextStyle longitudeAndLatitude)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("longitudeAndLatitude", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("longitudeAndLatitude", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetLongitudeAndLatitudeStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getMapName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$16 == null && (l = StandardMarginNative.jni_GetMapNameStyle(this.getHandle())) != 0L) {
                this._$16 = TextStyle.createInstance(l);
            }
            return this._$16;
        }

        public void setMapName(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setMapName(TextStyle mapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("mapName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("mapName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetMapNameStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getNeighborMapNames() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getNeighborMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$10 == null && (l = StandardMarginNative.jni_GetNeighborMapNamesStyle(this.getHandle())) != 0L) {
                this._$10 = TextStyle.createInstance(l);
            }
            return this._$10;
        }

        public void setNeighborMapNames(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setNeighborMapNames(TextStyle neighborMapNames)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("neighborMapNames", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("neighborMapNames", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetNeighborMapNamesStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getNeighborSheetNames() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getNeighborSheetNames()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$9 == null && (l = StandardMarginNative.jni_GetNeighborSheetNamesStyle(this.getHandle())) != 0L) {
                this._$9 = TextStyle.createInstance(l);
            }
            return this._$9;
        }

        public void setNeighborSheetNames(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setNeighborSheetNames(TextStyle neighborSheetNames)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("neighborSheetNames", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("neighborSheetNames", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetNeighborSheetNamesStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getPublisher() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$14 == null && (l = StandardMarginNative.jni_GetPublisherStyle(this.getHandle())) != 0L) {
                this._$14 = TextStyle.createInstance(l);
            }
            return this._$14;
        }

        public void setPublisher(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setPublisher(TextStyle publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("publisher", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("publisher", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetPublisherStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getSafeInfo() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$13 == null && (l = StandardMarginNative.jni_GetSafeInfoStyle(this.getHandle())) != 0L) {
                this._$13 = TextStyle.createInstance(l);
            }
            return this._$13;
        }

        public void setSafeInfo(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSafeInfo(TextStyle safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("safeInfo", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("safeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetSafeInfoStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getSheetName() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$15 == null && (l = StandardMarginNative.jni_GetSheetNameStyle(this.getHandle())) != 0L) {
                this._$15 = TextStyle.createInstance(l);
            }
            return this._$15;
        }

        public void setSheetName(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSheetName(TextStyle sheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("sheetName", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("sheetName", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetSheetNameStyle(this.getHandle(), textStyle.getHandle());
        }

        public TextStyle getTextScale() {
            long l;
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTextScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this._$8 == null && (l = StandardMarginNative.jni_GetTextScaleStyle(this.getHandle())) != 0L) {
                this._$8 = TextStyle.createInstance(l);
            }
            return this._$8;
        }

        public void setTextScale(TextStyle textStyle) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTextScale(TextStyle textScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (textStyle == null) {
                String string = InternalResource.loadString("textScale", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (textStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("textScale", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            StandardMarginNative.jni_SetTextScaleStyle(this.getHandle(), textStyle.getHandle());
        }

        protected void clearHandle() {
            this.setHandle(0L);
            if (this._$16 != null) {
                this._$16.clearHandle();
                this._$16 = null;
            }
            if (this._$15 != null) {
                this._$15.clearHandle();
                this._$15 = null;
            }
            if (this._$14 != null) {
                this._$14.clearHandle();
                this._$14 = null;
            }
            if (this._$13 != null) {
                this._$13.clearHandle();
                this._$13 = null;
            }
            if (this._$12 != null) {
                this._$12.clearHandle();
                this._$12 = null;
            }
            if (this._$11 != null) {
                this._$11.clearHandle();
                this._$11 = null;
            }
            if (this._$10 != null) {
                this._$10.clearHandle();
                this._$10 = null;
            }
            if (this._$9 != null) {
                this._$9.clearHandle();
                this._$9 = null;
            }
            if (this._$8 != null) {
                this._$8.clearHandle();
                this._$8 = null;
            }
            if (this._$7 != null) {
                this._$7.clearHandle();
                this._$7 = null;
            }
            if (this._$6 != null) {
                this._$6.clearHandle();
                this._$6 = null;
            }
            if (this._$5 != null) {
                this._$5.clearHandle();
                this._$5 = null;
            }
            if (this._$4 != null) {
                this._$4.clearHandle();
                this._$4 = null;
            }
            if (this._$3 != null) {
                this._$3.clearHandle();
                this._$3 = null;
            }
            if (this._$2 != null) {
                this._$2.clearHandle();
                this._$2 = null;
            }
        }
    }

    public class MarginOffset
    extends InternalHandle {
        private MarginOffset(long l) {
            this.setHandle(l);
        }

        public Size2D getAnnotation() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getAnnotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetAnnotationOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setAnnotation(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setAnnotation(Size2D annotation)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetAnnotationOffset(this.getHandle(), d, d2);
        }

        public Size2D getBasicScale() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBasicScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBasicScaleOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBasicScale(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBasicScale(Size2D basicScale)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetBasicScaleOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomLeftSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomLeftSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomLeftSheetNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomLeftSheetName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomLeftSheetName(Size2D bottomLeftSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetBottomLeftSheetNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomRightSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomRightSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomRightSheetNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomRightSheetName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomRightSheetName(Size2D bottomRightSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetBottomRightSheetNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getInformation() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getInformation()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetInformationOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setInformation(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setInformation(Size2D information)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetInformationOffset(this.getHandle(), d, d2);
        }

        public Size2D getPublisher() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getPublisher()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetPublisherOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setPublisher(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setPublisher(Size2D publisher)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetPublisherOffset(this.getHandle(), d, d2);
        }

        public Size2D getSafeInfo() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getSafeInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetSafeInfoOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setSafeInfo(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setSafeInfo(Size2D safeInfo)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetSafeInfoOffset(this.getHandle(), d, d2);
        }

        public Size2D getTextScale() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTextScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTextScaleOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTextScale(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTextScale(Size2D textScaleOffset)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTextScaleOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopLeftSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopLeftSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopLeftSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopLeftSheetName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopLeftSheetName(Size2D topLeftSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopLeftSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopRightSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopRightSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopRightSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopRightSheetName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopRightSheetName(Size2D topRightSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopRightSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopCenterSheetName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopCenterSheetName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopCenterSheepNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopCenterSheetName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopCenterSheetName(Size2D topCenterSheetName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopCenterSheepNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopCenterMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopCenterMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopCenterMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopCenterMapName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopCenterMapName(Size2D topCenterMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopCenterMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopRightMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopRightMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopRightMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopRightMapName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopRightMapName(Size2D topRightMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopRightMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getTopLeftMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getTopLeftMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetTopLeftMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setTopLeftMapName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setTopLeftMapName(Size2D topLeftMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetTopLeftMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomLeftMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomLeftMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomLeftMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomLeftMapName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomLeftMapName(Size2D bottomLeftMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetBottomLeftMapNameOffset(this.getHandle(), d, d2);
        }

        public Size2D getBottomRightMapName() {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getBottomRightMapName()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double[] dArray = new double[2];
            StandardMarginNative.jni_GetBottomRightMapNameOffset(this.getHandle(), dArray);
            Size2D size2D = new Size2D();
            size2D.setWidth(dArray[0]);
            size2D.setHeight(dArray[1]);
            return size2D;
        }

        public void setBottomRightMapName(Size2D size2D) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("setBottomRightMapName(Size2D bottomRightMapName)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            double d = size2D.getWidth();
            double d2 = size2D.getHeight();
            StandardMarginNative.jni_SetBottomLeftMapNameOffset(this.getHandle(), d, d2);
        }
    }
}

