/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AttributeStatisticsType;
import com.supermap.data.Charset;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.Feature;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoCoordSys;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalUGCType;
import com.supermap.data.InternalVariant;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.PrjParameter;
import com.supermap.data.Projection;
import com.supermap.data.ProjectionType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResampleInformation;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.SpatialIndexType;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.SpatialRelationType;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.Tolerance;
import com.supermap.data.Toolkit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetVector
extends Dataset {
    private Tolerance _$7 = null;
    private FieldInfos _$6 = null;
    private DatasetVector _$5 = null;
    private Dataset _$4 = null;
    private static Integer _$3 = new Integer(0);

    protected DatasetVector() {
    }

    DatasetVector(long l, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l);
        this.m_datasource = datasource;
    }

    public Charset getCharset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetCharset(this.getHandle());
        return (Charset)Enum.parseUGCValue(Charset.class, n);
    }

    public void setCharset(Charset charset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (charset == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorNative.jni_SetCharset(this.getHandle(), charset.getUGCValue());
    }

    public DatasetVector getChildDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = DatasetVectorNative.jni_GetChildDataset(this.getHandle())) != 0L) {
            this._$5 = new DatasetVector(l, this.m_datasource);
        }
        return this._$5;
    }

    public Dataset getParentDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = DatasetVectorNative.jni_GetParentDataset(this.getHandle())) != 0L) {
            this._$4 = new DatasetVector(l, this.m_datasource);
        }
        return this._$4;
    }

    public boolean isFileCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetIsFileCache(this.getHandle());
    }

    public void setFileCache(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFileCache(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVectorNative.jni_SetFileCache(this.getHandle(), bl);
    }

    public int getRecordCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetRecordCount(this.getHandle());
    }

    public Tolerance getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null) {
            this._$7 = new Tolerance(this, Tolerance.UserType.DATASETVECTOR);
        }
        return this._$7;
    }

    public void setTolerance(Tolerance tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null) {
            this._$7 = new Tolerance(this, Tolerance.UserType.DATASETVECTOR);
        }
        this._$7.setDangle(tolerance.getDangle());
        this._$7.setFuzzy(tolerance.getFuzzy());
        this._$7.setGrain(tolerance.getGrain());
        this._$7.setNodeSnap(tolerance.getNodeSnap());
        this._$7.setSmallPolygon(tolerance.getSmallPolygon());
        this._$7.setExtend(tolerance.getExtend());
    }

    public int getFieldCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getFieldInfos().getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Integer n = _$3;
        synchronized (n) {
            if (this._$6 == null) {
                long l = DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
                if (l == 0L) {
                    return null;
                }
                this._$6 = new FieldInfos(l, this);
                this._$6.setIsDisposable(false);
            } else if (!this.isOpen()) {
                DatasetVectorNative.jni_GetFieldInfos(this.getHandle());
            } else {
                this._$6.refresh();
            }
            return this._$6;
        }
    }

    public Recordset getRecordset(boolean bl, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        l = bl ? DatasetVectorNative.jni_GetEmptyRecordset(this.getHandle(), n) : DatasetVectorNative.jni_GetAllRecordsByRecordset(this.getHandle(), n);
        Recordset recordset = null;
        if (l != 0L) {
            recordset = new Recordset(l, this);
            recordset.setIsDisposable(true);
        }
        return recordset;
    }

    public boolean append(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_Append(this.getHandle(), recordset.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean append(Recordset recordset, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.isReadOnly()) {
            String string4 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (recordset == null) {
            String string5 = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (recordset.getHandle() == 0L) {
            String string6 = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = DatasetVectorNative.jni_Append1(this.getHandle(), recordset.getHandle(), string);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean append(Recordset recordset, String[] stringArray, String[] stringArray2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (recordset.getHandle() == 0L) {
            String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (stringArray2 == null) {
            String string = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = DatasetVectorNative.jni_Append2(this.getHandle(), recordset.getHandle(), stringArray, stringArray2);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl;
    }

    public boolean deleteRecords(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null || nArray.length == 0) {
            return true;
        }
        boolean bl = true;
        if (!this.open()) {
            bl = this.open();
        }
        if (bl) {
            Recordset recordset = this.query(nArray, CursorType.DYNAMIC);
            bl = recordset.deleteAll();
            recordset.close();
        }
        return bl;
    }

    public boolean isAvailableFieldName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        if (string.startsWith("Sm") || string.startsWith("SM") || string.startsWith("sm")) {
            return bl;
        }
        if (string != null && string.trim().length() != 0) {
            bl = DatasetVectorNative.jni_IsAvailableFieldName(this.getHandle(), string);
        }
        return bl;
    }

    public String getAvailableFieldName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (string.startsWith("sm")) {
            string = "Field_" + string;
        }
        return DatasetVectorNative.jni_GetUnoccupiedFieldName(this.getHandle(), string);
    }

    public Recordset query(String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query1(this.getHandle(), string, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(Geometry geometry, double d, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        if (geometry.isEmpty()) {
            return this.getRecordset(true, cursorType);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = this.query(geometry, d, "", cursorType);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return recordset;
    }

    public Recordset query(Geometry geometry, double d, String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string4 = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (geometry == null) {
            String string5 = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (geometry.getHandle() == 0L) {
            String string6 = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (geometry.getType().equals(GeometryType.GEOTEXT)) {
            String string7 = InternalResource.loadString("geometry", "DatasetVector_GeoTextIsUnsupported", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (geometry.isEmpty()) {
            InternalHandleDisposable.makeSureNativeObjectLive(geometry);
            return this.getRecordset(true, cursorType);
        }
        if (d < 0.0) {
            String string8 = InternalResource.loadString("bufferDistance", "DatasetVector_QueryBufferInvalid", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query2(this.getHandle(), geometry.getHandle(), d, string, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return recordset;
    }

    public Recordset query(Rectangle2D rectangle2D, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        Recordset recordset = this.query(rectangle2D, "", cursorType);
        return recordset;
    }

    public Recordset query(Rectangle2D rectangle2D, String string, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType().equals(DatasetType.TABULAR)) {
            String string4 = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rectangle2D == null) {
            String string5 = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        if (string == null) {
            string = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query3(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), string, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(int[] nArray, CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query4(this.getHandle(), nArray, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    public Recordset query(int[] nArray, String string, CursorType cursorType) {
        FieldInfo fieldInfo;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (nArray == null) {
            String string4 = InternalResource.loadString("id", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        if ((fieldInfo = this.getFieldInfos().get(string)).getType() != FieldType.INT32) {
            return this.getRecordset(true, cursorType);
        }
        int n = cursorType.getUGCValue();
        long l = DatasetVectorNative.jni_Query7(this.getHandle(), nArray, string, n);
        if (l == 0L) {
            return this.getRecordset(true, cursorType);
        }
        Recordset recordset = new Recordset(l, this);
        return recordset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Recordset query(QueryParameter queryParameter) {
        Object object;
        Object object2;
        String string;
        long l;
        long l2;
        int n;
        QueryParameter queryParameter2;
        int n2;
        long l3;
        block20: {
            if (this.getHandle() == 0L) {
                String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string2);
            }
            if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
                String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string3);
            }
            if (queryParameter == null) {
                String string4 = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string4);
            }
            if (this.getType().equals(DatasetType.TABULAR) && !queryParameter.getSpatialQueryMode().equals(SpatialQueryMode.NONE)) {
                String string5 = InternalResource.loadString("", "DatasetVector_TabularUnsupport", "data_resources");
                throw new IllegalArgumentException(string5);
            }
            l3 = 0L;
            n2 = -1;
            queryParameter2 = null;
            n = -1;
            l2 = 0L;
            l = 0L;
            string = "";
            queryParameter2 = new QueryParameter(queryParameter);
            Object object3 = queryParameter2.getSpatialQueryObject();
            if (object3 != null) {
                if (object3.getClass().equals(Rectangle2D.class)) {
                    if (!queryParameter2.getSpatialQueryMode().equals(SpatialQueryMode.INTERSECT)) {
                        object2 = (Rectangle2D)object3;
                        if (Toolkit.isZero(((Rectangle2D)object2).getWidth()) || Toolkit.isZero(((Rectangle2D)object2).getHeight())) {
                            return this.getRecordset(true, queryParameter.getCursorType());
                        }
                        object = new Point2Ds();
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getLeft(), ((Rectangle2D)object2).getBottom()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getLeft(), ((Rectangle2D)object2).getTop()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getRight(), ((Rectangle2D)object2).getTop()));
                        ((Point2Ds)object).add(new Point2D(((Rectangle2D)object2).getRight(), ((Rectangle2D)object2).getBottom()));
                        GeoRegion geoRegion = new GeoRegion((Point2Ds)object);
                        queryParameter2.setSpatialQueryObject(geoRegion);
                        break block20;
                    } else {
                        Rectangle2D rectangle2D = (Rectangle2D)object3;
                        l = DatasetVectorNative.jni_Query6(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), queryParameter2.getHandle());
                        Recordset recordset = null;
                        if (l == 0L) {
                            recordset = this.getRecordset(true, queryParameter.getCursorType());
                            recordset.setQueryParameter(queryParameter);
                        } else {
                            recordset = new Recordset(l, this);
                        }
                        queryParameter2.dispose();
                        return recordset;
                    }
                }
                if (object3.getClass().equals(Point2D.class)) {
                    object2 = (Point2D)object3;
                    if (((Point2D)object2).isEmpty()) {
                        return this.getRecordset(true, queryParameter.getCursorType());
                    }
                    object = new GeoPoint(((Point2D)object2).getX(), ((Point2D)object2).getY());
                    queryParameter2.setSpatialQueryObject(object);
                } else if (object3.getClass().getSuperclass().getClass().equals(Geometry.class) && ((Geometry)(object2 = (Geometry)object3)).isEmpty()) {
                    return this.getRecordset(true, queryParameter.getCursorType());
                }
            }
        }
        l3 = queryParameter2.getHandle();
        if (queryParameter2.getSpatialQueryObject() != null) {
            l2 = ((InternalHandle)queryParameter2.getSpatialQueryObject()).getHandle();
        }
        n2 = queryParameter2.getSpatialQueryMode().getUGCValue();
        object2 = null;
        if (queryParameter2.getSpatialQueryObject() != null) {
            object2 = queryParameter2.getSpatialQueryObject().getClass().equals(DatasetVector.class) ? InternalUGCType.UGDatasetVector : (queryParameter2.getSpatialQueryObject().getClass().equals(Recordset.class) ? InternalUGCType.UGRecordset : InternalUGCType.UGGeometry);
        }
        if (object2 != null) {
            n = ((Enum)object2).getUGCValue();
        }
        this._$1(queryParameter2.getSpatialQueryObject(), queryParameter2.getSpatialQueryMode());
        l = DatasetVectorNative.jni_Query5(this.getHandle(), l3, n2, l2, n, string);
        object = null;
        if (l == 0L) {
            object = this.getRecordset(true, queryParameter.getCursorType());
            ((Recordset)object).setQueryParameter(queryParameter);
        } else {
            object = new Recordset(l, this);
        }
        queryParameter2.dispose();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildFieldIndex(String[] stringArray, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (stringArray == null) {
            String string4 = InternalResource.loadString("fieldName", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        if (stringArray.length == 0) {
            return false;
        }
        Integer n = _$3;
        synchronized (n) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = this.getFieldInfos().indexOf(stringArray[i]);
                if (n2 != -1) continue;
                String string5 = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
                throw new IllegalArgumentException(string5);
            }
            if (string == null || string.trim().length() == 0) {
                String string6 = InternalResource.loadString("indexName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string6);
            }
            String string7 = Toolkit.joinString(stringArray, ",");
            return DatasetVectorNative.jni_CreateFieldIndex(this.getHandle(), string7, string);
        }
    }

    public SpatialIndexType getSpatialIndexType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorNative.jni_GetSpatialIndexType(this.getHandle());
        return (SpatialIndexType)Enum.parseUGCValue(SpatialIndexType.class, n);
    }

    public boolean isSpatialIndexDirty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_GetIsSpatialIndexDirty(this.getHandle());
    }

    public boolean isSpatialIndexTypeSupported(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = InternalResource.loadString("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return DatasetVectorNative.jni_IsSpatialIndexTypeSupported(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean buildSpatialIndex(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexType spatialIndexType = spatialIndexInfo.getType();
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = InternalResource.loadString("spatialIndexInfo", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexInfo == null || spatialIndexInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("spatialIndexInfo", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        boolean bl = DatasetVectorNative.jni_BuildSpatialIndex2(this.getHandle(), spatialIndexInfo.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(spatialIndexInfo);
        return bl;
    }

    public boolean buildSpatialIndex(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = InternalResource.loadString("spatialIndexType", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.isSpatialIndexTypeSupported(spatialIndexType)) {
            String string = InternalResource.loadString("spatialIndexType", "DatasetVector_BuildSpatialIndexUnsupportTheSpatialIndexType", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_BuildSpatialIndex1(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public boolean reBuildSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reBuildSpatialIndex()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_ReBuildSpatialIndex(this.getHandle());
    }

    public double statistic(String string, StatisticMode statisticMode) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = this.getFieldInfos().indexOf(string);
        if (n == -1) {
            String string5 = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (statisticMode == null) {
            String string6 = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string6);
        }
        int n2 = statisticMode.getUGCValue();
        return DatasetVectorNative.jni_Statistic(this.getHandle(), string, n2);
    }

    public double statistic(int n, StatisticMode statisticMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getFieldCount()) {
            String string = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (statisticMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        String string = this.getFieldInfos().get(n).getName();
        return this.statistic(string, statisticMode);
    }

    public boolean updateField(String string, Object object, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string4 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (this.isReadOnly()) {
            String string5 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string5);
        }
        if (string == null || string.trim().length() == 0) {
            String string6 = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        int n = this.getFieldInfos().indexOf(string);
        if (n == -1) {
            String string7 = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (!this._$1(string)) {
            String string8 = InternalResource.loadString("fieldName", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (object == null) {
            String string9 = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string9);
        }
        if (!InternalVariant.isSupportedInstance(object)) {
            String string10 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string10);
        }
        InternalVariant internalVariant = new InternalVariant(object);
        if (string2 == null) {
            string2 = "";
        }
        return DatasetVectorNative.jni_UpdateField1(this.getHandle(), string, internalVariant.getHandle(), string2);
    }

    public boolean updateField(int n, Object object, String string) {
        String string2;
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string4 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (this.isReadOnly()) {
            String string5 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string5);
        }
        if (n < 0 || n >= this.getFieldCount()) {
            String string6 = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string6);
        }
        if (object == null) {
            String string7 = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string7);
        }
        if (!InternalVariant.isSupportedInstance(object)) {
            String string8 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string == null) {
            string = "";
        }
        if (!this._$1(string2 = this.getFieldInfos().get(n).getName())) {
            String string9 = InternalResource.loadString("fieldIndex", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        return this.updateField(string2, object, string);
    }

    public boolean updateField(String string, String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string5 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string5);
        }
        if (this.isReadOnly()) {
            String string6 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string6);
        }
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("fieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        int n = this.getFieldInfos().indexOf(string);
        if (n == -1) {
            String string8 = InternalResource.loadString("fieldName", "DatasetVector_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (!this._$1(string)) {
            String string9 = InternalResource.loadString("fieldName", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string10 = InternalResource.loadString("expression", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string10);
        }
        if (string3 == null) {
            string3 = "";
        }
        return DatasetVectorNative.jni_UpdateField2(this.getHandle(), string, string2, string3);
    }

    public boolean updateField(int n, String string, String string2) {
        String string3;
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string5 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string5);
        }
        if (this.isReadOnly()) {
            String string6 = InternalResource.loadString("", "DatasetVector_TheDatasourceOrDatasetIsReadOnly", "data_resources");
            throw new IllegalStateException(string6);
        }
        if (n < 0 || n >= this.getFieldCount()) {
            String string7 = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string7);
        }
        if (string == null || string.trim().length() == 0) {
            String string8 = InternalResource.loadString("expression", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!this._$1(string3 = this.getFieldInfos().get(n).getName())) {
            String string9 = InternalResource.loadString("fieldIndex", "DatasetVector_CannotUpdateSystemField", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        return this.updateField(string3, string, string2);
    }

    public Rectangle2D computeBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetVectorNative.jni_ComputeBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean dropFieldIndex(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("indexName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return DatasetVectorNative.jni_DropFieldIndex(this.getHandle(), string);
    }

    public boolean dropSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_DropSpatialIndex(this.getHandle());
    }

    protected static DatasetVector createInstance(long l, Datasource datasource) {
        return new DatasetVector(l, datasource);
    }

    @Override
    protected final void clearHandle() {
        this._$7 = null;
        if (this._$6 != null) {
            this._$6.clearHandle();
            this._$6 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        this.setHandle(0L);
    }

    private String _$2(String string) {
        if (string.trim().length() == 0) {
            return string;
        }
        String string2 = string.charAt(0) >= '0' && string.charAt(0) <= '9' || string.startsWith("_") ? "Field_" + string : string;
        return string2;
    }

    private boolean _$1(String string) {
        int n = this.getFieldInfos().indexOf(string);
        boolean bl = false;
        if (n != -1) {
            if (this.getFieldInfos().get(n).isSystemField()) {
                if (string.equalsIgnoreCase("SmUserID")) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private double _$1(double d, Geometry geometry) {
        double d2 = 0.0;
        PrjCoordSysType prjCoordSysType = this.getPrjCoordSys().getType();
        if (prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            GeoCoordSys geoCoordSys = this.getPrjCoordSys().getGeoCoordSys();
            Projection projection = new Projection(ProjectionType.PRJ_EQUIDISTANT_AZIMUTHAL);
            Rectangle2D rectangle2D = geometry.getBounds();
            PrjParameter prjParameter = new PrjParameter();
            prjParameter.setCentralMeridian(rectangle2D.getCenter().getX() - 1.0E-6);
            prjParameter.setCentralParallel(rectangle2D.getCenter().getY() - 1.0E-6);
            prjParameter.setStandardParallel1(rectangle2D.getBottom() + rectangle2D.getHeight() / 3.0);
            prjParameter.setStandardParallel2(rectangle2D.getTop() - rectangle2D.getHeight() / 3.0);
            PrjCoordSys prjCoordSys = new PrjCoordSys(geoCoordSys, projection, prjParameter, "tempPrjCoordSys");
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(rectangle2D.getCenter());
            CoordSysTranslator.forward(point2Ds, prjCoordSys);
            Point2D point2D = point2Ds.getItem(0).clone();
            point2D.setX(point2Ds.getItem(0).getX() + d);
            point2Ds.add(point2D);
            CoordSysTranslator.inverse(point2Ds, prjCoordSys);
            double d3 = Math.pow(point2Ds.getItem(0).getX() - point2Ds.getItem(1).getX(), 2.0);
            double d4 = Math.pow(point2Ds.getItem(0).getY() - point2Ds.getItem(1).getY(), 2.0);
            d2 = Math.sqrt(d3 + d4);
            InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
            InternalHandleDisposable.makeSureNativeObjectLive(prjParameter);
        } else {
            d2 = d;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return d2;
    }

    private void _$1(Object object, SpatialQueryMode spatialQueryMode) {
        if (!spatialQueryMode.equals(SpatialQueryMode.NONE)) {
            InternalHandle internalHandle;
            int n = -1;
            int n2 = -1;
            if (this.getType().equals(DatasetType.CAD)) {
                return;
            }
            if (this.getType().equals(DatasetType.POINT) || this.getType().equals(DatasetType.POINT3D)) {
                n = 0;
            } else if (this.getType().equals(DatasetType.LINE) || this.getType().equals(DatasetType.NETWORK) || this.getType().equals(DatasetType.NETWORK3D) || this.getType().equals(DatasetType.LINE3D)) {
                n = 1;
            } else if (this.getType().equals(DatasetType.REGION) || this.getType().equals(DatasetType.TEXT) || this.getType().equals(DatasetType.REGION3D)) {
                n = 2;
            }
            if (object instanceof DatasetVector) {
                internalHandle = (DatasetVector)object;
                if (((Dataset)internalHandle).getType().equals(DatasetType.POINT) || ((Dataset)internalHandle).getType().equals(DatasetType.POINT3D)) {
                    n2 = 0;
                } else if (((Dataset)internalHandle).getType().equals(DatasetType.LINE) || ((Dataset)internalHandle).getType().equals(DatasetType.LINE3D)) {
                    n2 = 1;
                } else if (((Dataset)internalHandle).getType().equals(DatasetType.REGION) || ((Dataset)internalHandle).getType().equals(DatasetType.REGION3D) || ((Dataset)internalHandle).getType().equals(DatasetType.TEXT)) {
                    n2 = 2;
                }
            } else if (object instanceof Recordset) {
                internalHandle = (Recordset)object;
                if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.POINT) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.POINT3D)) {
                    n2 = 0;
                } else if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINE) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.LINE3D)) {
                    n2 = 1;
                } else if (((Recordset)internalHandle).getDataset().getType().equals(DatasetType.REGION) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.REGION3D) || ((Recordset)internalHandle).getDataset().getType().equals(DatasetType.TEXT)) {
                    n2 = 2;
                }
            } else if (object instanceof Geometry) {
                internalHandle = (Geometry)object;
                if (((Geometry)internalHandle).getType().equals(GeometryType.GEOPOINT) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPOINT3D)) {
                    n2 = 0;
                } else if (((Geometry)internalHandle).getType().equals(GeometryType.GEOLINE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOLINE3D)) {
                    n2 = 1;
                } else if (((Geometry)internalHandle).getType().equals(GeometryType.GEOREGION) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOREGION3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOMODEL) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOSPHERE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOHEMISPHERE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOBOX) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCYLINDER) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCONE) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPYRAMID) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPIE3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOCIRCLE3D) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOPIECYLINDER) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOELLIPSOID) || ((Geometry)internalHandle).getType().equals(GeometryType.GEOTEXT)) {
                    n2 = 2;
                }
            }
            boolean bl = false;
            if (n == -1 || n2 == -1) {
                bl = true;
            } else if (spatialQueryMode.equals(SpatialQueryMode.IDENTITY)) {
                if (n != n2) {
                    bl = true;
                }
            } else if (spatialQueryMode.equals(SpatialQueryMode.TOUCH)) {
                if (n == 0 && n2 == 0) {
                    bl = true;
                }
            } else if (spatialQueryMode.equals(SpatialQueryMode.OVERLAP)) {
                if (n == 0 || n != n2) {
                    bl = true;
                }
            } else if (spatialQueryMode.equals(SpatialQueryMode.CROSS)) {
                if (n == 0 || n2 != 1) {
                    bl = true;
                }
            } else if (spatialQueryMode.equals(SpatialQueryMode.WITHIN)) {
                if (n < n2) {
                    bl = true;
                }
            } else if (spatialQueryMode.equals(SpatialQueryMode.CONTAIN) && n > n2) {
                bl = true;
            }
            if (bl) {
                String string = InternalResource.loadString("", "QueryParameter_InvalidQueryObject", "data_resources");
                throw new IllegalStateException(string);
            }
        }
    }

    public Map<Integer, Feature> getAllFeatures() {
        Recordset recordset = this.query("", CursorType.STATIC);
        HashMap<Integer, Feature> hashMap = new HashMap<Integer, Feature>(this.getRecordCount());
        recordset.moveFirst();
        while (!recordset.isEOF()) {
            Feature feature = recordset.getFeature();
            hashMap.put(feature.getID(), feature);
            recordset.moveNext();
        }
        recordset.dispose();
        return hashMap;
    }

    public boolean updateFields(DatasetVector datasetVector, SpatialRelationType spatialRelationType, String[] stringArray, String[] stringArray2, AttributeStatisticsType attributeStatisticsType, boolean bl, String string, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string4 = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasetVector == null) {
            String string5 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string6 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (stringArray == null) {
            String string7 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (stringArray2 == null) {
            String string8 = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl3 = DatasetVectorNative.jni_UpdateFields1(this.getHandle(), datasetVector.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), stringArray, stringArray2, bl, string, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl3;
    }

    public boolean updateFields(Recordset recordset, SpatialRelationType spatialRelationType, String[] stringArray, String[] stringArray2, AttributeStatisticsType attributeStatisticsType, boolean bl, String string, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string4 = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (recordset == null) {
            String string5 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string6 = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (stringArray == null) {
            String string7 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (stringArray2 == null) {
            String string8 = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl3 = DatasetVectorNative.jni_UpdateFields2(this.getHandle(), recordset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), stringArray, stringArray2, bl, string, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl3;
    }

    public int[] getIDsByGeoRelation(DatasetVector datasetVector, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation1(this.getHandle(), datasetVector.getHandle(), spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public int[] getIDsByGeoRelation(Recordset recordset, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation2(this.getHandle(), recordset.getHandle(), spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return nArray;
    }

    public int[] getIDsByGeoRelation(Geometry[] geometryArray, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.POINT && this.getType() != DatasetType.LINE && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray.length == 0) {
            String string = InternalResource.loadString("sourceGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray[0] == null) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometryArray[0].getType();
        if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long[] lArray = new long[geometryArray.length];
        for (int i = 0; i < geometryArray.length; ++i) {
            Geometry geometry = geometryArray[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
            hashSet.add(geometry.getID());
        }
        if (hashSet.size() != geometryArray.length) {
            String string = InternalResource.loadString("sourceGeometries", "Geometry_Type_Must_Be_Same", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        int[] nArray = DatasetVectorNative.jni_GetIDsByGeoRelation3(this.getHandle(), lArray, spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public boolean resample(ResampleInformation resampleInformation, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.LINE && this.getType() != DatasetType.NETWORK && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInformation == null) {
            String string = InternalResource.loadString("ResampleInformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInformation.getHandle() == 0L) {
            String string = InternalResource.loadString("ResampleInformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (resampleInformation.getTolerance() <= 0.0) {
            String string = InternalResource.loadString("Tolerance", "Invalid_ArgumentValue", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl3 = DatasetVectorNative.jni_Resample1(this.getHandle(), resampleInformation.getHandle(), bl, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        InternalHandleDisposable.makeSureNativeObjectLive(resampleInformation);
        return bl3;
    }

    public boolean smooth(int n, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != DatasetType.LINE && this.getType() != DatasetType.NETWORK && this.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("DatasetVector", "TheTypeOfDatasetDoesn'tSupportThatOperation", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = DatasetVectorNative.jni_NewSelfEventHandle(this);
        boolean bl2 = DatasetVectorNative.jni_Smooth(this.getHandle(), n, bl, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl2;
    }

    static void steppedCallBack(DatasetVector datasetVector, int n, long l, String string, String string2, long l2) {
        if (datasetVector != null) {
            boolean bl = Toolkit.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent(datasetVector, n, l, string, string2, null, bl);
            datasetVector.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    public boolean appendFields(DatasetVector datasetVector, String string, String string2, String[] stringArray, String[] stringArray2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string4 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("sourceLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("targetLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasetVector == null) {
            String string7 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (stringArray == null) {
            String string8 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (stringArray2 == null) {
            String string9 = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        boolean bl = DatasetVectorNative.jni_AppendFields1(this.getHandle(), datasetVector.getHandle(), string, string2, stringArray, stringArray2);
        return bl;
    }

    public boolean appendFields(DatasetVector datasetVector, String string, String string2, String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string4 = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("sourceLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("targetLinkFieldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasetVector == null) {
            String string7 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (stringArray == null) {
            String string8 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        boolean bl = DatasetVectorNative.jni_AppendFields2(this.getHandle(), datasetVector.getHandle(), string, string2, stringArray);
        return bl;
    }

    @Override
    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetVectorNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public Map<String, String> getFieldIndexes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = DatasetVectorNative.jni_GetFieldIndexes(this.getHandle());
        int n = string.indexOf(47);
        while (n != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.indexOf(45);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            hashMap.put(string3, string4);
            string = string2 = string.substring(n + 1);
            n = string.indexOf(47);
        }
        return hashMap;
    }

    public boolean truncate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("DatasetVector", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("m_datasource", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorNative.jni_Truncate(this.getHandle());
    }
}

