/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.data.Toolkit;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeRangeItem;
import com.supermap.mapping.ThemeRangeNative;
import java.util.ArrayList;

public class ThemeRange
extends Theme {
    private ArrayList _$2 = null;
    private RangeMode _$1;

    public ThemeRange() {
        long l = ThemeRangeNative.jni_New();
        this.setHandle(l, true);
        this.setRangeExpression("");
        this._$2 = new ArrayList();
        this._$1 = RangeMode.NONE;
    }

    public ThemeRange(ThemeRange themeRange) {
        if (themeRange == null) {
            String string = InternalResource.loadString("themeRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeRange.getHandle() == 0L) {
            String string = InternalResource.loadString("themeRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeRangeNative.jni_Clone(themeRange.getHandle());
        this.setHandle(l, true);
        this._$2 = new ArrayList();
        int n = themeRange.getRangeItemsList().size();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this._$2.add(themeRangeItem);
        }
        this._$1 = themeRange.getRangeMode();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeRange));
    }

    ThemeRange(long l, boolean bl) {
        int n;
        this.setHandle(l, bl);
        int n2 = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        this._$2 = new ArrayList();
        int n3 = n2 - 1;
        for (n = 0; n < n3; ++n) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this._$2.add(themeRangeItem);
        }
        n = ThemeRangeNative.jni_GetRangeMethod(this.getHandle());
        this._$1 = (RangeMode)RangeMode.parse(RangeMode.class, (int)n);
    }

    public ThemeRangeItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeRangeItem)this._$2.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRangeNative.jni_GetCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_SetRangeExpression(this.getHandle(), string);
        this.m_lock.unlock();
    }

    public boolean addToHead(ThemeRangeItem themeRangeItem) {
        return this.addToHead(themeRangeItem, false);
    }

    public boolean addToTail(ThemeRangeItem themeRangeItem) {
        return this.addToTail(themeRangeItem, false);
    }

    public boolean addToHead(ThemeRangeItem themeRangeItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeRangeItem.getStart() >= themeRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeRangeItem.getStart() - themeRangeItem.getEnd()))) {
                    return false;
                }
                Double d = themeRangeItem.getStart();
                themeRangeItem.setStart(themeRangeItem.getEnd());
                themeRangeItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getEnd());
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeRangeItem.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = (d = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getStart())) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(themeRangeItem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeRangeItem2.getStyle());
        boolean bl3 = ThemeRangeNative.jni_AddToHead(this.getHandle(), themeRangeItem2.getCaption(), themeRangeItem2.isVisible(), l, themeRangeItem2.getStart(), themeRangeItem2.getEnd());
        if (bl3) {
            ThemeRangeItem themeRangeItem3 = new ThemeRangeItem(this);
            this._$2.add(0, themeRangeItem3);
            this._$1();
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean addToTail(ThemeRangeItem themeRangeItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeRangeItem.getStart() >= themeRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeRangeItem.getStart() - themeRangeItem.getEnd()))) {
                    return false;
                }
                Double d = themeRangeItem.getStart();
                themeRangeItem.setStart(themeRangeItem.getEnd());
                themeRangeItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getStart());
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeRangeItem.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = d2 - (d = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), themeRangeItem.getEnd()))))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(themeRangeItem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeRangeItem2.getStyle());
        boolean bl3 = ThemeRangeNative.jni_AddToTail(this.getHandle(), themeRangeItem2.getCaption(), themeRangeItem2.isVisible(), l, themeRangeItem2.getStart(), themeRangeItem2.getEnd());
        if (bl3) {
            ThemeRangeItem themeRangeItem3 = new ThemeRangeItem(this);
            this._$2.add(themeRangeItem3);
            this._$1();
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean split(int n, double d, GeoStyle geoStyle, String string, GeoStyle geoStyle2, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (geoStyle == null) {
            String string5 = InternalResource.loadString("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string6 = InternalResource.loadString("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (geoStyle2 == null) {
            String string7 = InternalResource.loadString("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        if (l2 == 0L) {
            String string8 = InternalResource.loadString("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n);
        double d3 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n + 1);
        if (d <= d2 || d >= d3) {
            String string9 = InternalResource.loadString("splitValue", "ThemeRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        GeoStyle geoStyle3 = geoStyle.clone();
        GeoStyle geoStyle4 = geoStyle2.clone();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3);
        long l4 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle4);
        if (string == null || string.trim().length() == 0) {
            String string10 = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string10);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string11 = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string11);
        }
        this.m_lock.lock();
        boolean bl = ThemeRangeNative.jni_Split(this.getHandle(), n, d, l3, string, l4, string2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle4);
        if (bl) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this._$2.add(n + 1, themeRangeItem);
            this._$1();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int n, int n2, GeoStyle geoStyle, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("merge(int index, int count, GeoStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (n + n2 < n || n + n2 > n3) {
            String string4 = InternalResource.loadString("count", "ThemeRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (geoStyle == null) {
            String string5 = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string6 = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (n2 == 0) {
            return true;
        }
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        this.m_lock.lock();
        boolean bl = ThemeRangeNative.jni_Merge(this.getHandle(), n, n2, l2, string);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
        if (bl) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this._$2.get(n);
            double d = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n + 1);
            themeRangeItem.setEnd(d);
            themeRangeItem.setCaption(string);
            themeRangeItem.setStyle(geoStyle.clone());
            for (int i = 0; i < n2 - 1; ++i) {
                ThemeRangeItem themeRangeItem2 = (ThemeRangeItem)this._$2.get(n + 1);
                themeRangeItem2.clearHandle();
                this._$2.remove(n + 1);
            }
            this._$1();
        }
        this.m_lock.unlock();
        return bl;
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d) {
        return ThemeRange.makeDefault(datasetVector, string, rangeMode, d, null, null);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d, ColorGradientType colorGradientType) {
        return ThemeRange.makeDefault(datasetVector, string, rangeMode, d, colorGradientType, null);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d, ColorGradientType colorGradientType, JoinItems joinItems) {
        return ThemeRange.makeDefault(datasetVector, string, rangeMode, d, colorGradientType, joinItems, 0.1);
    }

    public static ThemeRange makeDefault(DatasetVector datasetVector, String string, RangeMode rangeMode, double d, ColorGradientType colorGradientType, JoinItems joinItems, double d2) {
        int n;
        int n2;
        long l;
        long l2;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l3 == 0L) {
            String string2 = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string4 = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (rangeMode == null) {
            String string5 = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM) || rangeMode.equals((Object)RangeMode.QUANTILE)) && d < 1.0) {
            String string6 = InternalResource.loadString("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && d < 0.0) {
            String string7 = InternalResource.loadString("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        if ((l = ThemeRangeNative.jni_MakeDefault(l3, string, l2, n2 = InternalEnum.getUGCValue(rangeMode), d, n = InternalEnum.getUGCValue((Enum)colorGradientType), d2)) == 0L) {
            return null;
        }
        ThemeRange themeRange = new ThemeRange(l, true);
        themeRange._$1(rangeMode);
        return themeRange;
    }

    public double getPrecision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrecision()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetPrecision(this.getHandle());
    }

    public void setPrecision(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrecision(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeRangeNative.jni_SetPrecision(this.getHandle(), d);
    }

    public int indexOf(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= d) || !(d < dArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_Clear(this.getHandle());
        if (this._$2 != null) {
            int n = this._$2.size();
            for (int i = 0; i < n; ++i) {
                ThemeRangeItem themeRangeItem = (ThemeRangeItem)this._$2.get(i);
                themeRangeItem.clearHandle();
            }
            this._$2.clear();
        }
        this.m_lock.unlock();
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(n);
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                this._$2();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$2 != null) {
            this._$3();
            this._$2 = null;
        }
        this.setHandle(0L);
    }

    void changeHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
        this._$2();
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    ArrayList getRangeItemsList() {
        return this._$2;
    }

    private void _$3() {
        int n = this._$2.size();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this._$2.get(i);
            themeRangeItem.clearHandle();
        }
        this._$2.clear();
    }

    private void _$2() {
        if (this._$2 != null) {
            this._$3();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this._$2.add(themeRangeItem);
        }
    }

    private void _$1() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeRangeNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = this.getItem(i);
            themeRangeItem.refreshStyle(lArray[i]);
        }
    }

    private void _$1(RangeMode rangeMode) {
        this._$1 = rangeMode;
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeRangeNative.jni_SetOffsetX(this.getHandle(), string);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeRangeNative.jni_SetOffsetY(this.getHandle(), string);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeRangeNative.jni_SetOffsetFixed(this.getHandle(), bl);
    }

    public double getCustomInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetCustomInterval(this.getHandle());
    }
}

