/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoModel;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolMarker3DNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SymbolMarker3D
extends Symbol {
    SymbolMarker3D(long l) {
        this.setHandle(l, false);
    }

    public SymbolMarker3D(BufferedImage bufferedImage, GeoModel geoModel) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        long l = SymbolMarker3DNative.jni_New3(nArray, geoModel.getHandle(), n, n2);
        this.setHandle(l, true);
        geoModel.makeSureNativeObjectLive();
    }

    public SymbolMarker3D(SymbolMarker3D symbolMarker3D) {
        if (symbolMarker3D == null) {
            String string = InternalResource.loadString("symbolMarker3D", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(symbolMarker3D);
        if (l == 0L) {
            String string = InternalResource.loadString("symbolMarker3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolLibrary symbolLibrary = symbolMarker3D.getLibrary();
        long l2 = 0L;
        if (symbolLibrary != null) {
            l2 = InternalHandle.getHandle(symbolLibrary);
        }
        long l3 = SymbolMarker3DNative.jni_Clone(l, l2);
        this.setHandle(l3, true);
        symbolLibrary.makeSureNativeObjectLive();
        symbolMarker3D.makeSureNativeObjectLive();
    }

    public void setThumbnail(BufferedImage bufferedImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThumnnail(image)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        SymbolMarker3DNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getThumbnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThumnnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = SymbolMarker3DNative.jni_GetImage(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, nArray2[i * n + j]);
            }
        }
        return bufferedImage;
    }

    @Deprecated
    public void setThumnnail(BufferedImage bufferedImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThumnnail(image)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        SymbolMarker3DNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    @Deprecated
    public BufferedImage getThumnnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThumnnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = SymbolMarker3DNative.jni_GetImage(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, nArray2[i * n + j]);
            }
        }
        return bufferedImage;
    }

    public boolean draw(Graphics graphics, Geometry geometry) {
        return false;
    }

    public boolean draw(BufferedImage bufferedImage, Geometry geometry) {
        return false;
    }

    public boolean draw(Graphics graphics, Point2Ds point2Ds, GeoStyle geoStyle) {
        return false;
    }

    public boolean draw(BufferedImage bufferedImage, Point2Ds point2Ds, GeoStyle geoStyle) {
        return false;
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            SymbolMarker3DNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public SymbolType getType() {
        return SymbolType.MARKER3D;
    }

    public GeoModel getGeoModel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeoModel", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibrary symbolLibrary = this.getLibrary();
        long l = 0L;
        if (symbolLibrary != null) {
            l = InternalHandle.getHandle(symbolLibrary);
        }
        long l2 = SymbolMarker3DNative.jni_GetModel(this.getHandle(), l);
        GeoModel geoModel = null;
        if (l2 != 0L) {
            geoModel = new GeoModel(l2);
            InternalHandleDisposable.setIsDisposable(geoModel, true);
        }
        symbolLibrary.makeSureNativeObjectLive();
        return geoModel;
    }

    public void setGeoModel(GeoModel geoModel) {
        if (geoModel == null) {
            String string = InternalResource.loadString("setGeoModel", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoModel);
        SymbolMarker3DNative.jni_SetModel(this.getHandle(), l);
        geoModel.makeSureNativeObjectLive();
    }
}

