/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CustomGeometryCreatedEvent;
import com.supermap.data.CustomGeometryCreatedListener;
import com.supermap.data.Enum;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoBSpline;
import com.supermap.data.GeoBox;
import com.supermap.data.GeoCardinal;
import com.supermap.data.GeoChord;
import com.supermap.data.GeoCircle;
import com.supermap.data.GeoCircle3D;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoCone;
import com.supermap.data.GeoCurve;
import com.supermap.data.GeoCylinder;
import com.supermap.data.GeoEllipse;
import com.supermap.data.GeoEllipsoid;
import com.supermap.data.GeoEllipticArc;
import com.supermap.data.GeoHemiSphere;
import com.supermap.data.GeoLegend;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineM;
import com.supermap.data.GeoMap;
import com.supermap.data.GeoMapBorder;
import com.supermap.data.GeoMapScale;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoNorthArrow;
import com.supermap.data.GeoParametricLine;
import com.supermap.data.GeoParametricLineCompound;
import com.supermap.data.GeoParametricRegion;
import com.supermap.data.GeoParametricRegionCompound;
import com.supermap.data.GeoParticle;
import com.supermap.data.GeoPicture;
import com.supermap.data.GeoPicture3D;
import com.supermap.data.GeoPie;
import com.supermap.data.GeoPie3D;
import com.supermap.data.GeoPieCylinder;
import com.supermap.data.GeoPlacemark;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoPyramid;
import com.supermap.data.GeoRectangle;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.GeoRoundRectangle;
import com.supermap.data.GeoSphere;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.GeoText3D;
import com.supermap.data.GeoUserDefined;
import com.supermap.data.GeometryNative;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import java.util.Vector;

public abstract class Geometry
extends InternalHandleDisposable {
    private GeoStyle _$4 = null;
    private boolean _$3 = false;
    static transient Vector m_customGeometryCreateListeners;

    protected Geometry() {
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        if (this.getType().equals(GeometryType.GEOCOMPOUND)) {
            GeometryNative.jni_SetBoundsDirty(this.getHandle(), true);
        }
        GeometryNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Point2D getInnerPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInnerPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeometryNative.jni_GetInnerPoint(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_GetID(this.getHandle());
    }

    public void setID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_setID(this.getHandle(), n);
    }

    public boolean isEmpty() {
        return false;
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = GeometryNative.jni_GetStyle(this.getHandle())) != 0L) {
            this._$4 = GeoStyle.createInstance(l);
        }
        return this._$4;
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryType geometryType = this.getType();
        if (geometryType == GeometryType.GEOTEXT) {
            String string = InternalResource.loadString("value", "GeoText_UnsupprotStyle", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOTEXT3D) {
            String string = InternalResource.loadString("value", "GeoText_UnsupprotStyle", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPOINT3D) {
            String string = InternalResource.loadString("value", "GeoPoint3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("value", "GeoLine3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOREGION3D) {
            String string = InternalResource.loadString("value", "GeoRegion3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOCIRCLE3D) {
            String string = InternalResource.loadString("value", "GeoCircle3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPIE3D) {
            String string = InternalResource.loadString("value", "GeoPie3D_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPIECYLINDER) {
            String string = InternalResource.loadString("value", "GeoPieCylinder_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOSPHERE) {
            String string = InternalResource.loadString("value", "GeoSphere_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOHEMISPHERE) {
            String string = InternalResource.loadString("value", "GeoHemiSphere_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOELLIPSOID) {
            String string = InternalResource.loadString("value", "GeoEllipsoid_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOCYLINDER) {
            String string = InternalResource.loadString("value", "GeoCylinder_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geometryType == GeometryType.GEOPYRAMID) {
            String string = InternalResource.loadString("value", "GeoPyramid_UnsupprotStyle2D", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (geoStyle == null) {
            if (this._$4 != null) {
                this._$4.clearHandle();
                this._$4 = null;
            }
            GeometryNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (geoStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle geoStyle2 = geoStyle.clone();
            GeometryNative.jni_SetStyle(this.getHandle(), geoStyle2.getHandle());
            geoStyle2.dispose();
        }
        this._$3 = true;
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public GeometryType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeometryNative.jni_GetType(this.getHandle());
        try {
            return (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
        }
        catch (Exception exception) {
            return new GeometryType(n, n);
        }
    }

    public abstract Geometry clone();

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = GeometryNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public boolean hitTest(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Geometry_InvalidTolerance", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometryNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    public Geometry mirror(Point2D point2D, Point2D point2D2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint,endPoint", "Geometry_MirroStartEqualToEnd", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = this.clone();
        GeometryNative.jni_Mirror(geometry.getHandle(), point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        return geometry;
    }

    public void offset(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Offset(this.getHandle(), d, d2);
    }

    public void resize(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() == GeometryType.GEOREGION) {
            if (rectangle2D.getWidth() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsWidthIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (rectangle2D.getHeight() == 0.0) {
                String string = InternalResource.loadString("bounds", "Geometry_ResizeBoundsHeightIsZero", "data_resources");
                throw new IllegalArgumentException(string);
            }
        }
        GeometryNative.jni_Resize(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        if (this.getType() == GeometryType.GEOTEXT) {
            GeoText geoText = (GeoText)this;
            double d = geoText.getTextStyle().getFontWidth();
            double d2 = geoText.getTextStyle().getFontHeight();
            if (d < 0.0) {
                geoText.getTextStyle().setFontWidth(Math.abs(d));
            }
            if (d2 < 0.0) {
                geoText.getTextStyle().setFontHeight(Math.abs(d2));
            }
        }
    }

    public void rotate(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryNative.jni_Rotate(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    public void setEmpty() {
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryNative.jni_ToXML(this.getHandle());
    }

    static boolean copyGeometry(Geometry geometry, Geometry geometry2) {
        boolean bl = GeometryNative.jni_CopyGeometry(InternalHandle.getHandle(geometry), InternalHandle.getHandle(geometry2));
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public abstract void dispose();

    protected void clearHandle() {
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(Geometry geometry) {
        geometry.clearHandle();
    }

    static final Geometry createInstance(GeometryType geometryType) {
        Geometry geometry = null;
        if (geometryType.equals(GeometryType.GEOPOINT)) {
            geometry = new GeoPoint();
        } else if (geometryType.equals(GeometryType.GEOLINE)) {
            geometry = new GeoLine();
        } else if (geometryType.equals(GeometryType.GEOREGION)) {
            geometry = new GeoRegion();
        } else if (geometryType.equals(GeometryType.GEOTEXT)) {
            geometry = new GeoText();
        } else if (geometryType.equals(GeometryType.GEOLINEM)) {
            geometry = new GeoLineM();
        } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
            geometry = new GeoPoint3D();
        } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
            geometry = new GeoLine3D();
        } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
            geometry = new GeoRegion3D();
        } else if (geometryType.equals(GeometryType.GEOPIE)) {
            geometry = new GeoPie();
        } else if (geometryType.equals(GeometryType.GEOCIRCLE)) {
            geometry = new GeoCircle();
        } else if (geometryType.equals(GeometryType.GEOCIRCLE3D)) {
            geometry = new GeoCircle3D();
        } else if (geometryType.equals(GeometryType.GEOPIE3D)) {
            geometry = new GeoPie3D();
        } else if (geometryType.equals(GeometryType.GEOPIECYLINDER)) {
            geometry = new GeoPieCylinder();
        } else if (geometryType.equals(GeometryType.GEOSPHERE)) {
            geometry = new GeoSphere();
        } else if (geometryType.equals(GeometryType.GEOHEMISPHERE)) {
            geometry = new GeoHemiSphere();
        } else if (geometryType.equals(GeometryType.GEOELLIPSOID)) {
            geometry = new GeoEllipsoid();
        } else if (geometryType.equals(GeometryType.GEOCOMPOUND)) {
            geometry = new GeoCompound();
        } else if (geometryType.equals(GeometryType.GEORECTANGLE)) {
            geometry = new GeoRectangle();
        } else if (geometryType.equals(GeometryType.GEOELLIPSE)) {
            geometry = new GeoEllipse();
        } else if (geometryType.equals(GeometryType.GEOELLIPTICARC)) {
            geometry = new GeoEllipticArc();
        } else if (geometryType.equals(GeometryType.GEOROUNDRECTANGLE)) {
            geometry = new GeoRoundRectangle();
        } else if (geometryType.equals(GeometryType.GEOBOX)) {
            geometry = new GeoBox();
        } else if (geometryType.equals(GeometryType.GEOCONE)) {
            geometry = new GeoCone();
        } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
            geometry = new GeoPlacemark();
        } else if (geometryType.equals(GeometryType.GEOARC)) {
            geometry = new GeoArc();
        } else if (geometryType.equals(GeometryType.GEOBSPLINE)) {
            geometry = new GeoBSpline();
        } else if (geometryType.equals(GeometryType.GEOCARDINAL)) {
            geometry = new GeoCardinal();
        } else if (geometryType.equals(GeometryType.GEOCHORD)) {
            geometry = new GeoChord();
        } else if (geometryType.equals(GeometryType.GEOCYLINDER)) {
            geometry = new GeoCylinder();
        } else if (geometryType.equals(GeometryType.GEOPYRAMID)) {
            geometry = new GeoPyramid();
        } else if (geometryType.equals(GeometryType.GEOCURVE)) {
            geometry = new GeoCurve();
        } else if (geometryType.equals(GeometryType.GEOPICTURE)) {
            geometry = new GeoPicture();
        } else if (geometryType.equals(GeometryType.GEOMAP)) {
            geometry = new GeoMap();
        } else if (geometryType.equals(GeometryType.GEOMAPSCALE)) {
            geometry = new GeoMapScale();
        } else if (geometryType.equals(GeometryType.GEONORTHARROW)) {
            geometry = new GeoNorthArrow();
        } else if (geometryType.equals(GeometryType.GEOMAPBORDER)) {
            geometry = new GeoMapBorder();
        } else if (geometryType.equals(GeometryType.GEOMODEL)) {
            geometry = new GeoModel();
        } else if (geometryType.equals(GeometryType.GEOTEXT3D)) {
            geometry = new GeoText3D();
        } else if (geometryType.equals(GeometryType.GEOPICTURE3D)) {
            geometry = new GeoPicture3D();
        } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
            geometry = new GeoParametricLineCompound();
        } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
            geometry = new GeoParametricRegionCompound();
        } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINE)) {
            geometry = new GeoParametricLine();
        } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGION)) {
            geometry = new GeoParametricRegion();
        } else if (!geometryType.equals(GeometryType.GEOLEGEND)) {
            if (geometryType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined();
            } else {
                throw new RuntimeException("$$$\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u037b\ufffd\u03b4\u02b5\ufffd\ufffd");
            }
        }
        geometry.setIsDisposable(true);
        return geometry;
    }

    static final Geometry createInstance2(long l, Workspace workspace) {
        if (l == 0L) {
            return null;
        }
        Geometry geometry = null;
        int n = GeometryNative.jni_GetType(l);
        int[] nArray = Enum.getPredefineValues(GeometryType.class);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            GeometryType geometryType = (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
            if (geometryType.equals(GeometryType.GEOPOINT)) {
                geometry = new GeoPoint(l);
            } else if (geometryType.equals(GeometryType.GEOLINE)) {
                geometry = new GeoLine(l);
            } else if (geometryType.equals(GeometryType.GEOREGION)) {
                geometry = new GeoRegion(l);
            } else if (geometryType.equals(GeometryType.GEOTEXT)) {
                geometry = new GeoText(l);
            } else if (geometryType.equals(GeometryType.GEOLINEM)) {
                geometry = new GeoLineM(l);
            } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
                geometry = new GeoPoint3D(l);
            } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
                geometry = new GeoLine3D(l);
            } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
                geometry = new GeoRegion3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIE)) {
                geometry = new GeoPie(l);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE)) {
                geometry = new GeoCircle(l);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE3D)) {
                geometry = new GeoCircle3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIE3D)) {
                geometry = new GeoPie3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIECYLINDER)) {
                geometry = new GeoPieCylinder(l);
            } else if (geometryType.equals(GeometryType.GEOSPHERE)) {
                geometry = new GeoSphere(l);
            } else if (geometryType.equals(GeometryType.GEOHEMISPHERE)) {
                geometry = new GeoHemiSphere(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPSOID)) {
                geometry = new GeoEllipsoid(l);
            } else if (geometryType.equals(GeometryType.GEOCOMPOUND)) {
                geometry = new GeoCompound(l);
            } else if (geometryType.equals(GeometryType.GEORECTANGLE)) {
                geometry = new GeoRectangle(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPSE)) {
                geometry = new GeoEllipse(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPTICARC)) {
                geometry = new GeoEllipticArc(l);
            } else if (geometryType.equals(GeometryType.GEOROUNDRECTANGLE)) {
                geometry = new GeoRoundRectangle(l);
            } else if (geometryType.equals(GeometryType.GEOBOX)) {
                geometry = new GeoBox(l);
            } else if (geometryType.equals(GeometryType.GEOCONE)) {
                geometry = new GeoCone(l);
            } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
                geometry = new GeoPlacemark(l);
            } else if (geometryType.equals(GeometryType.GEOARC)) {
                geometry = new GeoArc(l);
            } else if (geometryType.equals(GeometryType.GEOBSPLINE)) {
                geometry = new GeoBSpline(l);
            } else if (geometryType.equals(GeometryType.GEOCARDINAL)) {
                geometry = new GeoCardinal(l);
            } else if (geometryType.equals(GeometryType.GEOCHORD)) {
                geometry = new GeoChord(l);
            } else if (geometryType.equals(GeometryType.GEOCYLINDER)) {
                geometry = new GeoCylinder(l);
            } else if (geometryType.equals(GeometryType.GEOPYRAMID)) {
                geometry = new GeoPyramid(l);
            } else if (geometryType.equals(GeometryType.GEOCURVE)) {
                geometry = new GeoCurve(l);
            } else if (geometryType.equals(GeometryType.GEOPICTURE)) {
                geometry = new GeoPicture(l);
            } else if (geometryType.equals(GeometryType.GEOMAP)) {
                geometry = new GeoMap(l);
            } else if (geometryType.equals(GeometryType.GEOMAPSCALE)) {
                geometry = new GeoMapScale(l);
            } else if (geometryType.equals(GeometryType.GEONORTHARROW)) {
                geometry = new GeoNorthArrow(l);
            } else if (geometryType.equals(GeometryType.GEOMAPBORDER)) {
                geometry = new GeoMapBorder(l);
            } else if (geometryType.equals(GeometryType.GEOMODEL)) {
                geometry = new GeoModel(l);
            } else if (geometryType.equals(GeometryType.GEOTEXT3D)) {
                geometry = new GeoText3D(l);
            } else if (geometryType.equals(GeometryType.GEOPICTURE3D)) {
                geometry = new GeoPicture3D(l);
            } else if (geometryType.equals(GeometryType.GEOLEGEND)) {
                geometry = new GeoLegend(l, workspace);
            } else if (geometryType.equals(GeometryType.GEOPARTICLE)) {
                geometry = new GeoParticle(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
                geometry = new GeoParametricLineCompound(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
                geometry = new GeoParametricRegionCompound(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINE)) {
                geometry = new GeoParametricLine(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGION)) {
                geometry = new GeoParametricRegion(l);
            } else if (geometryType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined(l);
            }
        } else {
            CustomGeometryCreatedEvent customGeometryCreatedEvent = new CustomGeometryCreatedEvent(Geometry.class, l, null);
            Geometry.fireCustomGeometryCreated(customGeometryCreatedEvent);
            geometry = customGeometryCreatedEvent.getCustomGeometry();
        }
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(workspace);
        return geometry;
    }

    static final Geometry createInstance(long l) {
        if (l == 0L) {
            return null;
        }
        Geometry geometry = null;
        int n = GeometryNative.jni_GetType(l);
        int[] nArray = Enum.getPredefineValues(GeometryType.class);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = false;
            break;
        }
        if (!bl) {
            GeometryType geometryType = (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
            if (geometryType.equals(GeometryType.GEOPOINT)) {
                geometry = new GeoPoint(l);
            } else if (geometryType.equals(GeometryType.GEOLINE)) {
                geometry = new GeoLine(l);
            } else if (geometryType.equals(GeometryType.GEOREGION)) {
                geometry = new GeoRegion(l);
            } else if (geometryType.equals(GeometryType.GEOTEXT)) {
                geometry = new GeoText(l);
            } else if (geometryType.equals(GeometryType.GEOLINEM)) {
                geometry = new GeoLineM(l);
            } else if (geometryType.equals(GeometryType.GEOPOINT3D)) {
                geometry = new GeoPoint3D(l);
            } else if (geometryType.equals(GeometryType.GEOLINE3D)) {
                geometry = new GeoLine3D(l);
            } else if (geometryType.equals(GeometryType.GEOREGION3D)) {
                geometry = new GeoRegion3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIE)) {
                geometry = new GeoPie(l);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE)) {
                geometry = new GeoCircle(l);
            } else if (geometryType.equals(GeometryType.GEOCIRCLE3D)) {
                geometry = new GeoCircle3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIE3D)) {
                geometry = new GeoPie3D(l);
            } else if (geometryType.equals(GeometryType.GEOPIECYLINDER)) {
                geometry = new GeoPieCylinder(l);
            } else if (geometryType.equals(GeometryType.GEOSPHERE)) {
                geometry = new GeoSphere(l);
            } else if (geometryType.equals(GeometryType.GEOHEMISPHERE)) {
                geometry = new GeoHemiSphere(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPSOID)) {
                geometry = new GeoEllipsoid(l);
            } else if (geometryType.equals(GeometryType.GEOCOMPOUND)) {
                geometry = new GeoCompound(l);
            } else if (geometryType.equals(GeometryType.GEORECTANGLE)) {
                geometry = new GeoRectangle(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPSE)) {
                geometry = new GeoEllipse(l);
            } else if (geometryType.equals(GeometryType.GEOELLIPTICARC)) {
                geometry = new GeoEllipticArc(l);
            } else if (geometryType.equals(GeometryType.GEOROUNDRECTANGLE)) {
                geometry = new GeoRoundRectangle(l);
            } else if (geometryType.equals(GeometryType.GEOBOX)) {
                geometry = new GeoBox(l);
            } else if (geometryType.equals(GeometryType.GEOCONE)) {
                geometry = new GeoCone(l);
            } else if (geometryType.equals(GeometryType.GEOPLACEMARK)) {
                geometry = new GeoPlacemark(l);
            } else if (geometryType.equals(GeometryType.GEOARC)) {
                geometry = new GeoArc(l);
            } else if (geometryType.equals(GeometryType.GEOBSPLINE)) {
                geometry = new GeoBSpline(l);
            } else if (geometryType.equals(GeometryType.GEOCARDINAL)) {
                geometry = new GeoCardinal(l);
            } else if (geometryType.equals(GeometryType.GEOCHORD)) {
                geometry = new GeoChord(l);
            } else if (geometryType.equals(GeometryType.GEOCYLINDER)) {
                geometry = new GeoCylinder(l);
            } else if (geometryType.equals(GeometryType.GEOPYRAMID)) {
                geometry = new GeoPyramid(l);
            } else if (geometryType.equals(GeometryType.GEOCURVE)) {
                geometry = new GeoCurve(l);
            } else if (geometryType.equals(GeometryType.GEOPICTURE)) {
                geometry = new GeoPicture(l);
            } else if (geometryType.equals(GeometryType.GEOMAP)) {
                geometry = new GeoMap(l);
            } else if (geometryType.equals(GeometryType.GEOMAPSCALE)) {
                geometry = new GeoMapScale(l);
            } else if (geometryType.equals(GeometryType.GEONORTHARROW)) {
                geometry = new GeoNorthArrow(l);
            } else if (geometryType.equals(GeometryType.GEOMAPBORDER)) {
                geometry = new GeoMapBorder(l);
            } else if (geometryType.equals(GeometryType.GEOMODEL)) {
                geometry = new GeoModel(l);
            } else if (geometryType.equals(GeometryType.GEOTEXT3D)) {
                geometry = new GeoText3D(l);
            } else if (geometryType.equals(GeometryType.GEOPICTURE3D)) {
                geometry = new GeoPicture3D(l);
            } else if (geometryType.equals(GeometryType.GEOPARTICLE)) {
                geometry = new GeoParticle(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINECOMPOUND)) {
                geometry = new GeoParametricLineCompound(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGIONCOMPOUND)) {
                geometry = new GeoParametricRegionCompound(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICLINE)) {
                geometry = new GeoParametricLine(l);
            } else if (geometryType.equals(GeometryType.GEOPARAMETRICREGION)) {
                geometry = new GeoParametricRegion(l);
            } else if (geometryType.equals(GeometryType.GEOLEGEND)) {
                geometry = new GeoLegend(l);
            } else if (geometryType.equals(GeometryType.GEOUSERDEFINED)) {
                geometry = new GeoUserDefined(l);
            }
        } else {
            CustomGeometryCreatedEvent customGeometryCreatedEvent = new CustomGeometryCreatedEvent(Geometry.class, l, null);
            Geometry.fireCustomGeometryCreated(customGeometryCreatedEvent);
            geometry = customGeometryCreatedEvent.getCustomGeometry();
        }
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        return geometry;
    }

    static final int[] getSpatialData(long l) {
        return GeometryNative.jni_GetSpatialData(l);
    }

    protected static final int[] internalGetSpatialData(long l) {
        return Geometry.getSpatialData(l);
    }

    protected static final Geometry internalCreateInstance(long l) {
        return Geometry.createInstance(l);
    }

    protected static final Geometry internalCreateInstance2(long l, Workspace workspace) {
        return Geometry.createInstance2(l, workspace);
    }

    protected void refreshHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public static synchronized void addCustomGeometryCreatedListener(CustomGeometryCreatedListener customGeometryCreatedListener) {
        if (m_customGeometryCreateListeners == null) {
            m_customGeometryCreateListeners = new Vector();
        }
        if (!m_customGeometryCreateListeners.contains(customGeometryCreatedListener)) {
            m_customGeometryCreateListeners.add(customGeometryCreatedListener);
        }
    }

    public static synchronized void removeCustomGeometryCreatedListener(CustomGeometryCreatedListener customGeometryCreatedListener) {
        if (m_customGeometryCreateListeners != null && m_customGeometryCreateListeners.contains(customGeometryCreatedListener)) {
            m_customGeometryCreateListeners.remove(customGeometryCreatedListener);
        }
    }

    protected static void fireCustomGeometryCreated(CustomGeometryCreatedEvent customGeometryCreatedEvent) {
        if (m_customGeometryCreateListeners != null) {
            Vector vector = m_customGeometryCreateListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CustomGeometryCreatedListener)vector.elementAt(i)).customGeometryCreated(customGeometryCreatedEvent);
            }
        }
    }
}

