/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoMapScaleNative;
import com.supermap.data.GeoMapScaleType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.TextStyle;
import com.supermap.data.Unit;

public class GeoMapScale
extends Geometry {
    private TextStyle _$7;
    private int _$6;
    private GeoStyle _$5;

    public GeoMapScale() {
        long l = GeoMapScaleNative.jni_New();
        this.setHandle(l, true);
        this._$6 = -1;
    }

    public GeoMapScale(GeoMapScale geoMapScale) {
        if (geoMapScale == null) {
            String string = InternalResource.loadString("geoMapScale", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapScale);
        if (l == 0L) {
            String string = InternalResource.loadString("geoMapScale", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapScaleNative.jni_Clone(l);
        this.setHandle(l2, true);
        this._$6 = geoMapScale.getBindingGeoMapID();
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapScale);
    }

    public GeoMapScale(Point2D point2D, double d, double d2) {
        this(-1, point2D, d, d2);
    }

    public GeoMapScale(int n, Point2D point2D, double d, double d2) {
        if (d <= 0.0) {
            String string = InternalResource.loadString("width", "GeoMapScale_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("height", "GeoMapScale_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoMapScaleNative.jni_New2(point2D.getX(), point2D.getY(), d, d2);
        this.setHandle(l, true);
        this._$6 = n;
    }

    GeoMapScale(long l) {
        this.setHandle(l, false);
    }

    public int getBindingGeoMapID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBindingGeoMapID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setBindingGeoMapID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBindingGeoMapID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$6 = n;
    }

    public GeoMapScaleType getScaleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetScaleType(this.getHandle());
        return (GeoMapScaleType)Enum.parse(GeoMapScaleType.class, n);
    }

    public void setScaleType(GeoMapScaleType geoMapScaleType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleType(GeoMapScaleType geoMapScaleType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapScaleType == null) {
            String string = InternalResource.loadString("geoMapScaleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapScaleType.value();
        GeoMapScaleNative.jni_SetScaleType(this.getHandle(), n);
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetScale(this.getHandle());
    }

    public void setScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_ScaleShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetScale(this.getHandle(), d);
    }

    public int getSegmentCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetSegmentCount(this.getHandle());
    }

    public void setSegmentCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2 || n > 20) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentCountOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetSegmentCount(this.getHandle(), n);
    }

    public double getSegmentLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSegmentLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetSegmentLength(this.getHandle());
    }

    public void setSegmentLength(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSegmentLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoMapScale_SegmentLengthShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_SetSegmentLength(this.getHandle(), d);
    }

    public int getLeftDivisionCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftDivisionCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetLeftDivisionCount(this.getHandle());
    }

    public void setLeftDivisionCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeftDivisionCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            n = 1;
        }
        GeoMapScaleNative.jni_SetLeftDivisionCount(this.getHandle(), n);
    }

    public Unit getScaleUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScaleUnit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapScaleNative.jni_GetScaleUnit(this.getHandle());
        return (Unit)Enum.parse(Unit.class, n);
    }

    public void setScaleUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleUnit(Unit unit)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("unit", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = unit.value();
        GeoMapScaleNative.jni_SetScaleUnit(this.getHandle(), n);
    }

    public TextStyle getTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = GeoMapScaleNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this._$7 = new TextStyle(l);
        }
        return this._$7;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapScaleNative.jni_SetTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetWidth(this.getHandle());
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapScaleNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapScaleNative.jni_setHeight(this.getHandle(), d);
    }

    public Point2D getLeftBottom() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLeftBottom()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoMapScaleNative.jni_getLeftBottom(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public GeoMapScale clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapScale(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapScaleNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = GeoMapScaleNative.jni_GetStyle(this.getHandle())) != 0L) {
            this._$5 = GeoStyle.createInstance(l);
        }
        return this._$5;
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            if (this._$5 != null) {
                this._$5.clearHandle();
                this._$5 = null;
            }
            GeoMapScaleNative.jni_SetStyle(this.getHandle(), 0L);
        } else {
            if (geoStyle.getHandle() == 0L) {
                String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            GeoStyle geoStyle2 = geoStyle.clone();
            GeoMapScaleNative.jni_SetStyle(this.getHandle(), geoStyle2.getHandle());
            InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
        }
    }

    protected void clearHandle() {
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        this.setHandle(0L);
    }
}

