/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEllipsoidNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoEllipsoid
extends Geometry3D {
    public GeoEllipsoid() {
        this.setHandle(GeoEllipsoidNative.jni_New(), true);
        this.setSemiAxisX(1.0);
        this.setSemiAxisY(1.0);
        this.setSemiAxisZ(2.0);
    }

    public GeoEllipsoid(GeoEllipsoid geoEllipsoid) {
        if (geoEllipsoid == null) {
            String string = InternalResource.loadString("GeoEllipsoid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoEllipsoid);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoEllipsoid", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoEllipsoidNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoEllipsoid);
    }

    public GeoEllipsoid(Point3D point3D, double d, double d2, double d3) {
        this();
        this.setPosition(point3D);
        this.setSemiAxisX(d);
        this.setSemiAxisY(d2);
        this.setSemiAxisZ(d3);
    }

    GeoEllipsoid(long l) {
        this.setHandle(l, false);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoEllipsoidNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public double getSemiAxisX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiAxisX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipsoidNative.jni_GetSemiAxisX(this.getHandle());
    }

    public void setSemiAxisX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiAxisX(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setSemiAxisX()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipsoidNative.jni_SetSemiAxisX(this.getHandle(), d);
    }

    public double getSemiAxisY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiAxisY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipsoidNative.jni_GetSemiAxisY(this.getHandle());
    }

    public void setSemiAxisY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiAxisX(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setSemiAxisY()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipsoidNative.jni_SetSemiAxisY(this.getHandle(), d);
    }

    public double getSemiAxisZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiAxisZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipsoidNative.jni_GetSemiAxisZ(this.getHandle());
    }

    public void setSemiAxisZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiAxisZ(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setSemiAxisX()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipsoidNative.jni_SetSemiAxisZ(this.getHandle(), d);
    }

    public GeoEllipsoid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipsoid(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipsoidNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

