/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.StoredIdentifierCase;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbSupport {
    public static final String PROPKEY_STORED_IDENTIFIER_CASE = "database.storedIndentifierCase";
    public static final String PROPKEY_IDENTIFIER_QUOTE_STRING = "database.identifierQuoteString";
    private String databaseDialect;
    private String schemaName;
    private SQLHandler sqlHandler;
    private StoredIdentifierCase storedIdentifierCase;
    private String identifierQuoteString;

    protected DbSupport(String databaseDialect) {
        this.databaseDialect = databaseDialect;
    }

    public void init(Properties configuration, SQLHandler sqlHandler, String schemaName) {
        this.sqlHandler = sqlHandler;
        String identifierQuoteStringProperty = PropertyUtils.getString("database.identifierQuoteString." + this.getDatabaseDialect(), configuration);
        String storedIdentifierCaseValue = PropertyUtils.getString("database.storedIndentifierCase." + this.getDatabaseDialect(), configuration);
        this.identifierQuoteString = this.determineIdentifierQuoteString(identifierQuoteStringProperty);
        this.storedIdentifierCase = this.determineStoredIdentifierCase(storedIdentifierCaseValue);
        this.schemaName = this.toCorrectCaseIdentifier(schemaName);
    }

    public String getDatabaseDialect() {
        return this.databaseDialect;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public StoredIdentifierCase getStoredIdentifierCase() {
        return this.storedIdentifierCase;
    }

    public SQLHandler getSQLHandler() {
        return this.sqlHandler;
    }

    public abstract Set<String> getTableNames();

    public abstract Set<String> getColumnNames(String var1);

    public abstract Set<String> getViewNames();

    public Set<String> getMaterializedViewNames() {
        throw new UnsupportedOperationException("Materialized views not supported for " + this.getDatabaseDialect());
    }

    public Set<String> getSynonymNames() {
        throw new UnsupportedOperationException("Synonyms not supported for " + this.getDatabaseDialect());
    }

    public Set<String> getSequenceNames() {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getDatabaseDialect());
    }

    public Set<String> getTriggerNames() {
        throw new UnsupportedOperationException("Triggers not supported for " + this.getDatabaseDialect());
    }

    public Set<String> getTypeNames() {
        throw new UnsupportedOperationException("Types are not supported for " + this.getDatabaseDialect());
    }

    public void dropTable(String tableName) {
        this.getSQLHandler().executeUpdate("drop table " + this.qualified(tableName) + (this.supportsCascade() ? " cascade" : ""));
    }

    public void dropView(String viewName) {
        this.getSQLHandler().executeUpdate("drop view " + this.qualified(viewName) + (this.supportsCascade() ? " cascade" : ""));
    }

    public void dropMaterializedView(String viewName) {
        throw new UnsupportedOperationException("Materialized views are not supported for " + this.getDatabaseDialect());
    }

    public void dropSynonym(String synonymName) {
        this.getSQLHandler().executeUpdate("drop synonym " + this.qualified(synonymName));
    }

    public void dropSequence(String sequenceName) {
        this.getSQLHandler().executeUpdate("drop sequence " + this.qualified(sequenceName));
    }

    public void dropTrigger(String triggerName) {
        this.getSQLHandler().executeUpdate("drop trigger " + this.qualified(triggerName));
    }

    public void dropType(String typeName) {
        this.getSQLHandler().executeUpdate("drop type " + this.qualified(typeName) + (this.supportsCascade() ? " cascade" : ""));
    }

    public abstract void disableReferentialConstraints();

    public abstract void disableValueConstraints();

    public long getSequenceValue(String sequenceName) {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getDatabaseDialect());
    }

    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        throw new UnsupportedOperationException("Sequences not supported for " + this.getDatabaseDialect());
    }

    public Set<String> getIdentityColumnNames(String tableName) {
        throw new UnsupportedOperationException("Identity columns not supported for " + this.getDatabaseDialect());
    }

    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        throw new UnsupportedOperationException("Identity columns not supported for " + this.getDatabaseDialect());
    }

    public String getLongDataType() {
        return "BIGINT";
    }

    public String getTextDataType(int length) {
        return "VARCHAR(" + length + ")";
    }

    public String qualified(String databaseObjectName) {
        return this.quoted(this.schemaName) + "." + this.quoted(databaseObjectName);
    }

    public String quoted(String databaseObjectName) {
        if (this.identifierQuoteString == null) {
            return databaseObjectName;
        }
        return this.identifierQuoteString + databaseObjectName + this.identifierQuoteString;
    }

    public String toCorrectCaseIdentifier(String identifier) {
        int index = (identifier = identifier.trim()).indexOf(46);
        if (index != -1) {
            String schemaNamePart = identifier.substring(0, index);
            String identifierPart = identifier.substring(index + 1);
            return this.toCorrectCaseIdentifier(schemaNamePart) + "." + this.toCorrectCaseIdentifier(identifierPart);
        }
        if (this.identifierQuoteString != null && identifier.startsWith(this.identifierQuoteString) && identifier.endsWith(this.identifierQuoteString)) {
            return identifier.substring(1, identifier.length() - 1);
        }
        if (this.storedIdentifierCase == StoredIdentifierCase.UPPER_CASE) {
            return identifier.toUpperCase();
        }
        if (this.storedIdentifierCase == StoredIdentifierCase.LOWER_CASE) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    private StoredIdentifierCase determineStoredIdentifierCase(String storedIdentifierCase) {
        if ("lower_case".equals(storedIdentifierCase)) {
            return StoredIdentifierCase.LOWER_CASE;
        }
        if ("upper_case".equals(storedIdentifierCase)) {
            return StoredIdentifierCase.UPPER_CASE;
        }
        if ("mixed_case".equals(storedIdentifierCase)) {
            return StoredIdentifierCase.MIXED_CASE;
        }
        if (!"auto".equals(storedIdentifierCase)) {
            throw new UnitilsException("Unknown value " + storedIdentifierCase + " for property " + PROPKEY_STORED_IDENTIFIER_CASE + ". It should be one of lower_case, upper_case, mixed_case or auto.");
        }
        Connection connection = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData.storesUpperCaseIdentifiers()) {
                StoredIdentifierCase storedIdentifierCase2 = StoredIdentifierCase.UPPER_CASE;
                return storedIdentifierCase2;
            }
            if (databaseMetaData.storesLowerCaseIdentifiers()) {
                StoredIdentifierCase storedIdentifierCase3 = StoredIdentifierCase.LOWER_CASE;
                return storedIdentifierCase3;
            }
            StoredIdentifierCase storedIdentifierCase4 = StoredIdentifierCase.MIXED_CASE;
            return storedIdentifierCase4;
        }
        catch (SQLException e) {
            throw new UnitilsException("Unable to determine stored identifier case.", e);
        }
        finally {
            DbUtils.closeQuietly(connection, null, null);
        }
    }

    private String determineIdentifierQuoteString(String identifierQuoteStringProperty) {
        if ("none".equals(identifierQuoteStringProperty)) {
            return null;
        }
        if (!"auto".equals(identifierQuoteStringProperty)) {
            return identifierQuoteStringProperty;
        }
        Connection connection = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String quoteString = databaseMetaData.getIdentifierQuoteString();
            if (quoteString == null || "".equals(quoteString.trim())) {
                String string = null;
                return string;
            }
            String string = quoteString;
            return string;
        }
        catch (SQLException e) {
            throw new UnitilsException("Unable to determine identifier quote string.", e);
        }
        finally {
            DbUtils.closeQuietly(connection, null, null);
        }
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsTriggers() {
        return false;
    }

    public boolean supportsTypes() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsMaterializedViews() {
        return false;
    }

    public boolean supportsCascade() {
        return false;
    }
}

