/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Metadata;

public final class CharacterSet
extends Metadata {
    public static final CharacterSet ALL = new CharacterSet("*", "All character sets");
    public static final CharacterSet ISO_8859_1 = new CharacterSet("ISO-8859-1", "ISO/IEC 8859-1 or Latin 1 character set");
    public static final CharacterSet ISO_8859_10 = new CharacterSet("ISO-8859-10", "ISO/IEC 8859-10 or Latin 6 character set");
    public static final CharacterSet ISO_8859_2 = new CharacterSet("ISO-8859-2", "ISO/IEC 8859-2 or Latin 2 character set");
    public static final CharacterSet ISO_8859_3 = new CharacterSet("ISO-8859-3", "ISO/IEC 8859-3 or Latin 3 character set");
    public static final CharacterSet ISO_8859_4 = new CharacterSet("ISO-8859-4", "ISO/IEC 8859-4 or Latin 4 character set");
    public static final CharacterSet ISO_8859_5 = new CharacterSet("ISO-8859-5", "ISO/IEC 8859-5 or Cyrillic character set");
    public static final CharacterSet ISO_8859_6 = new CharacterSet("ISO-8859-6", "ISO/IEC 8859-6 or Arabic character set");
    public static final CharacterSet ISO_8859_7 = new CharacterSet("ISO-8859-7", "ISO/IEC 8859-7 or Greek character set");
    public static final CharacterSet ISO_8859_8 = new CharacterSet("ISO-8859-8", "ISO/IEC 8859-8 or Hebrew character set");
    public static final CharacterSet ISO_8859_9 = new CharacterSet("ISO-8859-9", "ISO/IEC 8859-9 or Latin 5 character set");
    public static final CharacterSet MACINTOSH = new CharacterSet("macintosh", "Mac OS Roman character set");
    public static final CharacterSet US_ASCII = new CharacterSet("US-ASCII", "US ASCII character set");
    public static final CharacterSet UTF_16 = new CharacterSet("UTF-16", "UTF 16 character set");
    public static final CharacterSet UTF_8 = new CharacterSet("UTF-8", "UTF 8 character set");
    public static final CharacterSet WINDOWS_1252 = new CharacterSet("windows-1252", "Windows 1232 character set");

    private static String getIanaName(String name) {
        if (name != null) {
            if ((name = name.toUpperCase()).equalsIgnoreCase("MACROMAN")) {
                name = MACINTOSH.getName();
            } else if (name.equalsIgnoreCase("ASCII")) {
                name = US_ASCII.getName();
            } else if (name.equalsIgnoreCase("latin1")) {
                name = ISO_8859_1.getName();
            } else if (name.equalsIgnoreCase("latin2")) {
                name = ISO_8859_2.getName();
            } else if (name.equalsIgnoreCase("latin3")) {
                name = ISO_8859_3.getName();
            } else if (name.equalsIgnoreCase("latin4")) {
                name = ISO_8859_4.getName();
            } else if (name.equalsIgnoreCase("cyrillic")) {
                name = ISO_8859_5.getName();
            } else if (name.equalsIgnoreCase("arabic")) {
                name = ISO_8859_6.getName();
            } else if (name.equalsIgnoreCase("greek")) {
                name = ISO_8859_7.getName();
            } else if (name.equalsIgnoreCase("hebrew")) {
                name = ISO_8859_8.getName();
            } else if (name.equalsIgnoreCase("latin5")) {
                name = ISO_8859_9.getName();
            } else if (name.equalsIgnoreCase("latin6")) {
                name = ISO_8859_10.getName();
            }
        }
        return name;
    }

    public static CharacterSet valueOf(String name) {
        CharacterSet result = null;
        String ianaName = CharacterSet.getIanaName(name);
        if (ianaName != null && !ianaName.equals("")) {
            result = ianaName.equalsIgnoreCase(ALL.getName()) ? ALL : (ianaName.equalsIgnoreCase(ISO_8859_1.getName()) ? ISO_8859_1 : (ianaName.equalsIgnoreCase(US_ASCII.getName()) ? US_ASCII : (ianaName.equalsIgnoreCase(UTF_8.getName()) ? UTF_8 : (ianaName.equalsIgnoreCase(UTF_16.getName()) ? UTF_16 : (ianaName.equalsIgnoreCase(MACINTOSH.getName()) ? MACINTOSH : new CharacterSet(ianaName))))));
        }
        return result;
    }

    public CharacterSet(String name) {
        this(name == null ? null : name.toUpperCase(), "Character set or range of character sets");
    }

    public CharacterSet(String name, String description) {
        super(CharacterSet.getIanaName(name), description);
    }

    public boolean equals(Object object) {
        return object instanceof CharacterSet && this.getName().equalsIgnoreCase(((CharacterSet)object).getName());
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }
}

