/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel;
import com.supermap.data.Point3D;
import com.supermap.realspace.spatialanalyst.CheckErrorType;
import com.supermap.realspace.spatialanalyst.CheckResult;
import com.supermap.realspace.spatialanalyst.InternalGeoModel;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.ModelValidatorNative;
import com.supermap.realspace.spatialanalyst.ModelValidatorParameter;

public class ModelValidator {
    private static Point3D[] _$1(GeoModel geoModel, boolean bl, boolean bl2) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        double[][] dArray = ModelValidatorNative.jni_CheckIsolatedPoints(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl, bl2);
        if (dArray.length != 3 || dArray[0].length == 0 || dArray[1].length == 0 || dArray[2].length == 0) {
            return null;
        }
        Point3D[] point3DArray = new Point3D[dArray[0].length];
        for (int i = 0; i < dArray[0].length; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(dArray[0][i]);
            point3D.setY(dArray[1][i]);
            point3D.setZ(dArray[2][i]);
            point3DArray[i] = point3D;
        }
        return point3DArray;
    }

    private static GeoLine3D[] _$5(GeoModel geoModel, boolean bl) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckSelfIntersection(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    private static boolean _$4(GeoModel geoModel, boolean bl) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl2 = ModelValidatorNative.jni_CheckConnectivity(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl);
        InternalGeoModel.clearMeshes(geoModel);
        geoModel.getMeshes();
        return bl2;
    }

    private static GeoLine3D[] _$3(GeoModel geoModel, boolean bl) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckAmbiguousLines(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    private static Boolean _$2(GeoModel geoModel, boolean bl) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl2 = ModelValidatorNative.jni_TriangleValidator(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl);
        return bl2;
    }

    private static GeoLine3D[] _$1(GeoModel geoModel, boolean bl) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckBorder(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bl);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    public static CheckResult validator(GeoModel geoModel, ModelValidatorParameter modelValidatorParameter) {
        Point3D[] point3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        CheckResult checkResult = new CheckResult();
        if (modelValidatorParameter.isIsolatedPointChecked()) {
            point3DArray = ModelValidator._$1(geoModel, modelValidatorParameter.isRepair(), false);
            if (!modelValidatorParameter.isRepair() && point3DArray != null && point3DArray.length > 0) {
                checkResult.setErrorPoints(point3DArray);
                checkResult.setErrorType(CheckErrorType.ISOLATED_POINT);
                return checkResult;
            }
        }
        if (modelValidatorParameter.isConnectivityProcessed()) {
            ModelValidator._$4(geoModel, false);
        }
        if (modelValidatorParameter.isNoncoplanarIntersectionChecked() && (point3DArray = ModelValidator._$5(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.NONCOPLANAR_INTERSECTION);
            return checkResult;
        }
        if (modelValidatorParameter.isTriangleProcessed()) {
            ModelValidator._$2(geoModel, false);
        }
        if (modelValidatorParameter.isAmbiguousLineChecked() && (point3DArray = ModelValidator._$3(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.AMBIGUOUS_LINE);
            return checkResult;
        }
        if (modelValidatorParameter.isBorderChecked() && (point3DArray = ModelValidator._$1(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.BORDER);
            return checkResult;
        }
        return checkResult;
    }

    public static boolean isClosed(GeoModel geoModel) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Point3D[] point3DArray = ModelValidator._$1(geoModel, false, true);
        if (point3DArray.length > 0) {
            return false;
        }
        boolean bl = ModelValidator._$4(geoModel, true);
        if (!bl) {
            return false;
        }
        GeoLine3D[] geoLine3DArray = ModelValidator._$5(geoModel, true);
        if (geoLine3DArray.length > 0) {
            return false;
        }
        GeoLine3D[] geoLine3DArray2 = ModelValidator._$3(geoModel, true);
        if (geoLine3DArray2.length > 0) {
            return false;
        }
        boolean bl2 = ModelValidator._$2(geoModel, true);
        if (!bl2) {
            return false;
        }
        GeoLine3D[] geoLine3DArray3 = ModelValidator._$1(geoModel, true);
        return geoLine3DArray3.length <= 0;
    }

    public static boolean isValid(GeoModel geoModel) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Point3D[] point3DArray = ModelValidator._$1(geoModel, false, true);
        if (point3DArray.length > 0) {
            return false;
        }
        boolean bl = ModelValidator._$4(geoModel, true);
        if (!bl) {
            return false;
        }
        GeoLine3D[] geoLine3DArray = ModelValidator._$5(geoModel, true);
        if (geoLine3DArray.length > 0) {
            return false;
        }
        GeoLine3D[] geoLine3DArray2 = ModelValidator._$3(geoModel, true);
        if (geoLine3DArray2.length > 0) {
            return false;
        }
        boolean bl2 = ModelValidator._$2(geoModel, true);
        return bl2;
    }
}

