/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;

public abstract class InterpolationParameter
extends InternalHandleDisposable {
    private SearchMode _$1;

    protected InterpolationParameter(InterpolationAlgorithmType interpolationAlgorithmType) {
        this(interpolationAlgorithmType, 0.0, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    protected InterpolationParameter(InterpolationAlgorithmType interpolationAlgorithmType, double d, SearchMode searchMode, double d2, int n) {
        super.setHandle(InterpolationParameterNative.jni_New(InternalEnum.getUGCValue(interpolationAlgorithmType), d, InternalEnum.getUGCValue(searchMode), d2, n), true);
        this._$1 = searchMode;
        this.setBounds(Rectangle2D.getEMPTY());
    }

    protected InterpolationParameter(InterpolationAlgorithmType interpolationAlgorithmType, double d) {
        this(interpolationAlgorithmType, d, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    public double getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolution()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetResolution(this.getHandle());
    }

    public void setResolution(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResolution(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetResolution(this.getHandle(), d);
    }

    public SearchMode getSearchMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSearchMode()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    public void setSearchMode(SearchMode searchMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSearchMode(SearchMode searchMode)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(searchMode);
        InterpolationParameterNative.jni_SetSearchMode(this.getHandle(), n);
        this._$1 = searchMode;
    }

    public double getSearchRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSearchRadius()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetSearchRadius(this.getHandle());
    }

    public void setSearchRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSearchRadius(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetSearchRadius(this.getHandle(), d);
    }

    public int getExpectedCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExpectedCount()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetExpectedCount(this.getHandle());
    }

    public void setExpectedCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExpectedCount(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetExpectedCount(this.getHandle(), n);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        InterpolationParameterNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D rectangle2D)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            rectangle2D = Rectangle2D.getEMPTY();
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        InterpolationParameterNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public int getMaxPointCountForInterpolation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxPointCountForInterpolation()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("getMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetMaxPointCountForInterpolation(this.getHandle());
    }

    public void setMaxPointCountForInterpolation(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxPointCountForInterpolation(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("setMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetMaxPointCountForInterpolation(this.getHandle(), n);
    }

    public int getMaxPointCountInNode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxPointCountInNode()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("getMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetMaxPointCountInNode(this.getHandle());
    }

    public void setMaxPointCountInNode(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxPointCountInNode(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("setMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetMaxPointCountInNode(this.getHandle(), n);
    }

    public abstract InterpolationAlgorithmType getType();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Bounds={");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},ExpectedCount=");
        stringBuffer.append(this.getExpectedCount());
        stringBuffer.append(",Resolution=");
        stringBuffer.append(this.getResolution());
        stringBuffer.append(",SearchMode=");
        stringBuffer.append(this.getSearchMode().name());
        stringBuffer.append(",SearchRadius=");
        stringBuffer.append(this.getSearchRadius());
        stringBuffer.append(",Type=");
        stringBuffer.append(this.getType().name());
        if (this.getSearchMode() == SearchMode.QUADTREE) {
            stringBuffer.append(",MaxPointCountForInterpolation=");
            stringBuffer.append(this.getMaxPointCountForInterpolation());
            stringBuffer.append(",MaxPointCountInNode=");
            stringBuffer.append(this.getMaxPointCountInNode());
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            InterpolationParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }
}

